/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.annotations.NotNull;

public abstract class MethodArgumentFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(MethodArgumentFix.class);
    protected final PsiExpressionList myArgList;
    protected final int myIndex;
    protected final ArgumentFixerActionFactory myArgumentFixerActionFactory;
    @NotNull
    protected final PsiType myToType;

    protected MethodArgumentFix(@NotNull PsiExpressionList list, int i, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory fixerActionFactory) {
        this.myArgList = list;
        this.myIndex = i;
        this.myArgumentFixerActionFactory = fixerActionFactory;
        this.myToType = toType instanceof PsiEllipsisType ? ((PsiEllipsisType)toType).toArrayType() : toType;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (this.myToType.isValid() && this.myArgList.isValid() && PsiTypesUtil.allTypeParametersResolved((PsiElement)this.myArgList, (PsiType)this.myToType)) {
            PsiExpression[] args = this.myArgList.getExpressions();
            return args.length > this.myIndex && args[this.myIndex] != null && args[this.myIndex].isValid();
        }
        return false;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        PsiExpression expression2 = this.myArgList.getExpressions()[this.myIndex];
        LOG.assertTrue(expression2 != null && expression2.isValid());
        PsiExpression modified = this.myArgumentFixerActionFactory.getModifiedArgument(expression2, this.myToType);
        LOG.assertTrue(modified != null, (Object)this.myArgumentFixerActionFactory);
        expression2.replace((PsiElement)modified);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("fix.argument.family", new Object[0]);
    }
}

