/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AddDefaultConstructorFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddVariableInitializerFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorParameterFromFieldFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InitializeFinalFieldInConstructorFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(InitializeFinalFieldInConstructorFix.class);

    public InitializeFinalFieldInConstructorFix(@NotNull PsiField field) {
        super((PsiElement)field);
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("initialize.final.field.in.constructor.name", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiField field = (PsiField)ObjectUtils.tryCast((Object)startElement, PsiField.class);
        if (field == null) {
            return false;
        }
        if (!field.isValid() || field.hasModifierProperty("static") || field.hasInitializer()) {
            return false;
        }
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null || containingClass.getName() == null) {
            return false;
        }
        PsiManager manager = field.getManager();
        return manager != null && BaseIntentionAction.canModify((PsiElement)field);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiField field = (PsiField)ObjectUtils.tryCast((Object)startElement, PsiField.class);
        if (field == null) {
            return;
        }
        PsiClass myClass = field.getContainingClass();
        if (myClass == null) {
            return;
        }
        if (myClass.getConstructors().length == 0) {
            InitializeFinalFieldInConstructorFix.createDefaultConstructor(myClass, project, editor, file);
        }
        PsiMethod[] ctors = CreateConstructorParameterFromFieldFix.filterConstructorsIfFieldAlreadyAssigned(myClass.getConstructors(), field).toArray(PsiMethod.EMPTY_ARRAY);
        List<PsiMethod> constructors = InitializeFinalFieldInConstructorFix.choose(ctors, project);
        ApplicationManager.getApplication().runWriteAction(() -> InitializeFinalFieldInConstructorFix.addFieldInitialization(constructors, field, project, editor));
    }

    private static void addFieldInitialization(@NotNull List<? extends PsiMethod> constructors, @NotNull PsiField field, @NotNull Project project, @Nullable Editor editor) {
        if (constructors.isEmpty()) {
            return;
        }
        LookupElement[] suggestedInitializers = AddVariableInitializerFix.suggestInitializer((PsiVariable)field);
        ArrayList<PsiExpression> rExpressions = new ArrayList<PsiExpression>(constructors.size());
        for (PsiMethod psiMethod : constructors) {
            rExpressions.add(InitializeFinalFieldInConstructorFix.addFieldInitialization(psiMethod, suggestedInitializers, field, project));
        }
        Document doc = Objects.requireNonNull(PsiDocumentManager.getInstance((Project)project).getDocument(field.getContainingFile()));
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(doc);
        AddVariableInitializerFix.runAssignmentTemplate(rExpressions, suggestedInitializers, editor);
    }

    @NotNull
    private static PsiExpression addFieldInitialization(@NotNull PsiMethod constructor, LookupElement @NotNull [] suggestedInitializers, @NotNull PsiField field, @NotNull Project project) {
        PsiCodeBlock methodBody2 = constructor.getBody();
        if (methodBody2 == null) {
            CreateFromUsageUtils.setupMethodBody(constructor);
            methodBody2 = constructor.getBody();
            LOG.assertTrue(methodBody2 != null);
        }
        String fieldName = field.getName();
        String stmtText = fieldName + " = " + suggestedInitializers[0].getPsiElement().getText() + ";";
        if (InitializeFinalFieldInConstructorFix.methodContainsParameterWithName(constructor, fieldName)) {
            stmtText = "this." + stmtText;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiManager.getProject());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiExpressionStatement addedStatement = (PsiExpressionStatement)methodBody2.add(codeStyleManager.reformat((PsiElement)factory.createStatementFromText(stmtText, (PsiElement)methodBody2)));
        return Objects.requireNonNull(((PsiAssignmentExpression)addedStatement.getExpression()).getRExpression());
    }

    private static boolean methodContainsParameterWithName(@NotNull PsiMethod constructor, @NotNull String name2) {
        for (PsiParameter parameter2 : constructor.getParameterList().getParameters()) {
            if (!name2.equals(parameter2.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<PsiMethod> choose(PsiMethod @NotNull [] ctors, @NotNull Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Arrays.asList(ctors);
        }
        if (ctors.length == 1) {
            return Collections.singletonList(ctors[0]);
        }
        if (ctors.length > 1) {
            MemberChooser chooser = new MemberChooser((ClassMember[])InitializeFinalFieldInConstructorFix.toPsiMethodMemberArray(ctors), false, true, project);
            chooser.setTitle(QuickFixBundle.message("initialize.final.field.in.constructor.choose.dialog.title", new Object[0]));
            chooser.show();
            List chosenMembers = chooser.getSelectedElements();
            if (chosenMembers != null) {
                return Arrays.asList(InitializeFinalFieldInConstructorFix.toPsiMethodArray(chosenMembers));
            }
        }
        return Collections.emptyList();
    }

    private static PsiMethodMember @NotNull [] toPsiMethodMemberArray(PsiMethod @NotNull [] methods) {
        PsiMethodMember[] result = new PsiMethodMember[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            result[i] = new PsiMethodMember(methods[i]);
        }
        return result;
    }

    private static PsiMethod @NotNull [] toPsiMethodArray(@NotNull List<? extends PsiMethodMember> methodMembers) {
        PsiMethod[] result = new PsiMethod[methodMembers.size()];
        int i = 0;
        for (PsiMethodMember psiMethodMember : methodMembers) {
            result[i++] = (PsiMethod)psiMethodMember.getElement();
        }
        return result;
    }

    private static void createDefaultConstructor(PsiClass psiClass, @NotNull Project project, Editor editor, PsiFile file) {
        AddDefaultConstructorFix defaultConstructorFix = new AddDefaultConstructorFix(psiClass);
        ApplicationManager.getApplication().runWriteAction(() -> defaultConstructorFix.invoke(project, editor, file));
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return currentFile;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

