/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.CodeBlockSurrounder;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeleteReturnFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final SmartPsiElementPointer<PsiReturnStatement> myStatementPtr;
    private final boolean myIsLastStatement;
    private final boolean myHasSideEffects;

    public DeleteReturnFix(@NotNull PsiMethod method, @NotNull PsiReturnStatement returnStatement) {
        super((PsiElement)returnStatement);
        PsiCodeBlock codeBlock = Objects.requireNonNull(method.getBody());
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)returnStatement.getProject());
        this.myStatementPtr = manager.createSmartPsiElementPointer((PsiElement)returnStatement);
        this.myIsLastStatement = ControlFlowUtils.blockCompletesWithStatement(codeBlock, (PsiStatement)returnStatement);
        this.myHasSideEffects = SideEffectChecker.mayHaveSideEffects(Objects.requireNonNull(returnStatement.getReturnValue()));
    }

    private DeleteReturnFix(@NotNull PsiReturnStatement returnStatement, boolean isLastStatement, boolean hasSideEffects) {
        super((PsiElement)returnStatement);
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)returnStatement.getProject());
        this.myStatementPtr = manager.createSmartPsiElementPointer((PsiElement)returnStatement);
        this.myIsLastStatement = isLastStatement;
        this.myHasSideEffects = hasSideEffects;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String toDelete = this.myIsLastStatement ? "statement" : "value";
        return QuickFixBundle.message(this.myHasSideEffects ? "delete.return.fix.side.effects.text" : "delete.return.fix.text", toDelete);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("delete.return.fix.family", new Object[0]);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiReturnStatement returnStatement = (PsiReturnStatement)this.myStatementPtr.getElement();
        if (returnStatement == null) {
            return;
        }
        PsiExpression returnValue = returnStatement.getReturnValue();
        if (returnValue == null) {
            return;
        }
        CommentTracker ct = new CommentTracker();
        if (this.myHasSideEffects) {
            returnValue = Objects.requireNonNull(CodeBlockSurrounder.forExpression(returnValue)).surround().getExpression();
            returnStatement = (PsiReturnStatement)returnValue.getParent();
        }
        List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(returnValue);
        sideEffects.forEach(ct::markUnchanged);
        PsiStatement[] statements = StatementExtractor.generateStatements(sideEffects, returnValue);
        if (statements.length > 0) {
            BlockUtils.addBefore((PsiStatement)returnStatement, statements);
        }
        PsiReturnStatement toDelete = this.myIsLastStatement ? returnStatement : returnValue;
        ct.deleteAndRestoreComments((PsiElement)toDelete);
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        PsiReturnStatement returnStatement = (PsiReturnStatement)this.myStatementPtr.getElement();
        if (returnStatement == null) {
            return null;
        }
        return new DeleteReturnFix((PsiReturnStatement)PsiTreeUtil.findSameElementInCopy((PsiElement)returnStatement, (PsiFile)target), this.myIsLastStatement, this.myHasSideEffects);
    }
}

