/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CastMethodArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapObjectWithOptionalOfNullableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapWithAdapterMethodCallFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.annotations.NotNull;

public class ConstructorParametersFixer {
    public static void registerFixActions(@NotNull PsiJavaCodeReferenceElement ctrRef, @NotNull PsiConstructorCall constructorCall, @NotNull HighlightInfo highlightInfo, @NotNull TextRange fixRange) {
        JavaResolveResult resolved = ctrRef.advancedResolve(false);
        PsiClass aClass = (PsiClass)resolved.getElement();
        if (aClass == null) {
            return;
        }
        PsiMethod[] methods = aClass.getConstructors();
        CandidateInfo[] candidates = new CandidateInfo[methods.length];
        for (int i = 0; i < candidates.length; ++i) {
            candidates[i] = new CandidateInfo((PsiElement)methods[i], resolved.getSubstitutor());
        }
        CastMethodArgumentFix.REGISTRAR.registerCastActions(candidates, (PsiCall)constructorCall, highlightInfo, fixRange);
        AddTypeArgumentsFix.REGISTRAR.registerCastActions(candidates, (PsiCall)constructorCall, highlightInfo, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions(candidates, (PsiCall)constructorCall, highlightInfo, fixRange);
        WrapWithAdapterMethodCallFix.registerCastActions(candidates, (PsiCall)constructorCall, highlightInfo, fixRange);
    }
}

