/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class AddTypeCastFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    @FileModifier.SafeFieldForPreview
    private final PsiType myType;
    private final String myName;

    public AddTypeCastFix(@NotNull PsiType type2, @NotNull PsiExpression expression2) {
        this(type2, expression2, "add.typecast.text");
    }

    public AddTypeCastFix(@NotNull PsiType type2, @NotNull PsiExpression expression2, @PropertyKey(resourceBundle="messages.QuickFixBundle") String messageKey) {
        super((PsiElement)expression2);
        this.myType = type2;
        this.myName = QuickFixBundle.message(messageKey, type2.isValid() ? type2.getCanonicalText() : "");
    }

    @NotNull
    public String getText() {
        return this.myName;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("add.typecast.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return this.myType.isValid() && !PsiType.VOID.equals((Object)this.myType) && PsiTypesUtil.isDenotableType((PsiType)this.myType, (PsiElement)startElement) && PsiTypesUtil.allTypeParametersResolved((PsiElement)startElement, (PsiType)this.myType) && BaseIntentionAction.canModify((PsiElement)startElement);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        AddTypeCastFix.addTypeCast(project, (PsiExpression)startElement, this.myType);
    }

    public static void addTypeCast(Project project, PsiExpression originalExpression, PsiType type2) {
        PsiExpression typeCast = AddTypeCastFix.createCastExpression(originalExpression, project, type2);
        originalExpression.replace((PsiElement)typeCast);
    }

    static PsiExpression createCastExpression(PsiExpression original, Project project, PsiType type2) {
        PsiExpression expression2 = PsiUtil.deparenthesizeExpression((PsiExpression)original);
        if (expression2 == null) {
            return null;
        }
        if (type2.equals(PsiType.NULL)) {
            return null;
        }
        if (type2 instanceof PsiEllipsisType) {
            type2 = ((PsiEllipsisType)type2).toArrayType();
        }
        String text2 = "(" + type2.getCanonicalText(false) + ")value";
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)original.getProject());
        PsiTypeCastExpression typeCast = (PsiTypeCastExpression)factory.createExpressionFromText(text2, (PsiElement)original);
        typeCast = (PsiTypeCastExpression)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)typeCast);
        typeCast = (PsiTypeCastExpression)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)typeCast);
        if (expression2 instanceof PsiConditionalExpression) {
            PsiType elseType;
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression2.copy();
            PsiExpression thenE = conditional.getThenExpression();
            PsiExpression elseE = conditional.getElseExpression();
            PsiType thenType = thenE == null ? null : thenE.getType();
            PsiType psiType = elseType = elseE == null ? null : elseE.getType();
            if (elseType != null && thenType != null) {
                boolean replaceElse;
                boolean replaceThen = !TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)thenType);
                boolean bl = replaceElse = !TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)elseType);
                if (replaceThen != replaceElse) {
                    if (replaceThen) {
                        Objects.requireNonNull(typeCast.getOperand()).replace((PsiElement)thenE);
                        thenE.replace((PsiElement)typeCast);
                    } else {
                        Objects.requireNonNull(typeCast.getOperand()).replace((PsiElement)elseE);
                        elseE.replace((PsiElement)typeCast);
                    }
                    return conditional;
                }
            }
        }
        Objects.requireNonNull(typeCast.getOperand()).replace((PsiElement)expression2);
        return typeCast;
    }

    public static void registerFix(QuickFixActionRegistrar registrar, PsiExpression qualifier, PsiJavaCodeReferenceElement ref, TextRange fixRange) {
        String referenceName = ref.getReferenceName();
        if (referenceName == null) {
            return;
        }
        if (qualifier instanceof PsiReferenceExpression) {
            JavaResolveResult result;
            PsiMethodCallExpression callExpression;
            PsiElement resolve2 = ((PsiReferenceExpression)qualifier).resolve();
            if (resolve2 == null) {
                return;
            }
            if (resolve2 instanceof PsiParameter && ((PsiParameter)resolve2).getTypeElement() == null && (callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)resolve2, PsiMethodCallExpression.class)) != null && (result = callExpression.resolveMethodGenerics()) instanceof MethodCandidateInfo && ((MethodCandidateInfo)result).getInferenceErrorMessage() != null) {
                return;
            }
        }
        PsiElement gParent = ref.getParent();
        List<PsiType> conjuncts = GuessManager.getInstance(qualifier.getProject()).getControlFlowExpressionTypeConjuncts(qualifier);
        for (PsiType conjunct : conjuncts) {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)conjunct);
            if (psiClass == null || (gParent instanceof PsiMethodCallExpression ? psiClass.findMethodsByName(referenceName).length == 0 : psiClass.findFieldByName(referenceName, true) == null)) continue;
            registrar.register(fixRange, (IntentionAction)new AddTypeCastFix(conjunct, qualifier, "add.qualifier.typecast.text"), null);
        }
    }
}

