/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTypeArgumentsFix
extends MethodArgumentFix {
    private static final Logger LOG = Logger.getInstance(AddTypeArgumentsFix.class);
    public static final ArgumentFixerActionFactory REGISTRAR = new MyFixerActionFactory();

    private AddTypeArgumentsFix(@NotNull PsiExpressionList list, int i, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory factory) {
        super(list, i, toType, factory);
    }

    @NotNull
    public String getText() {
        if (this.myArgList.getExpressionCount() == 1) {
            return QuickFixBundle.message("add.type.arguments.single.argument.text", new Object[0]);
        }
        return QuickFixBundle.message("add.type.arguments.text", this.myIndex + 1);
    }

    @Nullable
    public static PsiExpression addTypeArguments(@NotNull PsiExpression expression2, @Nullable PsiType toType) {
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression2)) {
            return null;
        }
        PsiExpression orig = expression2;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression2;
            PsiReferenceParameterList list = methodCall.getMethodExpression().getParameterList();
            if (list == null || list.getTypeArguments().length > 0) {
                return null;
            }
            JavaResolveResult resolveResult = methodCall.resolveMethodGenerics();
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiType returnType = method.getReturnType();
                if (returnType == null) {
                    return null;
                }
                PsiTypeParameter[] typeParameters = method.getTypeParameters();
                if (typeParameters.length > 0) {
                    PsiType[] mappings = PsiType.createArray((int)typeParameters.length);
                    PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)expression2.getProject()).getResolveHelper();
                    LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)expression2);
                    for (int i = 0; i < typeParameters.length; ++i) {
                        PsiType substitution;
                        PsiTypeParameter typeParameter = typeParameters[i];
                        if (toType == null) {
                            substitution = resolveResult.getSubstitutor().substitute(typeParameter);
                            if (!PsiTypesUtil.isDenotableType((PsiType)substitution, (PsiElement)expression2)) {
                                return null;
                            }
                        } else {
                            substitution = helper.getSubstitutionForTypeParameter(typeParameter, returnType, toType, false, level);
                        }
                        if (substitution == null || PsiType.NULL.equals((Object)substitution)) {
                            return null;
                        }
                        mappings[i] = GenericsUtil.eliminateWildcards((PsiType)substitution, (boolean)false);
                    }
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
                    PsiMethodCallExpression copy = (PsiMethodCallExpression)expression2.copy();
                    PsiReferenceExpression methodExpression = copy.getMethodExpression();
                    PsiReferenceParameterList parameterList = methodExpression.getParameterList();
                    LOG.assertTrue(parameterList != null);
                    for (PsiType mapping : mappings) {
                        parameterList.add((PsiElement)factory.createTypeElement(mapping));
                    }
                    if (methodExpression.getQualifierExpression() == null) {
                        PsiClass containingClass = method.getContainingClass();
                        if (containingClass == null) {
                            return null;
                        }
                        Object qualifierExpression2 = method.hasModifierProperty("static") ? factory.createReferenceExpression(containingClass) : RefactoringChangeUtil.createThisExpression(method.getManager(), null);
                        methodExpression.setQualifierExpression((PsiExpression)qualifierExpression2);
                    }
                    PsiExpression result = (PsiExpression)JavaCodeStyleManager.getInstance((Project)copy.getProject()).shortenClassReferences((PsiElement)copy);
                    if (orig != expression2) {
                        PsiExpression parenthesized = (PsiExpression)orig.copy();
                        Objects.requireNonNull(PsiUtil.skipParenthesizedExprDown((PsiExpression)parenthesized)).replace((PsiElement)result);
                        return parenthesized;
                    }
                    return result;
                }
            }
        }
        return null;
    }

    @NotNull
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        return new AddTypeArgumentsFix((PsiExpressionList)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myArgList, (PsiFile)target), this.myIndex, this.myToType, this.myArgumentFixerActionFactory);
    }

    private static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        private MyFixerActionFactory() {
        }

        @Override
        public AddTypeArgumentsFix createFix(PsiExpressionList list, int i, PsiType toType) {
            return new AddTypeArgumentsFix(list, i, toType, this);
        }

        @Override
        protected PsiExpression getModifiedArgument(PsiExpression expression2, PsiType toType) throws IncorrectOperationException {
            return AddTypeArgumentsFix.addTypeArguments(expression2, toType);
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            return !(exprType instanceof PsiPrimitiveType) && !(parameterType instanceof PsiPrimitiveType) || TypeConversionUtil.boxingConversionApplicable((PsiType)exprType, (PsiType)parameterType);
        }
    }
}

