/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateAnnotationMethodFromUsageFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAnnotationAttributeNameFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myName;

    public AddAnnotationAttributeNameFix(PsiNameValuePair pair2, String name2) {
        super((PsiElement)pair2);
        this.myName = name2;
    }

    @Nls
    @NotNull
    public String getText() {
        return QuickFixBundle.message("add.annotation.attribute.name", this.myName);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("add.annotation.attribute.name.family.name", new Object[0]);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        AddAnnotationAttributeNameFix.doFix((PsiNameValuePair)startElement, this.myName);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return super.isAvailable(project, file, startElement, endElement) && startElement instanceof PsiNameValuePair;
    }

    @NotNull
    public static List<IntentionAction> createFixes(@NotNull PsiNameValuePair pair2) {
        PsiAnnotationMemberValue value2 = pair2.getValue();
        if (value2 == null || pair2.getName() != null) {
            return Collections.emptyList();
        }
        Collection<String> methodNames = AddAnnotationAttributeNameFix.getAvailableAnnotationMethodNames(pair2);
        return ContainerUtil.map2List(methodNames, name2 -> new AddAnnotationAttributeNameFix(pair2, (String)name2));
    }

    public static void doFix(@NotNull PsiNameValuePair annotationParameter, @NotNull String name2) {
        String text2 = AddAnnotationAttributeNameFix.buildReplacementText(annotationParameter, name2);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)annotationParameter.getProject());
        PsiAnnotation newAnnotation = factory.createAnnotationFromText("@A(" + text2 + " )", (PsiElement)annotationParameter);
        annotationParameter.replace((PsiElement)newAnnotation.getParameterList().getAttributes()[0]);
    }

    private static String buildReplacementText(@NotNull PsiNameValuePair annotationParameter, @NotNull String name2) {
        PsiAnnotationMemberValue value2 = annotationParameter.getValue();
        return value2 != null ? name2 + "=" + value2.getText() : name2 + "=";
    }

    public static boolean isCompatibleReturnType(@NotNull PsiMethod psiMethod, @Nullable PsiType valueType) {
        PsiType expectedType = psiMethod.getReturnType();
        if (expectedType == null || valueType == null || expectedType.isAssignableFrom(valueType)) {
            return true;
        }
        if (expectedType instanceof PsiArrayType) {
            PsiType componentType = ((PsiArrayType)expectedType).getComponentType();
            return componentType.isAssignableFrom(valueType);
        }
        return false;
    }

    @NotNull
    private static Collection<String> getAvailableAnnotationMethodNames(@NotNull PsiNameValuePair pair2) {
        PsiAnnotationParameterList parameterList;
        PsiClass annotationClass;
        PsiElement parent;
        PsiAnnotationMemberValue value2 = pair2.getValue();
        if (value2 != null && pair2.getName() == null && (parent = pair2.getParent()) instanceof PsiAnnotationParameterList && (annotationClass = AddAnnotationAttributeNameFix.getAnnotationClass(parameterList = (PsiAnnotationParameterList)parent)) != null) {
            Set<String> usedNames = AddAnnotationAttributeNameFix.getUsedAttributeNames(parameterList);
            Collection availableMethods = Arrays.stream(annotationClass.getMethods()).filter(PsiAnnotationMethod.class::isInstance).filter(psiMethod -> !usedNames.contains(psiMethod.getName())).collect(Collectors.toList());
            if (!availableMethods.isEmpty()) {
                PsiType valueType = CreateAnnotationMethodFromUsageFix.getAnnotationValueType(value2);
                return availableMethods.stream().filter(psiMethod -> AddAnnotationAttributeNameFix.isCompatibleReturnType(psiMethod, valueType)).map(PsiMethod::getName).collect(Collectors.toSet());
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    public static Set<String> getUsedAttributeNames(@NotNull PsiAnnotationParameterList parameterList) {
        return Arrays.stream(parameterList.getAttributes()).map(PsiNameValuePair::getName).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nullable
    private static PsiClass getAnnotationClass(@NotNull PsiAnnotationParameterList parameterList) {
        PsiElement parent = parameterList.getParent();
        return parent instanceof PsiAnnotation ? ((PsiAnnotation)parent).resolveAnnotationType() : null;
    }
}

