/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.CheckLevelHighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.daemon.impl.analysis.ImportsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInsight.daemon.impl.analysis.ModuleHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.PostHighlightingVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.PsiMethodReferenceHighlightingUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.AdjustFunctionContextFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.siyeh.ig.psiutils.ClassUtils;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightVisitorImpl
extends JavaElementVisitor
implements HighlightVisitor {
    private HighlightInfoHolder myHolder;
    private RefCountHolder myRefCountHolder;
    private LanguageLevel myLanguageLevel;
    private JavaSdkVersion myJavaSdkVersion;
    private PsiFile myFile;
    private PsiJavaModule myJavaModule;
    private final Map<PsiElement, Collection<PsiReferenceExpression>> myUninitializedVarProblems = new THashMap();
    private final Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> myFinalVarProblems = new THashMap();
    private final Map<PsiParameter, ReassignedState> myReassignedParameters = new THashMap();
    private final Map<String, Pair<PsiImportStaticReferenceElement, PsiClass>> mySingleImportedClasses = new THashMap();
    private final Map<String, Pair<PsiImportStaticReferenceElement, PsiField>> mySingleImportedFields = new THashMap();
    private final PsiElementVisitor REGISTER_REFERENCES_VISITOR = new PsiRecursiveElementWalkingVisitor(){

        public void visitElement(@NotNull PsiElement element) {
            super.visitElement(element);
            for (PsiReference reference : element.getReferences()) {
                PsiElement resolved = reference.resolve();
                if (!(resolved instanceof PsiNamedElement)) continue;
                HighlightVisitorImpl.this.myRefCountHolder.registerLocallyReferenced((PsiNamedElement)resolved);
                if (!(resolved instanceof PsiMember)) continue;
                HighlightVisitorImpl.this.myRefCountHolder.registerReference(reference, (JavaResolveResult)new CandidateInfo(resolved, PsiSubstitutor.EMPTY));
            }
        }
    };
    private final Map<PsiClass, MostlySingularMultiMap<MethodSignature, PsiMethod>> myDuplicateMethods = new THashMap();
    private final Set<PsiClass> myOverrideEquivalentMethodsVisitedClasses = new THashSet();
    private final Map<PsiMethod, PsiType> myExpectedReturnTypes = new HashMap<PsiMethod, PsiType>();
    private final Function<? super PsiElement, ? extends PsiClass> myInsideConstructorOfClass = this::findInsideConstructorClass;
    private final Map<PsiElement, PsiClass> myInsideConstructorOfClassCache = new HashMap<PsiElement, PsiClass>();

    @NotNull
    protected PsiResolveHelper getResolveHelper(@NotNull Project project) {
        return PsiResolveHelper.SERVICE.getInstance((Project)project);
    }

    protected HighlightVisitorImpl() {
    }

    private PsiClass findInsideConstructorClass(@NotNull PsiElement entry) {
        PsiClass result = null;
        PsiElement element = entry;
        while (element != null && !(element instanceof PsiFile)) {
            PsiElement p4;
            PsiElement p3;
            PsiElement p2;
            result = this.myInsideConstructorOfClassCache.get(entry);
            if (result != null || this.myInsideConstructorOfClassCache.containsKey(entry)) {
                return result;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof PsiExpressionStatement && (p2 = parent.getParent()) instanceof PsiCodeBlock && (p3 = p2.getParent()) instanceof PsiMethod && ((PsiMethod)p3).isConstructor() && (p4 = p3.getParent()) instanceof PsiClass) {
                result = (PsiClass)p4;
            }
            if (result != null) break;
            element = parent;
        }
        for (PsiElement e = entry; e != null && !(e instanceof PsiFile); e = e.getParent()) {
            this.myInsideConstructorOfClassCache.put(e, result);
            if (e == element) break;
        }
        return result;
    }

    @Deprecated
    protected HighlightVisitorImpl(@NotNull PsiResolveHelper psiResolveHelper) {
    }

    @NotNull
    private MostlySingularMultiMap<MethodSignature, PsiMethod> getDuplicateMethods(@NotNull PsiClass aClass) {
        MostlySingularMultiMap signatures = this.myDuplicateMethods.get(aClass);
        if (signatures == null) {
            signatures = new MostlySingularMultiMap();
            for (PsiMethod method : aClass.getMethods()) {
                if (method instanceof ExternallyDefinedPsiElement) continue;
                MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
                signatures.add((Object)signature, (Object)method);
            }
            this.myDuplicateMethods.put(aClass, (MostlySingularMultiMap<MethodSignature, PsiMethod>)signatures);
        }
        return signatures;
    }

    @NotNull
    public HighlightVisitorImpl clone() {
        return new HighlightVisitorImpl();
    }

    public boolean suitableForFile(@NotNull PsiFile file) {
        return file instanceof PsiImportHolder && !InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file);
    }

    public void visit(@NotNull PsiElement element) {
        if (Holder.CHECK_ELEMENT_LEVEL) {
            ((CheckLevelHighlightInfoHolder)this.myHolder).enterLevel(element);
            element.accept((PsiElementVisitor)this);
            ((CheckLevelHighlightInfoHolder)this.myHolder).enterLevel(null);
        } else {
            element.accept((PsiElementVisitor)this);
        }
    }

    private void registerReferencesFromInjectedFragments(@NotNull PsiElement element) {
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)this.myFile.getProject());
        manager.enumerateEx(element, this.myFile, false, (injectedPsi, places) -> injectedPsi.accept(this.REGISTER_REFERENCES_VISITOR));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(@NotNull PsiFile file, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable highlight) {
        boolean success = true;
        try {
            this.prepare((HighlightInfoHolder)(Holder.CHECK_ELEMENT_LEVEL ? new CheckLevelHighlightInfoHolder(file, holder) : holder), file);
            if (updateWholeFile) {
                TextRange dirtyScope;
                RefCountHolder refCountHolder;
                ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
                if (progress == null) {
                    throw new IllegalStateException("Must be run under progress");
                }
                this.myRefCountHolder = refCountHolder = RefCountHolder.get(file);
                Project project = file.getProject();
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
                TextRange textRange = dirtyScope = document == null ? null : DaemonCodeAnalyzerEx.getInstanceEx((Project)project).getFileStatusMap().getFileDirtyScope(document, 4);
                if (dirtyScope == null) {
                    dirtyScope = file.getTextRange();
                }
                success = refCountHolder.analyze(file, dirtyScope, progress, () -> {
                    highlight.run();
                    ProgressManager.checkCanceled();
                    if (document != null) {
                        new PostHighlightingVisitor(file, document, refCountHolder).collectHighlights(holder, progress);
                    }
                });
            } else {
                this.myRefCountHolder = null;
                highlight.run();
            }
        }
        finally {
            this.myUninitializedVarProblems.clear();
            this.myFinalVarProblems.clear();
            this.mySingleImportedClasses.clear();
            this.mySingleImportedFields.clear();
            this.myReassignedParameters.clear();
            this.myRefCountHolder = null;
            this.myJavaModule = null;
            this.myFile = null;
            this.myHolder = null;
            this.myDuplicateMethods.clear();
            this.myOverrideEquivalentMethodsVisitedClasses.clear();
            this.myExpectedReturnTypes.clear();
            this.myInsideConstructorOfClassCache.clear();
        }
        return success;
    }

    protected void prepareToRunAsInspection(@NotNull HighlightInfoHolder holder) {
        this.prepare(holder, holder.getContextFile());
    }

    private void prepare(@NotNull HighlightInfoHolder holder, @NotNull PsiFile file) {
        this.myHolder = holder;
        this.myFile = file;
        this.myLanguageLevel = PsiUtil.getLanguageLevel((PsiElement)file);
        this.myJavaSdkVersion = (JavaSdkVersion)ObjectUtils.notNull((Object)JavaVersionService.getInstance().getJavaSdkVersion((PsiElement)file), (Object)JavaSdkVersion.fromLanguageLevel((LanguageLevel)this.myLanguageLevel));
        this.myJavaModule = this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9) ? JavaModuleGraphUtil.findDescriptorByElement((PsiElement)file) : null;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (this.myRefCountHolder != null && this.myFile instanceof ServerPageFile) {
            try {
                for (PsiReference reference : element.getReferences()) {
                    JavaResolveResult result = HighlightVisitorImpl.resolveJavaReference(reference);
                    if (result == null) continue;
                    this.myRefCountHolder.registerReference(reference, result);
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        if (!(this.myFile instanceof ServerPageFile)) {
            this.myHolder.add(DefaultHighlightUtil.checkBadCharacter((PsiElement)element));
        }
    }

    @Nullable
    public static JavaResolveResult resolveJavaReference(@NotNull PsiReference reference) {
        return reference instanceof PsiJavaReference ? ((PsiJavaReference)reference).advancedResolve(false) : null;
    }

    public void visitAnnotation(PsiAnnotation annotation) {
        super.visitAnnotation(annotation);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature((PsiElement)annotation, HighlightingFeature.ANNOTATIONS));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkApplicability(annotation, this.myLanguageLevel, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkAnnotationType(annotation));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkMissingAttributes(annotation));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkTargetAnnotationDuplicates(annotation));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkDuplicateAnnotations(annotation, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkFunctionalInterface(annotation, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkRepeatableAnnotation(annotation));
        }
        if ("java.lang.Override".equals(annotation.getQualifiedName())) {
            PsiElement parent;
            PsiAnnotationOwner owner2 = annotation.getOwner();
            PsiElement psiElement = parent = owner2 instanceof PsiModifierList ? ((PsiModifierList)owner2).getParent() : null;
            if (parent instanceof PsiMethod) {
                this.myHolder.add(GenericsHighlightUtil.checkOverrideAnnotation((PsiMethod)parent, annotation, this.myLanguageLevel));
            }
        }
    }

    public void visitAnnotationArrayInitializer(PsiArrayInitializerMemberValue initializer) {
        PsiType type2;
        PsiMethod method = null;
        PsiElement parent = initializer.getParent();
        if (parent instanceof PsiNameValuePair) {
            PsiReference reference = parent.getReference();
            if (reference != null) {
                method = (PsiMethod)reference.resolve();
            }
        } else if (PsiUtil.isAnnotationMethod((PsiElement)parent)) {
            method = (PsiMethod)parent;
        }
        if (method != null && (type2 = method.getReturnType()) instanceof PsiArrayType) {
            PsiAnnotationMemberValue[] initializers;
            type2 = ((PsiArrayType)type2).getComponentType();
            for (PsiAnnotationMemberValue initializer1 : initializers = initializer.getInitializers()) {
                this.myHolder.add(AnnotationsHighlightUtil.checkMemberValueType(initializer1, type2));
            }
        }
    }

    public void visitAnnotationMethod(PsiAnnotationMethod method) {
        PsiTypeElement typeElement;
        PsiType returnType = method.getReturnType();
        PsiAnnotationMemberValue value2 = method.getDefaultValue();
        if (returnType != null && value2 != null) {
            this.myHolder.add(AnnotationsHighlightUtil.checkMemberValueType(value2, returnType));
        }
        if ((typeElement = method.getReturnTypeElement()) != null) {
            this.myHolder.add(AnnotationsHighlightUtil.checkValidAnnotationType(returnType, typeElement));
        }
        PsiClass aClass = method.getContainingClass();
        if (typeElement != null && aClass != null) {
            this.myHolder.add(AnnotationsHighlightUtil.checkCyclicMemberType(typeElement, aClass));
        }
        this.myHolder.add(AnnotationsHighlightUtil.checkClashesWithSuperMethods(method));
        if (!this.myHolder.hasErrorResults() && aClass != null) {
            this.myHolder.add(HighlightMethodUtil.checkDuplicateMethod(aClass, (PsiMethod)method, this.getDuplicateMethods(aClass)));
        }
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        super.visitArrayInitializerExpression(expression2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkArrayInitializerApplicable(expression2));
        }
        if (!(expression2.getParent() instanceof PsiNewExpression) && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkGenericArrayCreation((PsiElement)expression2, expression2.getType()));
        }
    }

    public void visitAssignmentExpression(PsiAssignmentExpression assignment) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAssignmentCompatibleTypes(assignment));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAssignmentOperatorApplicable(assignment));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)assignment);
        }
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        super.visitPolyadicExpression(expression2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkPolyadicOperatorApplicable(expression2));
        }
    }

    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        PsiElement body2;
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        this.myHolder.add(this.checkFeature((PsiElement)expression2, HighlightingFeature.LAMBDA_EXPRESSIONS));
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (HighlightVisitorImpl.toReportFunctionalExpressionProblemOnParent(parent)) {
            return;
        }
        if (!this.myHolder.hasErrorResults() && !LambdaUtil.isValidLambdaContext((PsiElement)parent)) {
            this.myHolder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(JavaErrorBundle.message("lambda.expression.not.expected", new Object[0])).create());
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(LambdaHighlightingUtil.checkConsistentParameterDeclaration(expression2));
        }
        PsiType functionalInterfaceType = null;
        if (!this.myHolder.hasErrorResults()) {
            functionalInterfaceType = expression2.getFunctionalInterfaceType();
            if (functionalInterfaceType != null) {
                String notFunctionalMessage = LambdaHighlightingUtil.checkInterfaceFunctional(functionalInterfaceType);
                if (notFunctionalMessage != null) {
                    this.myHolder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(notFunctionalMessage).create());
                } else {
                    this.checkFunctionalInterfaceTypeAccessible((PsiFunctionalExpression)expression2, functionalInterfaceType);
                }
            } else if (LambdaUtil.getFunctionalInterfaceType((PsiElement)expression2, (boolean)true) != null) {
                this.myHolder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(JavaErrorBundle.message("cannot.infer.functional.interface.type", new Object[0])).create());
            }
        }
        if (!this.myHolder.hasErrorResults() && functionalInterfaceType != null) {
            JavaResolveResult containingCallResolveResult;
            String parentInferenceErrorMessage = null;
            PsiCallExpression callExpression = parent instanceof PsiExpressionList && parent.getParent() instanceof PsiCallExpression ? (PsiCallExpression)parent.getParent() : null;
            JavaResolveResult javaResolveResult = containingCallResolveResult = callExpression != null ? callExpression.resolveMethodGenerics() : null;
            if (containingCallResolveResult instanceof MethodCandidateInfo) {
                parentInferenceErrorMessage = ((MethodCandidateInfo)containingCallResolveResult).getInferenceErrorMessage();
            }
            Map returnErrors = LambdaUtil.checkReturnTypeCompatible((PsiLambdaExpression)expression2, (PsiType)LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType));
            if (!(parentInferenceErrorMessage == null || returnErrors != null && returnErrors.containsValue(parentInferenceErrorMessage))) {
                if (returnErrors == null) {
                    return;
                }
                HighlightInfo info = HighlightMethodUtil.createIncompatibleTypeHighlightInfo(callExpression, this.getResolveHelper(this.myHolder.getProject()), (MethodCandidateInfo)containingCallResolveResult, expression2.getTextRange());
                returnErrors.keySet().forEach(k -> QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)AdjustFunctionContextFix.createFix(k)));
                this.myHolder.add(info);
            } else if (returnErrors != null) {
                for (Map.Entry entry : returnErrors.entrySet()) {
                    HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)entry.getKey()).descriptionAndTooltip((String)entry.getValue()).create();
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)AdjustFunctionContextFix.createFix((PsiElement)entry.getKey()));
                    if (entry.getKey() instanceof PsiExpression) {
                        PsiExpression expr2 = (PsiExpression)entry.getKey();
                        HighlightFixUtil.registerLambdaReturnTypeFixes(info, expression2, expr2);
                    }
                    this.myHolder.add(info);
                }
            }
        }
        if (!this.myHolder.hasErrorResults() && functionalInterfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)(resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType)))) != null) {
            PsiParameter[] parameters2 = interfaceMethod.getParameterList().getParameters();
            this.myHolder.add(LambdaHighlightingUtil.checkParametersCompatible(expression2, parameters2, LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult)));
        }
        if (!this.myHolder.hasErrorResults() && (body2 = expression2.getBody()) instanceof PsiCodeBlock) {
            this.myHolder.add(HighlightControlFlowUtil.checkUnreachableStatement((PsiCodeBlock)body2));
        }
    }

    public void visitBreakStatement(PsiBreakStatement statement) {
        super.visitBreakStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkBreakTarget(statement, this.myLanguageLevel));
        }
    }

    public void visitYieldStatement(PsiYieldStatement statement) {
        super.visitYieldStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkYieldOutsideSwitchExpression(statement));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkYieldExpressionType(statement));
        }
    }

    public void visitClass(PsiClass aClass) {
        super.visitClass(aClass);
        if (aClass instanceof PsiSyntheticClass) {
            return;
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkInterfaceMultipleInheritance(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkClassSupersAccessibility(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkDuplicateTopLevelClass(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkMustNotBeLocal(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkImplicitThisReferenceBeforeSuper(aClass, this.myJavaSdkVersion));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkClassAndPackageConflict(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkPublicClassInRightFile(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkWellFormedRecord(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkSealedNonEnumeratedInheritors(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkSealedSuper(aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkTypeParameterOverrideEquivalentMethods(aClass, this.myLanguageLevel));
        }
    }

    public void visitClassInitializer(PsiClassInitializer initializer) {
        super.visitClassInitializer(initializer);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkIllegalInstanceMemberInRecord((PsiMember)initializer));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkInitializerCompleteNormally(initializer));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkUnreachableStatement(initializer.getBody()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkThingNotAllowedInInterface((PsiElement)initializer, initializer.getContainingClass()));
        }
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
        super.visitClassObjectAccessExpression(expression2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkClassObjectAccessExpression(expression2));
        }
    }

    public void visitComment(@NotNull PsiComment comment) {
        super.visitComment(comment);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnclosedComment(comment));
        }
        if (this.myRefCountHolder != null && !this.myHolder.hasErrorResults()) {
            this.registerReferencesFromInjectedFragments((PsiElement)comment);
        }
    }

    public void visitContinueStatement(PsiContinueStatement statement) {
        super.visitContinueStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkContinueTarget(statement, this.myLanguageLevel));
        }
    }

    public void visitJavaToken(PsiJavaToken token) {
        super.visitJavaToken(token);
        IElementType type2 = token.getTokenType();
        if (!this.myHolder.hasErrorResults() && type2 == JavaTokenType.TEXT_BLOCK_LITERAL) {
            this.myHolder.add(this.checkFeature((PsiElement)token, HighlightingFeature.TEXT_BLOCKS));
        }
        if (!this.myHolder.hasErrorResults() && type2 == JavaTokenType.RBRACE && token.getParent() instanceof PsiCodeBlock) {
            PsiType returnType;
            PsiCodeBlock codeBlock;
            PsiElement gParent = token.getParent().getParent();
            if (gParent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)gParent;
                codeBlock = method.getBody();
                returnType = method.getReturnType();
            } else if (gParent instanceof PsiLambdaExpression) {
                PsiElement body2 = ((PsiLambdaExpression)gParent).getBody();
                if (!(body2 instanceof PsiCodeBlock)) {
                    return;
                }
                codeBlock = (PsiCodeBlock)body2;
                returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)gParent));
            } else {
                return;
            }
            this.myHolder.add(HighlightControlFlowUtil.checkMissingReturnStatement(codeBlock, returnType));
        }
    }

    public void visitDocComment(PsiDocComment comment) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnclosedComment((PsiComment)comment));
        }
    }

    public void visitDocTagValue(PsiDocTagValue value2) {
        PsiReference reference = value2.getReference();
        if (reference != null) {
            PsiElement element = reference.resolve();
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            if (element instanceof PsiMethod) {
                PsiElement nameElement = ((PsiDocMethodOrFieldRef)value2).getNameElement();
                if (nameElement != null) {
                    this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMethod)element, nameElement, false, colorsScheme));
                }
            } else if (element instanceof PsiParameter) {
                this.myHolder.add(HighlightNamesUtil.highlightVariableName((PsiVariable)element, value2.getNavigationElement(), colorsScheme));
            }
        }
    }

    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        super.visitEnumConstant(enumConstant);
        if (!this.myHolder.hasErrorResults()) {
            GenericsHighlightUtil.checkEnumConstantForConstructorProblems(enumConstant, this.myHolder, this.myJavaSdkVersion);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.registerConstructorCall((PsiConstructorCall)enumConstant);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnhandledExceptions((PsiElement)enumConstant, enumConstant.getNameIdentifier().getTextRange()));
        }
    }

    public void visitEnumConstantInitializer(PsiEnumConstantInitializer enumConstantInitializer) {
        super.visitEnumConstantInitializer(enumConstantInitializer);
        if (!this.myHolder.hasErrorResults()) {
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)enumConstantInitializer);
            this.myHolder.add(HighlightClassUtil.checkClassMustBeAbstract((PsiClass)enumConstantInitializer, textRange));
        }
    }

    public void visitExpression(PsiExpression expression2) {
        ProgressManager.checkCanceled();
        super.visitExpression(expression2);
        PsiElement parent = expression2.getParent();
        PsiType type2 = expression2.getType();
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkMustBeBoolean(expression2, type2));
        }
        if (!this.myHolder.hasErrorResults() && expression2 instanceof PsiArrayAccessExpression) {
            this.myHolder.add(HighlightUtil.checkValidArrayAccessExpression((PsiArrayAccessExpression)expression2));
        }
        if (!this.myHolder.hasErrorResults() && parent instanceof PsiNewExpression && ((PsiNewExpression)parent).getQualifier() != expression2 && ((PsiNewExpression)parent).getArrayInitializer() != expression2) {
            this.myHolder.add(HighlightUtil.checkAssignability((PsiType)PsiType.INT, expression2.getType(), expression2, (PsiElement)expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkCannotWriteToFinal(expression2, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkVariableExpected(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(HighlightUtil.checkArrayInitializer(expression2, type2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkTernaryOperatorConditionIsBoolean(expression2, type2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAssertOperatorTypes(expression2, type2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSynchronizedExpressionType(expression2, type2, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkConditionalExpressionBranchTypesMatch(expression2, type2));
        }
        if (!this.myHolder.hasErrorResults() && parent instanceof PsiThrowStatement && ((PsiThrowStatement)parent).getException() == expression2 && type2 != null) {
            this.myHolder.add(HighlightUtil.checkMustBeThrowable(type2, (PsiElement)expression2, true));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkConstantExpression(expression2));
        }
        if (!this.myHolder.hasErrorResults() && HighlightVisitorImpl.shouldReportForeachNotApplicable(expression2)) {
            this.myHolder.add(GenericsHighlightUtil.checkForeachExpressionTypeIsIterable(expression2));
        }
    }

    private static boolean shouldReportForeachNotApplicable(@NotNull PsiExpression expression2) {
        if (!(expression2.getParent() instanceof PsiForeachStatement)) {
            return false;
        }
        @NotNull PsiForeachStatement parentForEach = (PsiForeachStatement)expression2.getParent();
        PsiExpression iteratedValue2 = parentForEach.getIteratedValue();
        if (iteratedValue2 != expression2) {
            return false;
        }
        PsiType iteratedValueType = iteratedValue2.getType();
        return iteratedValueType == null || !PsiTypesUtil.hasUnresolvedComponents((PsiType)iteratedValueType);
    }

    public void visitExpressionList(PsiExpressionList list) {
        PsiMethodCallExpression expression2;
        super.visitExpressionList(list);
        PsiElement parent = list.getParent();
        if (parent instanceof PsiMethodCallExpression && (expression2 = (PsiMethodCallExpression)parent).getArgumentList() == list) {
            PsiReferenceExpression referenceExpression = expression2.getMethodExpression();
            JavaResolveResult[] results = this.resolveOptimised(referenceExpression);
            if (results == null) {
                return;
            }
            JavaResolveResult result = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
            PsiElement resolved = result.getElement();
            if (!(result.isAccessible() && result.isStaticsScopeCorrect() || HighlightMethodUtil.isDummyConstructorCall(expression2, this.getResolveHelper(this.myHolder.getProject()), list, referenceExpression) || referenceExpression.getParent() != expression2)) {
                try {
                    if (PsiTreeUtil.findChildrenOfType((PsiElement)expression2.getArgumentList(), PsiLambdaExpression.class).isEmpty()) {
                        this.myHolder.add(HighlightMethodUtil.checkAmbiguousMethodCallArguments(referenceExpression, results, list, resolved, result, expression2, this.getResolveHelper(this.myHolder.getProject()), (PsiElement)list));
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
        }
    }

    public void visitField(PsiField field) {
        super.visitField(field);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkIllegalInstanceMemberInRecord((PsiMember)field));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkFinalFieldInitialized(field));
        }
    }

    public void visitForStatement(PsiForStatement statement) {
        this.myHolder.add(HighlightUtil.checkForStatement(statement));
    }

    public void visitForeachStatement(PsiForeachStatement statement) {
        this.myHolder.add(this.checkFeature((PsiElement)statement, HighlightingFeature.FOR_EACH));
    }

    public void visitImportStaticStatement(PsiImportStaticStatement statement) {
        this.myHolder.add(this.checkFeature((PsiElement)statement, HighlightingFeature.STATIC_IMPORTS));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(ImportsHighlightUtil.checkStaticOnDemandImportResolvesToClass(statement));
        }
        if (!this.myHolder.hasErrorResults()) {
            PsiElement referenceNameElement2;
            PsiJavaCodeReferenceElement importReference2 = statement.getImportReference();
            PsiClass targetClass = statement.resolveTargetClass();
            if (importReference2 != null && (referenceNameElement2 = importReference2.getReferenceNameElement()) != null && targetClass != null) {
                this.myHolder.add(GenericsHighlightUtil.checkClassSupersAccessibility(targetClass, referenceNameElement2));
            }
        }
    }

    public void visitIdentifier(PsiIdentifier identifier) {
        TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
        PsiElement parent = identifier.getParent();
        if (parent instanceof PsiVariable) {
            boolean isMethodParameter;
            PsiElement child;
            PsiVariable variable = (PsiVariable)parent;
            this.myHolder.add(HighlightUtil.checkVariableAlreadyDefined(variable));
            if (variable.getInitializer() == null && (child = variable.getLastChild()) instanceof PsiErrorElement && child.getPrevSibling() == identifier) {
                return;
            }
            boolean bl = isMethodParameter = variable instanceof PsiParameter && ((PsiParameter)variable).getDeclarationScope() instanceof PsiMethod;
            if (isMethodParameter) {
                this.myReassignedParameters.put((PsiParameter)variable, ReassignedState.INSIDE_FILE);
            } else if (HighlightControlFlowUtil.isReassigned(variable, this.myFinalVarProblems)) {
                this.myHolder.add(HighlightNamesUtil.highlightReassignedVariable(variable, (PsiElement)identifier));
            } else {
                this.myHolder.add(HighlightNamesUtil.highlightVariableName(variable, (PsiElement)identifier, colorsScheme));
            }
        } else if (parent instanceof PsiClass) {
            PsiClass aClass = (PsiClass)parent;
            if (aClass.isAnnotationType()) {
                this.myHolder.add(this.checkFeature((PsiElement)identifier, HighlightingFeature.ANNOTATIONS));
            }
            this.myHolder.add(HighlightClassUtil.checkClassAlreadyImported(aClass, (PsiElement)identifier));
            if (!(parent instanceof PsiAnonymousClass) && aClass.getNameIdentifier() == identifier) {
                this.myHolder.add(HighlightNamesUtil.highlightClassName(aClass, (PsiElement)identifier, colorsScheme));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkClassRestrictedKeyword(this.myLanguageLevel, identifier));
            }
            if (!this.myHolder.hasErrorResults() && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                this.myHolder.add(GenericsHighlightUtil.checkUnrelatedDefaultMethods(aClass, identifier));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkUnrelatedConcrete(aClass, identifier));
            }
        } else if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            if (method.isConstructor()) {
                PsiType expectedType;
                HighlightInfo info = HighlightMethodUtil.checkConstructorName(method);
                if (info != null && (expectedType = this.myExpectedReturnTypes.computeIfAbsent(method, HighlightMethodUtil::determineReturnType)) != null) {
                    HighlightUtil.registerReturnTypeFixes(info, method, expectedType);
                }
                this.myHolder.add(info);
            }
            this.myHolder.add(HighlightNamesUtil.highlightMethodName(method, (PsiElement)identifier, true, colorsScheme));
            PsiClass aClass = method.getContainingClass();
            if (aClass != null) {
                this.myHolder.add(GenericsHighlightUtil.checkDefaultMethodOverrideEquivalentToObjectNonPrivate(this.myLanguageLevel, aClass, method, (PsiElement)identifier));
            }
        }
        this.myHolder.add(HighlightUtil.checkUnderscore(identifier, this.myLanguageLevel));
        super.visitIdentifier(identifier);
    }

    public void visitImportStatement(PsiImportStatement statement) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSingleImportClassConflict(statement, this.mySingleImportedClasses, this.myFile));
        }
    }

    public void visitImportStaticReferenceElement(@NotNull PsiImportStaticReferenceElement ref) {
        String refName = ref.getReferenceName();
        HighlightInfo results = ref.multiResolve(false);
        PsiElement referenceNameElement2 = ref.getReferenceNameElement();
        if (((JavaResolveResult[])results).length == 0) {
            String description = JavaErrorBundle.message("cannot.resolve.symbol", refName);
            assert (referenceNameElement2 != null) : ref;
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(referenceNameElement2).descriptionAndTooltip(description).create();
            this.myHolder.add(info);
        } else {
            PsiManager manager = ref.getManager();
            for (JavaResolveResult result : results) {
                Pair<PsiImportStaticReferenceElement, PsiClass> imported;
                PsiElement element = result.getElement();
                String description = null;
                if (element instanceof PsiClass) {
                    imported = this.mySingleImportedClasses.get(refName);
                    PsiClass aClass = (PsiClass)Pair.getSecond(imported);
                    if (aClass != null && !manager.areElementsEquivalent((PsiElement)aClass, element)) {
                        description = imported.first == null ? JavaErrorBundle.message("single.import.class.conflict", refName) : (((PsiImportStaticReferenceElement)imported.first).equals(ref) ? JavaErrorBundle.message("class.is.ambiguous.in.single.static.import", refName) : JavaErrorBundle.message("class.is.already.defined.in.single.static.import", refName));
                    }
                    this.mySingleImportedClasses.put(refName, (Pair<PsiImportStaticReferenceElement, PsiClass>)Pair.create((Object)ref, (Object)((PsiClass)element)));
                } else if (element instanceof PsiField) {
                    imported = this.mySingleImportedFields.get(refName);
                    PsiField field = (PsiField)Pair.getSecond(imported);
                    if (field != null && !manager.areElementsEquivalent((PsiElement)field, element)) {
                        description = ((PsiImportStaticReferenceElement)imported.first).equals(ref) ? JavaErrorBundle.message("field.is.ambiguous.in.single.static.import", refName) : JavaErrorBundle.message("field.is.already.defined.in.single.static.import", refName);
                    }
                    this.mySingleImportedFields.put(refName, (Pair<PsiImportStaticReferenceElement, PsiField>)Pair.create((Object)ref, (Object)((PsiField)element)));
                }
                if (description == null) continue;
                this.myHolder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(description).create());
            }
        }
        if (!this.myHolder.hasErrorResults() && ((HighlightInfo)results).length == 1) {
            this.myHolder.add(HighlightUtil.checkReference((PsiJavaCodeReferenceElement)ref, (JavaResolveResult)results[0], this.myFile, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            PsiElement resolved;
            PsiElement psiElement = resolved = ((HighlightInfo)results).length >= 1 ? results[0].getElement() : null;
            if (((HighlightInfo)results).length > 1) {
                for (int i = 1; i < ((HighlightInfo)results).length; ++i) {
                    PsiElement element = results[i].getElement();
                    if (!(resolved instanceof PsiMethod && !(element instanceof PsiMethod) || resolved instanceof PsiVariable && !(element instanceof PsiVariable)) && (!(resolved instanceof PsiClass) || element instanceof PsiClass)) continue;
                    resolved = null;
                    break;
                }
            }
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            if (resolved instanceof PsiClass) {
                this.myHolder.add(HighlightNamesUtil.highlightClassName((PsiClass)resolved, (PsiElement)ref, colorsScheme));
            } else if (referenceNameElement2 != null) {
                if (resolved instanceof PsiVariable) {
                    this.myHolder.add(HighlightNamesUtil.highlightVariableName((PsiVariable)resolved, referenceNameElement2, colorsScheme));
                } else if (resolved instanceof PsiMethod) {
                    this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMethod)resolved, referenceNameElement2, false, colorsScheme));
                }
            }
        }
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
        super.visitInstanceOfExpression(expression2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkInstanceOfApplicable(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkInstanceOfGenericType(this.myLanguageLevel, expression2));
        }
    }

    public void visitKeyword(PsiKeyword keyword) {
        super.visitKeyword(keyword);
        PsiElement parent = keyword.getParent();
        String text2 = keyword.getText();
        if (parent instanceof PsiModifierList) {
            PsiModifierList psiModifierList = (PsiModifierList)parent;
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkNotAllowedModifier(keyword, psiModifierList));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkIllegalModifierCombination(keyword, psiModifierList));
            }
            PsiElement pParent = psiModifierList.getParent();
            if ("abstract".equals(text2) && pParent instanceof PsiMethod && !this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkAbstractMethodInConcreteClass((PsiMethod)pParent, (PsiElement)keyword));
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkStaticDeclarationInInnerClass(keyword));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkIllegalVoidType(keyword));
        }
    }

    public void visitLabeledStatement(PsiLabeledStatement statement) {
        super.visitLabeledStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelWithoutStatement(statement));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkLabelAlreadyInUse(statement));
        }
    }

    public void visitLiteralExpression(PsiLiteralExpression expression2) {
        super.visitLiteralExpression(expression2);
        if (this.myHolder.hasErrorResults()) {
            return;
        }
        this.myHolder.add(HighlightUtil.checkLiteralExpressionParsingError(expression2, this.myLanguageLevel, this.myFile));
        if (this.myRefCountHolder != null && !this.myHolder.hasErrorResults()) {
            this.registerReferencesFromInjectedFragments((PsiElement)expression2);
        }
        if (this.myRefCountHolder != null && !this.myHolder.hasErrorResults()) {
            for (PsiReference reference : expression2.getReferences()) {
                PsiElement resolve2 = reference.resolve();
                if (!(resolve2 instanceof PsiMember)) continue;
                this.myRefCountHolder.registerReference(reference, (JavaResolveResult)new CandidateInfo(resolve2, PsiSubstitutor.EMPTY));
            }
        }
    }

    public void visitMethod(PsiMethod method) {
        super.visitMethod(method);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkUnreachableStatement(method.getBody()));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkConstructorHandleSuperClassExceptions(method));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkRecursiveConstructorInvocation(method));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkSafeVarargsAnnotation(method, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkRecordAccessorDeclaration(method));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(HighlightMethodUtil.checkRecordConstructorDeclaration(method));
        }
        PsiClass aClass = method.getContainingClass();
        if (!this.myHolder.hasErrorResults() && method.isConstructor()) {
            this.myHolder.add(HighlightClassUtil.checkThingNotAllowedInInterface((PsiElement)method, aClass));
        }
        if (!this.myHolder.hasErrorResults() && method.hasModifierProperty("default")) {
            this.myHolder.add(this.checkFeature((PsiElement)method, HighlightingFeature.EXTENSION_METHODS));
        }
        if (!this.myHolder.hasErrorResults() && aClass != null && aClass.isInterface() && method.hasModifierProperty("static")) {
            this.myHolder.add(this.checkFeature((PsiElement)method, HighlightingFeature.EXTENSION_METHODS));
        }
        if (!this.myHolder.hasErrorResults() && aClass != null) {
            this.myHolder.add(HighlightMethodUtil.checkDuplicateMethod(aClass, method, this.getDuplicateMethods(aClass)));
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
        for (PsiParameter parameter2 : parameters2) {
            PsiIdentifier nameIdentifier;
            ReassignedState info = this.myReassignedParameters.getOrDefault(parameter2, ReassignedState.DUNNO);
            if (info == ReassignedState.DUNNO || (nameIdentifier = parameter2.getNameIdentifier()) == null) continue;
            if (info == ReassignedState.REASSIGNED) {
                this.myHolder.add(HighlightNamesUtil.highlightReassignedVariable((PsiVariable)parameter2, (PsiElement)nameIdentifier));
                continue;
            }
            this.myHolder.add(HighlightNamesUtil.highlightVariableName((PsiVariable)parameter2, (PsiElement)nameIdentifier, colorsScheme));
        }
    }

    private void highlightReferencedMethodOrClassName(@NotNull PsiJavaCodeReferenceElement element, @Nullable PsiElement resolved) {
        PsiElement parent = element.getParent();
        TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
        if (parent instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)parent).resolveMethod();
            PsiElement methodNameElement = element.getReferenceNameElement();
            if (method != null && methodNameElement != null && !(methodNameElement instanceof PsiKeyword)) {
                this.myHolder.add(HighlightNamesUtil.highlightMethodName(method, methodNameElement, false, colorsScheme));
            }
        } else if (parent instanceof PsiConstructorCall) {
            try {
                PsiElement referenceNameElement2;
                PsiMethod methodOrClass;
                PsiMethod method = ((PsiConstructorCall)parent).resolveConstructor();
                Object object = method != null ? method : (methodOrClass = resolved instanceof PsiClass ? (PsiClass)resolved : null);
                if (methodOrClass != null && (referenceNameElement2 = element.getReferenceNameElement()) != null) {
                    TextRange range = referenceNameElement2.getTextRange();
                    this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMember)methodOrClass, referenceNameElement2, range, colorsScheme, false));
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {}
        } else if (resolved instanceof PsiPackage) {
            this.myHolder.add(HighlightNamesUtil.highlightPackage(resolved, element, colorsScheme));
        } else if (resolved instanceof PsiClass) {
            this.myHolder.add(HighlightNamesUtil.highlightClassName((PsiClass)resolved, (PsiElement)element, colorsScheme));
        }
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumSuperConstructorCall(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkSuperQualifierType(this.myFile.getProject(), expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            try {
                HighlightMethodUtil.checkMethodCall(expression2, this.getResolveHelper(this.myHolder.getProject()), this.myLanguageLevel, this.myJavaSdkVersion, this.myFile, this.myHolder);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkConstructorCallProblems(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightMethodUtil.checkSuperAbstractMethodDirectCall(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)expression2);
        }
    }

    public void visitModifierList(PsiModifierList list) {
        super.visitModifierList(list);
        PsiElement parent = list.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkMethodCanHaveBody(method, this.myLanguageLevel));
            }
            MethodSignatureBackedByPsiMethod methodSignature = MethodSignatureBackedByPsiMethod.create((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            PsiClass aClass = method.getContainingClass();
            if (!method.isConstructor()) {
                try {
                    List superMethodSignatures = method.getHierarchicalMethodSignature().getSuperSignatures();
                    if (!superMethodSignatures.isEmpty()) {
                        if (!method.hasModifierProperty("static")) {
                            if (!this.myHolder.hasErrorResults()) {
                                this.myHolder.add(HighlightMethodUtil.checkMethodWeakerPrivileges(methodSignature, superMethodSignatures, true, this.myFile));
                            }
                            if (!this.myHolder.hasErrorResults()) {
                                this.myHolder.add(HighlightMethodUtil.checkMethodOverridesFinal(methodSignature, superMethodSignatures));
                            }
                        }
                        if (!this.myHolder.hasErrorResults()) {
                            this.myHolder.add(HighlightMethodUtil.checkMethodIncompatibleReturnType(methodSignature, superMethodSignatures, true));
                        }
                        if (aClass != null && !this.myHolder.hasErrorResults()) {
                            this.myHolder.add(HighlightMethodUtil.checkMethodIncompatibleThrows(methodSignature, superMethodSignatures, true, aClass));
                        }
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkMethodMustHaveBody(method, aClass));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkConstructorCallsBaseClassConstructor(method, this.myRefCountHolder, this.getResolveHelper(this.myHolder.getProject())));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightMethodUtil.checkStaticMethodOverride(method, this.myFile));
            }
            if (!this.myHolder.hasErrorResults() && aClass != null && this.myOverrideEquivalentMethodsVisitedClasses.add(aClass)) {
                this.myHolder.addAll(GenericsHighlightUtil.checkOverrideEquivalentMethods(aClass));
            }
        } else if (parent instanceof PsiClass) {
            PsiClass aClass = (PsiClass)parent;
            try {
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightClassUtil.checkDuplicateNestedClass(aClass));
                }
                if (!this.myHolder.hasErrorResults()) {
                    TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
                    this.myHolder.add(HighlightClassUtil.checkClassMustBeAbstract(aClass, textRange));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightClassUtil.checkClassDoesNotCallSuperConstructorOrHandleExceptions(aClass, this.myRefCountHolder, this.getResolveHelper(this.myHolder.getProject())));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightMethodUtil.checkOverrideEquivalentInheritedMethods(aClass, this.myFile, this.myLanguageLevel));
                }
                if (!this.myHolder.hasErrorResults() && this.myOverrideEquivalentMethodsVisitedClasses.add(aClass)) {
                    this.myHolder.addAll(GenericsHighlightUtil.checkOverrideEquivalentMethods(aClass));
                }
                if (!this.myHolder.hasErrorResults()) {
                    this.myHolder.add(HighlightClassUtil.checkCyclicInheritance(aClass));
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {}
        } else if (parent instanceof PsiEnumConstant && !this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(GenericsHighlightUtil.checkEnumConstantModifierList(list));
        }
    }

    public void visitNameValuePair(PsiNameValuePair pair2) {
        PsiIdentifier nameId;
        this.myHolder.add(AnnotationsHighlightUtil.checkNameValuePair(pair2, this.myRefCountHolder));
        if (!this.myHolder.hasErrorResults() && (nameId = pair2.getNameIdentifier()) != null) {
            HighlightInfo result = HighlightInfo.newHighlightInfo((HighlightInfoType)JavaHighlightInfoTypes.ANNOTATION_ATTRIBUTE_NAME).range((PsiElement)nameId).create();
            this.myHolder.add(result);
        }
    }

    public void visitNewExpression(PsiNewExpression expression2) {
        PsiType type2 = expression2.getType();
        PsiClass aClass = PsiUtil.resolveClassInType((PsiType)type2);
        PsiJavaCodeReferenceElement classReference2 = expression2.getClassReference();
        this.myHolder.add(HighlightUtil.checkUnhandledExceptions((PsiElement)expression2, classReference2 != null ? classReference2.getTextRange() : null));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkAnonymousInheritFinal(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkAnonymousInheritProhibited(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkAnonymousSealedProhibited(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkQualifiedNew(expression2, type2, aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkCreateInnerClassFromStaticContext(expression2, type2, aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkTypeParameterInstantiation(expression2));
        }
        if (aClass != null && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkInstantiationOfAbstractClass(aClass, (PsiElement)expression2));
        }
        try {
            if (!this.myHolder.hasErrorResults()) {
                HighlightMethodUtil.checkNewExpression(expression2, type2, this.myHolder, this.myJavaSdkVersion);
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkEnumInstantiation((PsiElement)expression2, aClass));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkGenericArrayCreation((PsiElement)expression2, type2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.registerConstructorCall((PsiConstructorCall)expression2);
        }
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)expression2);
        }
    }

    public void visitPackageStatement(PsiPackageStatement statement) {
        super.visitPackageStatement(statement);
        this.myHolder.add(AnnotationsHighlightUtil.checkPackageAnnotationContainingFile(statement, this.myFile));
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9) && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkPackageStatement(statement, this.myFile, this.myJavaModule));
        }
    }

    public void visitRecordComponent(PsiRecordComponent recordComponent) {
        super.visitRecordComponent(recordComponent);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkRecordComponentVarArg(recordComponent));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkRecordComponentName(recordComponent));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightControlFlowUtil.checkRecordComponentInitialized(recordComponent));
        }
    }

    public void visitParameter(PsiParameter parameter2) {
        super.visitParameter(parameter2);
        PsiElement parent = parameter2.getParent();
        if (parent instanceof PsiParameterList && parameter2.isVarArgs()) {
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(this.checkFeature((PsiElement)parameter2, HighlightingFeature.VARARGS));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkVarArgParameterIsLast(parameter2));
            }
        } else if (parent instanceof PsiCatchSection) {
            if (!this.myHolder.hasErrorResults() && parameter2.getType() instanceof PsiDisjunctionType) {
                this.myHolder.add(this.checkFeature((PsiElement)parameter2, HighlightingFeature.MULTI_CATCH));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkCatchParameterIsThrowable(parameter2));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.addAll(GenericsHighlightUtil.checkCatchParameterIsClass(parameter2));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.addAll(HighlightUtil.checkCatchTypeIsDisjoint(parameter2));
            }
        } else if (parent instanceof PsiForeachStatement && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkForEachParameterType((PsiForeachStatement)parent, parameter2));
        }
    }

    public void visitParameterList(PsiParameterList list) {
        super.visitParameterList(list);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkAnnotationMethodParameters(list));
        }
    }

    public void visitUnaryExpression(PsiUnaryExpression expression2) {
        super.visitUnaryExpression(expression2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnaryOperatorApplicable(expression2.getOperationSign(), expression2.getOperand()));
        }
    }

    private void registerConstructorCall(@NotNull PsiConstructorCall constructorCall) {
        JavaResolveResult resolveResult;
        PsiElement resolved;
        if (this.myRefCountHolder != null && (resolved = (resolveResult = constructorCall.resolveMethodGenerics()).getElement()) instanceof PsiNamedElement) {
            this.myRefCountHolder.registerLocallyReferenced((PsiNamedElement)resolved);
        }
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement ref) {
        JavaResolveResult result = this.doVisitReferenceElement(ref);
        if (result != null) {
            PsiElement resolved = result.getElement();
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkRawOnParameterizedType(ref, resolved));
            }
        }
    }

    private JavaResolveResult doVisitReferenceElement(@NotNull PsiJavaCodeReferenceElement ref) {
        PsiClass containingClass;
        JavaResolveResult result = this.resolveOptimised(ref);
        if (result == null) {
            return null;
        }
        PsiElement resolved = result.getElement();
        PsiElement parent = ref.getParent();
        if (this.myRefCountHolder != null) {
            this.myRefCountHolder.registerReference((PsiReference)ref, result);
        }
        this.myHolder.add(HighlightUtil.checkReference(ref, result, this.myFile, this.myLanguageLevel));
        if ((parent instanceof PsiJavaCodeReferenceElement || ref.isQualified()) && !this.myHolder.hasErrorResults() && resolved instanceof PsiTypeParameter) {
            boolean canSelectFromTypeParameter = this.myJavaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7);
            if (canSelectFromTypeParameter && (containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class)) != null && (PsiTreeUtil.isAncestor((PsiElement)containingClass.getExtendsList(), (PsiElement)ref, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)containingClass.getImplementsList(), (PsiElement)ref, (boolean)false))) {
                canSelectFromTypeParameter = false;
            }
            if (!canSelectFromTypeParameter) {
                this.myHolder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(JavaErrorBundle.message("cannot.select.from.a.type.parameter", new Object[0])).range((PsiElement)ref).create());
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkAbstractInstantiation(ref));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkExtendsDuplicate(ref, resolved, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightClassUtil.checkClassExtendsForeignInnerClass(ref, resolved));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkSelectStaticClassFromParameterizedType(resolved, ref));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, ref, result.getSubstitutor(), this.myJavaSdkVersion));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkCannotPassInner(ref));
        }
        if (resolved != null && parent instanceof PsiReferenceList && !this.myHolder.hasErrorResults()) {
            PsiReferenceList referenceList = (PsiReferenceList)parent;
            this.myHolder.add(HighlightUtil.checkElementInReferenceList(ref, referenceList, result));
        }
        if (parent instanceof PsiAnonymousClass && ref.equals(((PsiAnonymousClass)parent).getBaseClassReference())) {
            if (this.myOverrideEquivalentMethodsVisitedClasses.add((PsiClass)parent)) {
                PsiClass aClass = (PsiClass)parent;
                this.myHolder.addAll(GenericsHighlightUtil.checkOverrideEquivalentMethods(aClass));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkGenericCannotExtendException((PsiAnonymousClass)parent));
            }
        }
        if (resolved instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)resolved;
            if (!(variable instanceof PsiField)) {
                containingClass = PsiTreeUtil.getNonStrictParentOfType((PsiElement)ref, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
                while ((containingClass instanceof PsiAnonymousClass || containingClass instanceof PsiLambdaExpression) && !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)variable, (boolean)false)) {
                    if (containingClass instanceof PsiLambdaExpression || !PsiTreeUtil.isAncestor((PsiElement)((PsiAnonymousClass)containingClass).getArgumentList(), (PsiElement)ref, (boolean)false)) {
                        this.myHolder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)JavaHighlightInfoTypes.IMPLICIT_ANONYMOUS_CLASS_PARAMETER).range((PsiElement)ref).create());
                        break;
                    }
                    containingClass = PsiTreeUtil.getParentOfType((PsiElement)containingClass, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
                }
            }
            if (variable instanceof PsiParameter && ref instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)ref))) {
                this.myReassignedParameters.put((PsiParameter)variable, ReassignedState.REASSIGNED);
            }
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            if (!variable.hasModifierProperty("final") && this.isReassigned(variable)) {
                this.myHolder.add(HighlightNamesUtil.highlightReassignedVariable(variable, (PsiElement)ref));
            } else {
                PsiElement nameElement = ref.getReferenceNameElement();
                if (nameElement != null) {
                    this.myHolder.add(HighlightNamesUtil.highlightVariableName(variable, nameElement, colorsScheme));
                }
            }
        } else {
            this.highlightReferencedMethodOrClassName(ref, resolved);
        }
        if (parent instanceof PsiNewExpression && !(resolved instanceof PsiClass) && resolved instanceof PsiNamedElement && ((PsiNewExpression)parent).getClassOrAnonymousClassReference() == ref) {
            String text2 = JavaErrorBundle.message("cannot.resolve.symbol", ((PsiNamedElement)resolved).getName());
            this.myHolder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(text2).create());
        }
        if (!this.myHolder.hasErrorResults() && resolved instanceof PsiClass) {
            PsiClass aClass = ((PsiClass)resolved).getContainingClass();
            if (aClass != null) {
                PsiExpression newQualifier;
                PsiElement qualifier = ref.getQualifier();
                Object place = qualifier instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)qualifier).resolve() : (parent instanceof PsiNewExpression ? ((newQualifier = ((PsiNewExpression)parent).getQualifier()) == null ? ref : PsiUtil.resolveClassInType((PsiType)newQualifier.getType())) : ref);
                if (place != null && PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)place, (boolean)false) && aClass.hasTypeParameters()) {
                    this.myHolder.add(HighlightClassUtil.checkCreateInnerClassFromStaticContext((PsiElement)ref, place, (PsiClass)resolved));
                }
            } else if (resolved instanceof PsiTypeParameter) {
                PsiClass cls;
                PsiTypeParameterListOwner owner2 = ((PsiTypeParameter)resolved).getOwner();
                if (owner2 instanceof PsiClass) {
                    PsiClass outerClass = (PsiClass)owner2;
                    if (!InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)outerClass, (PsiElement)ref, (boolean)false, (boolean)false)) {
                        this.myHolder.add(HighlightClassUtil.reportIllegalEnclosingUsage((PsiElement)ref, null, (PsiClass)owner2, (PsiElement)ref));
                    }
                } else if (owner2 instanceof PsiMethod && (cls = ClassUtils.getContainingStaticClass((PsiElement)ref)) != null && PsiTreeUtil.isAncestor((PsiElement)owner2, (PsiElement)cls, (boolean)true)) {
                    String description = JavaErrorBundle.message("cannot.be.referenced.from.static.context", ref.getReferenceName());
                    this.myHolder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(description).create());
                }
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkPackageAndClassConflict(ref, this.myFile));
        }
        if (!this.myHolder.hasErrorResults() && resolved instanceof PsiClass) {
            this.myHolder.add(HighlightUtil.checkRestrictedIdentifierReference(ref, (PsiClass)resolved, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkMemberReferencedBeforeConstructorCalled((PsiElement)ref, resolved, this.myFile, this.myInsideConstructorOfClass));
        }
        return result;
    }

    @Nullable
    private JavaResolveResult resolveOptimised(@NotNull PsiJavaCodeReferenceElement ref) {
        try {
            if (ref instanceof PsiReferenceExpressionImpl) {
                PsiReferenceExpressionImpl.OurGenericsResolver resolver = PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE;
                JavaResolveResult[] results = JavaResolveUtil.resolveWithContainingFile(ref, resolver, true, true, this.myFile);
                return results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
            }
            return ref.advancedResolve(true);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    private JavaResolveResult @Nullable [] resolveOptimised(@NotNull PsiReferenceExpression expression2) {
        try {
            if (expression2 instanceof PsiReferenceExpressionImpl) {
                PsiReferenceExpressionImpl.OurGenericsResolver resolver = PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE;
                return JavaResolveUtil.resolveWithContainingFile(expression2, resolver, true, true, this.myFile);
            }
            return expression2.multiResolve(true);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        PsiElement parent;
        JavaResolveResult[] results;
        JavaResolveResult resultForIncompleteCode = this.doVisitReferenceElement((PsiJavaCodeReferenceElement)expression2);
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)expression2);
            if (this.myHolder.hasErrorResults()) {
                return;
            }
        }
        if ((results = this.resolveOptimised(expression2)) == null) {
            return;
        }
        JavaResolveResult result = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        PsiElement resolved = result.getElement();
        if (resolved instanceof PsiVariable && resolved.getContainingFile() == expression2.getContainingFile()) {
            PsiVariable variable = (PsiVariable)resolved;
            boolean isFinal = variable.hasModifierProperty("final");
            if (isFinal && !variable.hasInitializer() && !this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightControlFlowUtil.checkFinalVariableMightAlreadyHaveBeenAssignedTo(variable, expression2, this.myFinalVarProblems));
            }
            if (!this.myHolder.hasErrorResults()) {
                try {
                    this.myHolder.add(HighlightControlFlowUtil.checkVariableInitializedBeforeUsage(expression2, (PsiVariable)resolved, this.myUninitializedVarProblems, this.myFile));
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
        }
        if (!(!((parent = expression2.getParent()) instanceof PsiMethodCallExpression) || ((PsiMethodCallExpression)parent).getMethodExpression() != expression2 || result.isAccessible() && result.isStaticsScopeCorrect())) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent;
            PsiExpressionList list = methodCallExpression.getArgumentList();
            PsiResolveHelper resolveHelper = this.getResolveHelper(this.myHolder.getProject());
            if (!HighlightMethodUtil.isDummyConstructorCall(methodCallExpression, resolveHelper, list, expression2)) {
                try {
                    PsiElement nameElement;
                    this.myHolder.add(HighlightMethodUtil.checkAmbiguousMethodCallIdentifier(expression2, results, list, resolved, result, methodCallExpression, resolveHelper, this.myLanguageLevel, this.myFile));
                    if (!PsiTreeUtil.findChildrenOfType((PsiElement)methodCallExpression.getArgumentList(), PsiLambdaExpression.class).isEmpty() && (nameElement = expression2.getReferenceNameElement()) != null) {
                        this.myHolder.add(HighlightMethodUtil.checkAmbiguousMethodCallArguments(expression2, results, list, resolved, result, methodCallExpression, resolveHelper, nameElement));
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
        }
        if (!this.myHolder.hasErrorResults() && resultForIncompleteCode != null) {
            this.myHolder.add(HighlightUtil.checkExpressionRequired(expression2, resultForIncompleteCode));
        }
        if (!this.myHolder.hasErrorResults() && resolved instanceof PsiField) {
            try {
                this.myHolder.add(HighlightUtil.checkIllegalForwardReferenceToField(expression2, (PsiField)resolved));
            }
            catch (IndexNotReadyException methodCallExpression) {
                // empty catch block
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkAccessStaticFieldFromEnumConstructor(expression2, result));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkClassReferenceAfterQualifier(expression2, resolved));
        }
        PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
        this.myHolder.add(HighlightUtil.checkUnqualifiedSuperInDefaultMethod(this.myLanguageLevel, expression2, qualifierExpression2));
        if (!this.myHolder.hasErrorResults() && this.myJavaModule == null && qualifierExpression2 != null) {
            PsiClass psiClass;
            if (parent instanceof PsiMethodCallExpression && (psiClass = RefactoringChangeUtil.getQualifierClass(expression2)) != null) {
                this.myHolder.add(GenericsHighlightUtil.checkClassSupersAccessibility(psiClass, (PsiElement)expression2));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkMemberSignatureTypesAccessibility(expression2));
            }
        }
    }

    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
        String badReturnTypeMessage;
        PsiElement qualifier;
        PsiElement qualifier2;
        PsiElement referenceNameElement2;
        PsiElement method;
        JavaResolveResult result;
        JavaResolveResult[] results;
        this.myHolder.add(this.checkFeature((PsiElement)expression2, HighlightingFeature.METHOD_REFERENCES));
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (HighlightVisitorImpl.toReportFunctionalExpressionProblemOnParent(parent)) {
            return;
        }
        PsiType functionalInterfaceType = expression2.getFunctionalInterfaceType();
        if (functionalInterfaceType != null && !PsiTypesUtil.allTypeParametersResolved((PsiElement)expression2, (PsiType)functionalInterfaceType)) {
            return;
        }
        try {
            results = expression2.multiResolve(true);
            result = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        }
        catch (IndexNotReadyException e) {
            return;
        }
        if (this.myRefCountHolder != null) {
            this.myRefCountHolder.registerReference((PsiReference)expression2, result);
        }
        if ((method = result.getElement()) instanceof PsiMethod && this.myRefCountHolder != null) {
            for (PsiParameter parameter2 : ((PsiMethod)method).getParameterList().getParameters()) {
                this.myRefCountHolder.registerLocallyReferenced((PsiNamedElement)parameter2);
            }
        }
        if (method instanceof PsiJvmMember && !result.isAccessible()) {
            String accessProblem = HighlightUtil.accessProblemDescription((PsiElement)expression2, method, result);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(accessProblem).create();
            HighlightFixUtil.registerAccessQuickFixAction((PsiJvmMember)method, (PsiJavaCodeReferenceElement)expression2, info, result.getCurrentFileResolveScope());
            this.myHolder.add(info);
        } else {
            PsiElement methodNameElement;
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            if (method instanceof PsiMethod && !expression2.isConstructor() && (methodNameElement = expression2.getReferenceNameElement()) != null) {
                this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMethod)method, methodNameElement, false, colorsScheme));
            }
        }
        if (!LambdaUtil.isValidLambdaContext((PsiElement)parent)) {
            String description = JavaErrorBundle.message("method.reference.expression.is.not.expected", new Object[0]);
            this.myHolder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create());
        }
        if (!this.myHolder.hasErrorResults() && (referenceNameElement2 = expression2.getReferenceNameElement()) instanceof PsiKeyword && !PsiMethodReferenceUtil.isValidQualifier((PsiMethodReferenceExpression)expression2) && (qualifier2 = expression2.getQualifier()) != null) {
            String description = JavaErrorBundle.message("cannot.find.class", qualifier2.getText());
            this.myHolder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(qualifier2).descriptionAndTooltip(description).create());
        }
        if (functionalInterfaceType != null) {
            String errorMessage;
            boolean isFunctional;
            if (!this.myHolder.hasErrorResults() && !(isFunctional = LambdaUtil.isFunctionalType((PsiType)functionalInterfaceType))) {
                String description = JavaErrorBundle.message("not.a.functional.interface", functionalInterfaceType.getPresentableText());
                this.myHolder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create());
            }
            if (!this.myHolder.hasErrorResults()) {
                this.checkFunctionalInterfaceTypeAccessible((PsiFunctionalExpression)expression2, functionalInterfaceType);
            }
            if (!this.myHolder.hasErrorResults() && (errorMessage = PsiMethodReferenceHighlightingUtil.checkMethodReferenceContext(expression2)) != null) {
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(errorMessage).create();
                if (method instanceof PsiMethod && !((PsiMethod)method).isConstructor() && !((PsiMethod)method).hasModifierProperty("abstract")) {
                    boolean shouldHave = !((PsiMethod)method).hasModifierProperty("static");
                    QuickFixAction.registerQuickFixActions((HighlightInfo)info, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((JvmModifiersOwner)method), (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.STATIC, (boolean)shouldHave)));
                }
                this.myHolder.add(info);
            }
        }
        if (!this.myHolder.hasErrorResults() && (qualifier = expression2.getQualifier()) instanceof PsiTypeElement) {
            PsiType psiType = ((PsiTypeElement)qualifier).getType();
            HighlightInfo genericArrayCreationInfo = GenericsHighlightUtil.checkGenericArrayCreation(qualifier, psiType);
            if (genericArrayCreationInfo != null) {
                this.myHolder.add(genericArrayCreationInfo);
            } else {
                String wildcardMessage = PsiMethodReferenceUtil.checkTypeArguments((PsiTypeElement)((PsiTypeElement)qualifier), (PsiType)psiType);
                if (wildcardMessage != null) {
                    this.myHolder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(qualifier).descriptionAndTooltip(wildcardMessage).create());
                }
            }
        }
        if (method instanceof PsiMethod && ((PsiMethod)method).hasModifierProperty("static")) {
            if (!this.myHolder.hasErrorResults() && ((PsiMethod)method).hasTypeParameters()) {
                this.myHolder.add(GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(method, (PsiJavaCodeReferenceElement)expression2, result.getSubstitutor(), this.myJavaSdkVersion));
            }
            PsiClass containingClass = ((PsiMethod)method).getContainingClass();
            if (!this.myHolder.hasErrorResults() && containingClass != null && containingClass.isInterface()) {
                this.myHolder.add(HighlightMethodUtil.checkStaticInterfaceCallQualifier((PsiReferenceExpression)expression2, result, expression2.getTextRange(), containingClass));
            }
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(PsiMethodReferenceHighlightingUtil.checkRawConstructorReference(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnhandledExceptions((PsiElement)expression2, expression2.getTextRange()));
        }
        if (!this.myHolder.hasErrorResults() && (results.length == 0 || results[0] instanceof MethodCandidateInfo && !((MethodCandidateInfo)results[0]).isApplicable() && functionalInterfaceType != null || results.length > 1)) {
            String description = null;
            if (results.length == 1) {
                description = ((MethodCandidateInfo)results[0]).getInferenceErrorMessage();
            }
            if (expression2.isConstructor()) {
                PsiClass containingClass = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)expression2).getContainingClass();
                if (containingClass != null && !this.myHolder.add(HighlightClassUtil.checkInstantiationOfAbstractClass(containingClass, (PsiElement)expression2)) && !this.myHolder.add(GenericsHighlightUtil.checkEnumInstantiation((PsiElement)expression2, containingClass)) && containingClass.isPhysical() && description == null) {
                    description = JavaErrorBundle.message("cannot.resolve.constructor", containingClass.getName());
                }
            } else if (description == null) {
                description = JavaErrorBundle.message("cannot.resolve.method", expression2.getReferenceName());
            }
            if (description != null) {
                PsiElement referenceNameElement3 = (PsiElement)ObjectUtils.notNull((Object)expression2.getReferenceNameElement(), (Object)expression2);
                HighlightInfoType type2 = results.length == 0 ? HighlightInfoType.WRONG_REF : HighlightInfoType.ERROR;
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)type2).descriptionAndTooltip(description).range(referenceNameElement3).create();
                this.myHolder.add(highlightInfo);
                TextRange fixRange = HighlightMethodUtil.getFixRange(referenceNameElement3);
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)QuickFixFactory.getInstance().createCreateMethodFromUsageFix(expression2));
            }
        }
        if (!this.myHolder.hasErrorResults() && (badReturnTypeMessage = PsiMethodReferenceUtil.checkReturnType((PsiMethodReferenceExpression)expression2, (JavaResolveResult)result, (PsiType)functionalInterfaceType)) != null) {
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(badReturnTypeMessage).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)AdjustFunctionContextFix.createFix((PsiElement)expression2));
            this.myHolder.add(info);
        }
    }

    private static boolean toReportFunctionalExpressionProblemOnParent(@Nullable PsiElement parent) {
        if (parent instanceof PsiLocalVariable) {
            return ((PsiLocalVariable)parent).getTypeElement().isInferredType();
        }
        return parent instanceof PsiExpressionStatement && !(parent.getParent() instanceof PsiSwitchLabeledRuleStatement);
    }

    private void checkFunctionalInterfaceTypeAccessible(@NotNull PsiFunctionalExpression expression2, @NotNull PsiType functionalInterfaceType) {
        this.checkFunctionalInterfaceTypeAccessible(expression2, functionalInterfaceType, true);
    }

    private boolean checkFunctionalInterfaceTypeAccessible(@NotNull PsiFunctionalExpression expression2, @NotNull PsiType functionalInterfaceType, boolean checkFunctionalTypeSignature) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass == null) {
            return false;
        }
        if (PsiUtil.isAccessible((Project)this.myFile.getProject(), (PsiMember)psiClass, (PsiElement)expression2, null)) {
            PsiMethod psiMethod;
            for (PsiType type2 : resolveResult.getSubstitutor().getSubstitutionMap().values()) {
                if (type2 == null || !this.checkFunctionalInterfaceTypeAccessible(expression2, type2, false)) continue;
                return true;
            }
            PsiMethod psiMethod2 = psiMethod = checkFunctionalTypeSignature ? LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult) : null;
            if (psiMethod != null) {
                PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)psiMethod, (PsiClassType.ClassResolveResult)resolveResult);
                for (PsiParameter parameter2 : psiMethod.getParameterList().getParameters()) {
                    PsiType substitute = substitutor.substitute(parameter2.getType());
                    if (substitute == null || !this.checkFunctionalInterfaceTypeAccessible(expression2, substitute, false)) continue;
                    return true;
                }
                PsiType substitute = substitutor.substitute(psiMethod.getReturnType());
                return substitute != null && this.checkFunctionalInterfaceTypeAccessible(expression2, substitute, false);
            }
        } else {
            Pair<String, List<IntentionAction>> problem = HighlightUtil.accessProblemDescriptionAndFixes((PsiElement)expression2, (PsiElement)psiClass, (JavaResolveResult)resolveResult);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip((String)problem.first).create();
            this.myHolder.add(info);
            if (problem.second != null) {
                ((List)problem.second).forEach(fix -> QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)fix));
            }
            return true;
        }
        return false;
    }

    public void visitReferenceList(PsiReferenceList list) {
        if (list.getFirstChild() == null) {
            return;
        }
        PsiElement parent = list.getParent();
        if (!(parent instanceof PsiTypeParameter)) {
            this.myHolder.add(AnnotationsHighlightUtil.checkAnnotationDeclaration(parent, list));
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkExtendsAllowed(list));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkImplementsAllowed(list));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightClassUtil.checkClassExtendsOnlyOneClass(list));
            }
            if (!this.myHolder.hasErrorResults()) {
                HighlightClassUtil.checkPermitsList(list, this.myHolder);
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkGenericCannotExtendException(list));
            }
        }
    }

    public void visitReferenceParameterList(PsiReferenceParameterList list) {
        if (list.getTextLength() == 0) {
            return;
        }
        this.myHolder.add(this.checkFeature((PsiElement)list, HighlightingFeature.GENERICS));
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkParametersAllowed(list));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkParametersOnRaw(list));
        }
        if (!this.myHolder.hasErrorResults()) {
            for (PsiTypeElement typeElement : list.getTypeParameterElements()) {
                if (!(typeElement.getType() instanceof PsiDiamondType)) continue;
                this.myHolder.add(this.checkFeature((PsiElement)list, HighlightingFeature.DIAMOND_TYPES));
            }
        }
    }

    public void visitReturnStatement(PsiReturnStatement statement) {
        super.visitStatement((PsiStatement)statement);
        if (!this.myHolder.hasErrorResults() && HighlightingFeature.ENHANCED_SWITCH.isAvailable((PsiElement)this.myFile)) {
            this.myHolder.add(HighlightUtil.checkReturnFromSwitchExpr((PsiStatement)statement));
        }
        if (!this.myHolder.hasErrorResults()) {
            try {
                HighlightInfo info;
                PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiFile.class, PsiClassInitializer.class, PsiLambdaExpression.class, PsiMethod.class});
                if (parent instanceof PsiMethod && JavaPsiRecordUtil.isCompactConstructor((PsiMethod)parent)) {
                    info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(JavaErrorBundle.message("record.compact.constructor.return", new Object[0])).create();
                } else {
                    PsiMethod method;
                    PsiType expectedType;
                    HighlightInfo highlightInfo = info = parent != null ? HighlightUtil.checkReturnStatementType(statement, parent) : null;
                    if (info != null && parent instanceof PsiMethod && (expectedType = this.myExpectedReturnTypes.computeIfAbsent(method = (PsiMethod)parent, HighlightMethodUtil::determineReturnType)) != null && !PsiType.VOID.equals((Object)expectedType)) {
                        HighlightUtil.registerReturnTypeFixes(info, method, expectedType);
                    }
                }
                this.myHolder.add(info);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
    }

    public void visitStatement(PsiStatement statement) {
        super.visitStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkNotAStatement(statement));
        }
    }

    public void visitSuperExpression(PsiSuperExpression expr2) {
        this.myHolder.add(HighlightUtil.checkThisOrSuperExpressionInIllegalContext((PsiExpression)expr2, expr2.getQualifier(), this.myLanguageLevel));
        if (!this.myHolder.hasErrorResults()) {
            this.visitExpression((PsiExpression)expr2);
        }
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        super.visitSwitchLabelStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkCaseStatement((PsiSwitchLabelStatementBase)statement));
        }
    }

    public void visitSwitchLabeledRuleStatement(PsiSwitchLabeledRuleStatement statement) {
        super.visitSwitchLabeledRuleStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkCaseStatement((PsiSwitchLabelStatementBase)statement));
        }
    }

    public void visitSwitchStatement(PsiSwitchStatement statement) {
        super.visitSwitchStatement(statement);
        this.checkSwitchBlock((PsiSwitchBlock)statement);
    }

    public void visitSwitchExpression(PsiSwitchExpression expression2) {
        super.visitSwitchExpression(expression2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature((PsiElement)expression2, HighlightingFeature.SWITCH_EXPRESSION));
        }
        this.checkSwitchBlock((PsiSwitchBlock)expression2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(HighlightUtil.checkSwitchExpressionReturnTypeCompatible(expression2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(HighlightUtil.checkSwitchExpressionHasResult(expression2));
        }
    }

    private void checkSwitchBlock(@NotNull PsiSwitchBlock switchBlock) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSwitchBlockStatements(switchBlock, this.myLanguageLevel, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkSwitchSelectorType(switchBlock, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(HighlightUtil.checkSwitchLabelValues(switchBlock));
        }
    }

    public void visitThisExpression(PsiThisExpression expr2) {
        if (!(expr2.getParent() instanceof PsiReceiverParameter)) {
            this.myHolder.add(HighlightUtil.checkThisOrSuperExpressionInIllegalContext((PsiExpression)expr2, expr2.getQualifier(), this.myLanguageLevel));
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkMemberReferencedBeforeConstructorCalled((PsiElement)expr2, null, this.myFile, this.myInsideConstructorOfClass));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.visitExpression((PsiExpression)expr2);
            }
        }
    }

    public void visitThrowStatement(PsiThrowStatement statement) {
        this.myHolder.add(HighlightUtil.checkUnhandledExceptions((PsiElement)statement, null));
        if (!this.myHolder.hasErrorResults()) {
            this.visitStatement((PsiStatement)statement);
        }
    }

    public void visitTryStatement(PsiTryStatement statement) {
        super.visitTryStatement(statement);
        if (!this.myHolder.hasErrorResults()) {
            Set<PsiClassType> thrownTypes = HighlightUtil.collectUnhandledExceptions(statement);
            for (PsiParameter parameter2 : statement.getCatchBlockParameters()) {
                boolean added = this.myHolder.addAll(HighlightUtil.checkExceptionAlreadyCaught(parameter2));
                if (!added) {
                    added = this.myHolder.addAll(HighlightUtil.checkExceptionThrownInTry(parameter2, thrownTypes));
                }
                if (added) continue;
                this.myHolder.addAll(HighlightUtil.checkWithImprovedCatchAnalysis(parameter2, thrownTypes, this.myFile));
            }
        }
    }

    public void visitResourceList(PsiResourceList resourceList) {
        super.visitResourceList(resourceList);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature((PsiElement)resourceList, HighlightingFeature.TRY_WITH_RESOURCES));
        }
    }

    public void visitResourceVariable(PsiResourceVariable resource) {
        super.visitResourceVariable(resource);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkTryResourceIsAutoCloseable((PsiResourceListElement)resource));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnhandledCloserExceptions((PsiResourceListElement)resource));
        }
    }

    public void visitResourceExpression(PsiResourceExpression resource) {
        super.visitResourceExpression(resource);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature((PsiElement)resource, HighlightingFeature.REFS_AS_RESOURCE));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkResourceVariableIsFinal(resource));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkTryResourceIsAutoCloseable((PsiResourceListElement)resource));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkUnhandledCloserExceptions((PsiResourceListElement)resource));
        }
    }

    public void visitTypeElement(PsiTypeElement type2) {
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(HighlightUtil.checkIllegalType(type2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkReferenceTypeUsedAsTypeArgument(type2, this.myLanguageLevel));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(GenericsHighlightUtil.checkWildcardUsage(type2));
        }
    }

    public void visitTypeCastExpression(PsiTypeCastExpression typeCast) {
        super.visitTypeCastExpression(typeCast);
        try {
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkIntersectionInTypeCast(typeCast, this.myLanguageLevel, this.myFile));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkInconvertibleTypeCast(typeCast));
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    public void visitTypeParameterList(PsiTypeParameterList list) {
        PsiTypeParameter[] typeParameters = list.getTypeParameters();
        if (typeParameters.length > 0) {
            this.myHolder.add(this.checkFeature((PsiElement)list, HighlightingFeature.GENERICS));
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(GenericsHighlightUtil.checkTypeParametersList(list, typeParameters, this.myLanguageLevel));
            }
        }
    }

    public void visitVariable(PsiVariable variable) {
        super.visitVariable(variable);
        if (variable instanceof PsiPatternVariable) {
            this.myHolder.add(this.checkFeature((PsiElement)((PsiPatternVariable)variable).getNameIdentifier(), HighlightingFeature.PATTERNS));
        }
        try {
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkVarTypeApplicability(variable));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(HighlightUtil.checkVariableInitializerType(variable));
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    private boolean isReassigned(@NotNull PsiVariable variable) {
        try {
            boolean reassigned = variable instanceof PsiParameter ? this.myReassignedParameters.get(variable) == ReassignedState.REASSIGNED : HighlightControlFlowUtil.isReassigned(variable, this.myFinalVarProblems);
            return reassigned;
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        super.visitConditionalExpression(expression2);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) && PsiPolyExpressionUtil.isPolyExpression((PsiExpression)expression2)) {
            PsiType conditionalType;
            PsiElement parent;
            PsiElement element = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
            if (element instanceof PsiExpressionList && (parent = element.getParent()) instanceof PsiCall && !((PsiCall)parent).resolveMethodGenerics().isValidResult()) {
                return;
            }
            PsiExpression thenExpression2 = expression2.getThenExpression();
            PsiExpression elseExpression2 = expression2.getElseExpression();
            if (thenExpression2 != null && elseExpression2 != null && (conditionalType = expression2.getType()) != null) {
                PsiExpression[] sides;
                for (PsiExpression side : sides = new PsiExpression[]{thenExpression2, elseExpression2}) {
                    PsiType sideType = side.getType();
                    if (sideType == null || TypeConversionUtil.isAssignable((PsiType)conditionalType, (PsiType)sideType)) continue;
                    this.myHolder.add(HighlightUtil.checkAssignability(conditionalType, sideType, side, (PsiElement)side));
                }
            }
        }
    }

    public void visitReceiverParameter(PsiReceiverParameter parameter2) {
        super.visitReceiverParameter(parameter2);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature((PsiElement)parameter2, HighlightingFeature.RECEIVERS));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkReceiverPlacement(parameter2));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(AnnotationsHighlightUtil.checkReceiverType(parameter2));
        }
    }

    public void visitModule(PsiJavaModule module) {
        super.visitModule(module);
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(this.checkFeature((PsiElement)module, HighlightingFeature.MODULES));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkFileName(module, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkFileDuplicates(module, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(ModuleHighlightUtil.checkDuplicateStatements(module));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkClashingReads(module));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(ModuleHighlightUtil.checkUnusedServices(module, this.myFile));
        }
        if (!this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkFileLocation(module, this.myFile));
        }
    }

    public void visitRequiresStatement(PsiRequiresStatement statement) {
        super.visitRequiresStatement(statement);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(ModuleHighlightUtil.checkModuleReference(statement));
            }
            if (!this.myHolder.hasErrorResults() && this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_10)) {
                this.myHolder.addAll(ModuleHighlightUtil.checkModifiers(statement));
            }
        }
    }

    public void visitPackageAccessibilityStatement(PsiPackageAccessibilityStatement statement) {
        super.visitPackageAccessibilityStatement(statement);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(ModuleHighlightUtil.checkHostModuleStrength(statement));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.add(ModuleHighlightUtil.checkPackageReference(statement, this.myFile));
            }
            if (!this.myHolder.hasErrorResults()) {
                this.myHolder.addAll(ModuleHighlightUtil.checkPackageAccessTargets(statement));
            }
        }
    }

    public void visitUsesStatement(PsiUsesStatement statement) {
        super.visitUsesStatement(statement);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9) && !this.myHolder.hasErrorResults()) {
            this.myHolder.add(ModuleHighlightUtil.checkServiceReference(statement.getClassReference()));
        }
    }

    public void visitProvidesStatement(PsiProvidesStatement statement) {
        super.visitProvidesStatement(statement);
        if (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_9) && !this.myHolder.hasErrorResults()) {
            this.myHolder.addAll(ModuleHighlightUtil.checkServiceImplementations(statement, this.myFile));
        }
    }

    private HighlightInfo checkFeature(@NotNull PsiElement element, @NotNull HighlightingFeature feature) {
        return HighlightUtil.checkFeature(element, feature, this.myLanguageLevel, this.myFile);
    }

    private static class Holder {
        private static final boolean CHECK_ELEMENT_LEVEL = ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal();

        private Holder() {
        }
    }

    private static enum ReassignedState {
        DUNNO,
        INSIDE_FILE,
        REASSIGNED;

    }
}

