/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericsHighlightUtil {
    private static final Logger LOG = Logger.getInstance(GenericsHighlightUtil.class);
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
    private static final MethodSignature ourValuesEnumSyntheticMethod = MethodSignatureUtil.createMethodSignature((String)"values", (PsiType[])PsiType.EMPTY_ARRAY, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);

    private GenericsHighlightUtil() {
    }

    static HighlightInfo checkInferredTypeArguments(@NotNull PsiTypeParameterListOwner listOwner, @NotNull PsiElement call, @NotNull PsiSubstitutor substitutor) {
        PsiTypeParameter[] typeParameters = listOwner.getTypeParameters();
        Pair inferredTypeArgument = GenericsUtil.findTypeParameterWithBoundError((PsiTypeParameter[])typeParameters, (PsiSubstitutor)substitutor, (PsiElement)call, (boolean)false);
        if (inferredTypeArgument != null) {
            PsiType extendsType = (PsiType)inferredTypeArgument.second;
            PsiTypeParameter typeParameter = (PsiTypeParameter)inferredTypeArgument.first;
            PsiClass boundClass = extendsType instanceof PsiClassType ? ((PsiClassType)extendsType).resolve() : null;
            String messageKey = boundClass == null || typeParameter.isInterface() == boundClass.isInterface() ? "generics.inferred.type.for.type.parameter.is.not.within.its.bound.extend" : "generics.inferred.type.for.type.parameter.is.not.within.its.bound.implement";
            String description = JavaErrorBundle.message(messageKey, HighlightUtil.formatClass((PsiClass)typeParameter), JavaHighlightUtil.formatType(extendsType), JavaHighlightUtil.formatType(substitutor.substitute(typeParameter)));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(call).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkParameterizedReferenceTypeArguments(@Nullable PsiElement resolved, @NotNull PsiJavaCodeReferenceElement referenceElement, @NotNull PsiSubstitutor substitutor, @NotNull JavaSdkVersion javaSdkVersion) {
        if (!(resolved instanceof PsiTypeParameterListOwner)) {
            return null;
        }
        PsiTypeParameterListOwner typeParameterListOwner = (PsiTypeParameterListOwner)resolved;
        return GenericsHighlightUtil.checkReferenceTypeArgumentList(typeParameterListOwner, referenceElement.getParameterList(), substitutor, true, javaSdkVersion);
    }

    static HighlightInfo checkReferenceTypeArgumentList(@NotNull PsiTypeParameterListOwner typeParameterListOwner, @Nullable PsiReferenceParameterList referenceParameterList, @NotNull PsiSubstitutor substitutor, boolean registerIntentions, @NotNull JavaSdkVersion javaSdkVersion) {
        block15: {
            int refParametersNum;
            PsiDiamondType.DiamondInferenceResult inferenceResult = null;
            PsiTypeElement[] referenceElements = null;
            if (referenceParameterList != null && (referenceElements = referenceParameterList.getTypeParameterElements()).length == 1 && referenceElements[0].getType() instanceof PsiDiamondType) {
                if (!typeParameterListOwner.hasTypeParameters()) {
                    String description = JavaErrorBundle.message("generics.diamond.not.applicable", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)referenceParameterList).descriptionAndTooltip(description).create();
                }
                inferenceResult = ((PsiDiamondType)referenceElements[0].getType()).resolveInferredTypes();
                String errorMessage = inferenceResult.getErrorMessage();
                if (errorMessage != null) {
                    PsiType expectedType = GenericsHighlightUtil.detectExpectedType(referenceParameterList);
                    if (!(inferenceResult.failedToInfer() && expectedType instanceof PsiClassType && ((PsiClassType)expectedType).isRaw())) {
                        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)referenceParameterList).descriptionAndTooltip(errorMessage).create();
                        if (inferenceResult == PsiDiamondType.DiamondInferenceResult.ANONYMOUS_INNER_RESULT && !PsiUtil.isLanguageLevel9OrHigher((PsiElement)referenceParameterList)) {
                            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createIncreaseLanguageLevelFix(LanguageLevel.JDK_1_9));
                        }
                        return highlightInfo;
                    }
                }
            }
            PsiTypeParameter[] typeParameters = typeParameterListOwner.getTypeParameters();
            int targetParametersNum = typeParameters.length;
            int n = refParametersNum = referenceParameterList == null ? 0 : referenceParameterList.getTypeArguments().length;
            if (targetParametersNum != refParametersNum && refParametersNum != 0) {
                String description = targetParametersNum == 0 ? (PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiCall.class) != null && typeParameterListOwner instanceof PsiMethod && (javaSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7) || GenericsHighlightUtil.hasSuperMethodsWithTypeParams((PsiMethod)typeParameterListOwner)) ? null : JavaErrorBundle.message("generics.type.or.method.does.not.have.type.parameters", GenericsHighlightUtil.typeParameterListOwnerCategoryDescription(typeParameterListOwner), GenericsHighlightUtil.typeParameterListOwnerDescription(typeParameterListOwner))) : JavaErrorBundle.message("generics.wrong.number.of.type.arguments", refParametersNum, targetParametersNum);
                if (description != null) {
                    HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)referenceParameterList).descriptionAndTooltip(description).create();
                    if (registerIntentions) {
                        PsiElement variable;
                        PsiElement grandParent;
                        if (typeParameterListOwner instanceof PsiClass) {
                            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createChangeClassSignatureFromUsageFix((PsiClass)typeParameterListOwner, referenceParameterList));
                        }
                        if ((grandParent = referenceParameterList.getParent().getParent()) instanceof PsiTypeElement && (variable = grandParent.getParent()) instanceof PsiVariable) {
                            if (targetParametersNum == 0) {
                                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createRemoveTypeArgumentsFix(variable));
                            }
                            GenericsHighlightUtil.registerVariableParameterizedTypeFixes(highlightInfo, (PsiVariable)variable, referenceParameterList, javaSdkVersion);
                        }
                    }
                    return highlightInfo;
                }
            }
            if (targetParametersNum <= 0 || refParametersNum == 0) break block15;
            if (inferenceResult != null) {
                PsiType[] types = inferenceResult.getTypes();
                for (int i = 0; i < typeParameters.length; ++i) {
                    PsiType type2 = types[i];
                    HighlightInfo highlightInfo = GenericsHighlightUtil.checkTypeParameterWithinItsBound(typeParameters[i], substitutor, type2, (PsiElement)referenceElements[0], referenceParameterList);
                    if (highlightInfo == null) continue;
                    return highlightInfo;
                }
            } else {
                for (int i = 0; i < typeParameters.length; ++i) {
                    PsiTypeElement typeElement = referenceElements[i];
                    HighlightInfo highlightInfo = GenericsHighlightUtil.checkTypeParameterWithinItsBound(typeParameters[i], substitutor, typeElement.getType(), (PsiElement)typeElement, referenceParameterList);
                    if (highlightInfo == null) continue;
                    return highlightInfo;
                }
            }
        }
        return null;
    }

    private static boolean hasSuperMethodsWithTypeParams(@NotNull PsiMethod method) {
        for (PsiMethod superMethod : method.findDeepestSuperMethods()) {
            if (!superMethod.hasTypeParameters()) continue;
            return true;
        }
        return false;
    }

    private static PsiType detectExpectedType(@NotNull PsiReferenceParameterList referenceParameterList) {
        PsiParameter parameter2;
        Object[] expressions2;
        int idx;
        PsiMethod method;
        PsiExpressionList argumentList;
        PsiElement pParent;
        PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiNewExpression.class);
        LOG.assertTrue(newExpression != null);
        PsiElement parent = newExpression.getParent();
        PsiType expectedType = null;
        if (parent instanceof PsiVariable && newExpression.equals(((PsiVariable)parent).getInitializer())) {
            expectedType = ((PsiVariable)parent).getType();
        } else if (parent instanceof PsiAssignmentExpression && newExpression.equals(((PsiAssignmentExpression)parent).getRExpression())) {
            expectedType = ((PsiAssignmentExpression)parent).getLExpression().getType();
        } else if (parent instanceof PsiReturnStatement) {
            PsiElement method2 = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (method2 instanceof PsiMethod) {
                expectedType = ((PsiMethod)method2).getReturnType();
            }
        } else if (parent instanceof PsiExpressionList && (pParent = parent.getParent()) instanceof PsiCallExpression && parent.equals(argumentList = ((PsiCallExpression)pParent).getArgumentList()) && (method = ((PsiCallExpression)pParent).resolveMethod()) != null && (idx = ArrayUtilRt.find((Object[])(expressions2 = argumentList.getExpressions()), (Object)newExpression)) > -1 && (parameter2 = method.getParameterList().getParameter(idx)) != null) {
            expectedType = parameter2.getType();
        }
        return expectedType;
    }

    private static HighlightInfo checkTypeParameterWithinItsBound(@NotNull PsiTypeParameter classParameter, @NotNull PsiSubstitutor substitutor, @NotNull PsiType type2, @NotNull PsiElement typeElement2Highlight, @Nullable PsiReferenceParameterList referenceParameterList) {
        PsiClassType[] bounds;
        PsiClass referenceClass = type2 instanceof PsiClassType ? ((PsiClassType)type2).resolve() : null;
        PsiType psiType = substitutor.substitute(classParameter);
        if (psiType instanceof PsiClassType && !(PsiUtil.resolveClassInType((PsiType)psiType) instanceof PsiTypeParameter) && GenericsUtil.checkNotInBounds((PsiType)type2, (PsiType)psiType, (PsiReferenceParameterList)referenceParameterList)) {
            String description = JavaErrorBundle.message("actual.type.argument.contradict.inferred.type", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(typeElement2Highlight).descriptionAndTooltip(description).create();
        }
        for (PsiClassType bound : bounds = classParameter.getSuperTypes()) {
            if ((bound = substitutor.substitute((PsiType)bound)).equalsToText("java.lang.Object") || !GenericsUtil.checkNotInBounds((PsiType)type2, (PsiType)bound, (PsiReferenceParameterList)referenceParameterList)) continue;
            PsiClass boundClass = bound instanceof PsiClassType ? bound.resolve() : null;
            String messageKey = boundClass == null || referenceClass == null || referenceClass.isInterface() == boundClass.isInterface() ? "generics.type.parameter.is.not.within.its.bound.extend" : "generics.type.parameter.is.not.within.its.bound.implement";
            String description = JavaErrorBundle.message(messageKey, referenceClass != null ? HighlightUtil.formatClass(referenceClass) : type2.getPresentableText(), JavaHighlightUtil.formatType((PsiType)bound));
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(typeElement2Highlight).descriptionAndTooltip(description).create();
            if (bound instanceof PsiClassType && referenceClass != null && info != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createExtendsListFix(referenceClass, bound, true), null);
            }
            return info;
        }
        return null;
    }

    @NotNull
    private static String typeParameterListOwnerDescription(@NotNull PsiTypeParameterListOwner typeParameterListOwner) {
        if (typeParameterListOwner instanceof PsiClass) {
            return HighlightUtil.formatClass((PsiClass)typeParameterListOwner);
        }
        if (typeParameterListOwner instanceof PsiMethod) {
            return JavaHighlightUtil.formatMethod((PsiMethod)typeParameterListOwner);
        }
        LOG.error("Unknown " + typeParameterListOwner);
        return "?";
    }

    @NotNull
    private static String typeParameterListOwnerCategoryDescription(@NotNull PsiTypeParameterListOwner typeParameterListOwner) {
        if (typeParameterListOwner instanceof PsiClass) {
            return JavaErrorBundle.message("generics.holder.type", new Object[0]);
        }
        if (typeParameterListOwner instanceof PsiMethod) {
            return JavaErrorBundle.message("generics.holder.method", new Object[0]);
        }
        LOG.error("Unknown " + typeParameterListOwner);
        return "?";
    }

    static HighlightInfo checkElementInTypeParameterExtendsList(@NotNull PsiReferenceList referenceList, @NotNull PsiClass aClass, @NotNull JavaResolveResult resolveResult, @NotNull PsiElement element) {
        PsiJavaCodeReferenceElement[] referenceElements = referenceList.getReferenceElements();
        PsiClass extendFrom = (PsiClass)resolveResult.getElement();
        if (extendFrom == null) {
            return null;
        }
        HighlightInfo errorResult = null;
        if (!extendFrom.isInterface() && referenceElements.length != 0 && element != referenceElements[0]) {
            String description = JavaErrorBundle.message("interface.expected", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
            PsiClassType type2 = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(extendFrom, resolveResult.getSubstitutor());
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createMoveBoundClassToFrontFix(aClass, type2), null);
        } else if (referenceElements.length != 0 && element != referenceElements[0] && referenceElements[0].resolve() instanceof PsiTypeParameter) {
            String description = JavaErrorBundle.message("type.parameter.cannot.be.followed.by.other.bounds", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
            PsiClassType type3 = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(extendFrom, resolveResult.getSubstitutor());
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createExtendsListFix(aClass, type3, false), null);
        }
        return errorResult;
    }

    static HighlightInfo checkInterfaceMultipleInheritance(@NotNull PsiClass aClass) {
        PsiClassType[] types = aClass.getSuperTypes();
        if (types.length < 2) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
        return GenericsHighlightUtil.checkInterfaceMultipleInheritance(aClass, (PsiElement)aClass, PsiSubstitutor.EMPTY, new HashMap<PsiClass, PsiSubstitutor>(), new HashSet(), textRange);
    }

    private static HighlightInfo checkInterfaceMultipleInheritance(@NotNull PsiClass aClass, @NotNull PsiElement place, @NotNull PsiSubstitutor derivedSubstitutor, @NotNull Map<PsiClass, PsiSubstitutor> inheritedClasses, @NotNull Set<? super PsiClass> visited, @NotNull TextRange textRange) {
        List<PsiClassType.ClassResolveResult> superTypes = PsiClassImplUtil.getScopeCorrectedSuperTypes(aClass, place.getResolveScope());
        for (PsiClassType.ClassResolveResult result : superTypes) {
            PsiClass superClass = result.getElement();
            if (superClass == null || visited.contains(superClass)) continue;
            PsiSubstitutor superTypeSubstitutor = result.getSubstitutor();
            superTypeSubstitutor = PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)aClass, (PsiSubstitutor)derivedSubstitutor) ? JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)superClass) : MethodSignatureUtil.combineSubstitutors((PsiSubstitutor)superTypeSubstitutor, (PsiSubstitutor)derivedSubstitutor);
            PsiSubstitutor inheritedSubstitutor = inheritedClasses.get(superClass);
            if (inheritedSubstitutor != null) {
                PsiTypeParameter[] typeParameters;
                for (PsiTypeParameter typeParameter : typeParameters = superClass.getTypeParameters()) {
                    PsiType type2;
                    PsiType type1 = inheritedSubstitutor.substitute(typeParameter);
                    if (Comparing.equal((Object)type1, (Object)(type2 = superTypeSubstitutor.substitute(typeParameter)))) continue;
                    String description = JavaErrorBundle.message("generics.cannot.be.inherited.with.different.type.arguments", HighlightUtil.formatClass(superClass), JavaHighlightUtil.formatType(type1), JavaHighlightUtil.formatType(type2));
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
                }
            }
            inheritedClasses.put(superClass, superTypeSubstitutor);
            visited.add((PsiClass)superClass);
            HighlightInfo highlightInfo = GenericsHighlightUtil.checkInterfaceMultipleInheritance(superClass, place, superTypeSubstitutor, inheritedClasses, visited, textRange);
            visited.remove(superClass);
            if (highlightInfo == null) continue;
            return highlightInfo;
        }
        return null;
    }

    @NotNull
    static Collection<HighlightInfo> checkOverrideEquivalentMethods(@NotNull PsiClass aClass) {
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>();
        Collection signaturesWithSupers = aClass.getVisibleSignatures();
        PsiManager manager = aClass.getManager();
        THashMap sameErasureMethods = new THashMap(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        THashSet foundProblems = new THashSet(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        for (HierarchicalMethodSignature signature : signaturesWithSupers) {
            HighlightInfo info = GenericsHighlightUtil.checkSameErasureNotSubSignatureInner(signature, manager, aClass, (Map<MethodSignature, MethodSignatureBackedByPsiMethod>)sameErasureMethods);
            if (info != null && foundProblems.add(signature)) {
                result.add(info);
            }
            if (!(aClass instanceof PsiTypeParameter) || (info = HighlightMethodUtil.checkMethodIncompatibleReturnType((MethodSignatureBackedByPsiMethod)signature, signature.getSuperSignatures(), true, HighlightNamesUtil.getClassDeclarationTextRange(aClass))) == null) continue;
            result.add(info);
        }
        return result;
    }

    static HighlightInfo checkDefaultMethodOverrideEquivalentToObjectNonPrivate(@NotNull LanguageLevel languageLevel, @NotNull PsiClass aClass, @NotNull PsiMethod method, @NotNull PsiElement methodIdentifier2) {
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && aClass.isInterface() && method.hasModifierProperty("default")) {
            HierarchicalMethodSignature sig = method.getHierarchicalMethodSignature();
            for (HierarchicalMethodSignature methodSignature : sig.getSuperSignatures()) {
                PsiMethod objectMethod = methodSignature.getMethod();
                PsiClass containingClass = objectMethod.getContainingClass();
                if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName()) || !objectMethod.hasModifierProperty("public")) continue;
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(JavaErrorBundle.message("default.method.overrides.object.member", sig.getName())).range(methodIdentifier2).create();
            }
        }
        return null;
    }

    static HighlightInfo checkUnrelatedDefaultMethods(@NotNull PsiClass aClass, @NotNull PsiIdentifier classIdentifier) {
        Map overrideEquivalent = PsiSuperMethodUtil.collectOverrideEquivalents((PsiClass)aClass);
        boolean isInterface = aClass.isInterface();
        for (Set overrideEquivalentMethods : overrideEquivalent.values()) {
            List defaultContainingClasses;
            String unrelatedDefaults;
            PsiClass unrelatedMethodContainingClass;
            PsiMethod unrelatedMethod;
            PsiClass defaultMethodContainingClass;
            PsiMethod defaultMethod;
            if (overrideEquivalentMethods.size() <= 1) continue;
            ArrayList<PsiMethod> defaults = null;
            ArrayList<PsiMethod> abstracts = null;
            boolean hasConcrete = false;
            for (PsiMethod method : overrideEquivalentMethods) {
                boolean isDefault = method.hasModifierProperty("default");
                boolean isAbstract = method.hasModifierProperty("abstract");
                if (isDefault) {
                    if (defaults == null) {
                        defaults = new ArrayList<PsiMethod>(2);
                    }
                    defaults.add(method);
                }
                if (isAbstract) {
                    if (abstracts == null) {
                        abstracts = new ArrayList<PsiMethod>(2);
                    }
                    abstracts.add(method);
                }
                hasConcrete |= !isDefault && !isAbstract && !method.hasModifierProperty("static");
            }
            if (hasConcrete || defaults == null || MethodSignatureUtil.findMethodBySuperMethod((PsiClass)aClass, (PsiMethod)(defaultMethod = (PsiMethod)defaults.get(0)), (boolean)false) != null || (defaultMethodContainingClass = defaultMethod.getContainingClass()) == null) continue;
            if (abstracts != null) {
                unrelatedMethod = (PsiMethod)abstracts.get(0);
            } else {
                if (defaults.size() <= 1) continue;
                unrelatedMethod = (PsiMethod)defaults.get(1);
            }
            if ((unrelatedMethodContainingClass = unrelatedMethod.getContainingClass()) == null) continue;
            if (!aClass.hasModifierProperty("abstract") && !(aClass instanceof PsiTypeParameter) && abstracts != null && unrelatedMethodContainingClass.isInterface()) {
                if (defaultMethodContainingClass.isInheritor(unrelatedMethodContainingClass, true) && MethodSignatureUtil.isSubsignature((MethodSignature)unrelatedMethod.getSignature(TypeConversionUtil.getSuperClassSubstitutor((PsiClass)unrelatedMethodContainingClass, (PsiClass)defaultMethodContainingClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)), (MethodSignature)defaultMethod.getSignature(PsiSubstitutor.EMPTY))) continue;
                String key2 = aClass instanceof PsiEnumConstantInitializer || aClass.isRecord() ? "class.must.implement.method" : "class.must.be.abstract";
                String message2 = JavaErrorBundle.message(key2, HighlightUtil.formatClass(aClass, false), JavaHighlightUtil.formatMethod((PsiMethod)abstracts.get(0)), HighlightUtil.formatClass(unrelatedMethodContainingClass, false));
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)classIdentifier).descriptionAndTooltip(message2).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createImplementMethodsFix(aClass));
                return info;
            }
            if (!isInterface && abstracts != null && !unrelatedMethodContainingClass.isInterface() || (unrelatedDefaults = GenericsHighlightUtil.hasUnrelatedDefaults(defaultContainingClasses = ContainerUtil.mapNotNull(defaults, PsiJvmMember::getContainingClass))) == null && (abstracts == null || !GenericsHighlightUtil.hasNotOverriddenAbstract(defaultContainingClasses, unrelatedMethodContainingClass))) continue;
            String message3 = unrelatedDefaults != null ? " inherits unrelated defaults for " : " inherits abstract and default for ";
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)classIdentifier).descriptionAndTooltip(HighlightUtil.formatClass(aClass) + message3 + JavaHighlightUtil.formatMethod(defaultMethod) + " from types " + (unrelatedDefaults != null ? unrelatedDefaults : HighlightUtil.formatClass(defaultMethodContainingClass) + " and " + HighlightUtil.formatClass(unrelatedMethodContainingClass))).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createImplementMethodsFix(aClass));
            return info;
        }
        return null;
    }

    private static boolean belongToOneHierarchy(@NotNull PsiClass defaultMethodContainingClass, @NotNull PsiClass unrelatedMethodContainingClass) {
        return defaultMethodContainingClass.isInheritor(unrelatedMethodContainingClass, true) || unrelatedMethodContainingClass.isInheritor(defaultMethodContainingClass, true);
    }

    private static boolean hasNotOverriddenAbstract(@NotNull List<? extends PsiClass> defaultContainingClasses, @NotNull PsiClass abstractMethodContainingClass) {
        return defaultContainingClasses.stream().noneMatch(containingClass -> GenericsHighlightUtil.belongToOneHierarchy(containingClass, abstractMethodContainingClass));
    }

    private static String hasUnrelatedDefaults(@NotNull List<? extends PsiClass> defaults) {
        if (defaults.size() > 1) {
            PsiClass[] defaultClasses = defaults.toArray(PsiClass.EMPTY_ARRAY);
            ArrayList<? extends PsiClass> classes2 = new ArrayList<PsiClass>(defaults);
            for (PsiClass aClass1 : defaultClasses) {
                classes2.removeIf(aClass2 -> aClass1.isInheritor(aClass2, true));
            }
            if (classes2.size() > 1) {
                return HighlightUtil.formatClass(classes2.get(0)) + " and " + HighlightUtil.formatClass(classes2.get(1));
            }
        }
        return null;
    }

    static HighlightInfo checkUnrelatedConcrete(@NotNull PsiClass psiClass, @NotNull PsiIdentifier classIdentifier) {
        PsiClass superClass = psiClass.getSuperClass();
        if (superClass != null && superClass.hasTypeParameters()) {
            Collection visibleSignatures = superClass.getVisibleSignatures();
            THashMap overrideEquivalent = new THashMap(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
            for (HierarchicalMethodSignature hms : visibleSignatures) {
                PsiClass foundMethodContainingClass;
                PsiClass containingClass;
                PsiMethod method = hms.getMethod();
                if (method.isConstructor() || method.hasModifierProperty("abstract") || method.hasModifierProperty("default") || method.hasModifierProperty("static") || psiClass.findMethodsBySignature(method, false).length > 0 || (containingClass = method.getContainingClass()) == null) continue;
                PsiSubstitutor containingClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)psiClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                PsiSubstitutor finalSubstitutor = PsiSuperMethodUtil.obtainFinalSubstitutor((PsiClass)containingClass, (PsiSubstitutor)containingClassSubstitutor, (PsiSubstitutor)hms.getSubstitutor(), (boolean)false);
                MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create((PsiMethod)method, (PsiSubstitutor)finalSubstitutor, (boolean)false);
                PsiMethod foundMethod = (PsiMethod)overrideEquivalent.get(signature);
                if (foundMethod != null && !foundMethod.hasModifierProperty("abstract") && !foundMethod.hasModifierProperty("default") && (foundMethodContainingClass = foundMethod.getContainingClass()) != null) {
                    String description = JavaErrorBundle.message("two.methods.are.inherited.with.same.signature", JavaHighlightUtil.formatMethod(foundMethod), HighlightUtil.formatClass(foundMethodContainingClass), JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(containingClass));
                    HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)classIdentifier).descriptionAndTooltip(description).create();
                    return info;
                }
                overrideEquivalent.put(signature, method);
            }
        }
        return null;
    }

    private static HighlightInfo checkSameErasureNotSubSignatureInner(@NotNull HierarchicalMethodSignature signature, @NotNull PsiManager manager, @NotNull PsiClass aClass, @NotNull Map<MethodSignature, MethodSignatureBackedByPsiMethod> sameErasureMethods) {
        HighlightInfo info;
        PsiMethod method = signature.getMethod();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        if (!facade.getResolveHelper().isAccessible((PsiMember)method, (PsiElement)aClass, null)) {
            return null;
        }
        MethodSignature signatureToErase = method.getSignature(PsiSubstitutor.EMPTY);
        MethodSignatureBackedByPsiMethod sameErasure = sameErasureMethods.get(signatureToErase);
        if (sameErasure != null) {
            if ((aClass instanceof PsiTypeParameter || MethodSignatureUtil.findMethodBySuperMethod((PsiClass)aClass, (PsiMethod)sameErasure.getMethod(), (boolean)false) != null || !InheritanceUtil.isInheritorOrSelf((PsiClass)sameErasure.getMethod().getContainingClass(), (PsiClass)method.getContainingClass(), (boolean)true) && !InheritanceUtil.isInheritorOrSelf((PsiClass)method.getContainingClass(), (PsiClass)sameErasure.getMethod().getContainingClass(), (boolean)true)) && (info = GenericsHighlightUtil.checkSameErasureNotSubSignatureOrSameClass(sameErasure, signature, aClass, method)) != null) {
                return info;
            }
        } else {
            sameErasureMethods.put(signatureToErase, (MethodSignatureBackedByPsiMethod)signature);
        }
        List supers = signature.getSuperSignatures();
        for (HierarchicalMethodSignature superSignature : supers) {
            info = GenericsHighlightUtil.checkSameErasureNotSubSignatureInner(superSignature, manager, aClass, sameErasureMethods);
            if (info != null) {
                return info;
            }
            if (!superSignature.isRaw() || signature.isRaw()) continue;
            PsiType[] parameterTypes = signature.getParameterTypes();
            PsiType[] erasedTypes = superSignature.getErasedParameterTypes();
            for (int i = 0; i < erasedTypes.length; ++i) {
                if (Comparing.equal((Object)parameterTypes[i], (Object)erasedTypes[i])) continue;
                return GenericsHighlightUtil.getSameErasureMessage(false, method, superSignature.getMethod(), HighlightNamesUtil.getClassDeclarationTextRange(aClass));
            }
        }
        return null;
    }

    private static HighlightInfo checkSameErasureNotSubSignatureOrSameClass(@NotNull MethodSignatureBackedByPsiMethod signatureToCheck, @NotNull HierarchicalMethodSignature superSignature, @NotNull PsiClass aClass, @NotNull PsiMethod superMethod) {
        PsiType retErasure2;
        boolean differentReturnTypeErasure;
        PsiMethod checkMethod = signatureToCheck.getMethod();
        if (superMethod.equals(checkMethod)) {
            return null;
        }
        PsiClass checkContainingClass = checkMethod.getContainingClass();
        LOG.assertTrue(checkContainingClass != null);
        PsiClass superContainingClass = superMethod.getContainingClass();
        boolean checkEqualsSuper = checkContainingClass.equals(superContainingClass);
        if (checkMethod.isConstructor() ? !superMethod.isConstructor() || !checkEqualsSuper : superMethod.isConstructor()) {
            return null;
        }
        JavaVersionService javaVersionService = JavaVersionService.getInstance();
        boolean atLeast17 = javaVersionService.isAtLeast((PsiElement)aClass, JavaSdkVersion.JDK_1_7);
        if (checkMethod.hasModifierProperty("static") && !checkEqualsSuper && !atLeast17) {
            return null;
        }
        if (superMethod.hasModifierProperty("static") && superContainingClass != null && superContainingClass.isInterface() && !checkEqualsSuper && PsiUtil.isLanguageLevel8OrHigher((PsiElement)superContainingClass)) {
            return null;
        }
        PsiType retErasure1 = TypeConversionUtil.erasure((PsiType)checkMethod.getReturnType());
        boolean bl = differentReturnTypeErasure = !Comparing.equal((Object)retErasure1, (Object)(retErasure2 = TypeConversionUtil.erasure((PsiType)superMethod.getReturnType())));
        if (checkEqualsSuper && atLeast17 && retErasure1 != null && retErasure2 != null) {
            boolean bl2 = differentReturnTypeErasure = !TypeConversionUtil.isAssignable((PsiType)retErasure1, (PsiType)retErasure2);
        }
        if (!(!differentReturnTypeErasure || TypeConversionUtil.isVoidType((PsiType)retErasure1) || TypeConversionUtil.isVoidType((PsiType)retErasure2) || checkEqualsSuper && Arrays.equals(superSignature.getParameterTypes(), signatureToCheck.getParameterTypes()) || atLeast17)) {
            int idx = 0;
            PsiType[] erasedTypes = signatureToCheck.getErasedParameterTypes();
            boolean erasure = erasedTypes.length > 0;
            for (PsiType type2 : superSignature.getParameterTypes()) {
                erasure &= Comparing.equal((Object)type2, (Object)erasedTypes[idx]);
                ++idx;
            }
            if (!erasure) {
                return null;
            }
        }
        if (!checkEqualsSuper && MethodSignatureUtil.isSubsignature((MethodSignature)superSignature, (MethodSignature)signatureToCheck)) {
            return null;
        }
        if (!javaVersionService.isCompilerVersionAtLeast((PsiElement)aClass, JavaSdkVersion.JDK_1_7) && superContainingClass != null && !superContainingClass.isInterface() && checkContainingClass.isInterface() && !aClass.equals(superContainingClass)) {
            return null;
        }
        if (aClass.equals(checkContainingClass)) {
            boolean sameClass = aClass.equals(superContainingClass);
            return GenericsHighlightUtil.getSameErasureMessage(sameClass, checkMethod, superMethod, HighlightNamesUtil.getMethodDeclarationTextRange(checkMethod));
        }
        return GenericsHighlightUtil.getSameErasureMessage(false, checkMethod, superMethod, HighlightNamesUtil.getClassDeclarationTextRange(aClass));
    }

    private static HighlightInfo getSameErasureMessage(boolean sameClass, @NotNull PsiMethod method, @NotNull PsiMethod superMethod, @NotNull TextRange textRange) {
        String key2 = sameClass ? "generics.methods.have.same.erasure" : (method.hasModifierProperty("static") ? "generics.methods.have.same.erasure.hide" : "generics.methods.have.same.erasure.override");
        String description = JavaErrorBundle.message(key2, HighlightMethodUtil.createClashMethodMessage(method, superMethod, !sameClass));
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createSameErasureButDifferentMethodsFix(method, superMethod));
        return info;
    }

    static HighlightInfo checkTypeParameterInstantiation(@NotNull PsiNewExpression expression2) {
        PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
        if (classReference2 == null) {
            return null;
        }
        JavaResolveResult result = classReference2.advancedResolve(false);
        PsiElement element = result.getElement();
        if (element instanceof PsiTypeParameter) {
            String description = JavaErrorBundle.message("generics.type.parameter.cannot.be.instantiated", HighlightUtil.formatClass((PsiClass)((PsiTypeParameter)element)));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)classReference2).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkWildcardUsage(@NotNull PsiTypeElement typeElement) {
        PsiType type2 = typeElement.getType();
        if (type2 instanceof PsiWildcardType) {
            if (typeElement.getParent() instanceof PsiReferenceParameterList) {
                PsiElement refPParent;
                PsiElement parent = typeElement.getParent().getParent();
                LOG.assertTrue(parent instanceof PsiJavaCodeReferenceElement, (Object)parent);
                PsiElement refParent = parent.getParent();
                if (refParent instanceof PsiAnonymousClass) {
                    refParent = refParent.getParent();
                }
                if (refParent instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)refParent;
                    if (!(newExpression.getType() instanceof PsiArrayType)) {
                        String description = JavaErrorBundle.message("wildcard.type.cannot.be.instantiated", JavaHighlightUtil.formatType(type2));
                        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
                    }
                } else if (refParent instanceof PsiReferenceList && (!((refPParent = refParent.getParent()) instanceof PsiTypeParameter) || refParent != ((PsiTypeParameter)refPParent).getExtendsList())) {
                    String description = JavaErrorBundle.message("generics.wildcard.not.expected", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
                }
            } else {
                String description = JavaErrorBundle.message("generics.wildcards.may.be.used.only.as.reference.parameters", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
            }
        }
        return null;
    }

    static HighlightInfo checkReferenceTypeUsedAsTypeArgument(@NotNull PsiTypeElement typeElement, @NotNull LanguageLevel level) {
        PsiType type2 = typeElement.getType();
        if (type2 != PsiType.NULL && type2 instanceof PsiPrimitiveType || type2 instanceof PsiWildcardType && ((PsiWildcardType)type2).getBound() instanceof PsiPrimitiveType) {
            PsiClassType boxedType;
            PsiElement element = new PsiMatcherImpl((PsiElement)typeElement).parent(PsiMatchers.hasClass(PsiReferenceParameterList.class)).parent(PsiMatchers.hasClass(PsiJavaCodeReferenceElement.class, PsiNewExpression.class)).getElement();
            if (element == null) {
                return null;
            }
            if (level.isAtLeast(LanguageLevel.JDK_X)) {
                return null;
            }
            String text2 = JavaErrorBundle.message("generics.type.argument.cannot.be.of.primitive.type", new Object[0]);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(text2).create();
            PsiType toConvert = type2;
            if (type2 instanceof PsiWildcardType) {
                toConvert = ((PsiWildcardType)type2).getBound();
            }
            if (toConvert instanceof PsiPrimitiveType && (boxedType = ((PsiPrimitiveType)toConvert).getBoxedType((PsiElement)typeElement)) != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createReplacePrimitiveWithBoxedTypeAction(typeElement, toConvert.getPresentableText(), ((PsiPrimitiveType)toConvert).getBoxedTypeName()));
            }
            return highlightInfo;
        }
        return null;
    }

    static HighlightInfo checkForeachExpressionTypeIsIterable(@NotNull PsiExpression expression2) {
        if (expression2.getType() == null) {
            return null;
        }
        PsiType itemType = JavaGenericsUtil.getCollectionItemType((PsiExpression)expression2);
        if (itemType == null) {
            String description = JavaErrorBundle.message("foreach.not.applicable", JavaHighlightUtil.formatType(expression2.getType()));
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createNotIterableForEachLoopFix(expression2));
            return highlightInfo;
        }
        return null;
    }

    static HighlightInfo checkForEachParameterType(@NotNull PsiForeachStatement statement, @NotNull PsiParameter parameter2) {
        PsiType itemType;
        PsiExpression expression2 = statement.getIteratedValue();
        PsiType psiType = itemType = expression2 == null ? null : JavaGenericsUtil.getCollectionItemType((PsiExpression)expression2);
        if (itemType == null) {
            return null;
        }
        PsiType parameterType = parameter2.getType();
        if (TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)itemType)) {
            return null;
        }
        HighlightInfo highlightInfo = HighlightUtil.createIncompatibleTypeHighlightInfo(itemType, parameterType, parameter2.getTextRange(), 0);
        HighlightFixUtil.registerChangeVariableTypeFixes((PsiVariable)parameter2, itemType, expression2, highlightInfo);
        return highlightInfo;
    }

    static HighlightInfo checkAccessStaticFieldFromEnumConstructor(@NotNull PsiReferenceExpression expr2, @NotNull JavaResolveResult result) {
        PsiType type2;
        PsiClass aClass;
        PsiElement resolved = result.getElement();
        if (!(resolved instanceof PsiField)) {
            return null;
        }
        if (!((PsiModifierListOwner)resolved).hasModifierProperty("static")) {
            return null;
        }
        if (PsiImplUtil.getSwitchLabel((PsiExpression)expr2) != null) {
            return null;
        }
        PsiMember constructorOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expr2);
        if (constructorOrInitializer == null) {
            return null;
        }
        if (constructorOrInitializer.hasModifierProperty("static")) {
            return null;
        }
        PsiClass psiClass = aClass = constructorOrInitializer instanceof PsiEnumConstantInitializer ? (PsiClass)constructorOrInitializer : constructorOrInitializer.getContainingClass();
        if (aClass == null || !aClass.isEnum() && !(aClass instanceof PsiEnumConstantInitializer)) {
            return null;
        }
        PsiField field = (PsiField)resolved;
        if (aClass instanceof PsiEnumConstantInitializer ? field.getContainingClass() != aClass.getSuperClass() : field.getContainingClass() != aClass) {
            return null;
        }
        if (!JavaVersionService.getInstance().isAtLeast((PsiElement)field, JavaSdkVersion.JDK_1_6) && (type2 = field.getType()) instanceof PsiClassType && ((PsiClassType)type2).resolve() == aClass) {
            return null;
        }
        if (PsiUtil.isCompileTimeConstant((PsiVariable)field)) {
            return null;
        }
        String description = JavaErrorBundle.message("illegal.to.access.static.member.from.enum.constructor.or.instance.initializer", HighlightMessageUtil.getSymbolName(resolved, result.getSubstitutor()));
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expr2).descriptionAndTooltip(description).create();
    }

    static HighlightInfo checkEnumInstantiation(@NotNull PsiElement expression2, @Nullable PsiClass aClass) {
        if (!(aClass == null || !aClass.isEnum() || expression2 instanceof PsiNewExpression && ((PsiNewExpression)expression2).isArrayCreation())) {
            String description = JavaErrorBundle.message("enum.types.cannot.be.instantiated", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(expression2).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkGenericArrayCreation(@NotNull PsiElement element, @Nullable PsiType type2) {
        if (type2 instanceof PsiArrayType) {
            if (!JavaGenericsUtil.isReifiableType((PsiType)((PsiArrayType)type2).getComponentType())) {
                String description = JavaErrorBundle.message("generic.array.creation", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
            }
            if (element instanceof PsiNewExpression && ((PsiNewExpression)element).getTypeArguments().length > 0) {
                String description = JavaErrorBundle.message("array.creation.with.type.arguments", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
            }
        }
        return null;
    }

    static boolean isEnumSyntheticMethod(@NotNull MethodSignature methodSignature, @NotNull Project project) {
        if (methodSignature.equals(ourValuesEnumSyntheticMethod)) {
            return true;
        }
        PsiClassType javaLangString = PsiType.getJavaLangString((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        MethodSignature valueOfMethod = MethodSignatureUtil.createMethodSignature((String)"valueOf", (PsiType[])new PsiType[]{javaLangString}, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return MethodSignatureUtil.areSignaturesErasureEqual((MethodSignature)valueOfMethod, (MethodSignature)methodSignature);
    }

    static HighlightInfo checkTypeParametersList(@NotNull PsiTypeParameterList list, PsiTypeParameter @NotNull [] parameters2, @NotNull LanguageLevel level) {
        PsiElement parent = list.getParent();
        if (parent instanceof PsiClass && ((PsiClass)parent).isEnum()) {
            String description = JavaErrorBundle.message("generics.enum.may.not.have.type.parameters", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
        }
        if (PsiUtil.isAnnotationMethod((PsiElement)parent)) {
            String description = JavaErrorBundle.message("generics.annotation.members.may.not.have.type.parameters", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
        }
        if (parent instanceof PsiClass && ((PsiClass)parent).isAnnotationType()) {
            String description = JavaErrorBundle.message("annotation.may.not.have.type.parameters", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
        }
        for (int i = 0; i < parameters2.length; ++i) {
            PsiTypeParameter typeParameter1 = parameters2[i];
            HighlightInfo cyclicInheritance = HighlightClassUtil.checkCyclicInheritance((PsiClass)typeParameter1);
            if (cyclicInheritance != null) {
                return cyclicInheritance;
            }
            String name1 = typeParameter1.getName();
            for (int j = i + 1; j < parameters2.length; ++j) {
                PsiTypeParameter typeParameter2 = parameters2[j];
                String name2 = typeParameter2.getName();
                if (!Comparing.strEqual((String)name1, (String)name2)) continue;
                String message2 = JavaErrorBundle.message("generics.duplicate.type.parameter", name1);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeParameter2).descriptionAndTooltip(message2).create();
            }
            if (level.isAtLeast(LanguageLevel.JDK_1_7)) continue;
            for (PsiJavaCodeReferenceElement referenceElement : typeParameter1.getExtendsList().getReferenceElements()) {
                PsiElement resolve2 = referenceElement.resolve();
                if (!(resolve2 instanceof PsiTypeParameter) || ArrayUtilRt.find((Object[])parameters2, (Object)resolve2) <= i) continue;
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)referenceElement).descriptionAndTooltip(JavaErrorBundle.message("illegal.forward.reference", new Object[0])).create();
            }
        }
        return null;
    }

    @NotNull
    static Collection<HighlightInfo> checkCatchParameterIsClass(@NotNull PsiParameter parameter2) {
        if (!(parameter2.getDeclarationScope() instanceof PsiCatchSection)) {
            return Collections.emptyList();
        }
        List typeElements = PsiUtil.getParameterTypeElements((PsiParameter)parameter2);
        ArrayList<HighlightInfo> result = new ArrayList<HighlightInfo>(typeElements.size());
        for (PsiTypeElement typeElement : typeElements) {
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)typeElement.getType());
            if (!(aClass instanceof PsiTypeParameter)) continue;
            String message2 = JavaErrorBundle.message("generics.cannot.catch.type.parameters", new Object[0]);
            result.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(message2).create());
        }
        return result;
    }

    static HighlightInfo checkInstanceOfGenericType(@NotNull LanguageLevel languageLevel, @NotNull PsiInstanceOfExpression expression2) {
        PsiTypeElement checkTypeElement = expression2.getCheckType();
        if (checkTypeElement == null) {
            return null;
        }
        PsiType checkType = checkTypeElement.getType();
        if (HighlightingFeature.PATTERNS.isSufficient(languageLevel)) {
            return GenericsHighlightUtil.isUnsafeCastInInstanceOf(checkTypeElement, checkType, expression2.getOperand().getType());
        }
        return GenericsHighlightUtil.isIllegalForInstanceOf(checkType, checkTypeElement);
    }

    private static HighlightInfo isUnsafeCastInInstanceOf(@NotNull PsiTypeElement checkTypeElement, @NotNull PsiType checkType, @Nullable PsiType expressionType) {
        if (expressionType != null && JavaGenericsUtil.isUncheckedCast((PsiType)checkType, (PsiType)expressionType)) {
            String description = JavaErrorBundle.message("unsafe.cast.in.instanceof", expressionType.getPresentableText(), checkType.getPresentableText());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)checkTypeElement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    private static HighlightInfo isIllegalForInstanceOf(@Nullable PsiType type2, @NotNull PsiTypeElement typeElement) {
        PsiClass resolved = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        if (resolved instanceof PsiTypeParameter) {
            String description = JavaErrorBundle.message("generics.cannot.instanceof.type.parameters", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
        }
        if (!JavaGenericsUtil.isReifiableType((PsiType)type2)) {
            String description = JavaErrorBundle.message("illegal.generic.type.for.instanceof", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkClassObjectAccessExpression(@NotNull PsiClassObjectAccessExpression expression2) {
        PsiType arrayComponentType;
        PsiType type2 = expression2.getOperand().getType();
        if (type2 instanceof PsiClassType) {
            return GenericsHighlightUtil.canSelectFrom((PsiClassType)type2, expression2.getOperand());
        }
        if (type2 instanceof PsiArrayType && (arrayComponentType = type2.getDeepComponentType()) instanceof PsiClassType) {
            return GenericsHighlightUtil.canSelectFrom((PsiClassType)arrayComponentType, expression2.getOperand());
        }
        return null;
    }

    private static HighlightInfo canSelectFrom(@NotNull PsiClassType type2, @NotNull PsiTypeElement operand2) {
        PsiClass aClass = type2.resolve();
        if (aClass instanceof PsiTypeParameter) {
            String description = JavaErrorBundle.message("cannot.select.dot.class.from.type.variable", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)operand2).descriptionAndTooltip(description).create();
        }
        if (type2.getParameters().length > 0) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)operand2).descriptionAndTooltip(JavaErrorBundle.message("cannot.select.from.parameterized.type", new Object[0])).create();
        }
        return null;
    }

    static HighlightInfo checkOverrideAnnotation(@NotNull PsiMethod method, @NotNull PsiAnnotation overrideAnnotation, @NotNull LanguageLevel languageLevel) {
        try {
            PsiMethod psiMethod;
            PsiClass containingClass;
            MethodSignatureBackedByPsiMethod superMethod = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
            if (superMethod != null && method.getContainingClass().isInterface() && (containingClass = (psiMethod = superMethod.getMethod()).getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && psiMethod.hasModifierProperty("protected")) {
                superMethod = null;
            }
            if (superMethod == null) {
                if (languageLevel != LanguageLevel.JDK_14_PREVIEW && JavaPsiRecordUtil.getRecordComponentForAccessor(method) != null) {
                    return null;
                }
                String description = JavaErrorBundle.message("method.does.not.override.super", new Object[0]);
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)overrideAnnotation).descriptionAndTooltip(description).create();
                QUICK_FIX_FACTORY.registerPullAsAbstractUpFixes(method, (QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(highlightInfo));
                return highlightInfo;
            }
            PsiClass superClass = superMethod.getMethod().getContainingClass();
            if (languageLevel == LanguageLevel.JDK_1_5 && superClass != null && superClass.isInterface()) {
                String description = JavaErrorBundle.message("override.not.allowed.in.interfaces", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)overrideAnnotation).descriptionAndTooltip(description).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createIncreaseLanguageLevelFix(LanguageLevel.JDK_1_6));
                return info;
            }
            return null;
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    static HighlightInfo checkSafeVarargsAnnotation(@NotNull PsiMethod method, @NotNull LanguageLevel languageLevel) {
        PsiModifierList list = method.getModifierList();
        PsiAnnotation safeVarargsAnnotation = list.findAnnotation("java.lang.SafeVarargs");
        if (safeVarargsAnnotation == null) {
            return null;
        }
        try {
            if (!method.isVarArgs()) {
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)safeVarargsAnnotation).descriptionAndTooltip(JavaErrorBundle.message("safevarargs.not.allowed.on.methods.with.fixed.arity", new Object[0])).create();
            }
            if (!GenericsHighlightUtil.isSafeVarargsNoOverridingCondition(method, languageLevel)) {
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)safeVarargsAnnotation).descriptionAndTooltip(JavaErrorBundle.message("safevarargs.not.allowed.non.final.instance.methods", new Object[0])).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "final", true, true));
                return info;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter varParameter = Objects.requireNonNull(parameterList.getParameter(parameterList.getParametersCount() - 1));
            for (PsiReferenceExpression element : VariableAccessUtils.getVariableReferences((PsiVariable)varParameter, (PsiElement)method.getBody())) {
                if (PsiUtil.isAccessedForReading((PsiExpression)element)) continue;
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range((PsiElement)element).descriptionAndTooltip(JavaErrorBundle.message("safevarargs.not.suppress.potentially.unsafe.operations", new Object[0])).create();
            }
            LOG.assertTrue(varParameter.isVarArgs());
            PsiEllipsisType ellipsisType = (PsiEllipsisType)varParameter.getType();
            PsiType componentType = ellipsisType.getComponentType();
            if (JavaGenericsUtil.isReifiableType((PsiType)componentType)) {
                PsiTypeElement element = varParameter.getTypeElement();
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range((PsiElement)element).descriptionAndTooltip(JavaErrorBundle.message("safevarargs.not.applicable.for.reifiable.types", new Object[0])).create();
            }
            return null;
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    public static boolean isSafeVarargsNoOverridingCondition(@NotNull PsiMethod method, @NotNull LanguageLevel languageLevel) {
        return method.hasModifierProperty("final") || method.hasModifierProperty("static") || method.isConstructor() || method.hasModifierProperty("private") && languageLevel.isAtLeast(LanguageLevel.JDK_1_9);
    }

    static void checkEnumConstantForConstructorProblems(@NotNull PsiEnumConstant enumConstant, @NotNull HighlightInfoHolder holder, @NotNull JavaSdkVersion javaSdkVersion) {
        PsiClass containingClass = enumConstant.getContainingClass();
        LOG.assertTrue(containingClass != null);
        if (enumConstant.getInitializingClass() == null && HighlightClassUtil.hasEnumConstantsWithInitializer(containingClass)) {
            HighlightInfo highlightInfo = HighlightClassUtil.checkInstantiationOfAbstractClass(containingClass, (PsiElement)enumConstant.getNameIdentifier());
            if (highlightInfo != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createImplementMethodsFix((PsiElement)enumConstant));
                holder.add(highlightInfo);
                return;
            }
            highlightInfo = HighlightClassUtil.checkClassWithAbstractMethods(enumConstant.getContainingClass(), (PsiElement)enumConstant, enumConstant.getNameIdentifier().getTextRange());
            if (highlightInfo != null) {
                holder.add(highlightInfo);
                return;
            }
        }
        PsiClassType type2 = JavaPsiFacade.getElementFactory((Project)holder.getProject()).createType(containingClass);
        HighlightMethodUtil.checkConstructorCall(type2.resolveGenerics(), (PsiConstructorCall)enumConstant, (PsiType)type2, null, holder, javaSdkVersion);
    }

    static HighlightInfo checkEnumSuperConstructorCall(@NotNull PsiMethodCallExpression expr2) {
        PsiClass aClass;
        PsiMember constructor;
        PsiReferenceExpression methodExpression = expr2.getMethodExpression();
        PsiElement refNameElement = methodExpression.getReferenceNameElement();
        if (refNameElement != null && "super".equals(refNameElement.getText()) && (constructor = PsiUtil.findEnclosingConstructorOrInitializer((PsiElement)expr2)) instanceof PsiMethod && (aClass = constructor.getContainingClass()) != null && aClass.isEnum()) {
            String message2 = JavaErrorBundle.message("call.to.super.is.not.allowed.in.enum.constructor", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expr2).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    static HighlightInfo checkVarArgParameterIsLast(@NotNull PsiParameter parameter2) {
        PsiParameter[] params;
        PsiElement declarationScope = parameter2.getDeclarationScope();
        if (declarationScope instanceof PsiMethod && (params = ((PsiMethod)declarationScope).getParameterList().getParameters())[params.length - 1] != parameter2) {
            String description = JavaErrorBundle.message("vararg.not.last.parameter", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)parameter2).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createMakeVarargParameterLastFix(parameter2));
            return info;
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkEnumConstantModifierList(@NotNull PsiModifierList modifierList) {
        PsiElement[] children;
        ArrayList<HighlightInfo> list = null;
        for (PsiElement child : children = modifierList.getChildren()) {
            if (!(child instanceof PsiKeyword)) continue;
            if (list == null) {
                list = new ArrayList<HighlightInfo>();
            }
            String description = JavaErrorBundle.message("modifiers.for.enum.constants", new Object[0]);
            list.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(child).descriptionAndTooltip(description).create());
        }
        return (List)ObjectUtils.notNull(list, Collections.emptyList());
    }

    static HighlightInfo checkParametersAllowed(@NotNull PsiReferenceParameterList refParamList) {
        PsiElement grandParent;
        PsiElement parent = refParamList.getParent();
        if (parent instanceof PsiReferenceExpression && !((grandParent = parent.getParent()) instanceof PsiMethodCallExpression) && !(parent instanceof PsiMethodReferenceExpression)) {
            String message2 = JavaErrorBundle.message("generics.reference.parameters.not.allowed", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)refParamList).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    static HighlightInfo checkParametersOnRaw(@NotNull PsiReferenceParameterList refParamList) {
        JavaResolveResult resolveResult = null;
        PsiElement parent = refParamList.getParent();
        PsiElement qualifier = null;
        if (parent instanceof PsiJavaCodeReferenceElement) {
            resolveResult = ((PsiJavaCodeReferenceElement)parent).advancedResolve(false);
            qualifier = ((PsiJavaCodeReferenceElement)parent).getQualifier();
        } else if (parent instanceof PsiCallExpression) {
            resolveResult = ((PsiCallExpression)parent).resolveMethodGenerics();
            if (parent instanceof PsiMethodCallExpression) {
                PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)parent).getMethodExpression();
                qualifier = methodExpression.getQualifier();
            }
        }
        if (resolveResult != null) {
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiTypeParameterListOwner)) {
                return null;
            }
            if (((PsiModifierListOwner)element).hasModifierProperty("static")) {
                return null;
            }
            if (qualifier instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifier).resolve() instanceof PsiTypeParameter) {
                return null;
            }
            PsiClass containingClass = ((PsiMember)element).getContainingClass();
            if (containingClass != null && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)resolveResult.getSubstitutor())) {
                if ((parent instanceof PsiCallExpression || parent instanceof PsiMethodReferenceExpression) && PsiUtil.isLanguageLevel7OrHigher((PsiElement)parent)) {
                    return null;
                }
                if (element instanceof PsiMethod) {
                    if (((PsiMethod)element).findSuperMethods().length > 0) {
                        return null;
                    }
                    if (qualifier instanceof PsiReferenceExpression) {
                        PsiType type2 = ((PsiReferenceExpression)qualifier).getType();
                        boolean isJavac7 = JavaVersionService.getInstance().isAtLeast((PsiElement)containingClass, JavaSdkVersion.JDK_1_7);
                        if (type2 instanceof PsiClassType && isJavac7 && ((PsiClassType)type2).isRaw()) {
                            return null;
                        }
                        PsiClass typeParameter = PsiUtil.resolveClassInType((PsiType)type2);
                        if (typeParameter instanceof PsiTypeParameter) {
                            if (isJavac7) {
                                return null;
                            }
                            for (PsiClassType classType : typeParameter.getExtendsListTypes()) {
                                PsiMethod[] superMethods;
                                PsiClass resolve2 = classType.resolve();
                                if (resolve2 == null) continue;
                                for (PsiMethod superMethod : superMethods = resolve2.findMethodsBySignature((PsiMethod)element, true)) {
                                    if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)superMethod, (PsiSubstitutor)resolveResult.getSubstitutor())) continue;
                                    return null;
                                }
                            }
                        }
                    }
                }
                String message2 = element instanceof PsiClass ? JavaErrorBundle.message("generics.type.arguments.on.raw.type", new Object[0]) : JavaErrorBundle.message("generics.type.arguments.on.raw.method", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)refParamList).descriptionAndTooltip(message2).create();
            }
        }
        return null;
    }

    static HighlightInfo checkGenericCannotExtendException(@NotNull PsiReferenceList list) {
        block5: {
            PsiMethod method;
            PsiElement parent;
            block4: {
                parent = list.getParent();
                if (!(parent instanceof PsiClass)) break block4;
                PsiClass klass = (PsiClass)parent;
                if (!GenericsHighlightUtil.hasGenericSignature(klass) || klass.getExtendsList() != list) break block5;
                PsiClass throwableClass = null;
                for (PsiJavaCodeReferenceElement refElement : list.getReferenceElements()) {
                    PsiElement resolved = refElement.resolve();
                    if (!(resolved instanceof PsiClass)) continue;
                    if (throwableClass == null) {
                        throwableClass = JavaPsiFacade.getInstance((Project)klass.getProject()).findClass("java.lang.Throwable", klass.getResolveScope());
                    }
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)resolved), throwableClass, (boolean)true)) continue;
                    String message2 = JavaErrorBundle.message("generic.extend.exception", new Object[0]);
                    HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)refElement).descriptionAndTooltip(message2).create();
                    PsiClassType classType = JavaPsiFacade.getElementFactory((Project)klass.getProject()).createType((PsiClass)resolved);
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createExtendsListFix(klass, classType, false));
                    return info;
                }
                break block5;
            }
            if (parent instanceof PsiMethod && (method = (PsiMethod)parent).getThrowsList() == list) {
                for (PsiJavaCodeReferenceElement refElement : list.getReferenceElements()) {
                    PsiReferenceParameterList parameterList = refElement.getParameterList();
                    if (parameterList == null || parameterList.getTypeParameterElements().length == 0) continue;
                    String message3 = JavaErrorBundle.message("generic.extend.exception", new Object[0]);
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)refElement).descriptionAndTooltip(message3).create();
                }
            }
        }
        return null;
    }

    static HighlightInfo checkGenericCannotExtendException(@NotNull PsiAnonymousClass anonymousClass) {
        if (GenericsHighlightUtil.hasGenericSignature((PsiClass)anonymousClass) && InheritanceUtil.isInheritor((PsiClass)anonymousClass, (boolean)true, (String)"java.lang.Throwable")) {
            String message2 = JavaErrorBundle.message("generic.extend.exception", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)anonymousClass.getBaseClassReference()).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    private static boolean hasGenericSignature(@NotNull PsiClass klass) {
        PsiClass containingClass = klass;
        while (containingClass != null && PsiUtil.isLocalOrAnonymousClass((PsiClass)containingClass)) {
            if (containingClass.hasTypeParameters()) {
                return true;
            }
            containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class);
        }
        return containingClass != null && PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)containingClass).hasNext();
    }

    static HighlightInfo checkSelectStaticClassFromParameterizedType(@Nullable PsiElement resolved, @NotNull PsiJavaCodeReferenceElement ref) {
        PsiReferenceParameterList parameterList;
        PsiElement qualifier;
        if (resolved instanceof PsiClass && ((PsiClass)resolved).hasModifierProperty("static") && (qualifier = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement && (parameterList = ((PsiJavaCodeReferenceElement)qualifier).getParameterList()) != null && parameterList.getTypeArguments().length > 0) {
            String message2 = JavaErrorBundle.message("generics.select.static.class.from.parameterized.type", HighlightUtil.formatClass((PsiClass)resolved));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)parameterList).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    static HighlightInfo checkCannotInheritFromTypeParameter(@Nullable PsiClass superClass, @NotNull PsiJavaCodeReferenceElement toHighlight) {
        if (superClass instanceof PsiTypeParameter) {
            String description = JavaErrorBundle.message("class.cannot.inherit.from.its.type.parameter", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)toHighlight).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkRawOnParameterizedType(@NotNull PsiJavaCodeReferenceElement parent, @Nullable PsiElement resolved) {
        PsiReferenceParameterList list = parent.getParameterList();
        if (list == null || list.getTypeArguments().length > 0) {
            return null;
        }
        PsiElement qualifier = parent.getQualifier();
        if (qualifier instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifier).getTypeParameters().length > 0 && resolved instanceof PsiTypeParameterListOwner && ((PsiTypeParameterListOwner)resolved).hasTypeParameters() && !((PsiTypeParameterListOwner)resolved).hasModifierProperty("static")) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)parent).descriptionAndTooltip("Improper formed type; some type parameters are missing").create();
        }
        return null;
    }

    static HighlightInfo checkCannotPassInner(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref.getParent() instanceof PsiTypeElement) {
            PsiElement qualifier;
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class);
            if (psiClass == null) {
                return null;
            }
            if ((PsiTreeUtil.isAncestor((PsiElement)psiClass.getExtendsList(), (PsiElement)ref, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)psiClass.getImplementsList(), (PsiElement)ref, (boolean)false)) && (qualifier = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)qualifier).resolve() == psiClass) {
                PsiClass hiddenClass;
                PsiClass containingClass;
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiJavaCodeReferenceElement.class);
                if (referenceElement == null) {
                    return null;
                }
                PsiElement typeClass = referenceElement.resolve();
                if (!(typeClass instanceof PsiClass)) {
                    return null;
                }
                PsiElement resolve2 = ref.resolve();
                PsiClass psiClass2 = containingClass = resolve2 != null ? ((PsiClass)resolve2).getContainingClass() : null;
                if (containingClass == null) {
                    return null;
                }
                if (psiClass.isInheritor(containingClass, true)) {
                    hiddenClass = (PsiClass)resolve2;
                } else {
                    hiddenClass = GenericsHighlightUtil.unqualifiedNestedClassReferenceAccessedViaContainingClassInheritance((PsiClass)typeClass, ((PsiClass)resolve2).getExtendsList());
                    if (hiddenClass == null) {
                        hiddenClass = GenericsHighlightUtil.unqualifiedNestedClassReferenceAccessedViaContainingClassInheritance((PsiClass)typeClass, ((PsiClass)resolve2).getImplementsList());
                    }
                }
                if (hiddenClass != null) {
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(hiddenClass.getName() + " is not accessible in current context").range((PsiElement)ref).create();
                }
            }
        }
        return null;
    }

    private static PsiClass unqualifiedNestedClassReferenceAccessedViaContainingClassInheritance(@NotNull PsiClass containingClass, @Nullable PsiReferenceList referenceList) {
        if (referenceList != null) {
            for (PsiJavaCodeReferenceElement referenceElement : referenceList.getReferenceElements()) {
                PsiClass superContainingClass;
                PsiElement superClass;
                if (referenceElement.isQualified() || !((superClass = referenceElement.resolve()) instanceof PsiClass) || (superContainingClass = ((PsiClass)superClass).getContainingClass()) == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)superContainingClass, (boolean)true) || PsiTreeUtil.isAncestor((PsiElement)superContainingClass, (PsiElement)containingClass, (boolean)true)) continue;
                return (PsiClass)superClass;
            }
        }
        return null;
    }

    private static void registerVariableParameterizedTypeFixes(@Nullable HighlightInfo highlightInfo, @NotNull PsiVariable variable, @NotNull PsiReferenceParameterList parameterList, @NotNull JavaSdkVersion version) {
        PsiType type2 = variable.getType();
        if (!(type2 instanceof PsiClassType) || highlightInfo == null) {
            return;
        }
        if (DumbService.getInstance((Project)variable.getProject()).isDumb()) {
            return;
        }
        String shortName = ((PsiClassType)type2).getClassName();
        PsiManager manager = parameterList.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiShortNamesCache shortNamesCache = PsiShortNamesCache.getInstance((Project)parameterList.getProject());
        PsiClass[] classes2 = shortNamesCache.getClassesByName(shortName, GlobalSearchScope.allScope((Project)manager.getProject()));
        PsiElementFactory factory = facade.getElementFactory();
        for (PsiClass aClass : classes2) {
            if (GenericsHighlightUtil.checkReferenceTypeArgumentList((PsiTypeParameterListOwner)aClass, parameterList, PsiSubstitutor.EMPTY, false, version) != null) continue;
            PsiType[] actualTypeParameters = parameterList.getTypeArguments();
            PsiTypeParameter[] classTypeParameters = aClass.getTypeParameters();
            HashMap<PsiTypeParameter, PsiType> map2 = new HashMap<PsiTypeParameter, PsiType>();
            for (int j = 0; j < Math.min(classTypeParameters.length, actualTypeParameters.length); ++j) {
                PsiTypeParameter classTypeParameter = classTypeParameters[j];
                PsiType actualTypeParameter = actualTypeParameters[j];
                map2.put(classTypeParameter, actualTypeParameter);
            }
            PsiSubstitutor substitutor = factory.createSubstitutor(map2);
            PsiClassType suggestedType = factory.createType(aClass, substitutor);
            HighlightFixUtil.registerChangeVariableTypeFixes(variable, (PsiType)suggestedType, variable.getInitializer(), highlightInfo);
        }
    }

    static HighlightInfo checkInferredIntersections(@NotNull PsiSubstitutor substitutor, @NotNull TextRange ref) {
        for (Map.Entry typeEntry : substitutor.getSubstitutionMap().entrySet()) {
            String conflictingConjunctsMessage;
            String parameterName = ((PsiTypeParameter)typeEntry.getKey()).getName();
            PsiType type2 = (PsiType)typeEntry.getValue();
            if (!(type2 instanceof PsiIntersectionType) || (conflictingConjunctsMessage = ((PsiIntersectionType)type2).getConflictingConjunctsMessage()) == null) continue;
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(JavaErrorBundle.message("type.parameter.has.incompatible.upper.bounds", parameterName, conflictingConjunctsMessage)).range(ref).create();
        }
        return null;
    }

    static HighlightInfo checkClassSupersAccessibility(@NotNull PsiClass aClass) {
        return GenericsHighlightUtil.checkClassSupersAccessibility(aClass, aClass.getResolveScope(), HighlightNamesUtil.getClassDeclarationTextRange(aClass), true);
    }

    static HighlightInfo checkClassSupersAccessibility(@NotNull PsiClass aClass, @NotNull PsiElement ref) {
        return GenericsHighlightUtil.checkClassSupersAccessibility(aClass, ref.getResolveScope(), ref.getTextRange(), false);
    }

    private static HighlightInfo checkClassSupersAccessibility(@NotNull PsiClass aClass, @NotNull GlobalSearchScope resolveScope, @NotNull TextRange range, boolean checkParameters) {
        JavaPsiFacade factory = JavaPsiFacade.getInstance((Project)aClass.getProject());
        for (PsiClassType superType : aClass.getSuperTypes()) {
            HashSet<PsiClass> checked = new HashSet<PsiClass>();
            checked.add(aClass);
            String notAccessibleErrorMessage = GenericsHighlightUtil.isTypeAccessible((PsiType)superType, checked, checkParameters, resolveScope, factory);
            if (notAccessibleErrorMessage == null) continue;
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(notAccessibleErrorMessage).range(range).create();
        }
        return null;
    }

    static HighlightInfo checkMemberSignatureTypesAccessibility(@NotNull PsiReferenceExpression ref) {
        String message2 = null;
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            JavaResolveResult resolveResult = ((PsiMethodCallExpression)parent).resolveMethodGenerics();
            PsiMethod method = (PsiMethod)resolveResult.getElement();
            if (method != null) {
                HashSet classes2 = new HashSet();
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)ref.getProject());
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                GlobalSearchScope resolveScope = ref.getResolveScope();
                message2 = GenericsHighlightUtil.isTypeAccessible(substitutor.substitute(method.getReturnType()), classes2, false, resolveScope, facade);
                if (message2 == null) {
                    PsiType type2;
                    PsiType[] psiTypeArray = method.getSignature(substitutor).getParameterTypes();
                    int n = psiTypeArray.length;
                    for (int i = 0; i < n && (message2 = GenericsHighlightUtil.isTypeAccessible(type2 = psiTypeArray[i], classes2, false, resolveScope, facade)) == null; ++i) {
                    }
                }
            }
        } else {
            PsiElement resolve2 = ref.resolve();
            if (resolve2 instanceof PsiField) {
                GlobalSearchScope resolveScope = ref.getResolveScope();
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)ref.getProject());
                message2 = GenericsHighlightUtil.isTypeAccessible(((PsiField)resolve2).getType(), new HashSet(), false, resolveScope, facade);
            }
        }
        if (message2 != null) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message2).range((PsiElement)ref).create();
        }
        return null;
    }

    @Nullable
    private static String isTypeAccessible(@Nullable PsiType type2, @NotNull Set<? super PsiClass> classes2, boolean checkParameters, @NotNull GlobalSearchScope resolveScope, @NotNull JavaPsiFacade factory) {
        PsiClass aClass = PsiUtil.resolveClassInType((PsiType)(type2 = PsiClassImplUtil.correctType(type2, resolveScope)));
        if (aClass != null && classes2.add((PsiClass)aClass)) {
            VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)aClass);
            if (vFile == null) {
                return null;
            }
            FileIndexFacade index = FileIndexFacade.getInstance((Project)aClass.getProject());
            if (!index.isInSource(vFile) && !index.isInLibraryClasses(vFile)) {
                return null;
            }
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName != null && factory.findClass(qualifiedName, resolveScope) == null) {
                return "Cannot access " + HighlightUtil.formatClass(aClass);
            }
            if (!checkParameters) {
                return null;
            }
            if (type2 instanceof PsiClassType) {
                for (PsiType parameterType : ((PsiClassType)type2).getParameters()) {
                    String notAccessibleMessage = GenericsHighlightUtil.isTypeAccessible(parameterType, classes2, true, resolveScope, factory);
                    if (notAccessibleMessage == null) continue;
                    return notAccessibleMessage;
                }
            }
            boolean isInLibrary = !index.isInContent(vFile);
            for (PsiClassType superType : aClass.getSuperTypes()) {
                String notAccessibleMessage = GenericsHighlightUtil.isTypeAccessible((PsiType)superType, classes2, !isInLibrary, resolveScope, factory);
                if (notAccessibleMessage == null) continue;
                return notAccessibleMessage;
            }
        }
        return null;
    }

    static HighlightInfo checkTypeParameterOverrideEquivalentMethods(@NotNull PsiClass aClass, @NotNull LanguageLevel level) {
        Collection<HighlightInfo> result;
        PsiReferenceList extendsList;
        if (aClass instanceof PsiTypeParameter && level.isAtLeast(LanguageLevel.JDK_1_7) && (extendsList = aClass.getExtendsList()) != null && extendsList.getReferenceElements().length > 1 && !(result = GenericsHighlightUtil.checkOverrideEquivalentMethods(aClass)).isEmpty()) {
            return result.iterator().next();
        }
        return null;
    }
}

