/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInsight.daemon.impl.analysis.MoveAnnotationOnStaticMemberQualifyingTypeFix;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationsHighlightUtil {
    private static final Logger LOG = Logger.getInstance(AnnotationsHighlightUtil.class);
    private static final ElementPattern<PsiElement> ANY_ANNOTATION_ALLOWED = PsiJavaPatterns.psiElement().andOr(new ElementPattern[]{PsiJavaPatterns.psiElement().withParent(PsiNameValuePair.class), PsiJavaPatterns.psiElement().withParents(new Class[]{PsiArrayInitializerMemberValue.class, PsiNameValuePair.class}), PsiJavaPatterns.psiElement().withParents(new Class[]{PsiArrayInitializerMemberValue.class, PsiAnnotationMethod.class}), ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(PsiAnnotationMethod.class)).afterLeaf(new String[]{"default"})});

    static HighlightInfo checkNameValuePair(@NotNull PsiNameValuePair pair2, @Nullable RefCountHolder refCountHolder) {
        HighlightInfo info;
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)pair2, PsiAnnotation.class);
        if (annotation == null) {
            return null;
        }
        PsiClass annotationClass = annotation.resolveAnnotationType();
        if (annotationClass == null) {
            return null;
        }
        PsiReference ref = pair2.getReference();
        if (ref == null) {
            return null;
        }
        PsiMethod method = (PsiMethod)ref.resolve();
        if (refCountHolder != null) {
            refCountHolder.registerReference(ref, (JavaResolveResult)(method != null ? new CandidateInfo((PsiElement)method, PsiSubstitutor.EMPTY) : JavaResolveResult.EMPTY));
        }
        if (method == null) {
            if (pair2.getName() != null) {
                String description = JavaErrorBundle.message("annotation.unknown.method", ref.getCanonicalText());
                HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(ref.getElement(), ref.getRangeInElement()).descriptionAndTooltip(description).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QuickFixFactory.getInstance().createCreateAnnotationMethodFromUsageFix(pair2));
                return highlightInfo;
            }
            String description = JavaErrorBundle.message("annotation.missing.method", ref.getCanonicalText());
            PsiElement element = ref.getElement();
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
            for (IntentionAction action : QuickFixFactory.getInstance().createAddAnnotationAttributeNameFixes(pair2)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)action);
            }
            return highlightInfo;
        }
        PsiType returnType = method.getReturnType();
        assert (returnType != null) : method;
        PsiAnnotationMemberValue value2 = pair2.getValue();
        if (value2 != null && (info = AnnotationsHighlightUtil.checkMemberValueType(value2, returnType)) != null) {
            return info;
        }
        return AnnotationsHighlightUtil.checkDuplicateAttribute(pair2);
    }

    private static HighlightInfo checkDuplicateAttribute(@NotNull PsiNameValuePair pair2) {
        PsiNameValuePair[] attributes;
        PsiAnnotationParameterList annotation = (PsiAnnotationParameterList)pair2.getParent();
        for (PsiNameValuePair attribute : attributes = annotation.getAttributes()) {
            if (attribute == pair2) break;
            String name2 = pair2.getName();
            if (!Objects.equals(attribute.getName(), name2)) continue;
            String description = JavaErrorBundle.message("annotation.duplicate.attribute", name2 == null ? "value" : name2);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)pair2).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkMemberValueType(@NotNull PsiAnnotationMemberValue value2, @NotNull PsiType expectedType) {
        if (expectedType instanceof PsiClassType && expectedType.equalsToText("java.lang.Class") && !(value2 instanceof PsiClassObjectAccessExpression)) {
            String description = JavaErrorBundle.message("annotation.non.class.literal.attribute.value", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)value2).descriptionAndTooltip(description).create();
        }
        if (value2 instanceof PsiAnnotation) {
            PsiClass aClass;
            PsiType componentType;
            PsiClass aClass2;
            PsiJavaCodeReferenceElement nameRef = ((PsiAnnotation)value2).getNameReferenceElement();
            if (nameRef == null) {
                return null;
            }
            if (expectedType instanceof PsiClassType && (aClass2 = ((PsiClassType)expectedType).resolve()) != null && nameRef.isReferenceTo((PsiElement)aClass2)) {
                return null;
            }
            if (expectedType instanceof PsiArrayType && (componentType = ((PsiArrayType)expectedType).getComponentType()) instanceof PsiClassType && (aClass = ((PsiClassType)componentType).resolve()) != null && nameRef.isReferenceTo((PsiElement)aClass)) {
                return null;
            }
            String description = JavaErrorBundle.message("incompatible.types", JavaHighlightUtil.formatType(expectedType), nameRef.getCanonicalText());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)value2).descriptionAndTooltip(description).create();
        }
        if (value2 instanceof PsiArrayInitializerMemberValue) {
            if (expectedType instanceof PsiArrayType) {
                return null;
            }
            String description = JavaErrorBundle.message("annotation.illegal.array.initializer", JavaHighlightUtil.formatType(expectedType));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)value2).descriptionAndTooltip(description).create();
        }
        if (value2 instanceof PsiExpression) {
            PsiExpression expr2 = (PsiExpression)value2;
            PsiType type2 = expr2.getType();
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
            if (!(psiClass == null || !psiClass.isEnum() || expr2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)expr2).resolve() instanceof PsiEnumConstant)) {
                String description = JavaErrorBundle.message("annotation.non.enum.constant.attribute.value", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)value2).descriptionAndTooltip(description).create();
            }
            if (type2 != null && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)expectedType, (PsiExpression)expr2) || expectedType instanceof PsiArrayType && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)((PsiArrayType)expectedType).getComponentType(), (PsiExpression)expr2)) {
                return null;
            }
            String description = JavaErrorBundle.message("incompatible.types", JavaHighlightUtil.formatType(expectedType), JavaHighlightUtil.formatType(type2));
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)value2).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QuickFixFactory.getInstance().createSurroundWithQuotesAnnotationParameterValueFix(value2, expectedType));
            return info;
        }
        LOG.error("Unknown annotation member value: " + value2);
        return null;
    }

    static HighlightInfo checkDuplicateAnnotations(@NotNull PsiAnnotation annotationToCheck, @NotNull LanguageLevel languageLevel) {
        String containedElementFQN;
        PsiAnnotationOwner owner2 = annotationToCheck.getOwner();
        if (owner2 == null) {
            return null;
        }
        PsiJavaCodeReferenceElement element = annotationToCheck.getNameReferenceElement();
        if (element == null) {
            return null;
        }
        PsiElement resolved = element.resolve();
        if (!(resolved instanceof PsiClass)) {
            return null;
        }
        PsiClass annotationType = (PsiClass)resolved;
        PsiClass contained = AnnotationsHighlightUtil.contained(annotationType);
        String string = containedElementFQN = contained == null ? null : contained.getQualifiedName();
        if (containedElementFQN != null) {
            String containerName = annotationType.getQualifiedName();
            if (AnnotationsHighlightUtil.isAnnotationRepeatedTwice(owner2, containedElementFQN)) {
                String description = JavaErrorBundle.message("annotation.container.wrong.place", containerName);
                return AnnotationsHighlightUtil.annotationError(annotationToCheck, description);
            }
        } else if (AnnotationsHighlightUtil.isAnnotationRepeatedTwice(owner2, annotationType.getQualifiedName())) {
            PsiAnnotation.TargetType[] targets;
            PsiAnnotation.TargetType applicable;
            if (!languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                String description = JavaErrorBundle.message("annotation.duplicate.annotation", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)element).descriptionAndTooltip(description).create();
            }
            PsiAnnotation metaAnno = PsiImplUtil.findAnnotation((PsiAnnotationOwner)annotationType.getModifierList(), "java.lang.annotation.Repeatable");
            if (metaAnno == null) {
                String explanation = JavaErrorBundle.message("annotation.non.repeatable", annotationType.getQualifiedName());
                String description = JavaErrorBundle.message("annotation.duplicate.explained", explanation);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)element).descriptionAndTooltip(description).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QuickFixFactory.getInstance().createCollapseAnnotationsFix(annotationToCheck));
                return info;
            }
            String explanation = AnnotationsHighlightUtil.doCheckRepeatableAnnotation(metaAnno);
            if (explanation != null) {
                String description = JavaErrorBundle.message("annotation.duplicate.explained", explanation);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)element).descriptionAndTooltip(description).create();
            }
            PsiClass container = AnnotationsHighlightUtil.getRepeatableContainer(metaAnno);
            if (container != null && (applicable = AnnotationTargetUtil.findAnnotationTarget((PsiClass)container, (PsiAnnotation.TargetType[])(targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)owner2)))) == null) {
                String target = JavaAnalysisBundle.message((String)("annotation.target." + targets[0]), (Object[])new Object[0]);
                String message2 = JavaErrorBundle.message("annotation.container.not.applicable", container.getName(), target);
                return AnnotationsHighlightUtil.annotationError(annotationToCheck, message2);
            }
        }
        return null;
    }

    private static PsiClass contained(@NotNull PsiClass annotationType) {
        if (!annotationType.isAnnotationType()) {
            return null;
        }
        PsiMethod[] values = annotationType.findMethodsByName("value", false);
        if (values.length != 1) {
            return null;
        }
        PsiMethod value2 = values[0];
        PsiType returnType = value2.getReturnType();
        if (!(returnType instanceof PsiArrayType)) {
            return null;
        }
        PsiType type2 = ((PsiArrayType)returnType).getComponentType();
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiClass contained = ((PsiClassType)type2).resolve();
        if (contained == null || !contained.isAnnotationType()) {
            return null;
        }
        if (PsiImplUtil.findAnnotation((PsiAnnotationOwner)contained.getModifierList(), "java.lang.annotation.Repeatable") == null) {
            return null;
        }
        return contained;
    }

    private static boolean isAnnotationRepeatedTwice(@NotNull PsiAnnotationOwner owner2, @Nullable String qualifiedName) {
        int count = 0;
        for (PsiAnnotation annotation : owner2.getAnnotations()) {
            PsiElement resolved;
            PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
            if (nameRef == null || !((resolved = nameRef.resolve()) instanceof PsiClass) || !Objects.equals(qualifiedName, ((PsiClass)resolved).getQualifiedName()) || ++count != 2) continue;
            return true;
        }
        return false;
    }

    static HighlightInfo checkMissingAttributes(@NotNull PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)nameRef.resolve();
        if (aClass != null && aClass.isAnnotationType()) {
            PsiNameValuePair[] attributes;
            HashSet<String> names2 = new HashSet<String>();
            for (PsiNameValuePair attribute : attributes = annotation.getParameterList().getAttributes()) {
                String name2 = attribute.getName();
                if (name2 != null) {
                    names2.add(name2);
                    continue;
                }
                names2.add("value");
            }
            PsiMethod[] annotationMethods = aClass.getMethods();
            ArrayList<String> missed = new ArrayList<String>();
            for (PsiMethod method : annotationMethods) {
                PsiAnnotationMethod annotationMethod;
                if (!PsiUtil.isAnnotationMethod((PsiElement)method) || (annotationMethod = (PsiAnnotationMethod)method).getDefaultValue() != null || names2.contains(annotationMethod.getName())) continue;
                missed.add(annotationMethod.getName());
            }
            if (!missed.isEmpty()) {
                StringBuffer buff = new StringBuffer("'" + (String)missed.get(0) + "'");
                for (int i = 1; i < missed.size(); ++i) {
                    buff.append(", ");
                    buff.append("'").append((String)missed.get(i)).append("'");
                }
                String description = JavaErrorBundle.message("annotation.missing.attribute", buff);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)nameRef).descriptionAndTooltip(description).create();
                IntentionAction fix = QuickFixFactory.getInstance().createAddMissingRequiredAnnotationParametersFix(annotation, annotationMethods, missed);
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)fix);
                return info;
            }
        }
        return null;
    }

    static HighlightInfo checkConstantExpression(@NotNull PsiExpression expression2) {
        PsiElement parent = expression2.getParent();
        if ((PsiUtil.isAnnotationMethod((PsiElement)parent) || parent instanceof PsiNameValuePair || parent instanceof PsiArrayInitializerMemberValue) && !PsiUtil.isConstantExpression((PsiExpression)expression2)) {
            String description = JavaErrorBundle.message("annotation.non.constant.attribute.value", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkValidAnnotationType(@Nullable PsiType type2, @NotNull PsiTypeElement typeElement) {
        if (type2 != null && ((Boolean)type2.accept((PsiTypeVisitor)AnnotationReturnTypeVisitor.INSTANCE)).booleanValue()) {
            return null;
        }
        String description = JavaErrorBundle.message("annotation.invalid.annotation.member.type", type2 != null ? type2.getPresentableText() : null);
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
    }

    public static HighlightInfo checkApplicability(@NotNull PsiAnnotation annotation, @NotNull LanguageLevel level, @NotNull PsiFile file) {
        HighlightInfo info;
        if (ANY_ANNOTATION_ALLOWED.accepts((Object)annotation)) {
            return null;
        }
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        PsiAnnotationOwner owner2 = annotation.getOwner();
        PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)owner2);
        if (owner2 == null || targets.length == 0) {
            String message2 = JavaErrorBundle.message("annotation.not.allowed.here", new Object[0]);
            return AnnotationsHighlightUtil.annotationError(annotation, message2);
        }
        if (!(owner2 instanceof PsiModifierList) && (info = HighlightUtil.checkFeature((PsiElement)annotation, HighlightingFeature.TYPE_ANNOTATIONS, level, file)) != null) {
            return info;
        }
        PsiAnnotation.TargetType applicable = AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])targets);
        if (applicable == PsiAnnotation.TargetType.UNKNOWN) {
            return null;
        }
        if (applicable == null) {
            String target = JavaAnalysisBundle.message((String)("annotation.target." + targets[0]), (Object[])new Object[0]);
            String message3 = JavaErrorBundle.message("annotation.not.applicable", nameRef.getText(), target);
            return AnnotationsHighlightUtil.annotationError(annotation, message3);
        }
        if (applicable == PsiAnnotation.TargetType.TYPE_USE) {
            if (owner2 instanceof PsiClassReferenceType) {
                PsiJavaCodeReferenceElement ref = ((PsiClassReferenceType)owner2).getReference();
                HighlightInfo info2 = AnnotationsHighlightUtil.checkReferenceTarget(annotation, ref);
                if (info2 != null) {
                    return info2;
                }
            } else if (owner2 instanceof PsiModifierList || owner2 instanceof PsiTypeElement) {
                PsiTypeElement nextElement;
                Object object = nextElement = owner2 instanceof PsiTypeElement ? (PsiTypeElement)owner2 : PsiTreeUtil.skipSiblingsForward((PsiElement)((PsiModifierList)owner2), (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class});
                if (nextElement instanceof PsiTypeElement) {
                    PsiJavaCodeReferenceElement ref;
                    HighlightInfo info3;
                    PsiTypeElement typeElement = nextElement;
                    PsiType type2 = typeElement.getType();
                    if (PsiType.VOID.equals((Object)type2)) {
                        String message4 = JavaErrorBundle.message("annotation.not.allowed.void", new Object[0]);
                        return AnnotationsHighlightUtil.annotationError(annotation, message4);
                    }
                    if (!(type2 instanceof PsiPrimitiveType) && !(type2 instanceof PsiArrayType) && (info3 = AnnotationsHighlightUtil.checkReferenceTarget(annotation, ref = AnnotationsHighlightUtil.getOutermostReferenceElement(typeElement.getInnermostComponentReferenceElement()))) != null) {
                        return info3;
                    }
                    PsiElement context = PsiTreeUtil.skipParentsOfType((PsiElement)typeElement, (Class[])new Class[]{PsiTypeElement.class});
                    if (context instanceof PsiClassObjectAccessExpression) {
                        String message5 = JavaErrorBundle.message("annotation.not.allowed.class", new Object[0]);
                        return AnnotationsHighlightUtil.annotationError(annotation, message5);
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private static HighlightInfo annotationError(@NotNull PsiAnnotation annotation, @NotNull String message2) {
        LocalQuickFixAndIntentionActionOnPsiElement fix = QuickFixFactory.getInstance().createDeleteFix((PsiElement)annotation, JavaAnalysisBundle.message((String)"intention.text.remove.annotation", (Object[])new Object[0]));
        return AnnotationsHighlightUtil.annotationError(annotation, message2, (IntentionAction)fix);
    }

    @Nullable
    private static HighlightInfo annotationError(@NotNull PsiAnnotation annotation, @NotNull String message2, @NotNull IntentionAction fix) {
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)annotation).descriptionAndTooltip(message2).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)fix);
        return info;
    }

    @Nullable
    private static HighlightInfo checkReferenceTarget(@NotNull PsiAnnotation annotation, @Nullable PsiJavaCodeReferenceElement ref) {
        PsiElement qualified;
        if (ref == null) {
            return null;
        }
        PsiElement refTarget = ref.resolve();
        if (refTarget == null) {
            return null;
        }
        if (!(refTarget instanceof PsiClass)) {
            return AnnotationsHighlightUtil.annotationError(annotation, JavaErrorBundle.message("annotation.not.allowed.ref", new Object[0]));
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiJavaCodeReferenceElement && (qualified = ((PsiJavaCodeReferenceElement)parent).resolve()) instanceof PsiMember && ((PsiMember)qualified).hasModifierProperty("static")) {
            return AnnotationsHighlightUtil.annotationError(annotation, JavaErrorBundle.message("annotation.not.allowed.static", new Object[0]), (IntentionAction)new MoveAnnotationOnStaticMemberQualifyingTypeFix(annotation));
        }
        return null;
    }

    @Contract(value="null->null; !null->!null")
    private static PsiJavaCodeReferenceElement getOutermostReferenceElement(@Nullable PsiJavaCodeReferenceElement ref) {
        PsiElement qualifier;
        if (ref == null) {
            return null;
        }
        while ((qualifier = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement) {
            ref = (PsiJavaCodeReferenceElement)qualifier;
        }
        return ref;
    }

    static HighlightInfo checkAnnotationType(@NotNull PsiAnnotation annotation) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
        if (!(nameReferenceElement == null || (resolved = nameReferenceElement.resolve()) instanceof PsiClass && ((PsiClass)resolved).isAnnotationType())) {
            String description = JavaErrorBundle.message("annotation.annotation.type.expected", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)nameReferenceElement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkCyclicMemberType(@NotNull PsiTypeElement typeElement, @NotNull PsiClass aClass) {
        HashSet checked;
        PsiType type2 = typeElement.getType();
        if (AnnotationsHighlightUtil.cyclicDependencies(aClass, type2, checked = new HashSet())) {
            String description = JavaErrorBundle.message("annotation.cyclic.element.type", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeElement).descriptionAndTooltip(description).create();
        }
        return null;
    }

    private static boolean cyclicDependencies(@NotNull PsiClass aClass, @Nullable PsiType type2, @NotNull Set<? super PsiClass> checked) {
        PsiClass resolvedClass = PsiUtil.resolveClassInType((PsiType)type2);
        if (resolvedClass != null && resolvedClass.isAnnotationType()) {
            PsiMethod[] methods;
            if (aClass == resolvedClass) {
                return true;
            }
            if (!checked.add((PsiClass)resolvedClass) || !BaseIntentionAction.canModify((PsiElement)resolvedClass)) {
                return false;
            }
            for (PsiMethod method : methods = resolvedClass.getMethods()) {
                if (!AnnotationsHighlightUtil.cyclicDependencies(aClass, method.getReturnType(), checked)) continue;
                return true;
            }
        }
        return false;
    }

    static HighlightInfo checkClashesWithSuperMethods(@NotNull PsiAnnotationMethod psiMethod) {
        PsiIdentifier nameIdentifier = psiMethod.getNameIdentifier();
        if (nameIdentifier != null) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = psiMethod.findDeepestSuperMethods()) {
                String qualifiedName;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null || !"java.lang.Object".equals(qualifiedName = containingClass.getQualifiedName()) && !"java.lang.annotation.Annotation".equals(qualifiedName)) continue;
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)nameIdentifier).descriptionAndTooltip(JavaErrorBundle.message("error.interface.member.clashes", JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(containingClass))).create();
            }
        }
        return null;
    }

    static HighlightInfo checkAnnotationDeclaration(@Nullable PsiElement parent, @NotNull PsiReferenceList list) {
        if (PsiUtil.isAnnotationMethod((PsiElement)parent)) {
            PsiAnnotationMethod method = (PsiAnnotationMethod)parent;
            if (list == method.getThrowsList()) {
                String description = JavaErrorBundle.message("annotation.members.may.not.have.throws.list", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
            }
        } else if (parent instanceof PsiClass && ((PsiClass)parent).isAnnotationType() && "extends".equals(list.getFirstChild().getText())) {
            String description = JavaErrorBundle.message("annotation.may.not.have.extends.list", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkPackageAnnotationContainingFile(@NotNull PsiPackageStatement statement, @NotNull PsiFile file) {
        PsiModifierList annotationList = statement.getAnnotationList();
        if (annotationList != null && !"package-info.java".equals(file.getName())) {
            String message2 = JavaErrorBundle.message("invalid.package.annotation.containing.file", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)annotationList).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    static HighlightInfo checkTargetAnnotationDuplicates(@NotNull PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        PsiElement resolved = nameRef.resolve();
        if (!(resolved instanceof PsiClass) || !"java.lang.annotation.Target".equals(((PsiClass)resolved).getQualifiedName())) {
            return null;
        }
        PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
        if (attributes.length < 1) {
            return null;
        }
        PsiAnnotationMemberValue value2 = attributes[0].getValue();
        if (!(value2 instanceof PsiArrayInitializerMemberValue)) {
            return null;
        }
        PsiAnnotationMemberValue[] arrayInitializers = ((PsiArrayInitializerMemberValue)value2).getInitializers();
        HashSet<PsiElement> targets = new HashSet<PsiElement>();
        for (PsiAnnotationMemberValue initializer : arrayInitializers) {
            PsiElement target;
            if (!(initializer instanceof PsiReferenceExpression) || (target = ((PsiReferenceExpression)initializer).resolve()) == null) continue;
            if (targets.contains(target)) {
                String description = JavaErrorBundle.message("repeated.annotation.target", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)initializer).descriptionAndTooltip(description).create();
            }
            targets.add(target);
        }
        return null;
    }

    static HighlightInfo checkFunctionalInterface(@NotNull PsiAnnotation annotation, @NotNull LanguageLevel languageLevel) {
        PsiElement parent;
        PsiAnnotationOwner owner2;
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && Comparing.strEqual((String)annotation.getQualifiedName(), (String)"java.lang.FunctionalInterface") && (owner2 = annotation.getOwner()) instanceof PsiModifierList && (parent = ((PsiModifierList)owner2).getParent()) instanceof PsiClass) {
            String errorMessage = LambdaHighlightingUtil.checkInterfaceFunctional((PsiClass)parent, JavaErrorBundle.message("not.a.functional.interface", ((PsiClass)parent).getName()));
            if (errorMessage != null) {
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)annotation).descriptionAndTooltip(errorMessage).create();
            }
            if (((PsiClass)parent).hasModifierProperty("sealed")) {
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)annotation).descriptionAndTooltip(JavaErrorBundle.message("functional.interface.must.not.be.sealed.error.description", "sealed")).create();
            }
        }
        return null;
    }

    static HighlightInfo checkRepeatableAnnotation(@NotNull PsiAnnotation annotation) {
        PsiAnnotationMemberValue containerRef;
        String qualifiedName = annotation.getQualifiedName();
        if (!"java.lang.annotation.Repeatable".equals(qualifiedName)) {
            return null;
        }
        String description = AnnotationsHighlightUtil.doCheckRepeatableAnnotation(annotation);
        if (description != null && (containerRef = PsiImplUtil.findAttributeValue(annotation, null)) != null) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)containerRef).descriptionAndTooltip(description).create();
        }
        return null;
    }

    private static String doCheckRepeatableAnnotation(@NotNull PsiAnnotation annotation) {
        Set containerTargets;
        RetentionPolicy containerPolicy;
        PsiArrayType expected;
        PsiAnnotationOwner owner2 = annotation.getOwner();
        if (!(owner2 instanceof PsiModifierList)) {
            return null;
        }
        PsiElement target = ((PsiModifierList)owner2).getParent();
        if (!(target instanceof PsiClass) || !((PsiClass)target).isAnnotationType()) {
            return null;
        }
        PsiClass container = AnnotationsHighlightUtil.getRepeatableContainer(annotation);
        if (container == null) {
            return null;
        }
        PsiMethod[] methods = container.findMethodsByName("value", false);
        if (methods.length == 0) {
            return JavaErrorBundle.message("annotation.container.no.value", container.getQualifiedName());
        }
        if (methods.length == 1 && !(expected = new PsiImmediateClassType((PsiClass)target, PsiSubstitutor.EMPTY).createArrayType()).equals(methods[0].getReturnType())) {
            return JavaErrorBundle.message("annotation.container.bad.type", container.getQualifiedName(), JavaHighlightUtil.formatType((PsiType)expected));
        }
        RetentionPolicy targetPolicy = AnnotationsHighlightUtil.getRetentionPolicy((PsiClass)target);
        if (targetPolicy != null && (containerPolicy = AnnotationsHighlightUtil.getRetentionPolicy(container)) != null && targetPolicy.compareTo(containerPolicy) > 0) {
            return JavaErrorBundle.message("annotation.container.low.retention", new Object[]{container.getQualifiedName(), containerPolicy});
        }
        Set repeatableTargets = AnnotationTargetUtil.getAnnotationTargets((PsiClass)((PsiClass)target));
        if (repeatableTargets != null && (containerTargets = AnnotationTargetUtil.getAnnotationTargets((PsiClass)container)) != null && !repeatableTargets.containsAll(containerTargets)) {
            return JavaErrorBundle.message("annotation.container.wide.target", container.getQualifiedName());
        }
        for (PsiMethod method : container.getMethods()) {
            if (!(method instanceof PsiAnnotationMethod) || "value".equals(method.getName()) || ((PsiAnnotationMethod)method).getDefaultValue() != null) continue;
            return JavaErrorBundle.message("annotation.container.abstract", container.getQualifiedName(), method.getName());
        }
        return null;
    }

    @Nullable
    private static PsiClass getRepeatableContainer(@NotNull PsiAnnotation annotation) {
        PsiAnnotationMemberValue containerRef = PsiImplUtil.findAttributeValue(annotation, null);
        if (!(containerRef instanceof PsiClassObjectAccessExpression)) {
            return null;
        }
        PsiType containerType = ((PsiClassObjectAccessExpression)containerRef).getOperand().getType();
        if (!(containerType instanceof PsiClassType)) {
            return null;
        }
        PsiClass container = ((PsiClassType)containerType).resolve();
        if (container == null || !container.isAnnotationType()) {
            return null;
        }
        return container;
    }

    static HighlightInfo checkReceiverPlacement(@NotNull PsiReceiverParameter parameter2) {
        PsiElement owner2 = parameter2.getParent().getParent();
        if (owner2 == null) {
            return null;
        }
        if (!(owner2 instanceof PsiMethod)) {
            String text2 = JavaErrorBundle.message("receiver.wrong.context", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)parameter2.getIdentifier()).descriptionAndTooltip(text2).create();
        }
        PsiMethod method = (PsiMethod)owner2;
        if (AnnotationsHighlightUtil.isStatic((PsiModifierListOwner)method) || method.isConstructor() && AnnotationsHighlightUtil.isStatic((PsiModifierListOwner)method.getContainingClass())) {
            String text3 = JavaErrorBundle.message("receiver.static.context", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)parameter2.getIdentifier()).descriptionAndTooltip(text3).create();
        }
        PsiElement leftNeighbour = PsiTreeUtil.skipWhitespacesBackward((PsiElement)parameter2);
        if (leftNeighbour != null && !PsiUtil.isJavaToken((PsiElement)leftNeighbour, (IElementType)JavaTokenType.LPARENTH)) {
            String text4 = JavaErrorBundle.message("receiver.wrong.position", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)parameter2.getIdentifier()).descriptionAndTooltip(text4).create();
        }
        return null;
    }

    static HighlightInfo checkReceiverType(@NotNull PsiReceiverParameter parameter2) {
        PsiElement owner2 = parameter2.getParent().getParent();
        if (!(owner2 instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)owner2;
        PsiClass enclosingClass = method.getContainingClass();
        if (method.isConstructor() && enclosingClass != null) {
            enclosingClass = enclosingClass.getContainingClass();
        }
        if (enclosingClass != null) {
            PsiClassType type2 = PsiElementFactory.getInstance((Project)parameter2.getProject()).createType(enclosingClass, PsiSubstitutor.EMPTY);
            if (!type2.equals((Object)parameter2.getType())) {
                PsiElement range = (PsiElement)ObjectUtils.notNull((Object)parameter2.getTypeElement(), (Object)parameter2);
                String text2 = JavaErrorBundle.message("receiver.type.mismatch", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(range).descriptionAndTooltip(text2).create();
            }
            PsiThisExpression identifier = parameter2.getIdentifier();
            if (!enclosingClass.equals(PsiUtil.resolveClassInType((PsiType)identifier.getType()))) {
                String text3 = JavaErrorBundle.message("receiver.name.mismatch", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(text3).create();
            }
        }
        return null;
    }

    private static boolean isStatic(@Nullable PsiModifierListOwner owner2) {
        if (owner2 == null) {
            return false;
        }
        if (owner2 instanceof PsiClass && ClassUtil.isTopLevelClass((PsiClass)((PsiClass)owner2))) {
            return true;
        }
        PsiModifierList modifierList = owner2.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty("static");
    }

    @Nullable
    public static RetentionPolicy getRetentionPolicy(@NotNull PsiClass annotation) {
        PsiModifierList modifierList = annotation.getModifierList();
        if (modifierList != null) {
            PsiElement field;
            PsiAnnotation retentionAnno = modifierList.findAnnotation("java.lang.annotation.Retention");
            if (retentionAnno == null) {
                return RetentionPolicy.CLASS;
            }
            PsiAnnotationMemberValue policyRef = PsiImplUtil.findAttributeValue(retentionAnno, null);
            if (policyRef instanceof PsiReference && (field = ((PsiReference)policyRef).resolve()) instanceof PsiEnumConstant) {
                String name2 = ((PsiEnumConstant)field).getName();
                try {
                    return Enum.valueOf(RetentionPolicy.class, name2);
                }
                catch (Exception e) {
                    LOG.warn("Unknown policy: " + name2);
                }
            }
        }
        return null;
    }

    public static class AnnotationReturnTypeVisitor
    extends PsiTypeVisitor<Boolean> {
        public static final AnnotationReturnTypeVisitor INSTANCE = new AnnotationReturnTypeVisitor();

        public Boolean visitType(@NotNull PsiType type2) {
            return Boolean.FALSE;
        }

        public Boolean visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
            return PsiType.VOID.equals((Object)primitiveType) || PsiType.NULL.equals((Object)primitiveType) ? Boolean.FALSE : Boolean.TRUE;
        }

        public Boolean visitArrayType(@NotNull PsiArrayType arrayType) {
            if (arrayType.getArrayDimensions() != 1) {
                return Boolean.FALSE;
            }
            PsiType componentType = arrayType.getComponentType();
            return (Boolean)componentType.accept((PsiTypeVisitor)this);
        }

        public Boolean visitClassType(@NotNull PsiClassType classType) {
            if (classType.getParameters().length > 0) {
                PsiClassType rawType = classType.rawType();
                return rawType.equalsToText("java.lang.Class");
            }
            PsiClass aClass = classType.resolve();
            if (aClass != null && (aClass.isAnnotationType() || aClass.isEnum())) {
                return Boolean.TRUE;
            }
            return classType.equalsToText("java.lang.Class") || classType.equalsToText("java.lang.String");
        }
    }
}

