/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class StringContentIndentUtil {
    private static final Key<Integer> TEXT_BLOCK_INDENT_KEY = Key.create((String)"TextBlockOffset");
    private static final Key<List<RangeHighlighter>> TEXT_BLOCK_HIGHLIGHTERS_IN_EDITOR_KEY = Key.create((String)"TextBlockHighlightersInEditor");
    private static final Key<Long> LAST_TIME_CONTENT_INDENT_CHANGED = Key.create((String)"LastTimeContentIndentChanged");

    static boolean isDocumentUpdated(@NotNull Editor editor) {
        Document document = editor.getDocument();
        long stamp = StringContentIndentUtil.getTimestamp(editor, document);
        Long prevStamp = (Long)document.getUserData(LAST_TIME_CONTENT_INDENT_CHANGED);
        return prevStamp == null || prevStamp != stamp;
    }

    static void updateTimestamp(@NotNull Editor editor) {
        Document document = editor.getDocument();
        long timestamp = StringContentIndentUtil.getTimestamp(editor, document);
        document.putUserData(LAST_TIME_CONTENT_INDENT_CHANGED, (Object)timestamp);
    }

    private static long getTimestamp(@NotNull Editor editor, Document document) {
        return editor.getSettings().isIndentGuidesShown() ? document.getModificationStamp() : -1L;
    }

    @NotNull
    public static Map<TextRange, RangeHighlighter> getIndentHighlighters(@NotNull Editor editor) {
        List highlighters = (List)editor.getUserData(TEXT_BLOCK_HIGHLIGHTERS_IN_EDITOR_KEY);
        if (highlighters == null) {
            return Collections.emptyMap();
        }
        return highlighters.stream().collect(Collectors.toMap(h -> new TextRange(h.getStartOffset(), h.getEndOffset()), Function.identity()));
    }

    public static void addIndentHighlighters(@NotNull Editor editor, @NotNull List<RangeHighlighter> highlighters) {
        editor.putUserData(TEXT_BLOCK_HIGHLIGHTERS_IN_EDITOR_KEY, highlighters);
    }

    public static int getIndent(@NotNull RangeHighlighter highlighter) {
        Integer indent = (Integer)highlighter.getUserData(TEXT_BLOCK_INDENT_KEY);
        return indent == null ? -1 : indent;
    }

    public static void setIndent(@NotNull RangeHighlighter highlighter, int indent) {
        highlighter.putUserData(TEXT_BLOCK_INDENT_KEY, (Object)indent);
    }
}

