/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.StringContentIndentUtil;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.ui.paint.LinePainter2D;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTextBlockIndentPass
extends TextEditorHighlightingPass {
    private static final StringContentIndentRenderer RENDERER = new StringContentIndentRenderer();
    private final Editor myEditor;
    private final PsiJavaFile myFile;
    private List<StringContentIndent> myIndents = Collections.emptyList();

    @Contract(pure=true)
    public JavaTextBlockIndentPass(@NotNull Project project, @NotNull Editor editor, @NotNull PsiJavaFile file) {
        super(project, editor.getDocument());
        this.myEditor = editor;
        this.myFile = file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (!this.myEditor.getSettings().isIndentGuidesShown()) {
            this.myIndents = Collections.emptyList();
            return;
        }
        Document document = this.myEditor.getDocument();
        IndentCollector collector = new IndentCollector(document);
        this.myFile.accept((PsiElementVisitor)collector);
        this.myIndents = collector.getIndents();
    }

    public void doApplyInformationToEditor() {
        if (!StringContentIndentUtil.isDocumentUpdated(this.myEditor)) {
            return;
        }
        MarkupModel model = this.myEditor.getMarkupModel();
        Map<TextRange, RangeHighlighter> oldHighlighters = StringContentIndentUtil.getIndentHighlighters(this.myEditor);
        ArrayList<RangeHighlighter> newHighlighters = new ArrayList<RangeHighlighter>();
        for (StringContentIndent indent : this.myIndents) {
            TextRange newRange = new TextRange(indent.startOffset, indent.endOffset);
            int newIndent = indent.column;
            if (newIndent <= 0) continue;
            RangeHighlighter oldHighlighter = oldHighlighters.get(newRange);
            if (oldHighlighter != null && StringContentIndentUtil.getIndent(oldHighlighter) == newIndent) {
                newHighlighters.add(oldHighlighter);
                oldHighlighters.remove(newRange);
                continue;
            }
            RangeHighlighter newHighlighter = model.addRangeHighlighter(null, indent.startOffset, indent.endOffset, 0, HighlighterTargetArea.EXACT_RANGE);
            newHighlighter.setCustomRenderer((CustomHighlighterRenderer)RENDERER);
            StringContentIndentUtil.setIndent(newHighlighter, newIndent);
            newHighlighters.add(newHighlighter);
        }
        oldHighlighters.values().forEach(RangeMarker::dispose);
        StringContentIndentUtil.addIndentHighlighters(this.myEditor, newHighlighters);
        StringContentIndentUtil.updateTimestamp(this.myEditor);
    }

    private static class IndentCollector
    extends JavaRecursiveElementWalkingVisitor {
        private final Document myDocument;
        private final List<StringContentIndent> myIndents = new ArrayList<StringContentIndent>();

        private IndentCollector(@NotNull Document document) {
            this.myDocument = document;
        }

        public void visitLiteralExpression(PsiLiteralExpression expression2) {
            TextBlockModel model = TextBlockModel.create(expression2);
            if (model == null) {
                return;
            }
            TextRange contentRange = this.getContentRange(model.myRange);
            if (contentRange == null) {
                return;
            }
            this.myIndents.add(new StringContentIndent(model.myBaseIndent, contentRange.getStartOffset(), contentRange.getEndOffset()));
        }

        @Nullable
        private TextRange getContentRange(@NotNull TextRange blockRange) {
            int nStartLine = this.myDocument.getLineNumber(blockRange.getStartOffset()) + 1;
            int nEndLine = this.myDocument.getLineNumber(blockRange.getEndOffset());
            TextRange lastLineRange = new TextRange(this.myDocument.getLineStartOffset(nEndLine), this.myDocument.getLineEndOffset(nEndLine));
            String lastLine = this.myDocument.getText(lastLineRange);
            if (StringUtil.skipWhitespaceForward((CharSequence)(lastLine = lastLine.substring(0, lastLine.indexOf("\"\"\""))), (int)0) == lastLine.length()) {
                --nEndLine;
            }
            if (nEndLine < nStartLine) {
                return null;
            }
            return new TextRange(this.myDocument.getLineStartOffset(nStartLine), this.myDocument.getLineStartOffset(nEndLine));
        }

        @Contract(pure=true)
        private List<StringContentIndent> getIndents() {
            return this.myIndents;
        }

        private static class TextBlockModel {
            private final int myBaseIndent;
            private final TextRange myRange;

            @Contract(pure=true)
            private TextBlockModel(int baseIndent, @NotNull TextRange range) {
                this.myBaseIndent = baseIndent;
                this.myRange = range;
            }

            @Nullable
            private static TextBlockModel create(@Nullable PsiLiteralExpression expression2) {
                if (expression2 == null || !expression2.isTextBlock()) {
                    return null;
                }
                int baseIndent = TextBlockModel.getIndent(expression2);
                if (baseIndent == -1) {
                    return null;
                }
                TextRange range = expression2.getTextRange();
                if (range == null) {
                    return null;
                }
                return new TextBlockModel(baseIndent, range);
            }

            private static int getIndent(@NotNull PsiLiteralExpression literal) {
                String[] lines = PsiLiteralUtil.getTextBlockLines((PsiLiteralExpression)literal);
                if (lines == null) {
                    return -1;
                }
                int indent = PsiLiteralUtil.getTextBlockIndent((String[])lines);
                if (indent <= 0) {
                    return indent;
                }
                IndentType indentType = TextBlockModel.findIndentType(lines, indent);
                if (indentType == null) {
                    return -1;
                }
                if (indentType == IndentType.TABS) {
                    indent *= CodeStyle.getSettings((Project)literal.getProject()).getTabSize((FileType)JavaFileType.INSTANCE);
                }
                return indent;
            }

            @Nullable
            private static IndentType findIndentType(String @NotNull [] lines, int indent) {
                IndentType indentType = null;
                for (int i = 0; i < lines.length; ++i) {
                    String line = lines[i];
                    if (!TextBlockModel.isContentPart(lines, i, line)) continue;
                    for (int j = 0; j < indent; ++j) {
                        char c = line.charAt(j);
                        IndentType currentType = IndentType.of(c);
                        if (currentType == null) {
                            return null;
                        }
                        if (indentType == null) {
                            indentType = currentType;
                            continue;
                        }
                        if (indentType == currentType) continue;
                        return null;
                    }
                }
                return indentType;
            }

            private static boolean isContentPart(String @NotNull [] lines, int i, String line) {
                return !line.isEmpty() && (i == lines.length - 1 || !line.chars().allMatch(Character::isWhitespace));
            }

            public String toString() {
                return "TextBlockModel{myBaseIndent=" + this.myBaseIndent + ", myRange=" + this.myRange + '}';
            }

            private static enum IndentType {
                SPACES,
                TABS;


                @Nullable
                @Contract(pure=true)
                private static IndentType of(char c) {
                    if (c == ' ') {
                        return SPACES;
                    }
                    if (c == '\t') {
                        return TABS;
                    }
                    return null;
                }
            }
        }
    }

    private static class StringContentIndentRenderer
    implements CustomHighlighterRenderer {
        private StringContentIndentRenderer() {
        }

        public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
            int indent = StringContentIndentUtil.getIndent(highlighter);
            if (indent <= 0) {
                return;
            }
            VisualPosition startPosition = editor.offsetToVisualPosition(highlighter.getStartOffset());
            Point start = editor.visualPositionToXY(new VisualPosition(startPosition.line, indent - 1));
            Point right = editor.visualPositionToXY(new VisualPosition(startPosition.line, indent));
            float x = (float)(start.x + right.x) / 2.0f;
            VisualPosition endPosition = editor.offsetToVisualPosition(highlighter.getEndOffset());
            Point end = editor.visualPositionToXY(new VisualPosition(endPosition.line, indent - 1));
            EditorColorsScheme scheme = editor.getColorsScheme();
            g.setColor(scheme.getColor(EditorColors.STRING_CONTENT_INDENT_GUIDE_COLOR));
            g.setFont(scheme.getFont(EditorFontType.PLAIN));
            FontMetrics fontMetrics = g.getFontMetrics();
            int ascent = fontMetrics.getAscent();
            int descent = fontMetrics.getDescent();
            float baseline = editor.getAscent();
            float startY = (float)start.y + baseline - (float)ascent;
            float endY = (float)end.y + baseline + (float)descent;
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)startY, (double)x, (double)endY);
        }
    }

    private static class StringContentIndent {
        private final int column;
        private final int startOffset;
        private final int endOffset;

        @Contract(pure=true)
        private StringContentIndent(int column, int startOffset, int endOffset) {
            this.column = column;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public String toString() {
            return "StringContentIndent{column=" + this.column + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + '}';
        }
    }
}

