/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.completion.ArrayMemberAccess;
import com.intellij.codeInsight.completion.BasicExpressionCompletionContributor;
import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.ChainedCallCompletion;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.FromArrayConversion;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.completion.ToArrayConversion;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SlowerTypeConversions {
    SlowerTypeConversions() {
    }

    static void addChainedSuggestions(CompletionParameters parameters2, CompletionResultSet result, Set<ExpectedTypeInfo> expectedInfos, List<LookupElement> base) {
        PsiElement position = parameters2.getPosition();
        PsiJavaCodeReferenceElement reference = (PsiJavaCodeReferenceElement)position.getParent();
        List chainable = ContainerUtil.filter(base, item -> SlowerTypeConversions.isChainable(item.getObject()));
        if (chainable.isEmpty()) {
            return;
        }
        for (ExpectedTypeInfo info : expectedInfos) {
            HashSet processedChains = new HashSet();
            JavaSmartCompletionParameters smartParams = new JavaSmartCompletionParameters(parameters2, info);
            for (LookupElement item2 : chainable) {
                SlowerTypeConversions.addSecondCompletionVariants(position, (PsiReference)reference, item2, smartParams, (Consumer<? super LookupElement>)((Consumer)lookupElement -> {
                    ContainerUtil.addIfNotNull((Collection)processedChains, SlowerTypeConversions.chainInfo(lookupElement));
                    result.consume((LookupElement)JavaSmartCompletionContributor.decorate(lookupElement, expectedInfos));
                }));
            }
            if (reference.isQualified()) continue;
            BasicExpressionCompletionContributor.processDataflowExpressionTypes(smartParams, null, PrefixMatcher.ALWAYS_TRUE, (Consumer<? super LookupElement>)((Consumer)baseItem -> SlowerTypeConversions.addSecondCompletionVariants(position, (PsiReference)reference, baseItem, smartParams, (Consumer<? super LookupElement>)((Consumer)lookupElement -> {
                if (!processedChains.contains(SlowerTypeConversions.chainInfo(lookupElement))) {
                    result.consume((LookupElement)JavaSmartCompletionContributor.decorate(lookupElement, expectedInfos));
                }
            }))));
        }
    }

    private static boolean isChainable(Object object) {
        return object instanceof PsiVariable || object instanceof PsiMethod || object instanceof PsiExpression;
    }

    private static void addSecondCompletionVariants(PsiElement element, PsiReference reference, LookupElement baseItem, JavaSmartCompletionParameters parameters2, Consumer<? super LookupElement> result) {
        Object object = baseItem.getObject();
        try {
            PsiType itemType = JavaCompletionUtil.getLookupElementType(baseItem);
            if (itemType instanceof PsiWildcardType) {
                itemType = ((PsiWildcardType)itemType).getExtendsBound();
            }
            if (itemType == null) {
                return;
            }
            assert (itemType.isValid()) : baseItem + "; " + baseItem.getClass();
            PsiElement element1 = reference.getElement();
            PsiElement qualifier = element1 instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)element1).getQualifier() : null;
            PsiType expectedType = parameters2.getExpectedType();
            ChainedCallCompletion.addChains(element, baseItem, result, itemType, expectedType, parameters2);
            PsiFile file = parameters2.getParameters().getOriginalFile();
            String prefix = SlowerTypeConversions.getItemText(file, object);
            if (prefix == null) {
                return;
            }
            FromArrayConversion.addConversions(element, prefix, itemType, result, qualifier, expectedType);
            ToArrayConversion.addConversions(file, element, prefix, itemType, result, qualifier, expectedType);
            ArrayMemberAccess.addMemberAccessors(element, prefix, itemType, qualifier, result, (PsiModifierListOwner)object, expectedType);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
    }

    @Nullable
    private static String getItemText(@NotNull PsiFile file, Object o) {
        if (o instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)o;
            PsiType type2 = method.getReturnType();
            if (PsiType.VOID.equals((Object)type2) || PsiType.NULL.equals((Object)type2)) {
                return null;
            }
            if (!method.getParameterList().isEmpty()) {
                return null;
            }
            return method.getName() + "(" + ReferenceExpressionCompletionContributor.getSpace(CodeStyle.getLanguageSettings((PsiFile)file).SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES) + ")";
        }
        if (o instanceof PsiVariable) {
            return ((PsiVariable)o).getName();
        }
        return null;
    }

    @Nullable
    private static Pair<LookupElement, String> chainInfo(LookupElement lookupElement) {
        Object object;
        if (lookupElement instanceof JavaChainLookupElement && (object = lookupElement.getObject()) instanceof PsiMember) {
            LookupElement qualifier = ((JavaChainLookupElement)lookupElement).getQualifier();
            if (qualifier instanceof CastingLookupElementDecorator) {
                qualifier = ((CastingLookupElementDecorator)qualifier).getDelegate();
            }
            return Pair.create((Object)qualifier, (Object)lookupElement.getLookupString());
        }
        return null;
    }
}

