/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaMethodReferenceElement
extends LookupElement
implements TypedLookupItem {
    private final PsiMethod myMethod;
    private final PsiElement myRefPlace;
    private final PsiType myType;

    JavaMethodReferenceElement(PsiMethod method, PsiElement refPlace, @Nullable PsiType type2) {
        this.myMethod = method;
        this.myRefPlace = refPlace;
        this.myType = type2;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return this.myType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaMethodReferenceElement)) {
            return false;
        }
        JavaMethodReferenceElement element = (JavaMethodReferenceElement)o;
        return this.getLookupString().equals(element.getLookupString()) && this.myRefPlace.equals(element.myRefPlace);
    }

    public int hashCode() {
        return Objects.hash(this.getLookupString(), this.myRefPlace);
    }

    @NotNull
    public Object getObject() {
        return this.myMethod;
    }

    @NotNull
    public String getLookupString() {
        return this.myMethod.isConstructor() ? "new" : this.myMethod.getName();
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setIcon(this.myMethod.getIcon(1));
        super.renderElement(presentation);
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (!(this.myRefPlace instanceof PsiMethodReferenceExpression)) {
            PsiClass containingClass = Objects.requireNonNull(this.myMethod.getContainingClass());
            String qualifiedName = Objects.requireNonNull(containingClass.getQualifiedName());
            Editor editor = context.getEditor();
            Document document = editor.getDocument();
            int startOffset = context.getStartOffset();
            document.insertString(startOffset, (CharSequence)(qualifiedName + "::"));
            JavaCompletionUtil.shortenReference(context.getFile(), startOffset + qualifiedName.length() - 1);
        }
    }
}

