/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassReferenceCompletionContributor
extends CompletionContributor {
    public void duringCompletion(@NotNull CompletionInitializationContext context) {
        JavaClassReference reference = JavaClassReferenceCompletionContributor.findJavaClassReference(context.getFile(), context.getStartOffset());
        if (reference != null && reference.getExtendClassNames() != null) {
            JavaClassReferenceSet set = reference.getJavaClassReferenceSet();
            context.setReplacementOffset(set.getRangeInElement().getEndOffset() + set.getElement().getTextRange().getStartOffset());
        }
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result) {
        PsiElement position = parameters2.getPosition();
        JavaClassReference reference = JavaClassReferenceCompletionContributor.findJavaClassReference(position.getContainingFile(), parameters2.getOffset());
        if (reference == null) {
            return;
        }
        String[] extendClassNames = reference.getExtendClassNames();
        PsiElement context = reference.getCompletionContext();
        if (extendClassNames != null && context instanceof PsiPackage) {
            if (parameters2.getCompletionType() == CompletionType.SMART) {
                JavaClassReferenceSet set = reference.getJavaClassReferenceSet();
                int setStart = set.getRangeInElement().getStartOffset() + set.getElement().getTextRange().getStartOffset();
                String fullPrefix = parameters2.getPosition().getContainingFile().getText().substring(setStart, parameters2.getOffset());
                reference.processSubclassVariants((PsiPackage)context, extendClassNames, (Consumer<? super LookupElement>)result.withPrefixMatcher(fullPrefix));
                return;
            }
            result.addLookupAdvertisement(JavaBundle.message((String)"press.0.to.see.inheritors.of.1", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"SmartTypeCompletion"), StringUtil.join((String[])extendClassNames, (String)", ")}));
        }
        if (parameters2.getCompletionType() == CompletionType.SMART) {
            return;
        }
        if (parameters2.isExtendedCompletion() || parameters2.getCompletionType() == CompletionType.CLASS_NAME) {
            JavaClassNameCompletionContributor.addAllClasses(parameters2, result);
        } else {
            LegacyCompletionContributor.completeReference((CompletionParameters)parameters2, (CompletionResultSet)result);
        }
        result.stopHere();
    }

    @Nullable
    public static JavaClassReference findJavaClassReference(PsiFile file, int offset) {
        PsiReference reference = file.findReferenceAt(offset);
        if (reference instanceof PsiMultiReference) {
            for (PsiReference psiReference : ((PsiMultiReference)reference).getReferences()) {
                if (!(psiReference instanceof JavaClassReference)) continue;
                return (JavaClassReference)psiReference;
            }
        }
        return reference instanceof JavaClassReference ? (JavaClassReference)reference : null;
    }
}

