/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaClassNameInsertHandler;
import com.intellij.codeInsight.completion.JavaClassReferenceCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaConstructorCallElement;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.LimitedAccessibleClassPreprocessor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.SkipAutopopupInStrings;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.java.JavaBundle;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.element.ExcludeDeclaredFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassNameCompletionContributor
extends CompletionContributor {
    public static final PsiJavaElementPattern.Capture<PsiElement> AFTER_NEW = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"new"});
    private static final PsiJavaElementPattern.Capture<PsiElement> IN_TYPE_PARAMETER = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"extends", "super", "&"})).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceList.class).withParent(PsiTypeParameter.class));
    private static final ElementPattern<PsiElement> IN_EXTENDS_IMPLEMENTS = PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceList.class).withParent((ElementPattern)PsiJavaPatterns.psiClass()));

    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet _result) {
        if (parameters2.getCompletionType() == CompletionType.CLASS_NAME || parameters2.isExtendedCompletion() && JavaClassNameCompletionContributor.mayContainClassName(parameters2)) {
            JavaClassNameCompletionContributor.addAllClasses(parameters2, _result);
        }
    }

    static void addAllClasses(CompletionParameters parameters2, CompletionResultSet _result) {
        CompletionResultSet result = _result.withPrefixMatcher(CompletionUtil.findReferenceOrAlphanumericPrefix((CompletionParameters)parameters2));
        JavaClassNameCompletionContributor.addAllClasses(parameters2, parameters2.getInvocationCount() <= 1, result.getPrefixMatcher(), (Consumer<? super LookupElement>)_result);
    }

    private static boolean mayContainClassName(CompletionParameters parameters2) {
        PsiElement position = parameters2.getPosition();
        if (SkipAutopopupInStrings.isInStringLiteral((PsiElement)position)) {
            return true;
        }
        PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)position, PsiComment.class, (boolean)false);
        return comment != null && !(comment instanceof PsiDocComment);
    }

    public static void addAllClasses(@NotNull CompletionParameters parameters2, boolean filterByScope, @NotNull PrefixMatcher matcher, @NotNull Consumer<? super LookupElement> consumer) {
        PsiElement insertedElement = parameters2.getPosition();
        JavaClassReference ref = JavaClassReferenceCompletionContributor.findJavaClassReference(insertedElement.getContainingFile(), parameters2.getOffset());
        if (ref != null && ref.getContext() instanceof PsiClass) {
            return;
        }
        if (JavaCompletionContributor.getAnnotationNameIfInside(insertedElement) != null) {
            String name2;
            MultiMap<String, PsiClass> annoMap = JavaClassNameCompletionContributor.getAllAnnotationClasses(insertedElement, matcher);
            LimitedAccessibleClassPreprocessor processor2 = new LimitedAccessibleClassPreprocessor(parameters2, filterByScope, (Processor<? super PsiClass>)((Processor)anno -> {
                JavaPsiClassReferenceElement item = AllClassesGetter.createLookupItem(anno, JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER);
                item.addLookupStrings(new String[]{JavaClassNameCompletionContributor.getClassNameWithContainers(anno)});
                consumer.consume((Object)item);
                return true;
            }));
            Iterator iterator = matcher.sortMatching((Collection)annoMap.keySet()).iterator();
            while (iterator.hasNext() && ContainerUtil.process((Iterable)annoMap.get((Object)(name2 = (String)iterator.next())), (Processor)processor2)) {
            }
            return;
        }
        ExcludeDeclaredFilter filter = IN_EXTENDS_IMPLEMENTS.accepts((Object)insertedElement) ? new ExcludeDeclaredFilter((ElementFilter)new ClassFilter(PsiClass.class)) : (IN_TYPE_PARAMETER.accepts((Object)insertedElement) ? new ExcludeDeclaredFilter((ElementFilter)new ClassFilter(PsiTypeParameter.class)) : TrueFilter.INSTANCE);
        boolean inJavaContext = parameters2.getPosition() instanceof PsiIdentifier;
        boolean afterNew = AFTER_NEW.accepts((Object)insertedElement);
        if (afterNew) {
            PsiExpression expr2 = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)insertedElement, PsiExpression.class, (boolean)true);
            for (ExpectedTypeInfo info : ExpectedTypesProvider.getExpectedTypes(expr2, true)) {
                PsiClass defClass;
                PsiType defaultType;
                PsiType type2 = info.getType();
                PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
                if (psiClass != null && psiClass.getName() != null) {
                    consumer.consume((Object)JavaClassNameCompletionContributor.createClassLookupItem(psiClass, inJavaContext));
                }
                if ((defaultType = info.getDefaultType()).equals(type2) || (defClass = PsiUtil.resolveClassInType((PsiType)defaultType)) == null || defClass.getName() == null) continue;
                consumer.consume((Object)JavaClassNameCompletionContributor.createClassLookupItem(defClass, true));
            }
        }
        boolean pkgContext = JavaCompletionUtil.inSomePackage(insertedElement);
        AllClassesGetter.processJavaClasses(parameters2, matcher, filterByScope, (Consumer<? super PsiClass>)new Consumer<PsiClass>((ElementFilter)filter, insertedElement, inJavaContext, consumer, filterByScope, pkgContext, afterNew, matcher){
            final /* synthetic */ ElementFilter val$filter;
            final /* synthetic */ PsiElement val$insertedElement;
            final /* synthetic */ boolean val$inJavaContext;
            final /* synthetic */ Consumer val$consumer;
            final /* synthetic */ boolean val$filterByScope;
            final /* synthetic */ boolean val$pkgContext;
            final /* synthetic */ boolean val$afterNew;
            final /* synthetic */ PrefixMatcher val$matcher;
            {
                this.val$filter = elementFilter;
                this.val$insertedElement = psiElement;
                this.val$inJavaContext = bl;
                this.val$consumer = consumer;
                this.val$filterByScope = bl2;
                this.val$pkgContext = bl3;
                this.val$afterNew = bl4;
                this.val$matcher = prefixMatcher;
            }

            public void consume(PsiClass psiClass) {
                this.processClass(psiClass, null, "");
            }

            private void processClass(PsiClass psiClass, @Nullable Set<? super PsiClass> visited, String prefix) {
                block7: {
                    PsiClass[] innerClasses;
                    block6: {
                        boolean isInnerClass = StringUtil.isNotEmpty((String)prefix);
                        if (isInnerClass && this.isProcessedIndependently(psiClass)) {
                            return;
                        }
                        if (!this.val$filter.isAcceptable((Object)psiClass, this.val$insertedElement)) break block6;
                        if (!this.val$inJavaContext) {
                            JavaPsiClassReferenceElement element = AllClassesGetter.createLookupItem(psiClass, AllClassesGetter.TRY_SHORTENING);
                            element.setLookupString(prefix + element.getLookupString());
                            this.val$consumer.consume((Object)element);
                        } else {
                            Condition condition2 = eachClass -> this.val$filter.isAcceptable(eachClass, this.val$insertedElement) && AllClassesGetter.isAcceptableInContext(this.val$insertedElement, eachClass, this.val$filterByScope, this.val$pkgContext);
                            for (JavaPsiClassReferenceElement element : JavaClassNameCompletionContributor.createClassLookupItems(psiClass, this.val$afterNew, JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER, (Condition<? super PsiClass>)condition2)) {
                                element.setLookupString(prefix + element.getLookupString());
                                JavaConstructorCallElement.wrap(element, this.val$insertedElement).forEach(e -> this.val$consumer.consume((Object)JavaCompletionUtil.highlightIfNeeded(null, e, e.getObject(), this.val$insertedElement)));
                            }
                        }
                        break block7;
                    }
                    String name2 = psiClass.getName();
                    if (name2 == null || (innerClasses = psiClass.getInnerClasses()).length <= 0) break block7;
                    if (visited == null) {
                        visited = new HashSet<PsiClass>();
                    }
                    for (PsiClass innerClass : innerClasses) {
                        if (!visited.add((PsiClass)innerClass)) continue;
                        this.processClass(innerClass, visited, prefix + name2 + ".");
                    }
                }
            }

            private boolean isProcessedIndependently(PsiClass psiClass) {
                String innerName = psiClass.getName();
                return innerName != null && this.val$matcher.prefixMatches(innerName);
            }
        });
    }

    @NotNull
    private static MultiMap<String, PsiClass> getAllAnnotationClasses(PsiElement context, PrefixMatcher matcher) {
        MultiMap map2 = new MultiMap();
        GlobalSearchScope scope = context.getResolveScope();
        PsiClass annotation = JavaPsiFacade.getInstance((Project)context.getProject()).findClass("java.lang.annotation.Annotation", scope);
        if (annotation != null) {
            DirectClassInheritorsSearch.search((PsiClass)annotation, (SearchScope)scope, (boolean)false).forEach(psiClass -> {
                if (!psiClass.isAnnotationType() || psiClass.getQualifiedName() == null) {
                    return true;
                }
                String name2 = Objects.requireNonNull(psiClass.getName());
                if (!matcher.prefixMatches(name2) && !matcher.prefixMatches(name2 = JavaClassNameCompletionContributor.getClassNameWithContainers(psiClass))) {
                    return true;
                }
                map2.putValue((Object)name2, psiClass);
                return true;
            });
        }
        return map2;
    }

    @NotNull
    private static String getClassNameWithContainers(@NotNull PsiClass psiClass) {
        String name2 = Objects.requireNonNull(psiClass.getName());
        for (PsiClass parent : JBIterable.generate((Object)psiClass, PsiClass::getContainingClass)) {
            name2 = parent.getName() + "." + name2;
        }
        return name2;
    }

    public static JavaPsiClassReferenceElement createClassLookupItem(PsiClass psiClass, boolean inJavaContext) {
        return AllClassesGetter.createLookupItem(psiClass, inJavaContext ? JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER : AllClassesGetter.TRY_SHORTENING);
    }

    public static List<JavaPsiClassReferenceElement> createClassLookupItems(PsiClass psiClass, boolean withInners, InsertHandler<JavaPsiClassReferenceElement> insertHandler, Condition<? super PsiClass> condition2) {
        SmartList result = new SmartList();
        if (condition2.value((Object)psiClass)) {
            result.add(AllClassesGetter.createLookupItem(psiClass, insertHandler));
        }
        String name2 = psiClass.getName();
        if (withInners && name2 != null) {
            for (PsiClass inner : psiClass.getInnerClasses()) {
                if (!inner.hasModifierProperty("static")) continue;
                for (JavaPsiClassReferenceElement lookupInner : JavaClassNameCompletionContributor.createClassLookupItems(inner, true, insertHandler, condition2)) {
                    String forced = lookupInner.getForcedPresentableName();
                    String qualifiedName = name2 + "." + (forced != null ? forced : inner.getName());
                    lookupInner.setForcedPresentableName(qualifiedName);
                    lookupInner.setLookupString(qualifiedName);
                    result.add(lookupInner);
                }
            }
        }
        return result;
    }

    public String handleEmptyLookup(@NotNull CompletionParameters parameters2, Editor editor) {
        if (!(parameters2.getOriginalFile() instanceof PsiJavaFile)) {
            return null;
        }
        if (JavaClassNameCompletionContributor.shouldShowSecondSmartCompletionHint(parameters2)) {
            return LangBundle.message((String)"completion.no.suggestions", (Object[])new Object[0]) + "; " + StringUtil.decapitalize((String)JavaBundle.message((String)"completion.class.name.hint.2", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion")}));
        }
        return null;
    }

    private static boolean shouldShowSecondSmartCompletionHint(CompletionParameters parameters2) {
        return parameters2.getCompletionType() == CompletionType.BASIC && parameters2.getInvocationCount() == 2 && parameters2.getOriginalFile().getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }
}

