/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.annoPackages;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.annoPackages.AnnotationPackageSupport;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CheckerFrameworkSupport
implements AnnotationPackageSupport {
    private static final String DEFAULT_QUALIFIER = "org.checkerframework.framework.qual.DefaultQualifier";
    private static final String DEFAULT_QUALIFIERS = "org.checkerframework.framework.qual.DefaultQualifiers";

    CheckerFrameworkSupport() {
    }

    @Override
    @Nullable
    public NullabilityAnnotationInfo getNullabilityByContainerAnnotation(@NotNull PsiAnnotation anno, // Could not load outer class - annotation placement on inner may be incorrect
    PsiAnnotation.TargetType @NotNull [] types, boolean superPackage) {
        String qName = anno.getQualifiedName();
        if (DEFAULT_QUALIFIER.equals(qName)) {
            PsiClass valueClass;
            PsiAnnotationMemberValue value2 = anno.findAttributeValue("value");
            if (value2 instanceof PsiClassObjectAccessExpression && CheckerFrameworkSupport.hasAppropriateTarget(types, anno.findAttributeValue("locations")) && (valueClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiClassObjectAccessExpression)value2).getOperand().getType())) != null) {
                NullableNotNullManager instance = NullableNotNullManager.getInstance((Project)value2.getProject());
                if (instance.getNullables().contains(valueClass.getQualifiedName())) {
                    return new NullabilityAnnotationInfo(anno, Nullability.NULLABLE, true);
                }
                if (instance.getNotNulls().contains(valueClass.getQualifiedName())) {
                    return new NullabilityAnnotationInfo(anno, Nullability.NOT_NULL, true);
                }
            }
            return null;
        }
        if (DEFAULT_QUALIFIERS.equals(qName)) {
            PsiAnnotationMemberValue value3 = anno.findAttributeValue("value");
            for (PsiAnnotationMemberValue initializer : AnnotationUtil.arrayAttributeValues((PsiAnnotationMemberValue)value3)) {
                NullabilityAnnotationInfo result;
                if (!(initializer instanceof PsiAnnotation) || (result = this.getNullabilityByContainerAnnotation((PsiAnnotation)initializer, types, superPackage)) == null) continue;
                return result;
            }
        }
        return null;
    }

    private static boolean hasAppropriateTarget(PsiAnnotation.TargetType[] types, PsiAnnotationMemberValue locations) {
        Set locationNames = ContainerUtil.map2SetNotNull((Collection)AnnotationUtil.arrayAttributeValues((PsiAnnotationMemberValue)locations), l -> l instanceof PsiReferenceExpression ? ((PsiReferenceExpression)l).getReferenceName() : null);
        if (locationNames.contains("ALL")) {
            return true;
        }
        for (PsiAnnotation.TargetType type2 : types) {
            if (type2 == PsiAnnotation.TargetType.FIELD) {
                return locationNames.contains("FIELD");
            }
            if (type2 == PsiAnnotation.TargetType.METHOD) {
                return locationNames.contains("RETURN");
            }
            if (type2 == PsiAnnotation.TargetType.PARAMETER) {
                return locationNames.contains("PARAMETER");
            }
            if (type2 != PsiAnnotation.TargetType.LOCAL_VARIABLE) continue;
            return locationNames.contains("LOCAL_VARIABLE");
        }
        return false;
    }

    @Override
    @NotNull
    public List<String> getNullabilityAnnotations(@NotNull Nullability nullability) {
        switch (nullability) {
            case NOT_NULL: {
                return Arrays.asList("org.checkerframework.checker.nullness.qual.NonNull", "org.checkerframework.checker.nullness.compatqual.NonNullDecl", "org.checkerframework.checker.nullness.compatqual.NonNullType");
            }
            case NULLABLE: {
                return Arrays.asList("org.checkerframework.checker.nullness.qual.Nullable", "org.checkerframework.checker.nullness.compatqual.NullableDecl", "org.checkerframework.checker.nullness.compatqual.NullableType");
            }
        }
        return Collections.singletonList("org.checkerframework.checker.nullness.qual.MonotonicNonNull");
    }
}

