/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class TestFrameworksImpl
extends TestFrameworks {
    private TestFrameworksImpl() {
    }

    public boolean isTestClass(PsiClass psiClass) {
        for (TestFramework framework : TestFramework.EXTENSION_NAME.getExtensionList()) {
            if (!framework.isTestClass((PsiElement)psiClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isPotentialTestClass(PsiClass psiClass) {
        for (TestFramework framework : TestFramework.EXTENSION_NAME.getExtensionList()) {
            if (!framework.isPotentialTestClass((PsiElement)psiClass)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PsiMethod findOrCreateSetUpMethod(PsiClass psiClass) {
        for (TestFramework framework : TestFramework.EXTENSION_NAME.getExtensionList()) {
            if (!framework.isTestClass((PsiElement)psiClass)) continue;
            try {
                PsiMethod setUpMethod = (PsiMethod)framework.findOrCreateSetUpMethod((PsiElement)psiClass);
                if (setUpMethod == null) continue;
                return setUpMethod;
            }
            catch (IncorrectOperationException incorrectOperationException) {
            }
        }
        return null;
    }

    @Nullable
    public PsiMethod findSetUpMethod(PsiClass psiClass) {
        for (TestFramework framework : TestFramework.EXTENSION_NAME.getExtensionList()) {
            PsiMethod setUpMethod;
            if (!framework.isTestClass((PsiElement)psiClass) || (setUpMethod = (PsiMethod)framework.findSetUpMethod((PsiElement)psiClass)) == null) continue;
            return setUpMethod;
        }
        return null;
    }

    @Nullable
    public PsiMethod findTearDownMethod(PsiClass psiClass) {
        for (TestFramework framework : TestFramework.EXTENSION_NAME.getExtensionList()) {
            PsiMethod setUpMethod;
            if (!framework.isTestClass((PsiElement)psiClass) || (setUpMethod = (PsiMethod)framework.findTearDownMethod((PsiElement)psiClass)) == null) continue;
            return setUpMethod;
        }
        return null;
    }

    protected boolean hasConfigMethods(PsiClass psiClass) {
        for (TestFramework framework : TestFramework.EXTENSION_NAME.getExtensionList()) {
            if (framework.findSetUpMethod((PsiElement)psiClass) == null && framework.findTearDownMethod((PsiElement)psiClass) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isTestMethod(PsiMethod method) {
        for (TestFramework framework : TestFramework.EXTENSION_NAME.getExtensionList()) {
            if (!framework.isTestMethod((PsiElement)method)) continue;
            return true;
        }
        return false;
    }

    public boolean isTestMethod(PsiMethod method, boolean checkAbstract) {
        for (TestFramework framework : TestFramework.EXTENSION_NAME.getExtensionList()) {
            if (!framework.isTestMethod((PsiElement)method, checkAbstract)) continue;
            return true;
        }
        return false;
    }
}

