/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.ExternalAnnotationsManagerImpl;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.MakeExternalAnnotationExplicit;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MakeAnnotationExternal
extends BaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.text.annotate.externally", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiModifierListOwner modifierListOwner;
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PsiAnnotation.class);
        if (annotation != null && annotation.getQualifiedName() != null && annotation.getManager().isInProject((PsiElement)annotation) && (modifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class)) != null && ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(modifierListOwner)) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)modifierListOwner);
            if (JavaCodeStyleSettings.getInstance((PsiFile)file).USE_EXTERNAL_ANNOTATIONS || virtualFile != null && ExternalAnnotationsManager.getInstance((Project)project).hasAnnotationRootsForFile(virtualFile)) {
                this.setText(JavaBundle.message((String)"intention.text.annotate.externally", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiAnnotation.class);
        assert (annotation != null);
        PsiModifierListOwner owner2 = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class);
        assert (owner2 != null);
        ExternalAnnotationsManager externalAnnotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(MakeExternalAnnotationExplicit.getFilesToWrite(file, owner2, externalAnnotationsManager))) {
            return;
        }
        String qualifiedName = annotation.getQualifiedName();
        assert (qualifiedName != null);
        try {
            externalAnnotationsManager.annotateExternally(owner2, qualifiedName, file, annotation.getParameterList().getAttributes());
        }
        catch (ExternalAnnotationsManager.CanceledConfigurationException e) {
            return;
        }
        WriteAction.run(() -> ((PsiAnnotation)annotation).delete());
    }

    public boolean startInWriteAction() {
        return false;
    }
}

