/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.ExpectedTypeUtil;
import com.intellij.codeInsight.FunctionalInterfaceSuggester;
import com.intellij.codeInsight.HardcodedDefaultTypesKt;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.CompletionMemory;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInsight.hints.ParameterHintsPass;
import com.intellij.codeInsight.lookup.CommaTailType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.resolve.CompletionParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypesProvider {
    private static final ExpectedTypeInfo VOID_EXPECTED = ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.VOID, 1, (PsiType)PsiType.VOID, TailType.SEMICOLON);
    private static final Logger LOG = Logger.getInstance(ExpectedTypesProvider.class);
    private static final int MAX_COUNT = 50;
    private static final ExpectedClassProvider ourGlobalScopeClassProvider = new ExpectedClassProvider(){

        @Override
        public PsiField @NotNull [] findDeclaredFields(@NotNull PsiManager manager, @NotNull String name2) {
            PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)manager.getProject());
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)manager.getProject());
            return cache.getFieldsByName(name2, scope);
        }

        @Override
        public PsiMethod @NotNull [] findDeclaredMethods(@NotNull PsiManager manager, @NotNull String name2) {
            Project project = manager.getProject();
            PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project);
            GlobalSearchScope sources = GlobalSearchScope.projectScope((Project)project);
            GlobalSearchScope libraries2 = GlobalSearchScope.notScope((GlobalSearchScope)sources);
            Object[] sourceMethods = cache.getMethodsByNameIfNotMoreThan(name2, sources, 50);
            if (sourceMethods.length >= 50) {
                return sourceMethods;
            }
            Object[] libraryMethods = cache.getMethodsByNameIfNotMoreThan(name2, libraries2, 50 - sourceMethods.length);
            return (PsiMethod[])ArrayUtil.mergeArrays((Object[])sourceMethods, (Object[])libraryMethods);
        }
    };
    private static final PsiType[] PRIMITIVE_TYPES = new PsiType[]{PsiType.BYTE, PsiType.CHAR, PsiType.SHORT, PsiType.INT, PsiType.LONG, PsiType.FLOAT, PsiType.DOUBLE};

    public static ExpectedTypesProvider getInstance(@NotNull Project project) {
        return (ExpectedTypesProvider)ServiceManager.getService((Project)project, ExpectedTypesProvider.class);
    }

    @NotNull
    public static ExpectedTypeInfo createInfo(@NotNull PsiType type2, @ExpectedTypeInfo.Type int kind2, PsiType defaultType, @NotNull TailType tailType) {
        return ExpectedTypesProvider.createInfoImpl(type2, kind2, defaultType, tailType);
    }

    @NotNull
    private static ExpectedTypeInfoImpl createInfoImpl(@NotNull PsiType type2, PsiType defaultType) {
        return ExpectedTypesProvider.createInfoImpl(type2, 1, defaultType, TailType.NONE);
    }

    @NotNull
    private static ExpectedTypeInfoImpl createInfoImpl(@NotNull PsiType type2, @ExpectedTypeInfo.Type int kind2, PsiType defaultType, @NotNull TailType tailType) {
        return new ExpectedTypeInfoImpl(type2, kind2, defaultType, tailType, null, ExpectedTypeInfoImpl.NULL);
    }

    @NotNull
    private static ExpectedTypeInfoImpl createInfoImpl(@NotNull PsiType type2, int kind2, PsiType defaultType, @NotNull TailType tailType, PsiMethod calledMethod, NullableComputable<String> expectedName) {
        return new ExpectedTypeInfoImpl(type2, kind2, defaultType, tailType, calledMethod, expectedName);
    }

    @Nullable
    public static ExpectedTypeInfo getSingleExpectedTypeForCompletion(@Nullable PsiExpression expr2) {
        ExpectedTypeInfo[] expectedTypes = ExpectedTypesProvider.getExpectedTypes(expr2, true, ourGlobalScopeClassProvider, false, false, 1);
        if (expectedTypes.length > 0) {
            return expectedTypes[0];
        }
        return null;
    }

    public static ExpectedTypeInfo @NotNull [] getExpectedTypes(@Nullable PsiExpression expr2, boolean forCompletion) {
        return ExpectedTypesProvider.getExpectedTypes(expr2, forCompletion, false, false);
    }

    public static ExpectedTypeInfo @NotNull [] getExpectedTypes(@Nullable PsiExpression expr2, boolean forCompletion, boolean voidable, boolean usedAfter) {
        return ExpectedTypesProvider.getExpectedTypes(expr2, forCompletion, ourGlobalScopeClassProvider, voidable, usedAfter);
    }

    public static ExpectedTypeInfo @NotNull [] getExpectedTypes(@Nullable PsiExpression expr2, boolean forCompletion, ExpectedClassProvider classProvider, boolean usedAfter) {
        return ExpectedTypesProvider.getExpectedTypes(expr2, forCompletion, classProvider, false, usedAfter);
    }

    public static ExpectedTypeInfo @NotNull [] getExpectedTypes(@Nullable PsiExpression expr2, boolean forCompletion, ExpectedClassProvider classProvider, boolean voidable, boolean usedAfter) {
        return ExpectedTypesProvider.getExpectedTypes(expr2, forCompletion, classProvider, voidable, usedAfter, Integer.MAX_VALUE);
    }

    private static ExpectedTypeInfo @NotNull [] getExpectedTypes(@Nullable PsiExpression expr2, boolean forCompletion, ExpectedClassProvider classProvider, boolean voidable, boolean usedAfter, int maxCandidates) {
        if (expr2 == null) {
            return ExpectedTypeInfo.EMPTY_ARRAY;
        }
        PsiElement parent = expr2.getParent();
        PsiFunctionalExpression functionalExpression = ExpectedTypesProvider.extractFunctionalExpression(expr2);
        if (functionalExpression != null) {
            Collection<? extends PsiType> types = FunctionalInterfaceSuggester.suggestFunctionalInterfaces(functionalExpression);
            if (types.isEmpty()) {
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            ExpectedTypeInfo[] result = new ExpectedTypeInfo[types.size()];
            int i = 0;
            for (PsiType psiType : types) {
                result[i++] = new ExpectedTypeInfoImpl(psiType, 4, psiType, TailType.NONE, null, ExpectedTypeInfoImpl.NULL);
            }
            return result;
        }
        MyParentVisitor visitor2 = new MyParentVisitor(expr2, forCompletion, classProvider, voidable, usedAfter, maxCandidates);
        if (parent != null) {
            parent.accept((PsiElementVisitor)visitor2);
        }
        return visitor2.getResult();
    }

    private static PsiFunctionalExpression extractFunctionalExpression(PsiExpression expr2) {
        PsiElement parent = expr2.getParent();
        if (expr2 instanceof PsiFunctionalExpression && parent instanceof PsiExpressionStatement && !(parent.getParent() instanceof PsiSwitchLabeledRuleStatement)) {
            return (PsiFunctionalExpression)expr2;
        }
        parent = PsiTreeUtil.skipParentsOfType((PsiElement)expr2, (Class[])new Class[]{PsiParenthesizedExpression.class});
        if (parent instanceof PsiAssignmentExpression && parent.getParent() instanceof PsiExpressionStatement && PsiTreeUtil.isAncestor((PsiElement)((PsiAssignmentExpression)parent).getLExpression(), (PsiElement)expr2, (boolean)false)) {
            return (PsiFunctionalExpression)ObjectUtils.tryCast((Object)((PsiAssignmentExpression)parent).getRExpression(), PsiFunctionalExpression.class);
        }
        return null;
    }

    public static PsiType @NotNull [] processExpectedTypes(ExpectedTypeInfo @NotNull [] infos, @NotNull PsiTypeVisitor<? extends PsiType> visitor2, @NotNull Project project) {
        LinkedHashSet set = new LinkedHashSet();
        for (ExpectedTypeInfo info : infos) {
            ExpectedTypeInfoImpl infoImpl = (ExpectedTypeInfoImpl)info;
            if (infoImpl.getDefaultType() instanceof PsiClassType) {
                PsiClassType.ClassResolveResult result = ((PsiClassType)infoImpl.getDefaultType()).resolveGenerics();
                PsiClass aClass = (PsiClass)result.getElement();
                if (aClass instanceof PsiAnonymousClass) {
                    ExpectedTypesProvider.processType((PsiType)((PsiAnonymousClass)aClass).getBaseClassType(), visitor2, set);
                    ((PsiAnonymousClass)aClass).getBaseClassType().accept(visitor2);
                } else {
                    ExpectedTypesProvider.processType(infoImpl.getDefaultType(), visitor2, set);
                }
            } else {
                ExpectedTypesProvider.processType(infoImpl.getDefaultType(), visitor2, set);
            }
            if (infoImpl.getKind() == 2) {
                ExpectedTypesProvider.processAllSuperTypes(infoImpl.getType(), visitor2, project, set, new HashSet());
                continue;
            }
            if (infoImpl.getKind() != 1 || !(infoImpl.getType() instanceof PsiPrimitiveType)) continue;
            ExpectedTypesProvider.processPrimitiveTypeAndSubtypes((PsiPrimitiveType)infoImpl.getType(), visitor2, set);
        }
        return set.toArray(PsiType.createArray((int)set.size()));
    }

    private static void processType(@NotNull PsiType type2, @NotNull PsiTypeVisitor<? extends PsiType> visitor2, @NotNull Set<? super PsiType> typeSet) {
        PsiType accepted = (PsiType)type2.accept(visitor2);
        if (accepted != null) {
            typeSet.add((PsiType)accepted);
        }
    }

    private static void processPrimitiveTypeAndSubtypes(@NotNull PsiPrimitiveType type2, @NotNull PsiTypeVisitor<? extends PsiType> visitor2, @NotNull Set<? super PsiType> set) {
        if (type2.equals((Object)PsiType.BOOLEAN) || type2.equals((Object)PsiType.VOID) || type2.equals((Object)PsiType.NULL)) {
            return;
        }
        int i = 0;
        while (true) {
            PsiType primitive = PRIMITIVE_TYPES[i];
            ExpectedTypesProvider.processType(primitive, visitor2, set);
            if (primitive.equals(type2)) {
                return;
            }
            ++i;
        }
    }

    public static void processAllSuperTypes(@NotNull PsiType type2, @NotNull PsiTypeVisitor<? extends PsiType> visitor2, @NotNull Project project, @NotNull Set<? super PsiType> set, @NotNull Set<? super PsiType> visited) {
        block7: {
            block6: {
                if (!visited.add((PsiType)type2)) {
                    return;
                }
                if (!(type2 instanceof PsiPrimitiveType)) break block6;
                if (type2.equals(PsiType.BOOLEAN) || type2.equals(PsiType.VOID) || type2.equals(PsiType.NULL)) {
                    return;
                }
                Stack stack = new Stack();
                int i = PRIMITIVE_TYPES.length - 1;
                while (!PRIMITIVE_TYPES[i].equals(type2)) {
                    stack.push((Object)PRIMITIVE_TYPES[i]);
                    --i;
                }
                while (!stack.empty()) {
                    ExpectedTypesProvider.processType((PsiType)stack.pop(), visitor2, set);
                }
                break block7;
            }
            PsiManager manager = PsiManager.getInstance((Project)project);
            GlobalSearchScope resolveScope = type2.getResolveScope();
            if (resolveScope == null) {
                resolveScope = GlobalSearchScope.allScope((Project)project);
            }
            PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)resolveScope);
            ExpectedTypesProvider.processType((PsiType)objectType, visitor2, set);
            if (!(type2 instanceof PsiClassType)) break block7;
            for (PsiType superType : type2.getSuperTypes()) {
                ExpectedTypesProvider.processType(superType, visitor2, set);
                ExpectedTypesProvider.processAllSuperTypes(superType, visitor2, project, set, visited);
            }
        }
    }

    @NotNull
    public static TailType getFinalCallParameterTailType(@NotNull PsiElement call, @Nullable PsiType returnType, @NotNull PsiMethod method) {
        boolean statementContext;
        if (method.isConstructor() && call instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)call).getMethodExpression() instanceof PsiSuperExpression) {
            return TailTypes.CALL_RPARENTH_SEMICOLON;
        }
        boolean chainable = !PsiType.VOID.equals((Object)returnType) && returnType != null || method.isConstructor() && call instanceof PsiNewExpression;
        PsiElement parent = call.getParent();
        boolean bl = statementContext = parent instanceof PsiExpressionStatement || parent instanceof PsiVariable || parent instanceof PsiCodeBlock;
        if (parent instanceof PsiThrowStatement || statementContext && !chainable) {
            return TailTypes.CALL_RPARENTH_SEMICOLON;
        }
        return TailTypes.CALL_RPARENTH;
    }

    private static class CommaTailTypeWithSyncHintUpdate
    extends TailType {
        private final PsiCall myOriginalCall;

        private CommaTailTypeWithSyncHintUpdate(@NotNull PsiCall originalCall) {
            this.myOriginalCall = originalCall;
        }

        public boolean isApplicable(@NotNull InsertionContext context) {
            return CommaTailType.INSTANCE.isApplicable(context);
        }

        public int processTail(Editor editor, int tailOffset) {
            int result = CommaTailType.INSTANCE.processTail(editor, tailOffset);
            if (this.myOriginalCall.isValid()) {
                PsiDocumentManager.getInstance((Project)this.myOriginalCall.getProject()).commitDocument(editor.getDocument());
                if (this.myOriginalCall.isValid()) {
                    ParameterHintsPass.syncUpdate((PsiElement)this.myOriginalCall, (Editor)editor);
                }
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            CommaTailTypeWithSyncHintUpdate update2 = (CommaTailTypeWithSyncHintUpdate)((Object)o);
            return this.myOriginalCall.equals(update2.myOriginalCall);
        }

        public int hashCode() {
            return Objects.hash(this.myOriginalCall);
        }
    }

    public static interface ExpectedClassProvider {
        public PsiField @NotNull [] findDeclaredFields(@NotNull PsiManager var1, @NotNull String var2);

        public PsiMethod @NotNull [] findDeclaredMethods(@NotNull PsiManager var1, @NotNull String var2);
    }

    private static class MyParentVisitor
    extends JavaElementVisitor {
        private PsiExpression myExpr;
        private final boolean myForCompletion;
        private final boolean myUsedAfter;
        private final int myMaxCandidates;
        private final ExpectedClassProvider myClassProvider;
        private final boolean myVoidable;
        final List<ExpectedTypeInfo> myResult = new ArrayList<ExpectedTypeInfo>();
        @NonNls
        private static final String LENGTH_SYNTHETIC_ARRAY_FIELD = "length";

        private MyParentVisitor(PsiExpression expr2, boolean forCompletion, ExpectedClassProvider classProvider, boolean voidable, boolean usedAfter, int maxCandidates) {
            this.myExpr = expr2;
            this.myForCompletion = forCompletion;
            this.myClassProvider = classProvider;
            this.myVoidable = voidable;
            this.myUsedAfter = usedAfter;
            this.myMaxCandidates = maxCandidates;
        }

        public ExpectedTypeInfo @NotNull [] getResult() {
            if (this.myResult.size() > this.myMaxCandidates) {
                return this.myResult.subList(0, this.myMaxCandidates).toArray(ExpectedTypeInfo.EMPTY_ARRAY);
            }
            return this.myResult.toArray(ExpectedTypeInfo.EMPTY_ARRAY);
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
            PsiElement parent = expression2.getParent();
            if (parent != null) {
                MyParentVisitor visitor2 = new MyParentVisitor((PsiExpression)expression2, this.myForCompletion, this.myClassProvider, this.myVoidable, this.myUsedAfter, this.myMaxCandidates);
                parent.accept((PsiElementVisitor)visitor2);
                for (ExpectedTypeInfo info : visitor2.myResult) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl(info.getType(), info.getKind(), info.getDefaultType(), TailTypes.RPARENTH, info.getCalledMethod(), (NullableComputable<String>)((ExpectedTypeInfoImpl)info)::getExpectedName));
                }
            }
        }

        public void visitAnnotationMethod(@NotNull PsiAnnotationMethod method) {
            PsiType type2;
            if (this.myExpr == method.getDefaultValue() && (type2 = method.getReturnType()) != null) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type2, 1, type2, TailType.SEMICOLON));
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            if (this.myForCompletion) {
                MyParentVisitor visitor2 = new MyParentVisitor((PsiExpression)expression2, true, this.myClassProvider, this.myVoidable, this.myUsedAfter, this.myMaxCandidates);
                expression2.getParent().accept((PsiElementVisitor)visitor2);
                this.myResult.addAll(visitor2.myResult);
                return;
            }
            String referenceName = expression2.getReferenceName();
            if (referenceName != null) {
                PsiElement parent = expression2.getParent();
                if (parent instanceof PsiMethodCallExpression) {
                    Collections.addAll(this.myResult, this.findClassesWithDeclaredMethod((PsiMethodCallExpression)parent));
                } else if (parent instanceof PsiVariable || parent instanceof PsiExpression) {
                    if (LENGTH_SYNTHETIC_ARRAY_FIELD.equals(referenceName)) {
                        this.myResult.addAll(this.anyArrayType());
                    } else {
                        Collections.addAll(this.myResult, this.findClassesWithDeclaredField(expression2));
                    }
                }
            }
        }

        public void visitExpressionStatement(PsiExpressionStatement statement) {
            PsiSwitchBlock block;
            if (statement.getParent() instanceof PsiSwitchLabeledRuleStatement && (block = ((PsiSwitchLabeledRuleStatement)statement.getParent()).getEnclosingSwitchBlock()) instanceof PsiSwitchExpression) {
                Collections.addAll(this.myResult, ExpectedTypesProvider.getExpectedTypes((PsiExpression)block, this.myForCompletion));
                return;
            }
            if (this.myVoidable) {
                this.myResult.add(VOID_EXPECTED);
            }
        }

        public void visitYieldStatement(PsiYieldStatement statement) {
            PsiSwitchExpression expression2 = statement.findEnclosingExpression();
            if (expression2 != null) {
                Collections.addAll(this.myResult, ExpectedTypesProvider.getExpectedTypes((PsiExpression)expression2, this.myForCompletion));
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            this.myExpr = (PsiExpression)this.myExpr.getParent();
            expression2.getParent().accept((PsiElementVisitor)this);
        }

        public void visitAnnotationArrayInitializer(@NotNull PsiArrayInitializerMemberValue initializer) {
            PsiElement parent = initializer.getParent();
            while (parent instanceof PsiArrayInitializerMemberValue) {
                parent = parent.getParent();
            }
            PsiType type2 = parent instanceof PsiNameValuePair ? MyParentVisitor.getAnnotationMethodType((PsiNameValuePair)parent) : ((PsiAnnotationMethod)parent).getReturnType();
            if (type2 instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)type2).getComponentType();
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(componentType, componentType));
            }
        }

        public void visitNameValuePair(@NotNull PsiNameValuePair pair2) {
            PsiType type2 = MyParentVisitor.getAnnotationMethodType(pair2);
            if (type2 == null) {
                return;
            }
            if (type2 instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)type2).getComponentType();
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(componentType, componentType));
            } else {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type2, type2));
            }
        }

        @Nullable
        private static PsiType getAnnotationMethodType(@NotNull PsiNameValuePair pair2) {
            PsiElement method;
            PsiReference reference = pair2.getReference();
            if (reference != null && (method = reference.resolve()) instanceof PsiMethod) {
                return ((PsiMethod)method).getReturnType();
            }
            return null;
        }

        public void visitLambdaExpression(PsiLambdaExpression lambdaExpression) {
            super.visitLambdaExpression(lambdaExpression);
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            PsiMethod scopeMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
            if (scopeMethod != null) {
                this.visitMethodReturnType(scopeMethod, LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType), LambdaHighlightingUtil.insertSemicolonAfter(lambdaExpression));
            }
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            boolean tailTypeSemicolon;
            PsiType type2;
            PsiMethod method;
            NavigatablePsiElement psiElement = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethod.class});
            if (psiElement instanceof PsiLambdaExpression) {
                PsiType functionalInterfaceType = ((PsiLambdaExpression)psiElement).getFunctionalInterfaceType();
                method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
                type2 = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
                tailTypeSemicolon = LambdaHighlightingUtil.insertSemicolonAfter((PsiLambdaExpression)psiElement);
            } else if (psiElement instanceof PsiMethod) {
                method = (PsiMethod)psiElement;
                type2 = method.getReturnType();
                tailTypeSemicolon = true;
            } else {
                method = null;
                type2 = null;
                tailTypeSemicolon = true;
            }
            if (method != null) {
                this.visitMethodReturnType(method, type2, tailTypeSemicolon);
            }
        }

        private void visitMethodReturnType(PsiMethod scopeMethod, PsiType type2, boolean tailTypeSemicolon) {
            if (type2 != null) {
                NullableComputable expectedName = PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)scopeMethod) ? () -> PropertyUtilBase.getPropertyName((PsiMethod)scopeMethod) : ExpectedTypeInfoImpl.NULL;
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type2, 1, type2, tailTypeSemicolon ? TailType.SEMICOLON : TailType.NONE, null, (NullableComputable<String>)expectedName));
            }
        }

        public void visitIfStatement(PsiIfStatement statement) {
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailTypes.IF_RPARENTH));
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailTypes.WHILE_RPARENTH));
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailTypes.WHILE_RPARENTH));
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (this.myExpr.equals(statement.getCondition())) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.SEMICOLON));
            }
        }

        public void visitAssertStatement(@NotNull PsiAssertStatement statement) {
            if (statement.getAssertDescription() == this.myExpr) {
                PsiClassType stringType = PsiType.getJavaLangString((PsiManager)this.myExpr.getManager(), (GlobalSearchScope)this.myExpr.getResolveScope());
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)stringType, 0, (PsiType)stringType, TailType.SEMICOLON));
            } else {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.SEMICOLON));
            }
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (this.myExpr.equals(statement.getIteratedValue())) {
                PsiType type2 = statement.getIterationParameter().getType();
                if (PsiType.NULL.equals((Object)type2)) {
                    return;
                }
                PsiArrayType arrayType = type2.createArrayType();
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)arrayType, (PsiType)arrayType));
                PsiManager manager = statement.getManager();
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
                PsiClass iterableClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Iterable", statement.getResolveScope());
                if (iterableClass != null && iterableClass.getTypeParameters().length == 1) {
                    HashMap<PsiTypeParameter, PsiWildcardType> map2 = new HashMap<PsiTypeParameter, PsiWildcardType>();
                    map2.put(iterableClass.getTypeParameters()[0], PsiWildcardType.createExtends((PsiManager)manager, (PsiType)type2));
                    PsiClassType iterableType = factory.createType(iterableClass, factory.createSubstitutor(map2));
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)iterableType, (PsiType)iterableType));
                }
            }
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            this.processSwitchBlock((PsiSwitchBlock)statement);
        }

        public void visitSwitchExpression(@NotNull PsiSwitchExpression expression2) {
            this.processSwitchBlock((PsiSwitchBlock)expression2);
        }

        public void processSwitchBlock(@NotNull PsiSwitchBlock statement) {
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, (PsiType)PsiType.INT));
            LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)statement);
            if (level.isAtLeast(LanguageLevel.JDK_1_5)) {
                PsiClassType enumType = TypeUtils.getType("java.lang.Enum", (PsiElement)statement);
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)enumType, (PsiType)enumType));
                if (level.isAtLeast(LanguageLevel.JDK_1_7)) {
                    PsiClassType stringType = TypeUtils.getStringType((PsiElement)statement);
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)stringType, (PsiType)stringType));
                }
            }
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)statement.getProject());
            PsiClassType objectType = factory.createTypeByFQClassName("java.lang.Object", this.myExpr.getResolveScope());
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)objectType, (PsiType)objectType));
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            PsiType type2 = variable.getType();
            TailType tail = variable instanceof PsiResourceVariable ? TailType.NONE : TailType.SEMICOLON;
            this.myResult.add(ExpectedTypesProvider.createInfoImpl(type2, 1, type2, tail, null, (NullableComputable<String>)MyParentVisitor.getPropertyName(variable)));
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (this.myExpr.equals(assignment.getRExpression())) {
                PsiExpression lExpr = assignment.getLExpression();
                PsiType type2 = lExpr.getType();
                if (type2 != null) {
                    PsiElement refElement;
                    TailType tailType = MyParentVisitor.getAssignmentRValueTailType(assignment);
                    NullableComputable<String> expectedName = ExpectedTypeInfoImpl.NULL;
                    if (lExpr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)lExpr).resolve()) instanceof PsiVariable) {
                        expectedName = MyParentVisitor.getPropertyName((PsiVariable)refElement);
                    }
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl(type2, 1, type2, tailType, null, (NullableComputable<String>)expectedName));
                }
            } else {
                PsiType type3;
                if (this.myForCompletion) {
                    this.myExpr = (PsiExpression)this.myExpr.getParent();
                    assignment.getParent().accept((PsiElementVisitor)this);
                    return;
                }
                PsiExpression rExpr = assignment.getRExpression();
                if (rExpr != null && (type3 = rExpr.getType()) != null && type3 != PsiType.NULL) {
                    PsiClass resolved;
                    if (type3 instanceof PsiClassType && (resolved = ((PsiClassType)type3).resolve()) instanceof PsiAnonymousClass) {
                        type3 = ((PsiAnonymousClass)resolved).getBaseClassType();
                    }
                    int kind2 = assignment.getOperationTokenType() != JavaTokenType.EQ ? 0 : 2;
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl(type3, kind2, type3, TailType.NONE));
                }
            }
        }

        @NotNull
        private static TailType getAssignmentRValueTailType(@NotNull PsiAssignmentExpression assignment) {
            if (assignment.getParent() instanceof PsiExpressionStatement) {
                if (!(assignment.getParent().getParent() instanceof PsiForStatement)) {
                    return TailType.SEMICOLON;
                }
                PsiForStatement forStatement = (PsiForStatement)assignment.getParent().getParent();
                if (!assignment.getParent().equals(forStatement.getUpdate())) {
                    return TailType.SEMICOLON;
                }
            }
            return TailType.NONE;
        }

        public void visitExpressionList(@NotNull PsiExpressionList list) {
            PsiType type2;
            PsiExpression expression2;
            PsiSwitchBlock switchBlock;
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)list.getProject()).getResolveHelper();
            PsiElement parent = list.getParent();
            if (parent instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
                CandidateInfo[] candidates = helper.getReferencedMethodCandidates((PsiCallExpression)methodCall, false, true);
                Collections.addAll(this.myResult, this.getExpectedArgumentTypesForMethodCall(candidates, list, this.myExpr, this.myForCompletion));
            } else if (parent instanceof PsiEnumConstant) {
                this.getExpectedArgumentsTypesForEnumConstant((PsiEnumConstant)parent, list);
            } else if (parent instanceof PsiNewExpression) {
                this.getExpectedArgumentsTypesForNewExpression((PsiNewExpression)parent, list);
            } else if (parent instanceof PsiAnonymousClass) {
                this.getExpectedArgumentsTypesForNewExpression((PsiNewExpression)parent.getParent(), list);
            } else if (parent instanceof PsiSwitchLabelStatementBase && (switchBlock = ((PsiSwitchLabelStatementBase)parent).getEnclosingSwitchBlock()) != null && (expression2 = switchBlock.getExpression()) != null && (type2 = expression2.getType()) != null) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type2, 1, type2, TailTypes.forSwitchLabel(switchBlock)));
            }
        }

        private void getExpectedArgumentsTypesForEnumConstant(@NotNull PsiEnumConstant enumConstant, @NotNull PsiExpressionList list) {
            PsiClass aClass = enumConstant.getContainingClass();
            if (aClass != null) {
                LOG.assertTrue(aClass.isEnum());
                this.getExpectedTypesForConstructorCall(aClass, list, PsiSubstitutor.EMPTY);
            }
        }

        private void getExpectedArgumentsTypesForNewExpression(@NotNull PsiNewExpression newExpr, @NotNull PsiExpressionList list) {
            if (PsiDiamondType.hasDiamond((PsiNewExpression)newExpr)) {
                List<CandidateInfo> candidates = PsiDiamondTypeImpl.collectStaticFactories(newExpr);
                if (candidates != null) {
                    PsiExpressionList argumentList = Objects.requireNonNull(newExpr.getArgumentList());
                    Collections.addAll(this.myResult, this.getExpectedArgumentTypesForMethodCall(candidates.toArray(CandidateInfo.EMPTY_ARRAY), argumentList, this.myExpr, this.myForCompletion));
                }
                return;
            }
            PsiType newType = newExpr.getType();
            if (newType instanceof PsiClassType) {
                PsiSubstitutor substitutor;
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)newType);
                PsiClass newClass = (PsiClass)resolveResult.getElement();
                if (newClass instanceof PsiAnonymousClass) {
                    PsiAnonymousClass anonymous = (PsiAnonymousClass)newClass;
                    if ((newClass = anonymous.getBaseClassType().resolve()) == null) {
                        return;
                    }
                    substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)newClass, (PsiClass)anonymous, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                } else if (newClass != null) {
                    substitutor = resolveResult.getSubstitutor();
                } else {
                    return;
                }
                this.getExpectedTypesForConstructorCall(newClass, list, substitutor);
            }
        }

        private void getExpectedTypesForConstructorCall(@NotNull PsiClass referencedClass, @NotNull PsiExpressionList argumentList, @NotNull PsiSubstitutor substitutor) {
            ArrayList<MethodCandidateInfo> array = new ArrayList<MethodCandidateInfo>();
            for (PsiMethod constructor : referencedClass.getConstructors()) {
                array.add(new MethodCandidateInfo((PsiElement)constructor, substitutor, false, false, (PsiElement)argumentList, null, argumentList.getExpressionTypes(), null));
            }
            CandidateInfo[] candidates = array.toArray(CandidateInfo.EMPTY_ARRAY);
            Collections.addAll(this.myResult, this.getExpectedArgumentTypesForMethodCall(candidates, argumentList, this.myExpr, this.myForCompletion));
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expr2) {
            PsiType anotherType;
            PsiExpression anotherExpr;
            PsiExpression[] operands2 = expr2.getOperands();
            int index = Arrays.asList(operands2).indexOf(this.myExpr);
            if (index < 0) {
                return;
            }
            IElementType op = expr2.getOperationTokenType();
            Object object = index > 0 ? operands2[0] : (anotherExpr = 1 < operands2.length ? operands2[1] : null);
            if (this.myForCompletion && index == 0) {
                if (op == JavaTokenType.EQEQ || op == JavaTokenType.NE) {
                    ContainerUtil.addIfNotNull(this.myResult, (Object)MyParentVisitor.getEqualsType(anotherExpr));
                }
                MyParentVisitor visitor2 = new MyParentVisitor((PsiExpression)expr2, true, this.myClassProvider, this.myVoidable, this.myUsedAfter, this.myMaxCandidates);
                this.myExpr = (PsiExpression)this.myExpr.getParent();
                expr2.getParent().accept((PsiElementVisitor)visitor2);
                this.myResult.addAll(visitor2.myResult);
                if (!(expr2.getParent() instanceof PsiExpressionList)) {
                    for (int i = 0; i < this.myResult.size(); ++i) {
                        ExpectedTypeInfo info = this.myResult.get(i);
                        this.myResult.set(i, ExpectedTypesProvider.createInfoImpl(info.getType(), info.getKind(), info.getDefaultType(), TailType.NONE, info.getCalledMethod(), (NullableComputable<String>)((ExpectedTypeInfoImpl)info)::getExpectedName));
                    }
                }
                return;
            }
            PsiType psiType = anotherType = anotherExpr != null ? anotherExpr.getType() : null;
            if (op == JavaTokenType.MINUS || op == JavaTokenType.ASTERISK || op == JavaTokenType.DIV || op == JavaTokenType.PERC || op == JavaTokenType.LT || op == JavaTokenType.GT || op == JavaTokenType.LE || op == JavaTokenType.GE) {
                if (anotherType != null) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, anotherType));
                }
            } else if (op == JavaTokenType.PLUS) {
                if (anotherType == null || anotherType.equalsToText("java.lang.String")) {
                    PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)expr2.getManager(), (GlobalSearchScope)expr2.getResolveScope());
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)objectType, (PsiType)(anotherType != null ? anotherType : objectType)));
                } else if (PsiType.DOUBLE.isAssignableFrom(anotherType)) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, anotherType));
                }
            } else if (op == JavaTokenType.EQEQ || op == JavaTokenType.NE) {
                ContainerUtil.addIfNotNull(this.myResult, (Object)MyParentVisitor.getEqualsType(anotherExpr));
            } else if (op == JavaTokenType.LTLT || op == JavaTokenType.GTGT || op == JavaTokenType.GTGTGT) {
                if (anotherType != null) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, 3, (PsiType)PsiType.SHORT, TailType.NONE));
                }
            } else if (op == JavaTokenType.OROR || op == JavaTokenType.ANDAND) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.NONE));
            } else if ((op == JavaTokenType.OR || op == JavaTokenType.XOR || op == JavaTokenType.AND) && anotherType != null) {
                ExpectedTypeInfoImpl info = PsiType.BOOLEAN.equals((Object)anotherType) ? ExpectedTypesProvider.createInfoImpl(anotherType, 0, anotherType, TailType.NONE) : ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, anotherType);
                this.myResult.add(info);
            }
        }

        @Nullable
        private static ExpectedTypeInfo getEqualsType(@Nullable PsiExpression anotherExpr) {
            ExpectedTypeInfoImpl info;
            PsiElement refElement;
            PsiType anotherType;
            PsiType psiType = anotherType = anotherExpr != null ? anotherExpr.getType() : null;
            if (anotherType == null) {
                return null;
            }
            NullableComputable<String> expectedName = ExpectedTypeInfoImpl.NULL;
            if (anotherExpr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)anotherExpr).resolve()) instanceof PsiVariable) {
                expectedName = MyParentVisitor.getPropertyName((PsiVariable)refElement);
            }
            if (anotherType instanceof PsiPrimitiveType) {
                if (PsiType.BOOLEAN.equals((Object)anotherType)) {
                    info = ExpectedTypesProvider.createInfoImpl(anotherType, 0, anotherType, TailType.NONE, null, (NullableComputable<String>)expectedName);
                } else if (PsiType.NULL.equals((Object)anotherType)) {
                    PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)anotherExpr.getManager(), (GlobalSearchScope)anotherExpr.getResolveScope());
                    info = ExpectedTypesProvider.createInfoImpl((PsiType)objectType, 1, (PsiType)objectType, TailType.NONE, null, (NullableComputable<String>)expectedName);
                } else {
                    info = ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, 1, anotherType, TailType.NONE, null, (NullableComputable<String>)expectedName);
                }
            } else {
                info = ExpectedTypesProvider.createInfoImpl(anotherType, 0, anotherType, TailType.NONE, null, (NullableComputable<String>)expectedName);
            }
            return info;
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expr2) {
            TailType tailType;
            IElementType i = expr2.getOperationTokenType();
            PsiType type2 = expr2.getType();
            PsiElement parent = expr2.getParent();
            TailType tailType2 = tailType = parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getRExpression() == expr2 ? MyParentVisitor.getAssignmentRValueTailType((PsiAssignmentExpression)parent) : TailType.NONE;
            if (i == JavaTokenType.PLUSPLUS || i == JavaTokenType.MINUSMINUS || i == JavaTokenType.TILDE) {
                ExpectedTypeInfoImpl info = this.myUsedAfter && type2 != null ? ExpectedTypesProvider.createInfoImpl(type2, 0, type2, tailType) : (type2 != null ? ExpectedTypesProvider.createInfoImpl(type2, type2 instanceof PsiPrimitiveType ? 2 : 1, (PsiType)PsiType.INT, tailType) : ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, 1, (PsiType)PsiType.INT, tailType));
                this.myResult.add(info);
            } else if (i == JavaTokenType.PLUS || i == JavaTokenType.MINUS) {
                if (parent instanceof PsiStatement) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, 1, (PsiType)PsiType.INT, tailType));
                } else {
                    this.myExpr = (PsiExpression)this.myExpr.getParent();
                    parent.accept((PsiElementVisitor)this);
                }
            } else if (i == JavaTokenType.EXCL) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, tailType));
            }
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression expr2) {
            if (this.myForCompletion) {
                return;
            }
            PsiType type2 = expr2.getType();
            ExpectedTypeInfoImpl info = this.myUsedAfter && type2 != null ? ExpectedTypesProvider.createInfoImpl(type2, 0, type2, TailType.NONE) : (type2 != null ? ExpectedTypesProvider.createInfoImpl(type2, type2 instanceof PsiPrimitiveType ? 2 : 1, (PsiType)PsiType.INT, TailType.NONE) : ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, (PsiType)PsiType.INT));
            this.myResult.add(info);
        }

        public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expr2) {
            PsiType type2;
            PsiElement pParent = expr2.getParent();
            PsiType arrayType = null;
            if (pParent instanceof PsiVariable) {
                arrayType = ((PsiVariable)pParent).getType();
            } else if (pParent instanceof PsiNewExpression) {
                arrayType = ((PsiNewExpression)pParent).getType();
            } else if (pParent instanceof PsiArrayInitializerExpression && (type2 = ((PsiArrayInitializerExpression)pParent).getType()) instanceof PsiArrayType) {
                arrayType = ((PsiArrayType)type2).getComponentType();
            }
            if (arrayType instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)arrayType).getComponentType();
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(componentType, componentType));
            }
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            PsiExpression[] arrayDimensions;
            for (PsiExpression dimension : arrayDimensions = expression2.getArrayDimensions()) {
                if (!this.myExpr.equals(dimension)) continue;
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.INT, (PsiType)PsiType.INT));
                return;
            }
        }

        public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expr2) {
            if (this.myExpr.equals(expr2.getIndexExpression())) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.INT, (PsiType)PsiType.INT));
            } else if (this.myExpr.equals(expr2.getArrayExpression())) {
                if (this.myForCompletion) {
                    this.myExpr = (PsiExpression)this.myExpr.getParent();
                    expr2.getParent().accept((PsiElementVisitor)this);
                    return;
                }
                PsiElement parent = expr2.getParent();
                MyParentVisitor visitor2 = new MyParentVisitor((PsiExpression)expr2, false, this.myClassProvider, this.myVoidable, this.myUsedAfter, this.myMaxCandidates);
                this.myExpr = (PsiExpression)this.myExpr.getParent();
                parent.accept((PsiElementVisitor)visitor2);
                ExpectedTypeInfo[] componentTypeInfo = visitor2.getResult();
                if (componentTypeInfo.length == 0) {
                    this.myResult.addAll(this.anyArrayType());
                } else {
                    for (ExpectedTypeInfo compInfo : componentTypeInfo) {
                        PsiArrayType expectedArrayType = compInfo.getType().createArrayType();
                        this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)expectedArrayType, (PsiType)expectedArrayType));
                    }
                }
            }
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expr2) {
            if (this.myExpr.equals(expr2.getCondition())) {
                if (this.myForCompletion) {
                    this.myExpr = expr2;
                    this.myExpr.getParent().accept((PsiElementVisitor)this);
                    return;
                }
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.NONE));
            } else if (this.myExpr.equals(expr2.getThenExpression())) {
                ExpectedTypeInfo[] types = ExpectedTypesProvider.getExpectedTypes((PsiExpression)expr2, this.myForCompletion, ourGlobalScopeClassProvider, false, false, this.myMaxCandidates);
                for (int i = 0; i < types.length; ++i) {
                    ExpectedTypeInfo info = types[i];
                    types[i] = ExpectedTypesProvider.createInfoImpl(info.getType(), info.getKind(), info.getDefaultType(), TailType.COND_EXPR_COLON, info.getCalledMethod(), (NullableComputable<String>)((ExpectedTypeInfoImpl)info)::getExpectedName);
                }
                Collections.addAll(this.myResult, types);
            } else {
                if (!this.myExpr.equals(expr2.getElseExpression())) {
                    LOG.error(Arrays.asList(expr2.getChildren()) + "; " + this.myExpr);
                }
                Collections.addAll(this.myResult, ExpectedTypesProvider.getExpectedTypes((PsiExpression)expr2, this.myForCompletion, ourGlobalScopeClassProvider, false, false, this.myMaxCandidates));
            }
        }

        public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
            if (statement.getException() == this.myExpr) {
                PsiMethod method;
                PsiManager manager = statement.getManager();
                PsiClassType throwableType = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createTypeByFQClassName("java.lang.Throwable", this.myExpr.getResolveScope());
                PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class, PsiClass.class});
                PsiType[] throwsTypes = PsiType.EMPTY_ARRAY;
                if (container instanceof PsiMethod) {
                    throwsTypes = ((PsiMethod)container).getThrowsList().getReferencedTypes();
                } else if (container instanceof PsiLambdaExpression && (method = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)container)) != null) {
                    throwsTypes = method.getThrowsList().getReferencedTypes();
                }
                if (throwsTypes.length == 0) {
                    PsiClassType exceptionType = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createTypeByFQClassName("java.lang.Exception", this.myExpr.getResolveScope());
                    throwsTypes = new PsiClassType[]{exceptionType};
                }
                for (PsiType throwsType : throwsTypes) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)(this.myExpr instanceof PsiTypeCastExpression && this.myForCompletion ? throwsType : throwableType), 1, throwsType, TailType.SEMICOLON));
                }
            }
        }

        public void visitCodeFragment(@NotNull JavaCodeFragment codeFragment) {
            PsiType type2;
            if (codeFragment instanceof PsiExpressionCodeFragment && (type2 = ((PsiExpressionCodeFragment)codeFragment).getExpectedType()) != null) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type2, type2));
            }
        }

        private ExpectedTypeInfo @NotNull [] getExpectedArgumentTypesForMethodCall(CandidateInfo @NotNull [] allCandidates, @NotNull PsiExpressionList argumentList, @NotNull PsiExpression argument, boolean forCompletion) {
            PsiSubstitutor substitutor;
            PsiMethod method;
            PsiExpression[] leftArgs;
            if (allCandidates.length == 0) {
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            if (CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION) {
                allCandidates = MyParentVisitor.selectCandidateChosenOnCompletion(argumentList.getParent(), allCandidates);
            }
            PsiMethod toExclude = JavaPsiConstructorUtil.isConstructorCall((PsiElement)argumentList.getParent()) ? (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)argument, PsiMethod.class) : null;
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)this.myExpr.getProject()).getResolveHelper();
            ArrayList<CandidateInfo> methodCandidates = new ArrayList<CandidateInfo>();
            for (CandidateInfo candidate : allCandidates) {
                PsiElement element = candidate.getElement();
                if (!(element instanceof PsiMethod) || !helper.isAccessible((PsiMember)element, (PsiElement)argumentList, null) || element == toExclude) continue;
                methodCandidates.add(candidate);
            }
            if (methodCandidates.isEmpty()) {
                Collections.addAll(methodCandidates, allCandidates);
            }
            Object[] args = (PsiExpression[])argumentList.getExpressions().clone();
            int index = ArrayUtil.indexOf((Object[])args, (Object)argument);
            LOG.assertTrue(index >= 0);
            if (index <= args.length - 1) {
                leftArgs = new PsiExpression[index];
                System.arraycopy(args, 0, leftArgs, 0, index);
                if (forCompletion) {
                    args[index] = null;
                }
            } else {
                leftArgs = null;
            }
            CompletionParameterTypeInferencePolicy policy = forCompletion ? CompletionParameterTypeInferencePolicy.INSTANCE : DefaultParameterTypeInferencePolicy.INSTANCE;
            LinkedHashSet<ExpectedTypeInfoImpl> set = new LinkedHashSet<ExpectedTypeInfoImpl>();
            for (CandidateInfo candidateInfo : methodCandidates) {
                method = (PsiMethod)candidateInfo.getElement();
                if (candidateInfo instanceof MethodCandidateInfo) {
                    MethodCandidateInfo info = (MethodCandidateInfo)candidateInfo;
                    substitutor = info.inferSubstitutorFromArgs((ParameterTypeInferencePolicy)policy, (PsiExpression[])args);
                    if (!info.isStaticsScopeCorrect() && !method.hasModifierProperty("static") || info.getInferenceErrorMessage() != null) {
                        continue;
                    }
                } else {
                    substitutor = candidateInfo.getSubstitutor();
                }
                if (substitutor == null) {
                    return ExpectedTypeInfo.EMPTY_ARRAY;
                }
                MyParentVisitor.inferMethodCallArgumentTypes(argument, forCompletion, (PsiExpression[])args, index, method, substitutor, set);
                if (set.size() >= this.myMaxCandidates) break;
                if (leftArgs == null || !(candidateInfo instanceof MethodCandidateInfo) || (substitutor = ((MethodCandidateInfo)candidateInfo).inferSubstitutorFromArgs((ParameterTypeInferencePolicy)policy, leftArgs)) == null) continue;
                MyParentVisitor.inferMethodCallArgumentTypes(argument, forCompletion, leftArgs, index, method, substitutor, set);
                if (set.size() < this.myMaxCandidates) continue;
                break;
            }
            if (forCompletion && set.isEmpty()) {
                for (CandidateInfo candidate : methodCandidates) {
                    method = (PsiMethod)candidate.getElement();
                    substitutor = candidate.getSubstitutor();
                    PsiParameter[] params = method.getParameterList().getParameters();
                    if (params.length <= index) continue;
                    PsiParameter param = params[index];
                    PsiType paramType = MyParentVisitor.getParameterType(param, substitutor);
                    if (method.hasTypeParameters() && PsiTypesUtil.mentionsTypeParameters((PsiType)paramType, (Set)ContainerUtil.newHashSet((Object[])method.getTypeParameters()))) continue;
                    TailType tailType = MyParentVisitor.getMethodArgumentTailType(argument, index, method, substitutor, params);
                    ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(paramType, 1, paramType, tailType, method, (NullableComputable<String>)MyParentVisitor.getPropertyName((PsiVariable)param));
                    set.add(info);
                    if (set.size() < this.myMaxCandidates) continue;
                    break;
                }
            }
            return set.toArray(ExpectedTypeInfo.EMPTY_ARRAY);
        }

        private static CandidateInfo @NotNull [] selectCandidateChosenOnCompletion(@Nullable PsiElement call, CandidateInfo @NotNull [] candidates) {
            PsiMethod method;
            PsiCall originalCall;
            if (call instanceof PsiCall && (originalCall = (PsiCall)CompletionUtil.getOriginalElement((PsiElement)((PsiCall)call))) != null && (method = CompletionMemory.getChosenMethod(originalCall)) != null) {
                for (CandidateInfo candidate : candidates) {
                    if (CompletionUtil.getOriginalOrSelf((PsiElement)candidate.getElement()) != method) continue;
                    return new CandidateInfo[]{candidate};
                }
            }
            return candidates;
        }

        @NotNull
        private static TailType getMethodArgumentTailType(@NotNull PsiExpression argument, int index, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, PsiParameter @NotNull [] params) {
            PsiCall completedOuterCall;
            if (index >= params.length || index == params.length - 2 && params[index + 1].isVarArgs()) {
                return TailType.NONE;
            }
            if (index == params.length - 1) {
                PsiElement call = argument.getParent().getParent();
                if (call instanceof SyntheticElement) {
                    return TailType.NONE;
                }
                PsiType returnType = method.getReturnType();
                if (returnType != null) {
                    returnType = substitutor.substitute(returnType);
                }
                return ExpectedTypesProvider.getFinalCallParameterTailType(call, returnType, method);
            }
            if (CodeInsightSettings.getInstance().SHOW_PARAMETER_NAME_HINTS_ON_COMPLETION && (completedOuterCall = MyParentVisitor.getCompletedOuterCall(argument)) != null) {
                return new CommaTailTypeWithSyncHintUpdate(completedOuterCall);
            }
            return CommaTailType.INSTANCE;
        }

        @Nullable
        private static PsiCall getCompletedOuterCall(@NotNull PsiExpression argument) {
            PsiCall originalCall;
            PsiElement call;
            PsiElement expressionList = argument.getParent();
            if (expressionList instanceof PsiExpressionList && (call = expressionList.getParent()) instanceof PsiCall && (originalCall = (PsiCall)CompletionUtil.getOriginalElement((PsiElement)((PsiCall)call))) != null && JavaMethodCallElement.isCompletionMode(originalCall)) {
                return originalCall;
            }
            return null;
        }

        private static void inferMethodCallArgumentTypes(@NotNull PsiExpression argument, boolean forCompletion, PsiExpression @NotNull [] args, int index, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull Set<? super ExpectedTypeInfo> array) {
            LOG.assertTrue(substitutor.isValid());
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (!forCompletion && parameters2.length != args.length && !method.isVarArgs()) {
                return;
            }
            if (parameters2.length <= index && !method.isVarArgs()) {
                return;
            }
            for (int j = 0; j < index; ++j) {
                PsiType paramType = MyParentVisitor.getParameterType(parameters2[Math.min(parameters2.length - 1, j)], substitutor);
                PsiType argType = args[j].getType();
                if (argType == null || paramType.isAssignableFrom(argType)) continue;
                return;
            }
            PsiParameter parameter2 = parameters2[Math.min(parameters2.length - 1, index)];
            PsiType parameterType = MyParentVisitor.getParameterType(parameter2, substitutor);
            TailType tailType = MyParentVisitor.getMethodArgumentTailType(argument, index, method, substitutor, parameters2);
            PsiType defaultType = MyParentVisitor.getDefaultType(method, substitutor, parameterType, argument, args, index);
            NullableComputable<String> propertyName = MyParentVisitor.getPropertyName((PsiVariable)parameter2);
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(parameterType, 1, defaultType, tailType, method, (NullableComputable<String>)propertyName);
            array.add(info);
            if (index == parameters2.length - 1 && parameter2.isVarArgs()) {
                PsiArrayType arrayType = parameterType.createArrayType();
                ExpectedTypeInfoImpl info1 = ExpectedTypesProvider.createInfoImpl((PsiType)arrayType, 1, (PsiType)arrayType, tailType, method, (NullableComputable<String>)propertyName);
                array.add(info1);
            }
        }

        @Nullable
        private static PsiType getDefaultType(@NotNull PsiMethod method, PsiSubstitutor substitutor, @NotNull PsiType parameterType, @NotNull PsiExpression argument, PsiExpression @NotNull [] args, int index) {
            PsiType typeArg;
            String className2;
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return parameterType;
            }
            PsiType hardcoded = HardcodedDefaultTypesKt.getDefaultType(method, substitutor, index, argument);
            if (hardcoded != null) {
                return hardcoded;
            }
            String name2 = method.getName();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)containingClass.getProject());
            int argCount = Math.max(index + 1, args.length);
            if (("assertEquals".equals(name2) || "assertNotEquals".equals(name2) || "assertSame".equals(name2) || "assertNotSame".equals(name2)) && method.getParameterList().getParametersCount() == argCount && (argCount == 2 || argCount == 3 && method.getParameterList().getParameters()[0].getType().equalsToText("java.lang.String"))) {
                ExpectedTypeInfo info;
                int other;
                int n = other = index == argCount - 1 ? index - 1 : index + 1;
                if (args.length > other && (info = MyParentVisitor.getEqualsType(args[other])) != null && parameterType.isAssignableFrom(info.getDefaultType())) {
                    return info.getDefaultType();
                }
            }
            if ((className2 = containingClass.getName()) != null && className2.startsWith("Log") && parameterType instanceof PsiClassType && ((typeArg = PsiUtil.substituteTypeParameter((PsiType)parameterType, (String)"java.lang.Class", (int)0, (boolean)true)) instanceof PsiWildcardType && !((PsiWildcardType)typeArg).isBounded() || typeArg != null && TypeConversionUtil.erasure((PsiType)typeArg).equalsToText("java.lang.Object"))) {
                PsiClass placeClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)argument, (Class[])new Class[]{PsiClass.class});
                PsiClass classClass = ((PsiClassType)parameterType).resolve();
                if (placeClass != null && classClass != null && classClass.getTypeParameters().length == 1) {
                    return factory.createType(classClass, (PsiType)factory.createType(placeClass));
                }
            }
            return parameterType;
        }

        private static PsiType getParameterType(@NotNull PsiParameter parameter2, @NotNull PsiSubstitutor substitutor) {
            PsiType parameterType;
            PsiType type2 = parameter2.getType();
            LOG.assertTrue(type2.isValid());
            if (parameter2.isVarArgs()) {
                if (type2 instanceof PsiArrayType) {
                    type2 = ((PsiArrayType)type2).getComponentType();
                } else {
                    LOG.error("Vararg parameter with non-array type. Class=" + parameter2.getClass() + "; type=" + parameter2.getType());
                }
            }
            if ((parameterType = substitutor.substitute(type2)) instanceof PsiCapturedWildcardType) {
                parameterType = ((PsiCapturedWildcardType)parameterType).getWildcard();
            }
            if (parameterType instanceof PsiWildcardType) {
                PsiType bound = ((PsiWildcardType)parameterType).getBound();
                return bound != null ? bound : PsiType.getJavaLangObject((PsiManager)parameter2.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)parameter2.getProject()));
            }
            return parameterType;
        }

        @NotNull
        private static NullableComputable<String> getPropertyName(@NotNull PsiVariable variable) {
            return () -> {
                String name2 = variable.getName();
                if (name2 == null) {
                    return null;
                }
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)variable.getProject());
                VariableKind variableKind = codeStyleManager.getVariableKind(variable);
                return codeStyleManager.variableNameToPropertyName(name2, variableKind);
            };
        }

        @NotNull
        private List<ExpectedTypeInfo> anyArrayType() {
            PsiArrayType objType = PsiType.getJavaLangObject((PsiManager)this.myExpr.getManager(), (GlobalSearchScope)this.myExpr.getResolveScope()).createArrayType();
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl((PsiType)objType, (PsiType)objType);
            ExpectedTypeInfoImpl info1 = ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE.createArrayType(), (PsiType)PsiType.INT.createArrayType());
            PsiArrayType booleanType = PsiType.BOOLEAN.createArrayType();
            ExpectedTypeInfoImpl info2 = ExpectedTypesProvider.createInfoImpl((PsiType)booleanType, 0, (PsiType)booleanType, TailType.NONE);
            return Arrays.asList(info, info1, info2);
        }

        private ExpectedTypeInfo @NotNull [] findClassesWithDeclaredMethod(@NotNull PsiMethodCallExpression methodCallExpr) {
            PsiUtilCore.ensureValid((PsiElement)methodCallExpr);
            PsiReferenceExpression reference = methodCallExpr.getMethodExpression();
            if (reference.getQualifierExpression() instanceof PsiClassObjectAccessExpression) {
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            PsiManager manager = methodCallExpr.getManager();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            Set<PsiMethod> psiMethods = MyParentVisitor.mapToDeepestSuperMethods(this.myClassProvider.findDeclaredMethods(manager, Objects.requireNonNull(reference.getReferenceName())));
            THashSet types = new THashSet();
            for (PsiMethod method : psiMethods) {
                PsiClassType type2;
                PsiClass aClass = method.getContainingClass();
                if (aClass == null || !facade.getResolveHelper().isAccessible((PsiMember)method, (PsiElement)reference, aClass)) continue;
                PsiSubstitutor substitutor = ExpectedTypeUtil.inferSubstitutor(method, methodCallExpr, false);
                PsiClassType psiClassType = type2 = substitutor == null ? facade.getElementFactory().createType(aClass) : facade.getElementFactory().createType(aClass, substitutor);
                if (method.hasModifierProperty("static") || method.hasModifierProperty("private")) {
                    types.add(ExpectedTypesProvider.createInfoImpl((PsiType)type2, 0, (PsiType)type2, TailType.DOT));
                    continue;
                }
                types.add(ExpectedTypesProvider.createInfoImpl((PsiType)type2, 1, (PsiType)type2, TailType.DOT));
            }
            return types.toArray(ExpectedTypeInfo.EMPTY_ARRAY);
        }

        private static Set<PsiMethod> mapToDeepestSuperMethods(PsiMethod[] methods) {
            LinkedHashSet<PsiMethod> psiMethods = new LinkedHashSet<PsiMethod>();
            for (PsiMethod m : methods) {
                if (m.hasModifierProperty("static") || m.hasModifierProperty("private")) {
                    psiMethods.add(m);
                    continue;
                }
                PsiMethod[] superMethods = m.findDeepestSuperMethods();
                if (superMethods.length > 0) {
                    psiMethods.addAll(Arrays.asList(superMethods));
                    continue;
                }
                psiMethods.add(m);
            }
            return psiMethods;
        }

        private ExpectedTypeInfo @NotNull [] findClassesWithDeclaredField(@NotNull PsiReferenceExpression expression2) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expression2.getProject());
            PsiField[] fields = this.myClassProvider.findDeclaredFields(expression2.getManager(), Objects.requireNonNull(expression2.getReferenceName()));
            ArrayList<ExpectedTypeInfoImpl> types = new ArrayList<ExpectedTypeInfoImpl>();
            for (PsiField field : fields) {
                PsiClass aClass = field.getContainingClass();
                if (aClass == null || !facade.getResolveHelper().isAccessible((PsiMember)field, (PsiElement)expression2, aClass)) continue;
                PsiClassType type2 = facade.getElementFactory().createType(aClass);
                int kind2 = field.hasModifierProperty("static") || field.hasModifierProperty("final") || field.hasModifierProperty("private") ? 0 : 1;
                ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl((PsiType)type2, kind2, (PsiType)type2, TailType.DOT);
                types.add(info);
            }
            return types.toArray(ExpectedTypeInfo.EMPTY_ARRAY);
        }
    }
}

