/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.PsiBasedStripTrailingSpacesFilter;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.annotations.NotNull;

public class JavaStripTrailingSpacesFilterFactory
extends PsiBasedStripTrailingSpacesFilter.Factory {
    @NotNull
    protected PsiBasedStripTrailingSpacesFilter createFilter(@NotNull Document document) {
        return new JavaPsiBasedStripTrailingSpacesFilter(document);
    }

    protected boolean isApplicableTo(@NotNull Language language) {
        return language.isKindOf((Language)JavaLanguage.INSTANCE);
    }

    private static class JavaPsiBasedStripTrailingSpacesFilter
    extends PsiBasedStripTrailingSpacesFilter {
        protected JavaPsiBasedStripTrailingSpacesFilter(@NotNull Document document) {
            super(document);
        }

        protected void process(@NotNull PsiFile psiFile) {
            if (!HighlightingFeature.TEXT_BLOCKS.isAvailable((PsiElement)psiFile)) {
                return;
            }
            psiFile.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitLiteralExpression(PsiLiteralExpression expression2) {
                    if (expression2.isTextBlock()) {
                        this.disableRange(expression2.getTextRange(), false);
                    }
                }
            });
        }
    }
}

