/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gct.testrecorder.event.ElementAction;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TestRecorderEvent
extends ElementAction {
    public static final String VIEW_CLICK = "VIEW_CLICKED";
    public static final String VIEW_LONG_CLICK = "VIEW_LONG_CLICKED";
    public static final String LIST_ITEM_CLICK = "LIST_ITEM_CLICKED";
    public static final String TEXT_CHANGE = "VIEW_TEXT_CHANGED";
    public static final String PRESS_BACK = "PRESSED_BACK";
    public static final String PRESS_BACK_EMULATOR_28 = "PRESSED_BACK_EMULATOR_28";
    public static final String PRESS_EDITOR_ACTION = "PRESSED_EDITOR_ACTION";
    public static final String VIEW_SWIPE = "VIEW_SWIPED";
    public static final String DELAYED_MESSAGE_POST = "DELAYED_MESSAGE_POSTED";
    public static final String WINDOW_CONTENT_CHANGED = "WINDOW_CONTENT_CHANGED";
    public static final String LAZY_CLASSES_LOADER = "LAZY_CLASSES_LOADER";
    public static final String PERMISSIONS_REQUEST = "PERMISSIONS_REQUEST";
    public static final HashSet<String> SUPPORTED_EVENTS = Sets.newHashSet((Object[])new String[]{"VIEW_CLICKED", "VIEW_LONG_CLICKED", "LIST_ITEM_CLICKED", "VIEW_TEXT_CHANGED", "PRESSED_BACK", "PRESSED_BACK_EMULATOR_28", "PRESSED_EDITOR_ACTION", "VIEW_SWIPED", "DELAYED_MESSAGE_POSTED", "PERMISSIONS_REQUEST"});
    private final String eventType;
    private final long timestamp;
    private String replacementText;
    private int actionCode = -1;
    private SwipeDirection swipeDirection = null;
    private long delayTime;
    private List<String> requestedPermissions = null;

    public TestRecorderEvent(String eventType, long timestamp) {
        this.eventType = eventType;
        this.timestamp = timestamp;
    }

    public String getEventType() {
        return this.eventType;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getReplacementText() {
        return this.replacementText;
    }

    public int getActionCode() {
        return this.actionCode;
    }

    public SwipeDirection getSwipeDirection() {
        return this.swipeDirection;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    public List<String> getRequestedPermissions() {
        return this.requestedPermissions;
    }

    public void setReplacementText(String replacementText) {
        this.replacementText = replacementText;
    }

    public void setActionCode(int actionCode) {
        this.actionCode = actionCode;
    }

    public void setSwipeDirection(SwipeDirection swipeDirection) {
        this.swipeDirection = swipeDirection;
    }

    public void setDelayTime(long delayTime) {
        this.delayTime = delayTime;
    }

    public void setRequestedPermissions(List<String> requestedPermissions) {
        this.requestedPermissions = ImmutableList.copyOf(requestedPermissions);
    }

    public boolean isViewClick() {
        return VIEW_CLICK.equals(this.eventType);
    }

    public boolean isViewLongClick() {
        return VIEW_LONG_CLICK.equals(this.eventType);
    }

    public boolean isListItemClick() {
        return LIST_ITEM_CLICK.equals(this.eventType);
    }

    public boolean isClickEvent() {
        return this.isViewClick() || this.isViewLongClick() || this.isListItemClick();
    }

    public boolean isTextChange() {
        return TEXT_CHANGE.equals(this.eventType);
    }

    public boolean isPressBack() {
        return PRESS_BACK.equals(this.eventType) || PRESS_BACK_EMULATOR_28.equals(this.eventType);
    }

    public boolean isPressBackEmulator28() {
        return PRESS_BACK_EMULATOR_28.equals(this.eventType);
    }

    public boolean isPressEditorAction() {
        return PRESS_EDITOR_ACTION.equals(this.eventType);
    }

    public boolean isPressEvent() {
        return this.isPressBack() || this.isPressEditorAction();
    }

    public boolean isSwipe() {
        return VIEW_SWIPE.equals(this.eventType);
    }

    public boolean isDelayedMessagePost() {
        return DELAYED_MESSAGE_POST.equals(this.eventType);
    }

    public boolean isPermissionsRequest() {
        return PERMISSIONS_REQUEST.equals(this.eventType);
    }

    @Override
    public String getRendererString() {
        if (this.isPermissionsRequest()) {
            return this.getIdAttributeDisplayPresentation("", StringUtils.join(this.requestedPermissions, (String)"<br>"));
        }
        if (this.isDelayedMessagePost()) {
            return this.getIdAttributeDisplayPresentation("", String.valueOf(this.getDelayTime()));
        }
        if (this.isSwipe()) {
            return this.getIdAttributeDisplayPresentation("", this.getSwipeDirection().name());
        }
        if (this.isPressEvent()) {
            return this.getIdAttributeDisplayPresentation("", this.isPressBack() ? "Back" : this.getRendererActionCode());
        }
        return super.getRendererString();
    }

    private String getRendererActionCode() {
        switch (this.actionCode) {
            case 2: {
                return "Go";
            }
            case 3: {
                return "Search";
            }
            case 4: {
                return "Send";
            }
            case 5: {
                return "Next";
            }
            case 6: {
                return "Done";
            }
            case 7: {
                return "Previous";
            }
        }
        return "Return";
    }

    @Override
    @NotNull
    protected String getRendererString(String displayElementAttribute) {
        String prefix = this.isTextChange() ? "into " : "";
        return prefix + super.getRendererString(displayElementAttribute);
    }

    public boolean canMerge(TestRecorderEvent eventToMergeWith) {
        return this.isTextChange() && eventToMergeWith.isTextChange() && this.getElementResourceId().equals(eventToMergeWith.getElementResourceId()) && this.getReplacementText().equals(eventToMergeWith.getElementText()) || this.isDelayedMessagePost() && eventToMergeWith.isDelayedMessagePost();
    }

    public void merge(TestRecorderEvent eventToMergeWith) {
        if (this.isTextChange()) {
            this.setReplacementText(eventToMergeWith.getReplacementText());
        } else {
            this.setDelayTime(Math.max(this.getDelayTime(), eventToMergeWith.getDelayTime()));
        }
    }

    public static enum SwipeDirection {
        Left,
        Right,
        Up,
        Down;

    }
}

