/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.pico.DefaultPicoContainer;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XmlExtensionAdapter
extends ExtensionComponentAdapter {
    @Nullable
    private Element myExtensionElement;
    private volatile Object extensionInstance;
    private boolean initializing;

    XmlExtensionAdapter(@NotNull String implementationClassName, @NotNull PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order, @Nullable Element extensionElement) {
        super(implementationClassName, pluginDescriptor, orderId, order);
        this.myExtensionElement = extensionElement;
    }

    @Override
    synchronized boolean isInstanceCreated() {
        return this.extensionInstance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> T createInstance(@NotNull ComponentManager componentManager) {
        Object instance = this.extensionInstance;
        if (instance != null) {
            return (T)instance;
        }
        XmlExtensionAdapter xmlExtensionAdapter = this;
        synchronized (xmlExtensionAdapter) {
            instance = this.extensionInstance;
            if (instance != null) {
                return (T)instance;
            }
            if (this.initializing) {
                componentManager.logError(new IllegalStateException("Cyclic extension initialization: " + this.toString()), this.getPluginDescriptor().getPluginId());
            }
            try {
                this.initializing = true;
                instance = super.createInstance(componentManager);
                Element element = this.myExtensionElement;
                if (element != null) {
                    XmlSerializer.deserializeInto((Object)instance, (Element)element);
                    this.myExtensionElement = null;
                }
                this.extensionInstance = instance;
            }
            finally {
                this.initializing = false;
            }
        }
        return (T)instance;
    }

    boolean isLoadedFromAnyElement(@NotNull List<Element> candidateElements, @NotNull Map<String, String> defaultAttributes) {
        SkipDefaultValuesSerializationFilters filter = new SkipDefaultValuesSerializationFilters();
        if (this.myExtensionElement == null && this.extensionInstance == null) {
            return true;
        }
        Element serializedElement = this.myExtensionElement != null ? this.myExtensionElement : XmlSerializer.serialize((Object)this.extensionInstance, (SerializationFilter)filter);
        Map<String, String> serializedData = XmlExtensionAdapter.getSerializedDataMap(serializedElement);
        for (Element candidateElement : candidateElements) {
            Map<String, String> candidateData = XmlExtensionAdapter.getSerializedDataMap(candidateElement);
            candidateData.entrySet().removeIf(entry -> Objects.equals(defaultAttributes.get(entry.getKey()), entry.getValue()));
            if (!serializedData.equals(candidateData)) continue;
            return true;
        }
        return false;
    }

    static Map<String, String> getSerializedDataMap(Element serializedElement) {
        HashMap<String, String> data = new HashMap<String, String>();
        for (Attribute attribute : serializedElement.getAttributes()) {
            if (attribute.getName().equals("id") || attribute.getName().equals("order")) continue;
            data.put(attribute.getName(), attribute.getValue());
        }
        for (Element child : serializedElement.getChildren()) {
            data.put(child.getName(), child.getText());
        }
        return data;
    }

    static final class SimpleConstructorInjectionAdapter
    extends XmlExtensionAdapter {
        SimpleConstructorInjectionAdapter(@NotNull String implementationClassName, @NotNull PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order, @Nullable Element extensionElement) {
            super(implementationClassName, pluginDescriptor, orderId, order, extensionElement);
        }

        @Override
        @NotNull
        protected <T> T instantiateClass(@NotNull Class<T> aClass, @NotNull ComponentManager componentManager) {
            if (((DefaultPicoContainer)componentManager.getPicoContainer()).getParent() == null) {
                try {
                    return super.instantiateClass(aClass, componentManager);
                }
                catch (ExtensionNotApplicableException | ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof NoSuchMethodException) && !(cause instanceof IllegalArgumentException)) {
                        throw e;
                    }
                    String message = "Cannot create extension without pico container (class=" + aClass.getName() + "), please remove extra constructor parameters";
                    PluginDescriptor pluginDescriptor = this.getPluginDescriptor();
                    if (pluginDescriptor.isBundled() && !SimpleConstructorInjectionAdapter.isKnownBadPlugin(pluginDescriptor)) {
                        ExtensionPointImpl.LOG.error(message, (Throwable)e);
                    }
                    ExtensionPointImpl.LOG.warn(message, (Throwable)e);
                }
            }
            return componentManager.instantiateClassWithConstructorInjection(aClass, aClass, this.getPluginDescriptor().getPluginId());
        }

        private static boolean isKnownBadPlugin(@NotNull PluginDescriptor pluginDescriptor) {
            String id = pluginDescriptor.getPluginId().getIdString();
            return id.equals("Lombook Plugin");
        }
    }
}

