/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.KeyedLazyInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtensionPointUtil {
    @NotNull
    public static <V extends ClearableLazyValue<?>> V dropLazyValueOnChange(@NotNull V lazyValue, @NotNull ExtensionPointName<?> extensionPointName, @Nullable Disposable parentDisposable) {
        extensionPointName.addChangeListener(() -> lazyValue.drop(), parentDisposable);
        return lazyValue;
    }

    @NotNull
    public static <T> Disposable createExtensionDisposable(@NotNull T extensionObject, @NotNull ExtensionPointName<T> extensionPointName) {
        return ExtensionPointUtil.createExtensionDisposable(extensionObject, extensionPointName.getPoint());
    }

    @NotNull
    public static <T> Disposable createExtensionDisposable(final @NotNull T extensionObject, @NotNull ExtensionPoint<T> extensionPoint) {
        final Disposable disposable = ExtensionPointUtil.createDisposable(extensionObject, extensionPoint);
        extensionPoint.addExtensionPointListener(new ExtensionPointListener<T>(){

            @Override
            public void extensionRemoved(@NotNull T removedExtension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extensionObject == removedExtension) {
                    Disposer.dispose((Disposable)disposable);
                }
            }
        }, false, disposable);
        return disposable;
    }

    @NotNull
    public static <T> Disposable createKeyedExtensionDisposable(final @NotNull T extensionObject, @NotNull ExtensionPoint<KeyedLazyInstance<T>> extensionPoint) {
        final Disposable disposable = ExtensionPointUtil.createDisposable(extensionObject, extensionPoint);
        extensionPoint.addExtensionPointListener(new ExtensionPointListener<KeyedLazyInstance<T>>(){

            @Override
            public void extensionRemoved(@NotNull KeyedLazyInstance<T> removedExtension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extensionObject == removedExtension.getInstance()) {
                    Disposer.dispose((Disposable)disposable);
                }
            }
        }, false, disposable);
        return disposable;
    }

    @NotNull
    private static <T> Disposable createDisposable(@NotNull T extensionObject, @NotNull ExtensionPoint<?> extensionPoint) {
        Disposable disposable = Disposer.newDisposable((String)("Disposable for [" + extensionObject + "]"));
        ComponentManager manager = ((ExtensionPointImpl)extensionPoint).getComponentManager();
        Disposer.register((Disposable)manager, (Disposable)disposable);
        return disposable;
    }
}

