/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyClosurePattern;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyPatternsKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToUtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J.\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleMiscContributor;", "Lorg/jetbrains/plugins/gradle/service/resolve/GradleMethodContextContributor;", "()V", "getDelegatesToInfo", "Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DelegatesToInfo;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "process", "", "methodCallInfo", "", "", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "place", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.gradle.java"})
public final class GradleMiscContributor
implements GradleMethodContextContributor {
    @NotNull
    private static final GroovyClosurePattern useJUnitClosure;
    @NotNull
    private static final GroovyClosurePattern testLoggingClosure;
    @NotNull
    private static final GroovyClosurePattern downloadClosure;
    @NotNull
    private static final GroovyClosurePattern domainCollectionWithTypeClosure;
    @NotNull
    private static final GroovyClosurePattern manifestClosure;
    @NotNull
    public static final String downloadSpecFqn = "de.undercouch.gradle.tasks.download.DownloadSpec";
    @NotNull
    public static final String pluginDependenciesSpecFqn = "org.gradle.plugin.use.PluginDependenciesSpec";
    public static final Companion Companion;

    @Override
    @Nullable
    public DelegatesToInfo getDelegatesToInfo(@NotNull GrClosableBlock closure) {
        PsiMethod psiMethod;
        if (useJUnitClosure.accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)"org.gradle.api.tasks.testing.junit.JUnitOptions", (PsiElement)((PsiElement)closure)), 1);
        }
        if (testLoggingClosure.accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)"org.gradle.api.tasks.testing.logging.TestLoggingContainer", (PsiElement)((PsiElement)closure)), 1);
        }
        if (downloadClosure.accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)downloadSpecFqn, (PsiElement)((PsiElement)closure)), 1);
        }
        if (manifestClosure.accepts((Object)closure)) {
            return new DelegatesToInfo((PsiType)TypesUtil.createType((String)"org.gradle.api.java.archives.Manifest", (PsiElement)((PsiElement)closure)), 1);
        }
        PsiElement parent = closure.getParent();
        if (domainCollectionWithTypeClosure.accepts((Object)closure) && parent instanceof GrMethodCallExpression) {
            PsiElement psiElement;
            GroovyPsiElement groovyPsiElement = (GroovyPsiElement)ArraysKt.singleOrNull((Object[])((GrMethodCallExpression)parent).getArgumentList().getAllArguments());
            PsiElement psiElement2 = groovyPsiElement != null && (groovyPsiElement = groovyPsiElement.getReference()) != null ? groovyPsiElement.resolve() : (psiElement = null);
            if (psiElement instanceof PsiClass) {
                return new DelegatesToInfo((PsiType)TypesUtil.createType((String)((PsiClass)psiElement).getQualifiedName(), (PsiElement)((PsiElement)closure)), 1);
            }
        }
        if (parent instanceof GrMethodCall && (psiMethod = ((GrMethodCall)parent).resolveMethod()) != null && (psiMethod = psiMethod.getReturnType()) != null) {
            PsiMethod psiMethod2 = psiMethod;
            boolean bl = false;
            boolean bl2 = false;
            PsiMethod type = psiMethod2;
            boolean bl3 = false;
            if (!(type instanceof PsiPrimitiveType)) {
                return new DelegatesToInfo((PsiType)type, 1);
            }
        }
        return null;
    }

    @Override
    public boolean process(@NotNull List<String> methodCallInfo, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        boolean shouldProcessMethods = ResolveUtil.shouldProcessMethods((ElementClassHint)classHint);
        GroovyPsiManager groovyPsiManager = GroovyPsiManager.getInstance((Project)place.getProject());
        GlobalSearchScope resolveScope = place.getResolveScope();
        if (shouldProcessMethods) {
            PsiElement psiElement = place.getParent();
            if ((psiElement != null ? psiElement.getParent() : null) instanceof GroovyFile && Intrinsics.areEqual((Object)place.getText(), (Object)"plugins")) {
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)place.getProject()).findClass(pluginDependenciesSpecFqn, resolveScope);
                if (psiClass == null) {
                    return true;
                }
                PsiClass pluginsDependenciesClass = psiClass;
                PsiClassType psiClassType = groovyPsiManager.createTypeByFQClassName(pluginDependenciesSpecFqn, resolveScope);
                if (psiClassType == null) {
                    return true;
                }
                PsiClassType returnClass = psiClassType;
                GrLightMethodBuilder grLightMethodBuilder = new GrLightMethodBuilder(place.getManager(), "plugins");
                boolean bl = false;
                boolean bl2 = false;
                GrLightMethodBuilder $this$apply = grLightMethodBuilder;
                boolean bl3 = false;
                $this$apply.setContainingClass(pluginsDependenciesClass);
                $this$apply.setReturnType((PsiType)returnClass);
                GrLightMethodBuilder methodBuilder = grLightMethodBuilder;
                methodBuilder.addAndGetParameter("configuration", "groovy.lang.Closure").putUserData(GrDelegatesToUtilKt.DELEGATES_TO_TYPE_KEY, (Object)pluginDependenciesSpecFqn);
                if (!processor.execute((PsiElement)methodBuilder, state)) {
                    return false;
                }
            }
        }
        ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside((ElementPattern)domainCollectionWithTypeClosure)).accepts((Object)place);
        return true;
    }

    static {
        Companion = new Companion(null);
        useJUnitClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.tasks.testing.Test", (String[])new String[]{"useJUnit"}));
        testLoggingClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.tasks.testing.Test", (String[])new String[]{"testLogging"}));
        downloadClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.Project", (String[])new String[]{"download"}));
        domainCollectionWithTypeClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.api.DomainObjectCollection", (String[])new String[]{"withType"}));
        manifestClosure = GroovyPatternsKt.groovyClosure().inMethod((ElementPattern)GroovyPatternsKt.psiMethod((String)"org.gradle.jvm.tasks.Jar", (String[])new String[]{"manifest"}));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0006R\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleMiscContributor$Companion;", "", "()V", "domainCollectionWithTypeClosure", "Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyClosurePattern;", "getDomainCollectionWithTypeClosure", "()Lorg/jetbrains/plugins/groovy/lang/psi/patterns/GroovyClosurePattern;", "downloadClosure", "getDownloadClosure", "downloadSpecFqn", "", "manifestClosure", "getManifestClosure", "pluginDependenciesSpecFqn", "testLoggingClosure", "getTestLoggingClosure", "useJUnitClosure", "getUseJUnitClosure", "intellij.gradle.java"})
    public static final class Companion {
        @NotNull
        public final GroovyClosurePattern getUseJUnitClosure() {
            return useJUnitClosure;
        }

        @NotNull
        public final GroovyClosurePattern getTestLoggingClosure() {
            return testLoggingClosure;
        }

        @NotNull
        public final GroovyClosurePattern getDownloadClosure() {
            return downloadClosure;
        }

        @NotNull
        public final GroovyClosurePattern getDomainCollectionWithTypeClosure() {
            return domainCollectionWithTypeClosure;
        }

        @NotNull
        public final GroovyClosurePattern getManifestClosure() {
            return manifestClosure;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

