/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.PatternGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestGradleConfigurationProducerUtilKt;
import org.jetbrains.plugins.gradle.execution.test.runner.TestTasksChooser;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleExecutionSettingsUtil;

public class TestMethodGradleConfigurationProducer
extends GradleTestRunConfigurationProducer {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return GradleExternalTaskConfigurationType.getInstance().getFactory();
    }

    @Override
    protected boolean doSetupConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (((PatternGradleConfigurationProducer)RunConfigurationProducer.getInstance(PatternGradleConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        PsiMethod psiMethod = this.getPsiMethodForLocation(contextLocation);
        if (psiMethod == null) {
            return false;
        }
        sourceElement.set((Object)psiMethod);
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        Module module = context.getModule();
        if (module == null) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return false;
        }
        if (!TestMethodGradleConfigurationProducer.applyTestMethodConfiguration(configuration, context, psiMethod, containingClass)) {
            return false;
        }
        JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, contextLocation);
        return true;
    }

    @Nullable
    protected PsiMethod getPsiMethodForLocation(Location contextLocation) {
        Location<PsiMethod> location = GradleRunnerUtil.getMethodLocation(contextLocation);
        return location != null ? (PsiMethod)location.getPsiElement() : null;
    }

    @Override
    protected boolean doIsConfigurationFromContext(ExternalSystemRunConfiguration configuration, ConfigurationContext context) {
        if (((PatternGradleConfigurationProducer)RunConfigurationProducer.getInstance(PatternGradleConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        PsiMethod psiMethod = this.getPsiMethodForLocation(contextLocation);
        if (psiMethod == null) {
            return false;
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        Module module = context.getModule();
        if (module == null) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return false;
        }
        String projectPath = this.resolveProjectPath(module);
        if (projectPath == null) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)projectPath, (CharSequence)configuration.getSettings().getExternalProjectPath())) {
            return false;
        }
        VirtualFile source = psiMethod.getContainingFile().getVirtualFile();
        if (!TestMethodGradleConfigurationProducer.hasTasksInConfiguration(source, context.getProject(), configuration.getSettings())) {
            return false;
        }
        String scriptParameters = configuration.getSettings().getScriptParameters() + ' ';
        String testFilter = TestMethodGradleConfigurationProducer.createTestFilter(contextLocation, containingClass, psiMethod);
        return testFilter != null && scriptParameters.contains(testFilter);
    }

    public void onFirstRun(final @NotNull ConfigurationFromContext fromContext, @NotNull ConfigurationContext context, @NotNull Runnable performRunnable) {
        PsiClass psiClass;
        Runnable runnableWithCheck = this.addCheckForTemplateParams(fromContext, context, performRunnable);
        final PsiMethod psiMethod = (PsiMethod)fromContext.getSourceElement();
        InheritorChooser inheritorChooser = new InheritorChooser(){

            protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                TestMethodGradleConfigurationProducer.this.chooseTestClassConfiguration(fromContext, context, performRunnable, psiMethod, classes.toArray(PsiClass.EMPTY_ARRAY));
            }

            protected void runForClass(PsiClass aClass, PsiMethod psiMethod2, ConfigurationContext context, Runnable performRunnable) {
                TestMethodGradleConfigurationProducer.this.chooseTestClassConfiguration(fromContext, context, performRunnable, psiMethod2, new PsiClass[]{aClass});
            }
        };
        if (inheritorChooser.runMethodInAbstractClass(context, runnableWithCheck, psiMethod, psiClass = psiMethod.getContainingClass())) {
            return;
        }
        this.chooseTestClassConfiguration(fromContext, context, runnableWithCheck, psiMethod, psiClass);
    }

    private void chooseTestClassConfiguration(@NotNull ConfigurationFromContext fromContext, @NotNull ConfigurationContext context, @NotNull Runnable performRunnable, @NotNull PsiMethod psiMethod, PsiClass ... classes) {
        DataContext dataContext = TestTasksChooser.contextWithLocationName(context.getDataContext(), psiMethod.getName());
        this.getTestTasksChooser().chooseTestTasks(context.getProject(), dataContext, (PsiElement[])classes, tasks -> {
            ExternalSystemRunConfiguration configuration = (ExternalSystemRunConfiguration)fromContext.getConfiguration();
            ExternalSystemTaskExecutionSettings settings = configuration.getSettings();
            Function1 createFilter = psiClass -> TestMethodGradleConfigurationProducer.createTestFilter(context.getLocation(), psiClass, psiMethod);
            if (!TestGradleConfigurationProducerUtilKt.applyTestConfiguration((ExternalSystemTaskExecutionSettings)settings, (Module)context.getModule(), (List)tasks, (PsiElement[])classes, (Function1)createFilter)) {
                LOG.warn("Cannot apply method test configuration, uses raw run configuration");
                performRunnable.run();
                return;
            }
            configuration.setName((classes.length == 1 ? classes[0].getName() + "." : "") + psiMethod.getName());
            performRunnable.run();
        });
    }

    private static boolean applyTestMethodConfiguration(@NotNull ExternalSystemRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull PsiMethod psiMethod, PsiClass ... containingClasses) {
        ExternalSystemTaskExecutionSettings settings = configuration.getSettings();
        Function1 createFilter = psiClass -> TestMethodGradleConfigurationProducer.createTestFilter(context.getLocation(), psiClass, psiMethod);
        if (!TestGradleConfigurationProducerUtilKt.applyTestConfiguration((ExternalSystemTaskExecutionSettings)settings, (Module)context.getModule(), (PsiElement[])containingClasses, (Function1)createFilter)) {
            return false;
        }
        configuration.setName((containingClasses.length == 1 ? containingClasses[0].getName() + "." : "") + psiMethod.getName());
        return true;
    }

    @Nullable
    private static String createTestFilter(@Nullable Location location, @NotNull PsiClass aClass, @NotNull PsiMethod psiMethod) {
        String filter = GradleExecutionSettingsUtil.createTestFilterFrom(location, aClass, psiMethod, true);
        return filter.isEmpty() ? null : filter;
    }

    @NotNull
    public static String createTestFilter(@Nullable String aClass, @Nullable String method) {
        return GradleExecutionSettingsUtil.createTestFilterFromMethod(aClass, method, true);
    }
}

