/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AfterSuiteEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AfterTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.BeforeSuiteEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.BeforeTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.ConfigurationErrorEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.OnOutputEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.ReportLocationEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventType;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXPPXmlView;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class GradleTestsExecutionConsoleOutputProcessor {
    private static final Logger LOG = Logger.getInstance(GradleTestsExecutionConsoleOutputProcessor.class);
    private static final String LOG_EOL = "<ijLogEol/>";
    private static final String LOG_START = "<ijLog>";
    private static final String LOG_END = "</ijLog>";

    public static void onOutput(@NotNull GradleTestsExecutionConsole executionConsole, @NotNull String text, @NotNull Key<?> processOutputType) {
        String eventMessage = GradleTestsExecutionConsoleOutputProcessor.getEventMessage(executionConsole, text, processOutputType);
        if (eventMessage == null) {
            return;
        }
        try {
            TestEventXPPXmlView xml = new TestEventXPPXmlView(eventMessage);
            TestEventType eventType = TestEventType.fromValue(xml.getTestEventType());
            AbstractTestEvent testEvent = null;
            switch (eventType) {
                case CONFIGURATION_ERROR: {
                    testEvent = new ConfigurationErrorEvent(executionConsole);
                    break;
                }
                case REPORT_LOCATION: {
                    testEvent = new ReportLocationEvent(executionConsole);
                    break;
                }
                case BEFORE_TEST: {
                    testEvent = new BeforeTestEvent(executionConsole);
                    break;
                }
                case ON_OUTPUT: {
                    testEvent = new OnOutputEvent(executionConsole);
                    break;
                }
                case AFTER_TEST: {
                    testEvent = new AfterTestEvent(executionConsole);
                    break;
                }
                case BEFORE_SUITE: {
                    testEvent = new BeforeSuiteEvent(executionConsole);
                    break;
                }
                case AFTER_SUITE: {
                    testEvent = new AfterSuiteEvent(executionConsole);
                    break;
                }
            }
            if (testEvent != null) {
                testEvent.process(xml);
            }
        }
        catch (TestEventXmlView.XmlParserException e) {
            LOG.error("Gradle test events parser error", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private static String getEventMessage(@NotNull GradleTestsExecutionConsole executionConsole, @NotNull String text, @NotNull Key<?> processOutputType) {
        StringBuilder consoleBuffer;
        String eventMessage;
        block8: {
            eventMessage = null;
            consoleBuffer = executionConsole.getBuffer();
            String trimmedText = text.trim();
            if (StringUtil.endsWith((CharSequence)trimmedText, (CharSequence)LOG_EOL)) {
                consoleBuffer.append(StringUtil.trimEnd((String)trimmedText, (String)LOG_EOL));
                return null;
            }
            if (consoleBuffer.length() == 0) {
                if (StringUtil.startsWith((CharSequence)trimmedText, (CharSequence)LOG_START) && StringUtil.endsWith((CharSequence)trimmedText, (CharSequence)LOG_END)) {
                    eventMessage = text;
                    break block8;
                } else {
                    executionConsole.print(text, ConsoleViewContentType.getConsoleViewType(processOutputType));
                    return null;
                }
            }
            consoleBuffer.append(text);
            if (trimmedText.isEmpty()) {
                return null;
            }
        }
        if (eventMessage == null) {
            String bufferText = consoleBuffer.toString().trim();
            consoleBuffer.setLength(0);
            if (!StringUtil.startsWith((CharSequence)bufferText, (CharSequence)LOG_START) || !StringUtil.endsWith((CharSequence)bufferText, (CharSequence)LOG_END)) {
                executionConsole.print(bufferText, ConsoleViewContentType.getConsoleViewType(processOutputType));
                return null;
            }
            eventMessage = bufferText;
        }
        assert (consoleBuffer.length() == 0);
        return eventMessage;
    }
}

