/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.inspection;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiEnumConstantImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JunitEnumSourceImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final String ENUM_SOURCE = "org.junit.jupiter.params.provider.EnumSource";

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element instanceof PsiEnumConstantImpl) {
            PsiSearchHelper searchHelper;
            PsiSearchHelper.SearchCostResult cheapEnough;
            String className;
            PsiClass psiClass = ((PsiEnumConstantImpl)element).getContainingClass();
            String string = className = psiClass != null ? psiClass.getName() : null;
            if (className == null) {
                return false;
            }
            SearchScope useScope = psiClass.getUseScope();
            if (!(useScope instanceof LocalSearchScope || (cheapEnough = (searchHelper = PsiSearchHelper.getInstance((Project)psiClass.getProject())).isCheapEnoughToSearch(className, (GlobalSearchScope)useScope, null, null)) != PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES && cheapEnough != PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES)) {
                return false;
            }
            return ReferencesSearch.search((PsiElement)psiClass, (SearchScope)useScope, (boolean)false).anyMatch(reference -> {
                PsiElement referenceElement = reference.getElement();
                return JunitEnumSourceImplicitUsageProvider.isReferencedInsideEnumSourceAnnotation(referenceElement);
            });
        }
        return false;
    }

    private static boolean isReferencedInsideEnumSourceAnnotation(PsiElement referenceElement) {
        String annotationName;
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiAnnotation.class);
        return annotation != null && ENUM_SOURCE.equals(annotationName = annotation.getQualifiedName()) && annotation.getAttributes().size() == 1;
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        return false;
    }
}

