/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.configuration;

import com.intellij.DynamicBundle;
import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.MethodBrowser;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestClassFilter;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit2.configuration.JUnitConfigurationModel;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.execution.ui.ShortenCommandLineModeCombo;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.rt.execution.junit.RepeatCount;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;

public class JUnitConfigurable<T extends JUnitConfiguration>
extends SettingsEditor<T>
implements PanelWithAnchor {
    private static final List<TIntArrayList> ourEnabledFields = Arrays.asList(new TIntArrayList(new int[]{0}), new TIntArrayList(new int[]{1}), new TIntArrayList(new int[]{1, 2}), new TIntArrayList(new int[]{3}), new TIntArrayList(new int[]{4}), new TIntArrayList(new int[]{5}), new TIntArrayList(new int[]{1, 2}), new TIntArrayList(new int[]{6}), new TIntArrayList(new int[]{1, 2}));
    private static final String[] FORK_MODE_ALL = new String[]{"none", "method", "class"};
    private static final String[] FORK_MODE = new String[]{"none", "method"};
    private final ConfigurationModuleSelector myModuleSelector;
    private final LabeledComponent[] myTestLocations = new LabeledComponent[6];
    private final JUnitConfigurationModel myModel;
    private final BrowseModuleValueActionListener[] myBrowsers;
    private JComponent myPackagePanel;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myPackage;
    private LabeledComponent<TextFieldWithBrowseButton> myDir;
    private LabeledComponent<JPanel> myPattern;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myClass;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myMethod;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myCategory;
    private JPanel myWholePanel;
    private LabeledComponent<ModuleDescriptionsComboBox> myModule;
    private LabeledComponent<JCheckBox> myUseModulePath;
    private CommonJavaParametersPanel myCommonJavaParameters;
    private JRadioButton myWholeProjectScope;
    private JRadioButton mySingleModuleScope;
    private JRadioButton myModuleWDScope;
    private final TextFieldWithBrowseButton myPatternTextField;
    private JrePathEditor myJrePathEditor;
    private LabeledComponent<ShortenCommandLineModeCombo> myShortenClasspathModeCombo;
    private JComboBox myForkCb;
    private JBLabel myTestLabel;
    private JComboBox<Integer> myTypeChooser;
    private JBLabel mySearchForTestsLabel;
    private JPanel myScopesPanel;
    private JComboBox<String> myRepeatCb;
    private JTextField myRepeatCountField;
    private LabeledComponent<JComboBox<String>> myChangeListLabeledComponent;
    private LabeledComponent<RawCommandLineEditor> myUniqueIdField;
    private LabeledComponent<RawCommandLineEditor> myTagsField;
    private final Project myProject;
    private JComponent anchor;

    public JUnitConfigurable(final Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myModel = new JUnitConfigurationModel(project);
        this.myModuleSelector = new ConfigurationModuleSelector(project, this.getModulesComponent());
        this.myJrePathEditor.setDefaultJreSelector(DefaultJreSelector.fromModuleDependencies((ModuleDescriptionsComboBox)this.getModulesComponent(), (boolean)false));
        this.myCommonJavaParameters.setModuleContext(this.myModuleSelector.getModule());
        this.myCommonJavaParameters.setHasModuleMacro();
        ((ModuleDescriptionsComboBox)this.myModule.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUnitConfigurable.this.myCommonJavaParameters.setModuleContext(JUnitConfigurable.this.myModuleSelector.getModule());
                JUnitConfigurable.this.reloadTestKindModel();
            }
        });
        this.myBrowsers = new BrowseModuleValueActionListener[]{new PackageChooserActionListener(project), new TestClassBrowser(project), new MethodBrowser(project){

            protected Condition<PsiMethod> getFilter(PsiClass testClass) {
                return new JUnitUtil.TestMethodFilter(testClass);
            }

            protected String getClassName() {
                return JUnitConfigurable.this.getClassName();
            }

            protected ConfigurationModuleSelector getModuleSelector() {
                return JUnitConfigurable.this.myModuleSelector;
            }
        }, new TestsChooserActionListener(project), new BrowseModuleValueActionListener(project){

            protected String showDialog() {
                VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), (Project)project, null);
                if (virtualFile != null) {
                    return FileUtil.toSystemDependentName((String)virtualFile.getPath());
                }
                return null;
            }
        }, new CategoryBrowser(project), null};
        this.reloadTestKindModel();
        this.myTypeChooser.setRenderer((ListCellRenderer<Integer>)SimpleListCellRenderer.create((String)"", value -> {
            switch (value) {
                case 0: {
                    return "All in package";
                }
                case 4: {
                    return "All in directory";
                }
                case 3: {
                    return "Pattern";
                }
                case 1: {
                    return "Class";
                }
                case 2: {
                    return "Method";
                }
                case 5: {
                    return "Category";
                }
                case 6: {
                    return "UniqueId";
                }
                case 7: {
                    return "Tags";
                }
                case 8: {
                    return "Through source location";
                }
                case 9: {
                    return "Over changes in sources";
                }
            }
            throw new IllegalArgumentException(String.valueOf(value));
        }));
        this.myTestLocations[0] = this.myPackage;
        this.myTestLocations[1] = this.myClass;
        this.myTestLocations[2] = this.myMethod;
        this.myTestLocations[4] = this.myDir;
        this.myTestLocations[5] = this.myCategory;
        this.myRepeatCb.setModel(new DefaultComboBoxModel<String>(RepeatCount.REPEAT_TYPES));
        this.myRepeatCb.setSelectedItem("Once");
        this.myRepeatCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JUnitConfigurable.this.myRepeatCountField.setEnabled("N Times".equals(JUnitConfigurable.this.myRepeatCb.getSelectedItem()));
            }
        });
        JPanel panel = (JPanel)this.myPattern.getComponent();
        panel.setLayout(new BorderLayout());
        this.myPatternTextField = new TextFieldWithBrowseButton((JTextField)new ExpandableTextField(text -> Arrays.asList(text.split("\\|\\|")), strings -> StringUtil.join((Collection)strings, (String)"||")));
        this.myPatternTextField.setButtonIcon(IconUtil.getAddIcon());
        panel.add((Component)this.myPatternTextField, "Center");
        this.myTestLocations[3] = this.myPattern;
        FileChooserDescriptor dirFileChooser = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        dirFileChooser.setHideIgnored(false);
        JTextField textField = ((TextFieldWithBrowseButton)this.myDir.getComponent()).getTextField();
        InsertPathAction.addTo((JTextComponent)textField, (FileChooserDescriptor)dirFileChooser);
        FileChooserFactory.getInstance().installFileCompletion(textField, dirFileChooser, true, null);
        this.myModel.setListener(this);
        this.myTypeChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = JUnitConfigurable.this.myTypeChooser.getSelectedItem();
                JUnitConfigurable.this.myModel.setType((Integer)selectedItem);
                JUnitConfigurable.this.changePanel();
            }
        });
        this.myRepeatCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((Integer)JUnitConfigurable.this.myTypeChooser.getSelectedItem() == 1) {
                    JUnitConfigurable.this.myForkCb.setModel(JUnitConfigurable.this.getForkModelBasedOnRepeat());
                }
            }
        });
        this.myModel.setType(1);
        this.installDocuments();
        JUnitConfigurable.addRadioButtonsListeners(new JRadioButton[]{this.myWholeProjectScope, this.mySingleModuleScope, this.myModuleWDScope}, null);
        this.myWholeProjectScope.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JUnitConfigurable.this.onScopeChanged();
            }
        });
        UIUtil.setEnabled((Component)this.myCommonJavaParameters.getProgramParametersComponent(), (boolean)false, (boolean)true);
        this.setAnchor((JComponent)this.mySearchForTestsLabel);
        this.myJrePathEditor.setAnchor((JComponent)this.myModule.getLabel());
        this.myUseModulePath.setAnchor((JComponent)this.myModule.getLabel());
        this.myCommonJavaParameters.setAnchor((JComponent)this.myModule.getLabel());
        this.myShortenClasspathModeCombo.setAnchor((JComponent)this.myModule.getLabel());
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        ((JComboBox)this.myChangeListLabeledComponent.getComponent()).setModel(model);
        model.addElement(JUnitBundle.message("test.discovery.by.all.changes.combo.item", new Object[0]));
        if (!project.isDefault()) {
            List changeLists = ChangeListManager.getInstance((Project)project).getChangeLists();
            for (LocalChangeList changeList : changeLists) {
                model.addElement(changeList.getName());
            }
        }
        this.myShortenClasspathModeCombo.setComponent((JComponent)new ShortenCommandLineModeCombo(this.myProject, this.myJrePathEditor, (ModuleDescriptionsComboBox)this.myModule.getComponent()){

            protected boolean productionOnly() {
                return false;
            }
        });
        ((JCheckBox)this.myUseModulePath.getComponent()).setText(ExecutionBundle.message((String)"use.module.path.checkbox.label", (Object[])new Object[0]));
        ((JCheckBox)this.myUseModulePath.getComponent()).setSelected(true);
        this.myUseModulePath.setVisible(FilenameIndex.getFilesByName((Project)project, (String)"module-info.java", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject)).length > 0);
    }

    private void reloadTestKindModel() {
        GlobalSearchScope searchScope;
        int selectedIndex = this.myTypeChooser.getSelectedIndex();
        DefaultComboBoxModel<Integer> aModel = new DefaultComboBoxModel<Integer>();
        aModel.addElement(0);
        aModel.addElement(4);
        aModel.addElement(3);
        aModel.addElement(1);
        aModel.addElement(2);
        Module module = this.getModuleSelector().getModule();
        GlobalSearchScope globalSearchScope = searchScope = module != null ? GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true) : GlobalSearchScope.allScope((Project)this.myProject);
        if (this.myProject.isDefault() || JavaPsiFacade.getInstance((Project)this.myProject).findPackage("org.junit") != null) {
            aModel.addElement(5);
        }
        if (this.myProject.isDefault() || JUnitUtil.isJUnit5((GlobalSearchScope)searchScope, (Project)this.myProject) || TestObject.hasJUnit5EnginesAPI(searchScope, JavaPsiFacade.getInstance((Project)this.myProject))) {
            aModel.addElement(6);
            aModel.addElement(7);
        }
        if (Registry.is((String)"testDiscovery.enabled")) {
            aModel.addElement(8);
            aModel.addElement(9);
        }
        this.myTypeChooser.setModel(aModel);
        this.myTypeChooser.setSelectedIndex(selectedIndex);
    }

    private static void addRadioButtonsListeners(JRadioButton[] radioButtons, ChangeListener listener) {
        ButtonGroup group = new ButtonGroup();
        for (JRadioButton radioButton : radioButtons) {
            radioButton.getModel().addChangeListener(listener);
            group.add(radioButton);
        }
        if (group.getSelection() == null) {
            group.setSelected(radioButtons[0].getModel(), true);
        }
    }

    public void applyEditorTo(@NotNull JUnitConfiguration configuration) {
        configuration.setRepeatMode((String)this.myRepeatCb.getSelectedItem());
        try {
            configuration.setRepeatCount(Integer.parseInt(this.myRepeatCountField.getText()));
        }
        catch (NumberFormatException e) {
            configuration.setRepeatCount(1);
        }
        configuration.getPersistentData().setUniqueIds(this.setArrayFromText(this.myUniqueIdField));
        configuration.getPersistentData().setTags(((RawCommandLineEditor)this.myTagsField.getComponent()).getText());
        configuration.getPersistentData().setChangeList((String)((JComboBox)this.myChangeListLabeledComponent.getComponent()).getSelectedItem());
        this.myModel.apply(this.getModuleSelector().getModule(), configuration);
        this.applyHelpersTo(configuration);
        JUnitConfiguration.Data data = configuration.getPersistentData();
        if (this.myWholeProjectScope.isSelected()) {
            data.setScope(TestSearchScope.WHOLE_PROJECT);
        } else if (this.mySingleModuleScope.isSelected()) {
            data.setScope(TestSearchScope.SINGLE_MODULE);
        } else if (this.myModuleWDScope.isSelected()) {
            data.setScope(TestSearchScope.MODULE_WITH_DEPENDENCIES);
        }
        configuration.setAlternativeJrePath(this.myJrePathEditor.getJrePathOrName());
        configuration.setAlternativeJrePathEnabled(this.myJrePathEditor.isAlternativeJreSelected());
        this.myCommonJavaParameters.applyTo((CommonJavaRunConfigurationParameters)configuration);
        configuration.setForkMode((String)this.myForkCb.getSelectedItem());
        configuration.setShortenCommandLine(((ShortenCommandLineModeCombo)this.myShortenClasspathModeCombo.getComponent()).getSelectedItem());
        configuration.setUseModulePath(this.myUseModulePath.isVisible() && ((JCheckBox)this.myUseModulePath.getComponent()).isSelected());
    }

    protected String[] setArrayFromText(LabeledComponent<RawCommandLineEditor> field) {
        String text = ((RawCommandLineEditor)field.getComponent()).getText();
        if (text.isEmpty()) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        return text.split(" ");
    }

    public void resetEditorFrom(@NotNull JUnitConfiguration configuration) {
        int count = configuration.getRepeatCount();
        this.myRepeatCountField.setText(String.valueOf(count));
        this.myRepeatCountField.setEnabled(count > 1);
        this.myRepeatCb.setSelectedItem(configuration.getRepeatMode());
        this.myModel.reset(configuration);
        ((JComboBox)this.myChangeListLabeledComponent.getComponent()).setSelectedItem(configuration.getPersistentData().getChangeList());
        String[] ids = configuration.getPersistentData().getUniqueIds();
        ((RawCommandLineEditor)this.myUniqueIdField.getComponent()).setText(ids != null ? StringUtil.join((String[])ids, (String)" ") : null);
        ((RawCommandLineEditor)this.myTagsField.getComponent()).setText(configuration.getPersistentData().getTags());
        this.myCommonJavaParameters.reset((CommonJavaRunConfigurationParameters)configuration);
        this.getModuleSelector().reset((ModuleBasedConfiguration)configuration);
        TestSearchScope scope = configuration.getPersistentData().getScope();
        if (scope == TestSearchScope.SINGLE_MODULE) {
            this.mySingleModuleScope.setSelected(true);
        } else if (scope == TestSearchScope.MODULE_WITH_DEPENDENCIES) {
            this.myModuleWDScope.setSelected(true);
        } else {
            this.myWholeProjectScope.setSelected(true);
        }
        this.myJrePathEditor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled());
        this.myForkCb.setSelectedItem(configuration.getForkMode());
        ((ShortenCommandLineModeCombo)this.myShortenClasspathModeCombo.getComponent()).setSelectedItem((Object)configuration.getShortenCommandLine());
        ((JCheckBox)this.myUseModulePath.getComponent()).setSelected(configuration.isUseModulePath());
    }

    private void changePanel() {
        Integer selectedType;
        String selectedItem = (String)this.myForkCb.getSelectedItem();
        if (selectedItem == null) {
            selectedItem = "none";
        }
        if ((selectedType = (Integer)this.myTypeChooser.getSelectedItem()) == 0) {
            this.myPackagePanel.setVisible(true);
            this.myScopesPanel.setVisible(true);
            this.myPattern.setVisible(false);
            this.myClass.setVisible(false);
            this.myCategory.setVisible(false);
            this.myUniqueIdField.setVisible(false);
            this.myTagsField.setVisible(false);
            this.myMethod.setVisible(false);
            this.myDir.setVisible(false);
            this.myChangeListLabeledComponent.setVisible(false);
            this.myForkCb.setEnabled(true);
            this.myForkCb.setModel(new DefaultComboBoxModel<String>(FORK_MODE_ALL));
            this.myForkCb.setSelectedItem(selectedItem);
        } else if (selectedType == 4) {
            this.myPackagePanel.setVisible(false);
            this.myScopesPanel.setVisible(false);
            this.myDir.setVisible(true);
            this.myPattern.setVisible(false);
            this.myClass.setVisible(false);
            this.myCategory.setVisible(false);
            this.myUniqueIdField.setVisible(false);
            this.myTagsField.setVisible(false);
            this.myChangeListLabeledComponent.setVisible(false);
            this.myMethod.setVisible(false);
            this.myForkCb.setEnabled(true);
            this.myForkCb.setModel(new DefaultComboBoxModel<String>(FORK_MODE_ALL));
            this.myForkCb.setSelectedItem(selectedItem);
        } else if (selectedType == 1) {
            this.myPackagePanel.setVisible(false);
            this.myScopesPanel.setVisible(false);
            this.myPattern.setVisible(false);
            this.myDir.setVisible(false);
            this.myClass.setVisible(true);
            this.myCategory.setVisible(false);
            this.myUniqueIdField.setVisible(false);
            this.myTagsField.setVisible(false);
            this.myChangeListLabeledComponent.setVisible(false);
            this.myMethod.setVisible(false);
            this.myForkCb.setEnabled(true);
            this.myForkCb.setModel(this.getForkModelBasedOnRepeat());
            this.myForkCb.setSelectedItem(selectedItem != "class" ? selectedItem : "method");
        } else if (selectedType == 2 || selectedType == 8) {
            this.myPackagePanel.setVisible(false);
            this.myScopesPanel.setVisible(false);
            this.myPattern.setVisible(false);
            this.myDir.setVisible(false);
            this.myClass.setVisible(true);
            this.myCategory.setVisible(false);
            this.myUniqueIdField.setVisible(false);
            this.myTagsField.setVisible(false);
            this.myMethod.setVisible(true);
            this.myChangeListLabeledComponent.setVisible(false);
            this.myForkCb.setEnabled(false);
            this.myForkCb.setSelectedItem("none");
        } else if (selectedType == 5) {
            this.myPackagePanel.setVisible(false);
            this.myScopesPanel.setVisible(true);
            this.myDir.setVisible(false);
            this.myPattern.setVisible(false);
            this.myClass.setVisible(false);
            this.myCategory.setVisible(true);
            this.myUniqueIdField.setVisible(false);
            this.myTagsField.setVisible(false);
            this.myMethod.setVisible(false);
            this.myChangeListLabeledComponent.setVisible(false);
            this.myForkCb.setEnabled(true);
            this.myForkCb.setModel(new DefaultComboBoxModel<String>(FORK_MODE_ALL));
            this.myForkCb.setSelectedItem(selectedItem);
        } else if (selectedType == 9) {
            this.myPackagePanel.setVisible(false);
            this.myScopesPanel.setVisible(false);
            this.myDir.setVisible(false);
            this.myPattern.setVisible(false);
            this.myClass.setVisible(false);
            this.myCategory.setVisible(false);
            this.myUniqueIdField.setVisible(false);
            this.myTagsField.setVisible(false);
            this.myMethod.setVisible(false);
            this.myChangeListLabeledComponent.setVisible(true);
            this.myForkCb.setEnabled(true);
            this.myForkCb.setModel(new DefaultComboBoxModel<String>(FORK_MODE_ALL));
            this.myForkCb.setSelectedItem(selectedItem);
        } else if (selectedType == 6) {
            this.myPackagePanel.setVisible(false);
            this.myScopesPanel.setVisible(false);
            this.myDir.setVisible(false);
            this.myPattern.setVisible(false);
            this.myClass.setVisible(false);
            this.myCategory.setVisible(false);
            this.myUniqueIdField.setVisible(true);
            this.myTagsField.setVisible(false);
            this.myMethod.setVisible(false);
            this.myChangeListLabeledComponent.setVisible(false);
            this.myForkCb.setEnabled(true);
            this.myForkCb.setModel(new DefaultComboBoxModel<String>(FORK_MODE_ALL));
            this.myForkCb.setSelectedItem(selectedItem);
        } else if (selectedType == 7) {
            this.myPackagePanel.setVisible(false);
            this.myScopesPanel.setVisible(true);
            this.myDir.setVisible(false);
            this.myPattern.setVisible(false);
            this.myClass.setVisible(false);
            this.myCategory.setVisible(false);
            this.myUniqueIdField.setVisible(false);
            this.myTagsField.setVisible(true);
            this.myMethod.setVisible(false);
            this.myChangeListLabeledComponent.setVisible(false);
            this.myForkCb.setEnabled(true);
            this.myForkCb.setModel(new DefaultComboBoxModel<String>(FORK_MODE_ALL));
            this.myForkCb.setSelectedItem(selectedItem);
        } else {
            this.myPackagePanel.setVisible(false);
            this.myScopesPanel.setVisible(true);
            this.myPattern.setVisible(true);
            this.myDir.setVisible(false);
            this.myClass.setVisible(false);
            this.myCategory.setVisible(false);
            this.myUniqueIdField.setVisible(false);
            this.myTagsField.setVisible(false);
            this.myMethod.setVisible(true);
            this.myChangeListLabeledComponent.setVisible(false);
            this.myForkCb.setEnabled(true);
            this.myForkCb.setModel(new DefaultComboBoxModel<String>(FORK_MODE_ALL));
            this.myForkCb.setSelectedItem(selectedItem);
        }
    }

    private DefaultComboBoxModel getForkModelBasedOnRepeat() {
        return new DefaultComboBoxModel<String>("Once".equals(this.myRepeatCb.getSelectedItem()) ? FORK_MODE : FORK_MODE_ALL);
    }

    public ModuleDescriptionsComboBox getModulesComponent() {
        return (ModuleDescriptionsComboBox)this.myModule.getComponent();
    }

    public ConfigurationModuleSelector getModuleSelector() {
        return this.myModuleSelector;
    }

    private void installDocuments() {
        for (int i = 0; i < this.myTestLocations.length; ++i) {
            PlainDocument document;
            TextFieldWithBrowseButton field;
            LabeledComponent testLocation = this.getTestLocation(i);
            JComponent component = testLocation.getComponent();
            if (component instanceof TextFieldWithBrowseButton) {
                field = (TextFieldWithBrowseButton)component;
                document = new PlainDocument();
                field.getTextField().setDocument(document);
            } else if (component instanceof EditorTextFieldWithBrowseButton) {
                field = (EditorTextFieldWithBrowseButton)component;
                document = ((EditorTextField)field.getChildComponent()).getDocument();
            } else {
                field = this.myPatternTextField;
                document = new PlainDocument();
                field.getTextField().setDocument(document);
            }
            this.myBrowsers[i].setField((ComponentWithBrowseButton)field);
            if (this.myBrowsers[i] instanceof MethodBrowser) {
                EditorTextField childComponent = (EditorTextField)field.getChildComponent();
                ((MethodBrowser)this.myBrowsers[i]).installCompletion(childComponent);
                document = childComponent.getDocument();
            }
            this.myModel.setJUnitDocument(i, document);
        }
    }

    public LabeledComponent getTestLocation(int index) {
        return this.myTestLocations[index];
    }

    private void createUIComponents() {
        this.myPackage = new LabeledComponent();
        this.myPackage.setComponent((JComponent)new EditorTextFieldWithBrowseButton(this.myProject, false));
        this.myClass = new LabeledComponent();
        final TestClassBrowser classBrowser = new TestClassBrowser(this.myProject);
        this.myClass.setComponent((JComponent)new EditorTextFieldWithBrowseButton(this.myProject, true, new JavaCodeFragment.VisibilityChecker(){

            public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
                try {
                    if (declaration instanceof PsiClass && (classBrowser.getFilter().isAccepted((PsiClass)declaration) || classBrowser.findClass(((PsiClass)declaration).getQualifiedName()) != null && place.getParent() != null)) {
                        return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
                    }
                }
                catch (ClassBrowser.NoFilterException e) {
                    return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
                }
                return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
            }
        }));
        this.myCategory = new LabeledComponent();
        this.myCategory.setComponent((JComponent)new EditorTextFieldWithBrowseButton(this.myProject, true, new JavaCodeFragment.VisibilityChecker(){

            public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
                if (declaration instanceof PsiClass) {
                    return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
                }
                return JavaCodeFragment.VisibilityChecker.Visibility.NOT_VISIBLE;
            }
        }));
        this.myMethod = new LabeledComponent();
        EditorTextFieldWithBrowseButton textFieldWithBrowseButton = new EditorTextFieldWithBrowseButton(this.myProject, true, JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE, (FileType)PlainTextLanguage.INSTANCE.getAssociatedFileType());
        this.myMethod.setComponent((JComponent)textFieldWithBrowseButton);
        this.myShortenClasspathModeCombo = new LabeledComponent();
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.mySearchForTestsLabel.setAnchor(anchor);
        this.myTestLabel.setAnchor(anchor);
        this.myClass.setAnchor(anchor);
        this.myDir.setAnchor(anchor);
        this.myMethod.setAnchor(anchor);
        this.myPattern.setAnchor(anchor);
        this.myPackage.setAnchor(anchor);
        this.myCategory.setAnchor(anchor);
        this.myUniqueIdField.setAnchor(anchor);
        this.myTagsField.setAnchor(anchor);
        this.myChangeListLabeledComponent.setAnchor(anchor);
    }

    public void onTypeChanged(int newType) {
        this.myTypeChooser.setSelectedItem(newType);
        TIntArrayList enabledFields = ourEnabledFields.size() > newType ? ourEnabledFields.get(newType) : null;
        for (int i = 0; i < this.myTestLocations.length; ++i) {
            this.getTestLocation(i).setEnabled(enabledFields != null && enabledFields.contains(i));
        }
        if (newType != 0 && newType != 3 && newType != 5 && newType != 7 && newType != 6) {
            this.myModule.setEnabled(true);
        } else {
            this.onScopeChanged();
        }
    }

    private void onScopeChanged() {
        Integer selectedItem = (Integer)this.myTypeChooser.getSelectedItem();
        boolean allInPackageAllInProject = (selectedItem == 0 || selectedItem == 3 || selectedItem == 5 || selectedItem == 7 || selectedItem == 6) && this.myWholeProjectScope.isSelected();
        this.myModule.setEnabled(!allInPackageAllInProject);
        if (allInPackageAllInProject) {
            ((ModuleDescriptionsComboBox)this.myModule.getComponent()).setSelectedItem(null);
        }
    }

    private String getClassName() {
        return ((EditorTextFieldWithBrowseButton)this.getTestLocation(1).getComponent()).getText();
    }

    private void setPackage(PsiPackage aPackage) {
        if (aPackage == null) {
            return;
        }
        ((EditorTextFieldWithBrowseButton)this.getTestLocation(0).getComponent()).setText(aPackage.getQualifiedName());
    }

    @NotNull
    public JComponent createEditor() {
        return this.myWholePanel;
    }

    private void applyHelpersTo(JUnitConfiguration currentState) {
        this.myCommonJavaParameters.applyTo((CommonJavaRunConfigurationParameters)currentState);
        this.getModuleSelector().applyTo((ModuleBasedConfiguration)currentState);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JBLabel jBLabel;
        JPanel jPanel;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        LabeledComponent labeledComponent4;
        LabeledComponent labeledComponent5;
        JTextField jTextField;
        JComboBox jComboBox;
        JrePathEditor jrePathEditor;
        LabeledComponent labeledComponent6;
        LabeledComponent labeledComponent7;
        CommonJavaParametersPanel commonJavaParametersPanel;
        JBLabel jBLabel2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myTestLabel = jBLabel2 = new JBLabel();
        jBLabel2.setHorizontalAlignment(2);
        jBLabel2.setHorizontalTextPosition(2);
        jBLabel2.setIconTextGap(4);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/ExecutionBundle", JUnitConfigurable.class).getString("junit.configuration.configure.junit.test.kind.label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)jBLabel2, gridBagConstraints);
        JComboBox jComboBox2 = new JComboBox();
        this.myTypeChooser = jComboBox2;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 10, 0, 0);
        jPanel3.add(jComboBox2, gridBagConstraints2);
        JPanel jPanel4 = new JPanel();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.fill = 2;
        jPanel3.add((Component)jPanel4, gridBagConstraints3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCommonJavaParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel5.add((Component)commonJavaParametersPanel, new GridConstraints(0, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        this.myModule = labeledComponent7 = new LabeledComponent();
        labeledComponent7.setComponentClass("com.intellij.application.options.ModuleDescriptionsComboBox");
        labeledComponent7.setEnabled(true);
        labeledComponent7.setLabelLocation("West");
        labeledComponent7.setText(DynamicBundle.getBundle((String)"messages/ExecutionBundle", JUnitConfigurable.class).getString("application.configuration.use.classpath.and.jdk.of.module.label"));
        jPanel5.add((Component)labeledComponent7, new GridConstraints(2, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myUseModulePath = labeledComponent6 = new LabeledComponent();
        labeledComponent6.setComponentClass("javax.swing.JCheckBox");
        labeledComponent6.setEnabled(true);
        labeledComponent6.setLabelLocation("West");
        labeledComponent6.setText("");
        jPanel5.add((Component)labeledComponent6, new GridConstraints(3, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        LabeledComponent<ShortenCommandLineModeCombo> labeledComponent8 = this.myShortenClasspathModeCombo;
        labeledComponent8.setEnabled(true);
        labeledComponent8.setLabelLocation("West");
        labeledComponent8.setText(DynamicBundle.getBundle((String)"messages/ExecutionBundle", JUnitConfigurable.class).getString("application.configuration.shorten.command.line.label"));
        jPanel5.add((Component)labeledComponent8, new GridConstraints(5, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(1, 0, 1, 2, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(6, 0, 1, 2, 0, 2, 1, 7, null, null, null));
        this.myJrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel5.add((Component)jrePathEditor, new GridConstraints(4, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(0, 1, 1, 1, 1, 1, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JUnitBundle", JUnitConfigurable.class).getString("repeat.label"));
        jPanel6.add((Component)jLabel, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/JUnitBundle", JUnitConfigurable.class).getString("fork.mode.label"));
        jPanel6.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myForkCb = jComboBox = new JComboBox();
        jPanel6.add(jComboBox, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myRepeatCountField = jTextField = new JTextField();
        jTextField.setColumns(3);
        jPanel6.add((Component)jTextField, new GridConstraints(0, 5, 1, 1, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        JComboBox jComboBox3 = new JComboBox();
        this.myRepeatCb = jComboBox3;
        jPanel6.add(jComboBox3, new GridConstraints(0, 4, 1, 1, 8, 1, 2, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel2.add((Component)jSeparator, new GridConstraints(2, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(10, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(1, 0, 1, 2, 1, 1, 3, 3, null, null, null));
        LabeledComponent<EditorTextFieldWithBrowseButton> labeledComponent9 = this.myMethod;
        labeledComponent9.setEnabled(true);
        labeledComponent9.setLabelLocation("West");
        labeledComponent9.setText(DynamicBundle.getBundle((String)"messages/JUnitBundle", JUnitConfigurable.class).getString("junit.configuration.method.label"));
        jPanel7.add((Component)labeledComponent9, new GridConstraints(8, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        this.myPackagePanel = jPanel8;
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        LabeledComponent<EditorTextFieldWithBrowseButton> labeledComponent10 = this.myPackage;
        labeledComponent10.setEnabled(true);
        labeledComponent10.setLabelLocation("West");
        labeledComponent10.setText(DynamicBundle.getBundle((String)"messages/JUnitBundle", JUnitConfigurable.class).getString("junit.configuration.package.label"));
        labeledComponent10.setVisible(true);
        jPanel8.add((Component)labeledComponent10, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myPattern = labeledComponent5 = new LabeledComponent();
        labeledComponent5.setComponentClass("javax.swing.JPanel");
        labeledComponent5.setLabelLocation("West");
        labeledComponent5.setText(DynamicBundle.getBundle((String)"messages/JUnitBundle", JUnitConfigurable.class).getString("pattern.label"));
        labeledComponent5.setVisible(true);
        jPanel7.add((Component)labeledComponent5, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        LabeledComponent<EditorTextFieldWithBrowseButton> labeledComponent11 = this.myClass;
        labeledComponent11.setLabelLocation("West");
        labeledComponent11.setText(DynamicBundle.getBundle((String)"messages/JUnitBundle", JUnitConfigurable.class).getString("junit.configuration.class.label"));
        jPanel7.add((Component)labeledComponent11, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        LabeledComponent<EditorTextFieldWithBrowseButton> labeledComponent12 = this.myCategory;
        labeledComponent12.setLabelLocation("West");
        labeledComponent12.setText(DynamicBundle.getBundle((String)"messages/JUnitBundle", JUnitConfigurable.class).getString("category.label"));
        jPanel7.add((Component)labeledComponent12, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myUniqueIdField = labeledComponent4 = new LabeledComponent();
        labeledComponent4.setComponentClass("com.intellij.ui.RawCommandLineEditor");
        labeledComponent4.setLabelLocation("West");
        labeledComponent4.setText(DynamicBundle.getBundle((String)"messages/JUnitBundle", JUnitConfigurable.class).getString("uniqueid.label"));
        jPanel7.add((Component)labeledComponent4, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDir = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/JUnitBundle", JUnitConfigurable.class).getString("directory.label"));
        jPanel7.add((Component)labeledComponent3, new GridConstraints(6, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myChangeListLabeledComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("javax.swing.JComboBox");
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/JUnitBundle", JUnitConfigurable.class).getString("change.list.label"));
        jPanel7.add((Component)labeledComponent2, new GridConstraints(7, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myScopesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel, new GridConstraints(9, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySearchForTestsLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/JUnitBundle", JUnitConfigurable.class).getString("junit.configuration.search.for.tests.label"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWholeProjectScope = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/JUnitBundle", JUnitConfigurable.class).getString("junit.configuration.in.whole.project.radio"));
        jPanel.add((Component)jRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySingleModuleScope = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/JUnitBundle", JUnitConfigurable.class).getString("junit.configuration.in.single.module.radio"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myModuleWDScope = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/JUnitBundle", JUnitConfigurable.class).getString("junit.configuration.across.module.dependencies.radio"));
        jPanel.add((Component)jRadioButton, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTagsField = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.ui.RawCommandLineEditor");
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/JUnitBundle", JUnitConfigurable.class).getString("tag.expression.label"));
        jPanel7.add((Component)labeledComponent, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        jBLabel2.setLabelFor(jComboBox2);
        jLabel.setLabelFor(jComboBox3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class CategoryBrowser
    extends ClassBrowser {
        CategoryBrowser(Project project) {
            super(project, "Category Interface");
        }

        protected PsiClass findClass(String className) {
            return JUnitConfigurable.this.myModuleSelector.findClass(className);
        }

        protected ClassFilter.ClassFilterWithScope getFilter() throws ClassBrowser.NoFilterException {
            Module module = JUnitConfigurable.this.myModuleSelector.getModule();
            final GlobalSearchScope scope = module == null ? GlobalSearchScope.allScope((Project)JUnitConfigurable.this.myProject) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            return new ClassFilter.ClassFilterWithScope(){

                public GlobalSearchScope getScope() {
                    return scope;
                }

                public boolean isAccepted(PsiClass aClass) {
                    return true;
                }
            };
        }

        protected void onClassChosen(@NotNull PsiClass psiClass) {
            ((EditorTextFieldWithBrowseButton)JUnitConfigurable.this.getTestLocation(5).getComponent()).setText(psiClass.getQualifiedName());
        }
    }

    private class TestClassBrowser
    extends ClassBrowser {
        TestClassBrowser(Project project) {
            super(project, ExecutionBundle.message((String)"choose.test.class.dialog.title", (Object[])new Object[0]));
        }

        protected void onClassChosen(@NotNull PsiClass psiClass) {
            JUnitConfigurable.this.setPackage(JUnitUtil.getContainingPackage((PsiClass)psiClass));
        }

        protected PsiClass findClass(String className) {
            return JUnitConfigurable.this.getModuleSelector().findClass(className);
        }

        protected ClassFilter.ClassFilterWithScope getFilter() throws ClassBrowser.NoFilterException {
            TestClassFilter classFilter;
            ConfigurationModuleSelector moduleSelector = JUnitConfigurable.this.getModuleSelector();
            Module module = moduleSelector.getModule();
            if (module == null) {
                Project project = moduleSelector.getProject();
                String moduleName = moduleSelector.getModuleName();
                throw new ClassBrowser.NoFilterException(new MessagesEx.MessageInfo(project, moduleName.isEmpty() ? "No module selected" : JUnitBundle.message("module.does.not.exists", moduleName, project.getName()), JUnitBundle.message("cannot.browse.test.inheritors.dialog.title", new Object[0])));
            }
            try {
                JUnitConfiguration configurationCopy = new JUnitConfiguration(JUnitBundle.message("default.junit.configuration.name", new Object[0]), this.getProject());
                JUnitConfigurable.this.applyEditorTo(configurationCopy);
                SourceScope sourceScope = SourceScope.modulesWithDependencies((Module[])configurationCopy.getModules());
                final GlobalSearchScope globalSearchScope = sourceScope.getGlobalSearchScope();
                if (JUnitUtil.isJUnit5((GlobalSearchScope)globalSearchScope, (Project)this.getProject())) {
                    return new ClassFilter.ClassFilterWithScope(){

                        public GlobalSearchScope getScope() {
                            return globalSearchScope;
                        }

                        public boolean isAccepted(PsiClass aClass) {
                            return JUnitUtil.isTestClass((PsiClass)aClass, (boolean)true, (boolean)true);
                        }
                    };
                }
                classFilter = TestClassFilter.create(sourceScope, ((JavaRunConfigurationModule)configurationCopy.getConfigurationModule()).getModule());
            }
            catch (JUnitUtil.NoJUnitException e) {
                throw new ClassBrowser.NoFilterException(new MessagesEx.MessageInfo(module.getProject(), JUnitBundle.message("junit.not.found.in.module.error.message", module.getName()), JUnitBundle.message("cannot.browse.test.inheritors.dialog.title", new Object[0])));
            }
            return classFilter;
        }
    }

    private class TestsChooserActionListener
    extends TestClassBrowser {
        TestsChooserActionListener(Project project) {
            super(project);
        }

        @Override
        protected void onClassChosen(@NotNull PsiClass psiClass) {
            JTextField textField = JUnitConfigurable.this.myPatternTextField.getTextField();
            String text = textField.getText();
            textField.setText(text + (text.length() > 0 ? "||" : "") + psiClass.getQualifiedName());
        }

        @Override
        protected ClassFilter.ClassFilterWithScope getFilter() throws ClassBrowser.NoFilterException {
            try {
                return TestClassFilter.create(SourceScope.wholeProject((Project)this.getProject()), null);
            }
            catch (JUnitUtil.NoJUnitException e) {
                throw new ClassBrowser.NoFilterException(new MessagesEx.MessageInfo(this.getProject(), e.getMessage(), JUnitBundle.message("cannot.browse.test.inheritors.dialog.title", new Object[0])));
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.showDialog();
        }
    }

    private static class PackageChooserActionListener
    extends BrowseModuleValueActionListener {
        PackageChooserActionListener(Project project) {
            super(project);
        }

        protected String showDialog() {
            PackageChooserDialog dialog = new PackageChooserDialog(ExecutionBundle.message((String)"choose.package.dialog.title", (Object[])new Object[0]), this.getProject());
            dialog.show();
            PsiPackage aPackage = dialog.getSelectedPackage();
            return aPackage != null ? aPackage.getQualifiedName() : null;
        }
    }
}

