/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.util.HgUtil;

public final class HgErrorUtil {
    private static final Logger LOG = Logger.getInstance((String)HgErrorUtil.class.getName());
    private static final String MERGE_WITH_ANCESTOR_ERROR = "merging with a working directory ancestor has no effect";
    private static final String NOTHING_TO_REBASE_WARNING = "nothing to rebase";

    private HgErrorUtil() {
    }

    public static HgCommandResult ensureSuccess(@Nullable HgCommandResult result) throws VcsException {
        if (result == null) {
            throw new VcsException("Couldn't execute Mercurial command");
        }
        if (HgErrorUtil.fatalErrorOccurred(result) && !HgErrorUtil.isAncestorMergeError(result)) {
            throw new VcsException(result.getRawError());
        }
        return result;
    }

    private static boolean fatalErrorOccurred(@NotNull HgCommandResult result) {
        return result.getExitValue() == 255 || result.getRawError().contains("** unknown exception encountered");
    }

    public static boolean isAbort(@Nullable HgCommandResult result) {
        return result == null || HgErrorUtil.getAbortLine(result) != null;
    }

    @Nullable
    private static String getAbortLine(@NotNull HgCommandResult result) {
        List<String> errorLines = result.getErrorLines();
        return (String)ContainerUtil.find(errorLines, s -> HgErrorUtil.isAbortLine(s));
    }

    public static boolean isAncestorMergeError(@Nullable HgCommandResult result) {
        if (result == null) {
            return false;
        }
        String errorLine = HgErrorUtil.getAbortLine(result);
        return errorLine != null && StringUtil.contains((CharSequence)errorLine, (CharSequence)MERGE_WITH_ANCESTOR_ERROR);
    }

    public static boolean isNothingToRebase(@Nullable HgCommandResult result) {
        if (result == null) {
            return false;
        }
        return ContainerUtil.exists(result.getOutputLines(), s -> StringUtil.contains((CharSequence)s, (CharSequence)NOTHING_TO_REBASE_WARNING));
    }

    public static boolean isAuthorizationError(@Nullable HgCommandResult result) {
        if (result == null) {
            return false;
        }
        String line = HgErrorUtil.getLastErrorLine(result);
        return HgErrorUtil.isAuthorizationError(line);
    }

    @Nullable
    private static String getLastErrorLine(@Nullable HgCommandResult result) {
        if (result == null) {
            return null;
        }
        List<String> errorLines = result.getErrorLines();
        if (errorLines.isEmpty()) {
            return null;
        }
        return errorLines.get(errorLines.size() - 1);
    }

    public static boolean hasErrorsInCommandExecution(@Nullable HgCommandResult result) {
        return HgErrorUtil.isAbort(result) || result.getExitValue() != 0;
    }

    public static boolean isCommandExecutionFailed(@Nullable HgCommandResult result) {
        return HgErrorUtil.isAbort(result) || result.getExitValue() > 1;
    }

    public static boolean hasAuthorizationInDestinationPath(@Nullable String destinationPath) {
        if (StringUtil.isEmptyOrSpaces((String)destinationPath)) {
            return false;
        }
        return HgUtil.URL_WITH_PASSWORD.matcher(destinationPath).matches();
    }

    public static boolean isUnknownEncodingError(@NotNull List<String> errorLines) {
        if (errorLines.isEmpty()) {
            return false;
        }
        String line = errorLines.get(0);
        return !StringUtil.isEmptyOrSpaces((String)line) && line.contains("abort") && line.contains("unknown encoding");
    }

    public static boolean hasUncommittedChangesConflict(@Nullable HgCommandResult result) {
        if (result == null) {
            return false;
        }
        Pattern UNCOMMITTED_PATTERN = Pattern.compile(".*abort.*uncommitted\\s*(change|merge).*", 32);
        Matcher matcher = UNCOMMITTED_PATTERN.matcher(result.getRawError());
        return matcher.matches();
    }

    public static boolean isAuthorizationError(String line) {
        return !StringUtil.isEmptyOrSpaces((String)line) && (line.contains("authorization required") || line.contains("authorization failed"));
    }

    public static boolean isAbortLine(String line) {
        return !StringUtil.isEmptyOrSpaces((String)line) && line.trim().startsWith("abort:");
    }

    public static void handleException(@Nullable Project project, @NotNull Exception e) {
        HgErrorUtil.handleException(project, "Error", e);
    }

    public static void handleException(@Nullable Project project, @NotNull String title, @NotNull Exception e) {
        LOG.info((Throwable)e);
        new HgCommandResultNotifier(project).notifyError(null, title, e.getMessage());
    }

    @Deprecated
    public static void markDirtyAndHandleErrors(Project project, VirtualFile repository) {
        HgUtil.markDirectoryDirty(project, repository);
    }

    public static boolean isWLockError(@Nullable HgCommandResult result) {
        if (result == null) {
            return false;
        }
        return HgErrorUtil.isAbort(result) && result.getRawError().contains("waiting for lock");
    }
}

