/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.provider.update.HgUpdateConfigurationSettings;
import org.zmlx.hg4idea.provider.update.HgUpdateType;

public class HgUpdateDialog {
    private final JComponent myContentPanel = this.createCenterPanel();
    private JCheckBox myPullCheckBox;
    private JCheckBox myCommitAfterMergeCheckBox;
    private JRadioButton myOnlyUpdateButton;
    private JRadioButton myMergeRadioButton;
    private JRadioButton myRebaseRadioButton;

    @NotNull
    public JComponent getContentPanel() {
        return this.myContentPanel;
    }

    private void updateEnabledStates() {
        this.myCommitAfterMergeCheckBox.setEnabled(this.myMergeRadioButton.isSelected());
    }

    public void applyTo(@NotNull HgUpdateConfigurationSettings updateConfiguration) {
        updateConfiguration.setShouldPull(this.myPullCheckBox.isSelected());
        if (this.myOnlyUpdateButton.isSelected()) {
            updateConfiguration.setUpdateType(HgUpdateType.ONLY_UPDATE);
        }
        if (this.myMergeRadioButton.isSelected()) {
            updateConfiguration.setUpdateType(HgUpdateType.MERGE);
        }
        if (this.myRebaseRadioButton.isSelected()) {
            updateConfiguration.setUpdateType(HgUpdateType.REBASE);
        }
        updateConfiguration.setShouldCommitAfterMerge(this.myCommitAfterMergeCheckBox.isSelected());
    }

    @NotNull
    public JComponent createCenterPanel() {
        String panelConstraints = "flowy, ins 0 0 0 10, fill";
        MigLayout migLayout = new MigLayout(panelConstraints);
        JPanel contentPane = new JPanel((LayoutManager)migLayout);
        this.myPullCheckBox = new JBCheckBox(HgBundle.message("action.hg4idea.pull.p", new Object[0]), true);
        this.myPullCheckBox.setToolTipText(HgBundle.message("action.hg4idea.pull.from.default.remote", new Object[0]));
        this.myPullCheckBox.setSelected(true);
        this.myOnlyUpdateButton = new JRadioButton(HgBundle.message("action.hg4idea.pull.only.update", new Object[0]), true);
        this.myOnlyUpdateButton.setToolTipText(HgBundle.message("action.hg4idea.pull.update.to.head", new Object[0]));
        this.myMergeRadioButton = new JRadioButton(HgBundle.message("action.hg4idea.pull.update.merge", new Object[0]), false);
        this.myMergeRadioButton.setToolTipText(HgBundle.message("action.hg4idea.pull.merge.if.in.extra", new Object[0]));
        this.myMergeRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                HgUpdateDialog.this.updateEnabledStates();
            }
        });
        this.myCommitAfterMergeCheckBox = new JCheckBox(HgBundle.message("action.hg4idea.pull.commit.after.merge", new Object[0]), false);
        this.myCommitAfterMergeCheckBox.setToolTipText(HgBundle.message("action.hg4idea.pull.commit.automatically", new Object[0]));
        this.myCommitAfterMergeCheckBox.setSelected(false);
        this.myRebaseRadioButton = new JRadioButton(HgBundle.message("action.hg4idea.pull.rebase", new Object[0]), false);
        this.myRebaseRadioButton.setToolTipText(HgBundle.message("action.hg4idea.pull.rebase.tooltip", new Object[0]));
        contentPane.add((Component)this.myPullCheckBox, "left");
        JPanel strategyPanel = new JPanel((LayoutManager)new MigLayout(panelConstraints));
        strategyPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)HgBundle.message("action.hg4idea.pull.update.strategy", new Object[0]), (boolean)false));
        strategyPanel.add((Component)this.myOnlyUpdateButton, "left");
        strategyPanel.add((Component)this.myMergeRadioButton, "left");
        strategyPanel.add((Component)this.myCommitAfterMergeCheckBox, "gapx 5%");
        strategyPanel.add((Component)this.myRebaseRadioButton, "left");
        contentPane.add(strategyPanel);
        ButtonGroup group = new ButtonGroup();
        group.add(this.myOnlyUpdateButton);
        group.add(this.myRebaseRadioButton);
        group.add(this.myMergeRadioButton);
        this.updateEnabledStates();
        return contentPane;
    }

    public void updateFrom(@NotNull HgUpdateConfigurationSettings updateConfiguration) {
        this.myPullCheckBox.setSelected(updateConfiguration.shouldPull());
        HgUpdateType updateType = updateConfiguration.getUpdateType();
        switch (updateType) {
            case ONLY_UPDATE: {
                this.myOnlyUpdateButton.setSelected(true);
                break;
            }
            case MERGE: {
                this.myMergeRadioButton.setSelected(true);
                break;
            }
            case REBASE: {
                this.myRebaseRadioButton.setSelected(true);
                break;
            }
            default: {
                assert (false) : "Unknown value of update type: " + (Object)((Object)updateType);
                break;
            }
        }
        this.myCommitAfterMergeCheckBox.setSelected(updateConfiguration.shouldCommitAfterMerge());
    }
}

