/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.VcsExecutablePathSelector;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.util.Objects;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgExecutableManager;
import org.zmlx.hg4idea.HgGlobalSettings;
import org.zmlx.hg4idea.HgProjectConfigurable;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgVersion;

public class HgConfigurationProjectPanel
implements ConfigurableUi<HgProjectConfigurable.HgSettingsHolder>,
Disposable {
    private final BorderLayoutPanel myMainPanel;
    private final VcsExecutablePathSelector myExecutablePathSelector;
    private final JBCheckBox myCheckIncomingOutgoingCbx;
    private final JBCheckBox myIgnoredWhitespacesInAnnotationsCbx;
    private final JBCheckBox mySyncControl;
    @NotNull
    private final Project myProject;

    public HgConfigurationProjectPanel(@NotNull Project project) {
        this.myProject = project;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.myExecutablePathSelector = new VcsExecutablePathSelector("Mercurial", (Disposable)this, this::testExecutable);
        panel.add(this.myExecutablePathSelector.getMainPanel());
        this.myCheckIncomingOutgoingCbx = new JBCheckBox(HgBundle.message("hg4idea.configuration.check.incoming.outgoing", new Object[0]));
        panel.add(UI.PanelFactory.panel((JComponent)this.myCheckIncomingOutgoingCbx).createPanel());
        this.myIgnoredWhitespacesInAnnotationsCbx = new JBCheckBox(HgBundle.message("hg4idea.configuration.ignore.whitespace.in.annotate", new Object[0]));
        panel.add(UI.PanelFactory.panel((JComponent)this.myIgnoredWhitespacesInAnnotationsCbx).createPanel());
        this.mySyncControl = new JBCheckBox(DvcsBundle.getString((String)"sync.setting"));
        JPanel mySyncControlPanel = Objects.requireNonNull(UI.PanelFactory.panel((JComponent)this.mySyncControl).withTooltip(DvcsBundle.message((String)"sync.setting.description", (Object[])new Object[]{"Mercurial"})).createPanel());
        if (!project.isDefault()) {
            HgRepositoryManager repositoryManager = (HgRepositoryManager)((Object)ServiceManager.getService((Project)project, HgRepositoryManager.class));
            mySyncControlPanel.setVisible(repositoryManager != null && repositoryManager.moreThanOneRoot());
        } else {
            mySyncControlPanel.setVisible(true);
        }
        panel.add(mySyncControlPanel);
        this.myMainPanel = JBUI.Panels.simplePanel();
        this.myMainPanel.addToTop((Component)panel);
    }

    public void dispose() {
    }

    private void testExecutable(final @NotNull String executable) {
        new Task.Modal(this.myProject, HgBundle.message("hg4idea.configuration.identifying.version", new Object[0]), true){
            HgVersion version;

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    this.version = HgVersion.identifyVersion(executable);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void onSuccess() {
                Messages.showInfoMessage((Component)HgConfigurationProjectPanel.this.myMainPanel, (String)HgBundle.message("hg4idea.configuration.version", this.version.toString()), (String)HgBundle.message("hg4idea.run.success.title", new Object[0]));
            }

            public void onThrowable(@NotNull Throwable error) {
                Messages.showErrorDialog((Component)HgConfigurationProjectPanel.this.myMainPanel, (String)error.getCause().getMessage(), (String)HgBundle.message("hg4idea.run.failed.title", new Object[0]));
            }
        }.queue();
    }

    public void reset(@NotNull HgProjectConfigurable.HgSettingsHolder settings) {
        HgProjectSettings projectSettings = settings.getProjectSettings();
        this.myExecutablePathSelector.reset(settings.getGlobalSettings().getHgExecutable(), projectSettings.isHgExecutableOverridden(), projectSettings.getHgExecutable(), HgExecutableManager.getInstance().getDefaultExecutable());
        this.myCheckIncomingOutgoingCbx.setSelected(projectSettings.isCheckIncomingOutgoing());
        this.myIgnoredWhitespacesInAnnotationsCbx.setSelected(projectSettings.isWhitespacesIgnoredInAnnotations());
        this.mySyncControl.setSelected(projectSettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC);
    }

    public boolean isModified(@NotNull HgProjectConfigurable.HgSettingsHolder settings) {
        HgProjectSettings projectSettings = settings.getProjectSettings();
        return this.myExecutablePathSelector.isModified(settings.getGlobalSettings().getHgExecutable(), projectSettings.isHgExecutableOverridden(), projectSettings.getHgExecutable()) || this.myCheckIncomingOutgoingCbx.isSelected() != projectSettings.isCheckIncomingOutgoing() || projectSettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC != this.mySyncControl.isSelected() || this.myIgnoredWhitespacesInAnnotationsCbx.isSelected() != projectSettings.isWhitespacesIgnoredInAnnotations();
    }

    public void apply(@NotNull HgProjectConfigurable.HgSettingsHolder settings) {
        HgGlobalSettings globalSettings = settings.getGlobalSettings();
        HgProjectSettings projectSettings = settings.getProjectSettings();
        boolean executablePathOverridden = this.myExecutablePathSelector.isOverridden();
        projectSettings.setHgExecutableOverridden(executablePathOverridden);
        if (executablePathOverridden) {
            projectSettings.setHgExecutable(this.myExecutablePathSelector.getCurrentPath());
        } else {
            globalSettings.setHgExecutable(this.myExecutablePathSelector.getCurrentPath());
            projectSettings.setHgExecutable(null);
        }
        projectSettings.setCheckIncomingOutgoing(this.myCheckIncomingOutgoingCbx.isSelected());
        projectSettings.setIgnoreWhitespacesInAnnotations(this.myIgnoredWhitespacesInAnnotationsCbx.isSelected());
        projectSettings.setSyncSetting(this.mySyncControl.isSelected() ? DvcsSyncSettings.Value.SYNC : DvcsSyncSettings.Value.DONT_SYNC);
        Objects.requireNonNull(HgVcs.getInstance(this.myProject)).checkVersion();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myMainPanel;
    }
}

