/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.push;

import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgPushCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.push.HgPushSource;
import org.zmlx.hg4idea.push.HgTarget;
import org.zmlx.hg4idea.push.HgVcsPushOptionValue;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgPusher
extends Pusher<HgRepository, HgPushSource, HgTarget> {
    private static final Logger LOG = Logger.getInstance(HgPusher.class);
    private static final String ONE = "one";
    private static final Pattern PUSH_COMMITS_PATTERN = Pattern.compile(".*(?:added|pushed) (\\d+|one) changeset.*");
    static int PUSH_SUCCEEDED_EXIT_VALUE = 0;
    static int NOTHING_TO_PUSH_EXIT_VALUE = 1;

    public void push(@NotNull Map<HgRepository, PushSpec<HgPushSource, HgTarget>> pushSpecs, @Nullable VcsPushOptionValue vcsPushOptionValue, boolean force) {
        for (Map.Entry<HgRepository, PushSpec<HgPushSource, HgTarget>> entry : pushSpecs.entrySet()) {
            HgRepository repository = entry.getKey();
            PushSpec<HgPushSource, HgTarget> hgSpec = entry.getValue();
            HgTarget destination = (HgTarget)hgSpec.getTarget();
            HgPushSource source = (HgPushSource)hgSpec.getSource();
            Project project = repository.getProject();
            HgPushCommand pushCommand = new HgPushCommand(project, repository.getRoot(), destination.myTarget);
            pushCommand.setIsNewBranch(true);
            pushCommand.setForce(force);
            String branchName = source.getBranch();
            if (branchName.equals(repository.getCurrentBookmark())) {
                if (vcsPushOptionValue == HgVcsPushOptionValue.Current) {
                    pushCommand.setBookmarkName(branchName);
                } else {
                    pushCommand.setRevision(branchName);
                }
            } else {
                pushCommand.setBranchName(branchName);
            }
            HgPusher.pushSynchronously(project, pushCommand);
        }
    }

    public static void pushSynchronously(@NotNull Project project, @NotNull HgPushCommand command) {
        VirtualFile repo = command.getRepo();
        HgCommandResult result = command.executeInCurrentThread();
        if (result == null) {
            return;
        }
        if (result.getExitValue() == PUSH_SUCCEEDED_EXIT_VALUE) {
            int commitsNum = HgPusher.getNumberOfPushedCommits(result);
            String successTitle = HgBundle.message("action.hg4idea.push.success", new Object[0]);
            String successDescription = HgBundle.message("action.hg4idea.push.success.msg", commitsNum, repo.getPresentableName());
            VcsNotifier.getInstance((Project)project).notifySuccess(successTitle, successDescription);
        } else if (result.getExitValue() == NOTHING_TO_PUSH_EXIT_VALUE) {
            VcsNotifier.getInstance((Project)project).notifySuccess(HgBundle.message("action.hg4idea.push.nothing", new Object[0]));
        } else {
            new HgCommandResultNotifier(project).notifyError(result, HgBundle.message("action.hg4idea.push.error", new Object[0]), HgBundle.message("action.hg4idea.push.error.msg", repo.getPresentableName()));
        }
    }

    static int getNumberOfPushedCommits(@NotNull HgCommandResult result) {
        int numberOfCommitsInAllSubrepos = 0;
        List<String> outputLines = result.getOutputLines();
        for (String outputLine : outputLines) {
            Matcher matcher = PUSH_COMMITS_PATTERN.matcher(outputLine = outputLine.trim());
            if (!matcher.matches()) continue;
            try {
                String numberOfCommits = matcher.group(1);
                numberOfCommitsInAllSubrepos += ONE.equals(numberOfCommits) ? 1 : Integer.parseInt(numberOfCommits);
            }
            catch (NumberFormatException e) {
                LOG.error("getNumberOfPushedCommits ", (Throwable)e);
                return -1;
            }
        }
        return numberOfCommitsInAllSubrepos;
    }
}

