/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgExecutableManager;
import org.zmlx.hg4idea.HgExecutableValidator;
import org.zmlx.hg4idea.HgProjectConfigurable;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVFSListener;
import org.zmlx.hg4idea.provider.HgChangeProvider;
import org.zmlx.hg4idea.provider.HgCheckoutProvider;
import org.zmlx.hg4idea.provider.HgCommittedChangesProvider;
import org.zmlx.hg4idea.provider.HgDiffProvider;
import org.zmlx.hg4idea.provider.HgHistoryProvider;
import org.zmlx.hg4idea.provider.HgMergeProvider;
import org.zmlx.hg4idea.provider.HgRollbackEnvironment;
import org.zmlx.hg4idea.provider.annotate.HgAnnotationProvider;
import org.zmlx.hg4idea.provider.commit.HgCheckinEnvironment;
import org.zmlx.hg4idea.provider.commit.HgCloseBranchExecutor;
import org.zmlx.hg4idea.provider.commit.HgCommitAndPushExecutor;
import org.zmlx.hg4idea.provider.commit.HgMQNewExecutor;
import org.zmlx.hg4idea.provider.update.HgUpdateEnvironment;
import org.zmlx.hg4idea.roots.HgIntegrationEnabler;
import org.zmlx.hg4idea.status.HgRemoteStatusUpdater;
import org.zmlx.hg4idea.status.ui.HgWidgetUpdater;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public class HgVcs
extends AbstractVcs {
    public static final Topic<HgUpdater> REMOTE_TOPIC = new Topic("hg4idea.remote", HgUpdater.class);
    public static final Topic<HgUpdater> STATUS_TOPIC = new Topic("hg4idea.status", HgUpdater.class);
    public static final Topic<HgWidgetUpdater> INCOMING_OUTGOING_CHECK_TOPIC = new Topic("hg4idea.incomingcheck", HgWidgetUpdater.class);
    private static final Logger LOG = Logger.getInstance(HgVcs.class);
    public static final String VCS_NAME = "hg4idea";
    public static final String DISPLAY_NAME = "Mercurial";
    private static final VcsKey ourKey = HgVcs.createKey((String)"hg4idea");
    private static final int MAX_CONSOLE_OUTPUT_SIZE = 10000;
    private static final String ORIG_FILE_PATTERN = "*.orig";
    @Nullable
    public static final String HGENCODING = System.getenv("HGENCODING");
    private final HgChangeProvider changeProvider;
    private final HgRollbackEnvironment rollbackEnvironment;
    private final HgDiffProvider diffProvider;
    private final HgHistoryProvider historyProvider;
    private final HgCheckinEnvironment checkinEnvironment;
    private final HgAnnotationProvider annotationProvider;
    private final HgUpdateEnvironment updateEnvironment;
    private final HgCommittedChangesProvider committedChangesProvider;
    private final ProjectLevelVcsManager myVcsManager;
    private HgVFSListener myVFSListener;
    private final HgMergeProvider myMergeProvider;
    private HgExecutableValidator myExecutableValidator;
    private final Object myExecutableValidatorLock = new Object();
    private File myPromptHooksExtensionFile;
    private final CommitExecutor myCommitAndPushExecutor;
    private final CommitExecutor myMqNewExecutor;
    private final HgCloseBranchExecutor myCloseBranchExecutor;
    private HgRemoteStatusUpdater myHgRemoteStatusUpdater;
    @NotNull
    private HgVersion myVersion = HgVersion.NULL;

    public HgVcs(@NotNull Project project) {
        super(project, VCS_NAME);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.changeProvider = new HgChangeProvider(project, this.getKeyInstanceMethod());
        this.rollbackEnvironment = new HgRollbackEnvironment(project);
        this.diffProvider = new HgDiffProvider(project);
        this.historyProvider = new HgHistoryProvider(project);
        this.checkinEnvironment = new HgCheckinEnvironment(this);
        this.annotationProvider = new HgAnnotationProvider(project);
        this.updateEnvironment = new HgUpdateEnvironment(project);
        this.committedChangesProvider = new HgCommittedChangesProvider(project, this);
        this.myMergeProvider = new HgMergeProvider(this.myProject);
        this.myCommitAndPushExecutor = new HgCommitAndPushExecutor();
        this.myMqNewExecutor = new HgMQNewExecutor();
        this.myCloseBranchExecutor = new HgCloseBranchExecutor();
    }

    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @NotNull
    public String getShortName() {
        return "Hg";
    }

    public Configurable getConfigurable() {
        return new HgProjectConfigurable(this.myProject);
    }

    @NotNull
    public HgProjectSettings getProjectSettings() {
        return HgProjectSettings.getInstance(this.myProject);
    }

    public ChangeProvider getChangeProvider() {
        return this.changeProvider;
    }

    @Nullable
    public RollbackEnvironment createRollbackEnvironment() {
        return this.rollbackEnvironment;
    }

    public DiffProvider getDiffProvider() {
        return this.diffProvider;
    }

    public VcsHistoryProvider getVcsHistoryProvider() {
        return this.historyProvider;
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.getVcsHistoryProvider();
    }

    @Nullable
    public CheckinEnvironment createCheckinEnvironment() {
        return this.checkinEnvironment;
    }

    public AnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    public MergeProvider getMergeProvider() {
        return this.myMergeProvider;
    }

    @Nullable
    public UpdateEnvironment createUpdateEnvironment() {
        return this.updateEnvironment;
    }

    public UpdateEnvironment getIntegrateEnvironment() {
        return null;
    }

    public boolean fileListenerIsSynchronous() {
        return false;
    }

    public CommittedChangesProvider getCommittedChangesProvider() {
        return this.committedChangesProvider;
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return HgUtil.getNearestHgRoot(dir) != null;
    }

    @NotNull
    public File getPromptHooksExtensionFile() {
        if (this.myPromptHooksExtensionFile == null || !this.myPromptHooksExtensionFile.exists()) {
            this.myPromptHooksExtensionFile = HgUtil.getTemporaryPythonFile("prompthooks");
            if (this.myPromptHooksExtensionFile == null || !this.myPromptHooksExtensionFile.exists()) {
                LOG.error("prompthooks.py Mercurial extension is not found. Please reinstall " + ApplicationNamesInfo.getInstance().getProductName());
            }
        }
        return this.myPromptHooksExtensionFile;
    }

    public void activate() {
        this.checkExecutableAndVersion();
        this.myHgRemoteStatusUpdater = new HgRemoteStatusUpdater(this);
        this.myVFSListener = HgVFSListener.createInstance(this);
        String ignoredPattern = FileTypeManager.getInstance().getIgnoredFilesList();
        if (!ignoredPattern.contains(ORIG_FILE_PATTERN)) {
            String newPattern = ignoredPattern + (ignoredPattern.endsWith(";") ? "" : ";") + ORIG_FILE_PATTERN;
            HgUtil.runWriteActionLater(() -> FileTypeManager.getInstance().setIgnoredFilesList(newPattern));
        }
    }

    private void checkExecutableAndVersion() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.getExecutableValidator().checkExecutableAndNotifyIfNeeded()) {
            this.checkVersion();
        }
    }

    public void deactivate() {
        if (this.myHgRemoteStatusUpdater != null) {
            Disposer.dispose((Disposable)this.myHgRemoteStatusUpdater);
            this.myHgRemoteStatusUpdater = null;
        }
        if (this.myVFSListener != null) {
            Disposer.dispose((Disposable)this.myVFSListener);
            this.myVFSListener = null;
        }
        super.deactivate();
    }

    @Nullable
    public static HgVcs getInstance(Project project) {
        if (project == null || project.isDisposed()) {
            return null;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        if (vcsManager == null) {
            return null;
        }
        return (HgVcs)vcsManager.findVcsByName(VCS_NAME);
    }

    public void showMessageInConsole(@NotNull String message, @NotNull ConsoleViewContentType contentType) {
        if (message.length() > 10000) {
            message = message.substring(0, 10000);
        }
        this.myVcsManager.addMessageToConsoleWindow(message, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HgExecutableValidator getExecutableValidator() {
        Object object = this.myExecutableValidatorLock;
        synchronized (object) {
            if (this.myExecutableValidator == null) {
                this.myExecutableValidator = new HgExecutableValidator(this.myProject);
            }
            return this.myExecutableValidator;
        }
    }

    public List<CommitExecutor> getCommitExecutors() {
        ArrayList commitExecutors = ContainerUtil.newArrayList((Object[])new CommitExecutor[]{this.myCommitAndPushExecutor});
        if (ContainerUtil.exists(HgUtil.getRepositoryManager(this.myProject).getRepositories(), r -> r.getRepositoryConfig().isMqUsed())) {
            commitExecutors.add(this.myMqNewExecutor);
        }
        return commitExecutors;
    }

    @NotNull
    public HgCloseBranchExecutor getCloseBranchExecutor() {
        return this.myCloseBranchExecutor;
    }

    @Nullable
    public HgRemoteStatusUpdater getRemoteStatusUpdater() {
        return this.myHgRemoteStatusUpdater;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public VcsType getType() {
        return VcsType.distributed;
    }

    public void enableIntegration() {
        new Task.Backgroundable(this.myProject, HgBundle.message("progress.title.enabling.hg", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                Collection roots = ((VcsRootDetector)ServiceManager.getService((Project)this.myProject, VcsRootDetector.class)).detect();
                new HgIntegrationEnabler(HgVcs.this).enable(roots);
            }
        }.queue();
    }

    public CheckoutProvider getCheckoutProvider() {
        return new HgCheckoutProvider();
    }

    public void checkVersion() {
        block5: {
            String executable = HgExecutableManager.getInstance().getHgExecutable(this.myProject);
            VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.myProject);
            String SETTINGS_LINK = "settings";
            String UPDATE_LINK = "update";
            NotificationListener.Adapter linkAdapter = new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if ("settings".equals(e.getDescription())) {
                        ShowSettingsUtil.getInstance().showSettingsDialog(HgVcs.this.myProject, HgVcs.this.getConfigurable().getDisplayName());
                    } else if ("update".equals(e.getDescription())) {
                        BrowserUtil.browse((String)"http://mercurial.selenic.com");
                    }
                }
            };
            try {
                this.myVersion = HgVersion.identifyVersion(executable);
                if (!this.myVersion.isSupported()) {
                    LOG.info("Unsupported Hg version: " + this.myVersion);
                    String message = HgBundle.message("hg4idea.version.update", "settings", this.myVersion, HgVersion.MIN, "update");
                    vcsNotifier.notifyError(HgBundle.message("hg4idea.version.unsupported", new Object[0]), message, (NotificationListener)linkAdapter);
                } else if (this.myVersion.hasUnsupportedExtensions()) {
                    String unsupportedExtensionsAsString = this.myVersion.getUnsupportedExtensions().toString();
                    LOG.warn("Unsupported Hg extensions: " + unsupportedExtensionsAsString);
                    String message = HgBundle.message("hg4idea.version.unsupported.ext", unsupportedExtensionsAsString);
                    vcsNotifier.notifyWarning(HgBundle.message("hg4idea.version.unsupported", new Object[0]), message);
                }
            }
            catch (Exception e) {
                if (!this.getExecutableValidator().checkExecutableAndNotifyIfNeeded()) break block5;
                String reason = (e.getCause() != null ? e.getCause() : e).getMessage();
                String message = HgBundle.message("hg4idea.unable.to.run.hg", executable);
                vcsNotifier.notifyError(message, HgBundle.message("hg4idea.exec.not.found", reason, "settings"), (NotificationListener)linkAdapter);
            }
        }
    }

    @NotNull
    public HgVersion getVersion() {
        return this.myVersion;
    }
}

