/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ResultClassInReturnTypeCheckerKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ResultClassInReturnTypeChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isForbiddenReturnType", "", "returnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "declarationDescriptor", "frontend"})
public final class ResultClassInReturnTypeChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        LanguageVersionSettings languageVersionSettings = context2.getLanguageVersionSettings();
        if (languageVersionSettings.getFlag(AnalysisFlags.INSTANCE.getAllowResultReturnType()).booleanValue()) {
            return;
        }
        if ((languageVersionSettings.getFeatureSupport(LanguageFeature.InlineClasses) == LanguageFeature.State.ENABLED || languageVersionSettings.supportsFeature(LanguageFeature.JvmInlineValueClasses)) && languageVersionSettings.supportsFeature(LanguageFeature.AllowResultInReturnType)) {
            return;
        }
        if (languageVersionSettings.supportsFeature(LanguageFeature.AllowNullOperatorsForResultAndResultReturnTypeByDefault)) {
            return;
        }
        if (!(declaration2 instanceof KtCallableDeclaration) || !(descriptor2 instanceof CallableMemberDescriptor)) {
            return;
        }
        Object object = ((CallableMemberDescriptor)descriptor2).getReturnType();
        if (object == null) {
            return;
        }
        Object object2 = object;
        KotlinType returnType2 = object2;
        if (this.isForbiddenReturnType(returnType2, declaration2, descriptor2)) {
            PsiElement psiElement;
            KtTypeReference ktTypeReference = ((KtCallableDeclaration)declaration2).getTypeReference();
            if (ktTypeReference == null) {
                PsiElement psiElement2 = ((KtCallableDeclaration)declaration2).getNameIdentifier();
                if (psiElement2 == null) {
                    return;
                }
                psiElement = psiElement2;
            } else {
                psiElement = ktTypeReference;
            }
            SimpleDiagnostic<PsiElement> typeReferenceOrDeclarationName = object = psiElement;
            BindingTrace bindingTrace = context2.getTrace();
            object = Errors.RESULT_CLASS_IN_RETURN_TYPE.on((PsiElement)((Object)typeReferenceOrDeclarationName));
            Intrinsics.checkNotNullExpressionValue(object, "RESULT_CLASS_IN_RETURN_TYPE.on(typeReferenceOrDeclarationName)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, (Diagnostic)object);
        }
    }

    private final boolean isForbiddenReturnType(KotlinType returnType2, KtDeclaration declaration2, DeclarationDescriptor declarationDescriptor) {
        if (!ResultClassInReturnTypeCheckerKt.isResultType(returnType2)) {
            return false;
        }
        if (declarationDescriptor instanceof PropertyDescriptor || declarationDescriptor instanceof PropertyGetterDescriptor) {
            KtPropertyAccessor ktPropertyAccessor;
            if (declaration2 instanceof KtProperty && Intrinsics.areEqual((ktPropertyAccessor = ((KtProperty)declaration2).getGetter()) == null ? null : Boolean.valueOf(ktPropertyAccessor.hasBody()), true)) {
                return true;
            }
            DescriptorVisibility descriptorVisibility = ((DeclarationDescriptorWithVisibility)declarationDescriptor).getVisibility();
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "declarationDescriptor as DeclarationDescriptorWithVisibility).visibility");
            DescriptorVisibility visibility2 = descriptorVisibility;
            return !DescriptorVisibilities.isPrivate(visibility2) && !Intrinsics.areEqual(visibility2, DescriptorVisibilities.LOCAL);
        }
        return true;
    }
}

