/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendException;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrStringConcatenationImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrThrowImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.ConstantValueGenerator;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.TypeTranslator;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.BodyGenerator;
import org.jetbrains.kotlin.psi2ir.generators.BranchingExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.DelegatedPropertyGenerator;
import org.jetbrains.kotlin.psi2ir.generators.ErrorExpressionException;
import org.jetbrains.kotlin.psi2ir.generators.ErrorExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.Generator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorWithScope;
import org.jetbrains.kotlin.psi2ir.generators.LocalClassGenerator;
import org.jetbrains.kotlin.psi2ir.generators.LocalFunctionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.LoopExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.OperatorExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.ReflectionReferencesGenerator;
import org.jetbrains.kotlin.psi2ir.generators.TryCatchExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilder;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilderKt;
import org.jetbrains.kotlin.psi2ir.intermediate.IntermediateValue;
import org.jetbrains.kotlin.psi2ir.intermediate.RematerializableValueKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00012\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%J\u000e\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020#J&\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\f\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010+H\u0002J(\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u000e\u00105\u001a\u00020\u00022\u0006\u00106\u001a\u000207J\"\u00108\u001a\b\u0012\u0004\u0012\u00020\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020#0;2\u0006\u0010<\u001a\u00020\u001dJ&\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DJ\u0010\u0010E\u001a\u00020F2\u0006\u0010\"\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u00020I2\u0006\u0010C\u001a\u00020DH\u0002J\b\u0010J\u001a\u00020FH\u0002J\u001a\u0010K\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010N\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020O2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010P\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020Q2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010R\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020S2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010T\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020U2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010V\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020W2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010X\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020Y2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010Z\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020[2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\\\u001a\u00020\u00022\u0006\u0010]\u001a\u00020^2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010_\u001a\u00020!2\u0006\u0010\"\u001a\u00020`2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010a\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020b2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010c\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010d\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020e2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010f\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020g2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010h\u001a\u00020\u00022\u0006\u0010i\u001a\u00020j2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010k\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010l\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020m2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010n\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020o2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010p\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020q2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010r\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020s2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010t\u001a\u00020\u00022\u0006\u0010i\u001a\u00020u2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010v\u001a\u00020\u00022\u0006\u0010w\u001a\u00020x2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010y\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020z2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010{\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020|2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010}\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020~2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001b\u0010\u007f\u001a\u00020\u00022\u0007\u0010\u0080\u0001\u001a\u00020.2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001b\u0010\u0081\u0001\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020G2\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0082\u0001\u001a\u00020\u00022\u0007\u0010\"\u001a\u00030\u0083\u00012\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0084\u0001\u001a\u00020!2\u0007\u0010\"\u001a\u00030\u0085\u00012\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0086\u0001\u001a\u00020\u00022\u0007\u0010i\u001a\u00030\u0087\u00012\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0088\u0001\u001a\u00020\u00022\u0007\u0010\"\u001a\u00030\u0089\u00012\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u008a\u0001\u001a\u00020!2\u0007\u0010\"\u001a\u00030\u008b\u00012\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u008c\u0001\u001a\u00020\u00022\u0007\u0010\"\u001a\u00030\u008d\u00012\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u008e\u0001\u001a\u00020\u00022\u0007\u0010\"\u001a\u00030\u008f\u00012\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001d\u0010\u0090\u0001\u001a\u00020\u00022\b\u0010\u0091\u0001\u001a\u00030\u0092\u00012\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0093\u0001\u001a\u00020\u00022\u0007\u0010\"\u001a\u00030\u0094\u00012\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\u001c\u0010\u0095\u0001\u001a\u00020\u00022\u0007\u0010\"\u001a\u00030\u0096\u00012\b\u0010M\u001a\u0004\u0018\u00010\u0003H\u0016J\r\u0010\u0097\u0001\u001a\u00020!*\u000207H\u0002J\r\u0010\u0098\u0001\u001a\u00020\u0002*\u000207H\u0002J\u0019\u0010\u0099\u0001\u001a\b\u0012\u0004\u0012\u00020!0;*\b\u0012\u0004\u0012\u00020!0;H\u0002J\f\u0010\u009a\u0001\u001a\u00030\u009b\u0001*\u00020BR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009c\u0001"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/ir/IrStatement;", "", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorWithScope;", "bodyGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/BodyGenerator;", "scope", "Lorg/jetbrains/kotlin/ir/builders/Scope;", "(Lorg/jetbrains/kotlin/psi2ir/generators/BodyGenerator;Lorg/jetbrains/kotlin/ir/builders/Scope;)V", "getBodyGenerator", "()Lorg/jetbrains/kotlin/psi2ir/generators/BodyGenerator;", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "getContext", "()Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "getScope", "()Lorg/jetbrains/kotlin/ir/builders/Scope;", "scopeOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getScopeOwner", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "typeTranslator", "Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "declareComponentVariablesInBlock", "", "multiDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "irBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementContainer;", "containerValue", "Lorg/jetbrains/kotlin/psi2ir/intermediate/IntermediateValue;", "generateConstantExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "generateExpression", "ktExpression", "generateExpressionForReferencedDescriptor", "descriptor", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "generateLocalDelegatedProperty", "ktProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "ktDelegate", "Lorg/jetbrains/kotlin/psi/KtPropertyDelegate;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptorWithAccessors;", "scopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "generateStatement", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "generateStatements", "", "ktStatements", "", "to", "generateThisReceiver", "startOffset", "", "endOffset", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getReturnExpressionTarget", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "isThisForClassPhysicallyAvailable", "", "scopeOwnerAsCallable", "visitArrayAccessExpression", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "data", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitBlockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "visitBreakExpression", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitCallableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "visitClassLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "visitClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "visitContinueExpression", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "visitDestructuringDeclaration", "visitDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "visitDotQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "visitEscapeStringTemplateEntry", "entry", "Lorg/jetbrains/kotlin/psi/KtEscapeStringTemplateEntry;", "visitExpression", "visitForExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitLiteralStringTemplateEntry", "Lorg/jetbrains/kotlin/psi/KtLiteralStringTemplateEntry;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitObjectLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "visitPostfixExpression", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "visitPrefixExpression", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "visitProperty", "property", "visitReturnExpression", "visitSafeQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitStringTemplateEntryWithExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntryWithExpression;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitThisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "visitThrowExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "visitTryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "genExpr", "genStmt", "postprocessStringTemplateEntries", "toIrType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ir.psi2ir"})
public final class StatementGenerator
extends KtVisitor
implements GeneratorWithScope {
    @NotNull
    private final BodyGenerator bodyGenerator;
    @NotNull
    private final Scope scope;
    @NotNull
    private final TypeTranslator typeTranslator;

    public StatementGenerator(@NotNull BodyGenerator bodyGenerator, @NotNull Scope scope2) {
        Intrinsics.checkNotNullParameter(bodyGenerator, "bodyGenerator");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        this.bodyGenerator = bodyGenerator;
        this.scope = scope2;
        this.typeTranslator = this.getContext().getTypeTranslator();
    }

    @NotNull
    public final BodyGenerator getBodyGenerator() {
        return this.bodyGenerator;
    }

    @Override
    @NotNull
    public Scope getScope() {
        return this.scope;
    }

    @Override
    @NotNull
    public GeneratorContext getContext() {
        return this.bodyGenerator.getContext();
    }

    @NotNull
    public final DeclarationDescriptor getScopeOwner() {
        return this.bodyGenerator.getScopeOwner();
    }

    @NotNull
    public final IrType toIrType(@NotNull KotlinType $this$toIrType) {
        Intrinsics.checkNotNullParameter($this$toIrType, "<this>");
        return this.typeTranslator.translateType($this$toIrType);
    }

    @NotNull
    public final IrStatement generateStatement(@NotNull KtElement ktElement) {
        Intrinsics.checkNotNullParameter(ktElement, "ktElement");
        return this.genStmt(ktElement);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IrStatement> generateStatements(@NotNull List<? extends KtExpression> ktStatements, @NotNull IrStatementContainer to) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(ktStatements, "ktStatements");
        Intrinsics.checkNotNullParameter(to, "to");
        Iterable iterable = ktStatements;
        Collection destination$iv = to.getStatements();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            KtExpression ktExpression = (KtExpression)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            IrStatement irStatement = this.generateStatement((KtElement)it);
            collection.add(irStatement);
        }
        return (List)destination$iv;
    }

    @NotNull
    public final IrExpression generateExpression(@NotNull KtExpression ktExpression) {
        Intrinsics.checkNotNullParameter(ktExpression, "ktExpression");
        return this.genExpr(ktExpression);
    }

    private final IrStatement genStmt(KtElement $this$genStmt) {
        IrStatement irStatement;
        try {
            irStatement = (IrStatement)KotlinUtilsKt.deparenthesize($this$genStmt).accept(this, null);
        }
        catch (BackendException e) {
            throw e;
        }
        catch (ErrorExpressionException e) {
            throw e;
        }
        catch (Throwable e) {
            irStatement = new ErrorExpressionGenerator(this).generateErrorExpression($this$genStmt, e);
        }
        return irStatement;
    }

    private final IrExpression genExpr(KtElement $this$genExpr) {
        IrElement $this$assertCast$iv = this.genStmt($this$genExpr);
        boolean $i$f$assertCast = false;
        if (!($this$assertCast$iv instanceof IrExpression)) {
            throw new AssertionError((Object)("Expected " + Reflection.getOrCreateKotlinClass(IrExpression.class).getSimpleName() + ": " + $this$assertCast$iv));
        }
        return (IrExpression)$this$assertCast$iv;
    }

    @NotNull
    public IrStatement visitExpression(@NotNull KtExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        int n = PsiUtilsKt.getStartOffsetSkippingComments(expression2);
        int n2 = PsiUtilsKt.getEndOffset(expression2);
        IrType irType = this.getContext().getIrBuiltIns().getNothingType();
        String string2 = expression2.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "expression::class.java.simpleName");
        return new IrErrorExpressionImpl(n, n2, irType, string2);
    }

    @NotNull
    public IrStatement visitProperty(@NotNull KtProperty property2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(property2, "property");
        Generator generator2 = this;
        Object object = BindingContext.VARIABLE;
        Intrinsics.checkNotNullExpressionValue(object, "VARIABLE");
        VariableDescriptor variableDescriptor = (VariableDescriptor)GeneratorKt.getOrFail(generator2, (ReadOnlySlice)object, property2);
        object = property2.getDelegate();
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object ktDelegate = object2;
            boolean bl3 = false;
            if (variableDescriptor == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors");
            }
            return this.generateLocalDelegatedProperty(property2, (KtPropertyDelegate)ktDelegate, (VariableDescriptorWithAccessors)variableDescriptor, this.getBodyGenerator().getScopeOwnerSymbol());
        }
        SymbolTable symbolTable = this.getContext().getSymbolTable();
        int n = PsiUtilsKt.getStartOffsetSkippingComments(property2);
        int n2 = PsiUtilsKt.getEndOffset(property2);
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
        Intrinsics.checkNotNullExpressionValue(variableDescriptor, "variableDescriptor");
        object = variableDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue(object, "variableDescriptor.type");
        IrType irType = this.toIrType((KotlinType)object);
        object = property2.getInitializer();
        return symbolTable.declareVariable(n, n2, irDeclarationOrigin, variableDescriptor, irType, object == null ? null : this.genExpr((KtElement)object));
    }

    private final IrStatement generateLocalDelegatedProperty(KtProperty ktProperty, KtPropertyDelegate ktDelegate, VariableDescriptorWithAccessors variableDescriptor, IrSymbol scopeOwnerSymbol) {
        return new DelegatedPropertyGenerator(this.getContext()).generateLocalDelegatedProperty(ktProperty, ktDelegate, variableDescriptor, scopeOwnerSymbol);
    }

    @NotNull
    public IrStatement visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, @Nullable Void data) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter(multiDeclaration, "multiDeclaration");
        IrCompositeImpl irBlock = new IrCompositeImpl(PsiUtilsKt.getStartOffsetSkippingComments(multiDeclaration), PsiUtilsKt.getEndOffset(multiDeclaration), this.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.DESTRUCTURING_DECLARATION.INSTANCE);
        KtExpression ktExpression2 = multiDeclaration.getInitializer();
        Intrinsics.checkNotNull(ktExpression2);
        KtExpression ktInitializer = ktExpression = ktExpression2;
        IntermediateValue containerValue = RematerializableValueKt.createTemporaryVariableInBlock(this.getScope(), this.getContext(), this.genExpr(ktInitializer), irBlock, "container");
        this.declareComponentVariablesInBlock(multiDeclaration, irBlock, containerValue);
        return irBlock;
    }

    public final void declareComponentVariablesInBlock(@NotNull KtDestructuringDeclaration multiDeclaration, @NotNull IrStatementContainer irBlock, @NotNull IntermediateValue containerValue) {
        Intrinsics.checkNotNullParameter(multiDeclaration, "multiDeclaration");
        Intrinsics.checkNotNullParameter(irBlock, "irBlock");
        Intrinsics.checkNotNullParameter(containerValue, "containerValue");
        CallGenerator callGenerator = new CallGenerator(this);
        Iterator<KtDestructuringDeclarationEntry> iterator2 = multiDeclaration.getEntries().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index2 = n++;
            KtDestructuringDeclarationEntry ktEntry = iterator2.next();
            Generator generator2 = this;
            WritableSlice<KtDestructuringDeclarationEntry, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.COMPONENT_RESOLVED_CALL;
            Intrinsics.checkNotNullExpressionValue(writableSlice, "COMPONENT_RESOLVED_CALL");
            ResolvedCall componentResolvedCall = (ResolvedCall)GeneratorKt.getOrFail(generator2, writableSlice, ktEntry);
            Intrinsics.checkNotNullExpressionValue(componentResolvedCall, "componentResolvedCall");
            CallBuilder componentSubstitutedCall = ArgumentsGenerationUtilsKt.pregenerateCall(this, componentResolvedCall);
            CallBuilderKt.setExplicitReceiverValue(componentSubstitutedCall, containerValue);
            Generator generator3 = this;
            WritableSlice<PsiElement, VariableDescriptor> writableSlice2 = BindingContext.VARIABLE;
            Intrinsics.checkNotNullExpressionValue(writableSlice2, "VARIABLE");
            VariableDescriptor componentVariable = (VariableDescriptor)GeneratorKt.getOrFail(generator3, writableSlice2, ktEntry);
            if (componentVariable.getName().isSpecial()) continue;
            Intrinsics.checkNotNullExpressionValue(ktEntry, "ktEntry");
            IrExpression irComponentCall = callGenerator.generateCall(PsiUtilsKt.getStartOffsetSkippingComments(ktEntry), PsiUtilsKt.getEndOffset(ktEntry), componentSubstitutedCall, IrStatementOrigin.COMPONENT_N.Companion.withIndex(index2 + 1));
            SymbolTable symbolTable = this.getContext().getSymbolTable();
            int n2 = PsiUtilsKt.getStartOffsetSkippingComments(ktEntry);
            int n3 = PsiUtilsKt.getEndOffset(ktEntry);
            IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.DEFINED.INSTANCE;
            Intrinsics.checkNotNullExpressionValue(componentVariable, "componentVariable");
            KotlinType kotlinType = componentVariable.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "componentVariable.type");
            IrVariable irComponentVar = symbolTable.declareVariable(n2, n3, irDeclarationOrigin, componentVariable, this.toIrType(kotlinType), irComponentCall);
            irBlock.getStatements().add(irComponentVar);
        }
    }

    @NotNull
    public IrStatement visitBlockExpression(@NotNull KtBlockExpression expression2, @Nullable Void data) {
        boolean isBlockBody;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        boolean bl = isBlockBody = expression2.getParent() instanceof KtDeclarationWithBody && !(expression2.getParent() instanceof KtFunctionLiteral);
        if (isBlockBody) {
            throw new AssertionError((Object)"Use IrBlockBody and corresponding body generator to generate blocks as function bodies");
        }
        KotlinType returnType2 = GeneratorKt.getExpressionTypeWithCoercionToUnitOrFail(this, expression2);
        IrBlockImpl irBlock = new IrBlockImpl(PsiUtilsKt.getStartOffsetSkippingComments(expression2), PsiUtilsKt.getEndOffset(expression2), this.toIrType(returnType2), null, 8, null);
        List<KtExpression> list2 = expression2.getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, "expression.statements");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression it = (KtExpression)element$iv;
            boolean bl2 = false;
            List<IrStatement> list3 = irBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(it, "it");
            list3.add(this.genStmt(it));
        }
        return irBlock;
    }

    @NotNull
    public IrStatement visitReturnExpression(@NotNull KtReturnExpression expression2, @Nullable Void data) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        CallableDescriptor returnTarget = this.getReturnExpressionTarget(expression2);
        KtExpression ktExpression = expression2.getReturnedExpression();
        if (ktExpression == null) {
            int n = PsiUtilsKt.getStartOffsetSkippingComments(expression2);
            int n2 = PsiUtilsKt.getEndOffset(expression2);
            IrType irType = this.getContext().getIrBuiltIns().getUnitType();
            SymbolTable symbolTable = this.getContext().getSymbolTable();
            ClassDescriptor classDescriptor = this.getContext().getBuiltIns().getUnit();
            Intrinsics.checkNotNullExpressionValue(classDescriptor, "context.builtIns.unit");
            irExpression = new IrGetObjectValueImpl(n, n2, irType, symbolTable.referenceClass(classDescriptor));
        } else {
            irExpression = this.genExpr(ktExpression);
        }
        IrExpression irReturnedExpression = irExpression;
        return new IrReturnImpl(PsiUtilsKt.getStartOffsetSkippingComments(expression2), PsiUtilsKt.getEndOffset(expression2), this.getContext().getIrBuiltIns().getNothingType(), IrUtilsKt.referenceFunction(this.getContext().getSymbolTable(), returnTarget), irReturnedExpression);
    }

    private final CallableDescriptor scopeOwnerAsCallable() {
        CallableDescriptor callableDescriptor;
        DeclarationDescriptor declarationDescriptor = this.getScopeOwner();
        CallableDescriptor callableDescriptor2 = callableDescriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
        if (callableDescriptor == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus("'return' in a non-callable: ", this.getScopeOwner()));
        }
        return callableDescriptor;
    }

    private final CallableDescriptor getReturnExpressionTarget(KtReturnExpression expression2) {
        CallableDescriptor callableDescriptor;
        if (!ExpressionTypingUtils.isFunctionLiteral(this.getScopeOwner()) && !ExpressionTypingUtils.isFunctionExpression(this.getScopeOwner())) {
            callableDescriptor = this.scopeOwnerAsCallable();
        } else {
            CallableDescriptor callableDescriptor2;
            KtSimpleNameExpression label = expression2.getTargetLabel();
            if (label != null) {
                Generator generator2 = this;
                WritableSlice<KtReferenceExpression, PsiElement> writableSlice = BindingContext.LABEL_TARGET;
                Intrinsics.checkNotNullExpressionValue(writableSlice, "LABEL_TARGET");
                PsiElement labelTarget = (PsiElement)GeneratorKt.getOrFail(generator2, writableSlice, label);
                Generator generator3 = this;
                ReadOnlySlice<PsiElement, DeclarationDescriptor> readOnlySlice = BindingContext.DECLARATION_TO_DESCRIPTOR;
                Intrinsics.checkNotNullExpressionValue(readOnlySlice, "DECLARATION_TO_DESCRIPTOR");
                DeclarationDescriptor labelTargetDescriptor = GeneratorKt.getOrFail(generator3, readOnlySlice, labelTarget);
                if (labelTargetDescriptor == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
                }
                callableDescriptor2 = (CallableDescriptor)labelTargetDescriptor;
            } else {
                callableDescriptor2 = ExpressionTypingUtils.isFunctionLiteral(this.getScopeOwner()) ? (CallableDescriptor)BindingContextUtils.getContainingFunctionSkipFunctionLiterals((DeclarationDescriptor)this.getScopeOwner(), (boolean)true).first : this.scopeOwnerAsCallable();
            }
            CallableDescriptor callableDescriptor3 = callableDescriptor2;
            Intrinsics.checkNotNullExpressionValue(callableDescriptor3, "{\n            val label = expression.getTargetLabel()\n            when {\n                label != null -> {\n                    val labelTarget = getOrFail(BindingContext.LABEL_TARGET, label)\n                    val labelTargetDescriptor = getOrFail(BindingContext.DECLARATION_TO_DESCRIPTOR, labelTarget)\n                    labelTargetDescriptor as CallableDescriptor\n                }\n                ExpressionTypingUtils.isFunctionLiteral(scopeOwner) -> {\n                    BindingContextUtils.getContainingFunctionSkipFunctionLiterals(scopeOwner, true).first\n                }\n                else -> {\n                    scopeOwnerAsCallable()\n                }\n            }\n        }");
            callableDescriptor = callableDescriptor3;
        }
        return callableDescriptor;
    }

    @NotNull
    public IrStatement visitThrowExpression(@NotNull KtThrowExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        int n = PsiUtilsKt.getStartOffsetSkippingComments(expression2);
        int n2 = PsiUtilsKt.getEndOffset(expression2);
        IrType irType = this.getContext().getIrBuiltIns().getNothingType();
        KtExpression ktExpression = expression2.getThrownExpression();
        Intrinsics.checkNotNull(ktExpression);
        KtExpression ktExpression2 = ktExpression;
        return new IrThrowImpl(n, n2, irType, this.genExpr(ktExpression2));
    }

    @NotNull
    public IrExpression visitConstantExpression(@NotNull KtConstantExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, this.getContext().getBindingContext());
        if (compileTimeConstant == null) {
            String string2 = Intrinsics.stringPlus("KtConstantExpression was not evaluated: ", expression2.getText());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return this.generateConstantExpression(expression2, compileTimeConstant);
    }

    @NotNull
    public final IrExpression generateConstantExpression(@NotNull KtExpression expression2, @NotNull CompileTimeConstant<?> constant) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(constant, "constant");
        return ConstantValueGenerator.generateConstantValueAsExpression$default(this.getContext().getConstantValueGenerator(), PsiUtilsKt.getStartOffsetSkippingComments(expression2), PsiUtilsKt.getEndOffset(expression2), constant.toConstantValue(GeneratorKt.getTypeInferredByFrontendOrFail(this, expression2)), null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrStatement visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, @Nullable Void data) {
        IrStatement irStatement;
        Collection<IrExpression> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(expression2);
        int endOffset = PsiUtilsKt.getEndOffset(expression2);
        IrType resultType = this.toIrType(GeneratorKt.getTypeInferredByFrontendOrFail(this, expression2));
        Object[] objectArray = expression2.getEntries();
        Intrinsics.checkNotNullExpressionValue(objectArray, "expression.entries");
        objectArray = objectArray;
        StatementGenerator statementGenerator = this;
        boolean $i$f$map = false;
        void var9_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtStringTemplateEntry ktStringTemplateEntry = (KtStringTemplateEntry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            IrExpression irExpression = this.genExpr((KtElement)it);
            collection.add(irExpression);
        }
        collection = (List)destination$iv$iv;
        List<IrExpression> entries = statementGenerator.postprocessStringTemplateEntries((List<? extends IrExpression>)collection);
        int n = entries.size();
        switch (n) {
            case 0: {
                irStatement = IrConstImpl.Companion.string(startOffset, endOffset, resultType, "");
                break;
            }
            case 1: {
                IrExpression first = CollectionsKt.first(entries);
                irStatement = first instanceof IrConst && Intrinsics.areEqual(((IrConst)first).getKind(), IrConstKind.String.INSTANCE) ? first : (IrExpression)new IrStringConcatenationImpl(startOffset, endOffset, resultType, (Collection<? extends IrExpression>)CollectionsKt.listOf(first));
                break;
            }
            default: {
                irStatement = new IrStringConcatenationImpl(startOffset, endOffset, resultType, (Collection<? extends IrExpression>)entries);
            }
        }
        return irStatement;
    }

    private final List<IrExpression> postprocessStringTemplateEntries(List<? extends IrExpression> $this$postprocessStringTemplateEntries) {
        ArrayList<IrExpression> arrayList = new ArrayList<IrExpression>($this$postprocessStringTemplateEntries.size());
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<IrExpression> result2 = arrayList;
        boolean bl3 = false;
        IrType stringType = this.getContext().getIrBuiltIns().getStringType();
        StringBuilder constString = new StringBuilder();
        int constStringStartOffset = 0;
        int constStringEndOffset = 0;
        for (IrExpression irExpression : $this$postprocessStringTemplateEntries) {
            boolean bl4;
            CharSequence charSequence;
            if (irExpression instanceof IrConst && Intrinsics.areEqual(((IrConst)irExpression).getKind(), IrConstKind.String.INSTANCE)) {
                charSequence = constString;
                bl4 = false;
                if (charSequence.length() == 0) {
                    constStringStartOffset = irExpression.getStartOffset();
                }
                constString.append((String)IrConstKind.String.INSTANCE.valueOf((IrConst)irExpression));
                constStringEndOffset = irExpression.getEndOffset();
                continue;
            }
            charSequence = constString;
            bl4 = false;
            if (charSequence.length() > 0) {
                charSequence = constString.toString();
                Intrinsics.checkNotNullExpressionValue(charSequence, "constString.toString()");
                result2.add(IrConstImpl.Companion.string(constStringStartOffset, constStringEndOffset, stringType, (String)charSequence));
                StringsKt.clear(constString);
            }
            result2.add(irExpression);
        }
        Object object = constString;
        boolean bl5 = false;
        if (object.length() > 0) {
            object = constString.toString();
            Intrinsics.checkNotNullExpressionValue(object, "constString.toString()");
            result2.add(IrConstImpl.Companion.string(constStringStartOffset, constStringEndOffset, stringType, (String)object));
        }
        return arrayList;
    }

    @NotNull
    public IrStatement visitLiteralStringTemplateEntry(@NotNull KtLiteralStringTemplateEntry entry, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        int n = PsiUtilsKt.getStartOffsetSkippingComments(entry);
        int n2 = PsiUtilsKt.getEndOffset(entry);
        IrType irType = this.getContext().getIrBuiltIns().getStringType();
        String string2 = entry.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "entry.text");
        return IrConstImpl.Companion.string(n, n2, irType, string2);
    }

    @NotNull
    public IrStatement visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        int n = PsiUtilsKt.getStartOffsetSkippingComments(entry);
        int n2 = PsiUtilsKt.getEndOffset(entry);
        IrType irType = this.getContext().getIrBuiltIns().getStringType();
        String string2 = entry.getUnescapedValue();
        Intrinsics.checkNotNullExpressionValue(string2, "entry.unescapedValue");
        return IrConstImpl.Companion.string(n, n2, irType, string2);
    }

    @NotNull
    public IrStatement visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        KtExpression ktExpression = entry.getExpression();
        Intrinsics.checkNotNull(ktExpression);
        KtExpression ktExpression2 = ktExpression;
        return this.genExpr(ktExpression2);
    }

    @NotNull
    public IrExpression visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 != null) {
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                CallBuilder variableCall = ArgumentsGenerationUtilsKt.pregenerateCall(this, ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall());
                return CallGeneratorKt.generateCall(new CallGenerator(this), expression2, variableCall, (IrStatementOrigin)IrStatementOrigin.VARIABLE_AS_FUNCTION.INSTANCE);
            }
            CallableDescriptor descriptor2 = resolvedCall2.getResultingDescriptor();
            return this.generateExpressionForReferencedDescriptor(descriptor2, expression2, resolvedCall2);
        }
        Generator generator2 = this;
        WritableSlice<KtReferenceExpression, DeclarationDescriptor> writableSlice = BindingContext.REFERENCE_TARGET;
        Intrinsics.checkNotNullExpressionValue(writableSlice, "REFERENCE_TARGET");
        DeclarationDescriptor referenceTarget = (DeclarationDescriptor)GeneratorKt.get(generator2, writableSlice, expression2);
        if (referenceTarget != null) {
            return this.generateExpressionForReferencedDescriptor(referenceTarget, expression2, null);
        }
        return new ErrorExpressionGenerator(this).generateErrorSimpleName(expression2);
    }

    private final IrExpression generateExpressionForReferencedDescriptor(DeclarationDescriptor descriptor2, KtExpression expression2, ResolvedCall<?> resolvedCall2) {
        KotlinType kotlinType;
        ExplicitSmartCasts explicitSmartCasts;
        return new CallGenerator(this).generateValueReference(PsiUtilsKt.getStartOffsetSkippingComments(expression2), PsiUtilsKt.getEndOffset(expression2), descriptor2, resolvedCall2, null, (explicitSmartCasts = (ExplicitSmartCasts)this.getContext().getBindingContext().get(BindingContext.SMARTCAST, expression2)) == null ? null : ((kotlinType = explicitSmartCasts.getDefaultType()) == null ? null : this.toIrType(kotlinType)));
    }

    @NotNull
    public IrStatement visitCallExpression(@NotNull KtCallExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = GeneratorKt.getResolvedCall(this, expression2);
        if (resolvedCall2 == null) {
            return new ErrorExpressionGenerator(this).generateErrorCall(expression2);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (resolvedCall3 instanceof VariableAsFunctionResolvedCall) {
            CallBuilder functionCall = ArgumentsGenerationUtilsKt.pregenerateCall(this, ((VariableAsFunctionResolvedCall)((Object)resolvedCall3)).getFunctionCall());
            return CallGeneratorKt.generateCall(new CallGenerator(this), expression2, functionCall, (IrStatementOrigin)IrStatementOrigin.INVOKE.INSTANCE);
        }
        KtExpression calleeExpression = expression2.getCalleeExpression();
        IrStatementOrigin.INVOKE origin = Intrinsics.areEqual(resolvedCall3.getResultingDescriptor().getName(), OperatorNameConventions.INVOKE) && !(calleeExpression instanceof KtSimpleNameExpression) && !(calleeExpression instanceof KtQualifiedExpression) ? IrStatementOrigin.INVOKE.INSTANCE : null;
        return new CallGenerator(this).generateCall(PsiUtilsKt.getStartOffsetSkippingComments(expression2), PsiUtilsKt.getEndOffset(expression2), ArgumentsGenerationUtilsKt.pregenerateCall(this, resolvedCall3), origin);
    }

    @NotNull
    public IrStatement visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2, @Nullable Void data) {
        IrStatement irStatement;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Generator generator2 = this;
        WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.INDEXED_LVALUE_GET;
        Intrinsics.checkNotNullExpressionValue(writableSlice, "INDEXED_LVALUE_GET");
        ResolvedCall indexedGetCall = (ResolvedCall)GeneratorKt.getOrFail(generator2, writableSlice, expression2);
        writableSlice = indexedGetCall.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(writableSlice, "indexedGetCall.resultingDescriptor");
        if (DynamicCallsKt.isDynamic((DeclarationDescriptor)((Object)writableSlice))) {
            irStatement = new OperatorExpressionGenerator(this).generateDynamicArrayAccess(expression2);
        } else {
            CallGenerator callGenerator = new CallGenerator(this);
            int n = PsiUtilsKt.getStartOffsetSkippingComments(expression2);
            int n2 = PsiUtilsKt.getEndOffset(expression2);
            Intrinsics.checkNotNullExpressionValue(indexedGetCall, "indexedGetCall");
            irStatement = callGenerator.generateCall(n, n2, ArgumentsGenerationUtilsKt.pregenerateCall(this, indexedGetCall), IrStatementOrigin.GET_ARRAY_ELEMENT.INSTANCE);
        }
        return irStatement;
    }

    @NotNull
    public IrStatement visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression ktExpression = expression2.getSelectorExpression();
        Intrinsics.checkNotNull(ktExpression);
        Object r = ktExpression.accept(this, data);
        Intrinsics.checkNotNullExpressionValue(r, "expression.selectorExpression!!.accept(this, data)");
        return (IrStatement)r;
    }

    @NotNull
    public IrStatement visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression ktExpression = expression2.getSelectorExpression();
        Intrinsics.checkNotNull(ktExpression);
        Object r = ktExpression.accept(this, data);
        Intrinsics.checkNotNullExpressionValue(r, "expression.selectorExpression!!.accept(this, data)");
        return (IrStatement)r;
    }

    private final boolean isThisForClassPhysicallyAvailable(ClassDescriptor classDescriptor) {
        for (DeclarationDescriptor scopeDescriptor = this.getScopeOwner(); scopeDescriptor != null; scopeDescriptor = scopeDescriptor.getContainingDeclaration()) {
            if (Intrinsics.areEqual(scopeDescriptor, classDescriptor)) {
                return true;
            }
            if (!(scopeDescriptor instanceof ClassDescriptor) || ((ClassDescriptor)scopeDescriptor).isInner()) continue;
            return false;
        }
        return false;
    }

    @NotNull
    public final IrExpression generateThisReceiver(int startOffset, int endOffset, @NotNull KotlinType kotlinType, @NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter(kotlinType, "kotlinType");
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        ReceiverParameterDescriptor receiverParameterDescriptor = classDescriptor.getThisAsReceiverParameter();
        Intrinsics.checkNotNullExpressionValue(receiverParameterDescriptor, "classDescriptor.thisAsReceiverParameter");
        ReceiverParameterDescriptor thisAsReceiverParameter = receiverParameterDescriptor;
        IrType thisType = this.toIrType(kotlinType);
        return DescriptorUtils.isObject(classDescriptor) && !this.isThisForClassPhysicallyAvailable(classDescriptor) ? (IrExpression)new IrGetObjectValueImpl(startOffset, endOffset, thisType, this.getContext().getSymbolTable().referenceClass(classDescriptor)) : (IrExpression)new IrGetValueImpl(startOffset, endOffset, thisType, this.getContext().getSymbolTable().referenceValueParameter(thisAsReceiverParameter), null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrExpression visitThisExpression(@NotNull KtThisExpression expression2, @Nullable Void data) {
        IrExpression irExpression;
        void slice$iv;
        void $this$getOrFail$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Generator generator2 = this;
        ReadOnlySlice<KtReferenceExpression, DeclarationDescriptor> readOnlySlice = BindingContext.REFERENCE_TARGET;
        Intrinsics.checkNotNullExpressionValue(readOnlySlice, "REFERENCE_TARGET");
        readOnlySlice = readOnlySlice;
        KtReferenceExpression key$iv = expression2.getInstanceReference();
        boolean $i$f$getOrFail2 = false;
        Object object = $this$getOrFail$iv.getContext().getBindingContext().get(slice$iv, key$iv);
        if (object == null) {
            String string2;
            KtReferenceExpression it = key$iv;
            boolean bl = false;
            String string3 = string2 = "No reference target for this";
            throw new RuntimeException(string3);
        }
        DeclarationDescriptor referenceTarget = (DeclarationDescriptor)object;
        int startOffset = PsiUtilsKt.getStartOffsetSkippingComments(expression2);
        int endOffset = PsiUtilsKt.getEndOffset(expression2);
        DeclarationDescriptor declarationDescriptor = referenceTarget;
        if (declarationDescriptor instanceof ClassDescriptor) {
            KotlinType $i$f$getOrFail2 = ((ClassDescriptor)referenceTarget).getThisAsReceiverParameter().getType();
            Intrinsics.checkNotNullExpressionValue($i$f$getOrFail2, "referenceTarget.thisAsReceiverParameter.type");
            irExpression = this.generateThisReceiver(startOffset, endOffset, $i$f$getOrFail2, (ClassDescriptor)referenceTarget);
        } else if (declarationDescriptor instanceof CallableDescriptor) {
            Annotated annotated = ((CallableDescriptor)referenceTarget).getExtensionReceiverParameter();
            if (annotated == null) {
                String string4 = Intrinsics.stringPlus("No extension receiver: ", referenceTarget);
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string4);
            }
            Object extensionReceiver = object = annotated;
            annotated = extensionReceiver.getType();
            Intrinsics.checkNotNullExpressionValue(annotated, "extensionReceiver.type");
            IrType extensionReceiverType = this.toIrType((KotlinType)annotated);
            irExpression = new IrGetValueImpl(startOffset, endOffset, extensionReceiverType, this.getContext().getSymbolTable().referenceValueParameter((ParameterDescriptor)extensionReceiver), null, 16, null);
        } else {
            String string5 = Intrinsics.stringPlus("Expected this or receiver: ", referenceTarget);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string5.toString());
        }
        return irExpression;
    }

    @NotNull
    public IrStatement visitBinaryExpression(@NotNull KtBinaryExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new OperatorExpressionGenerator(this).generateBinaryExpression(expression2);
    }

    @NotNull
    public IrStatement visitPrefixExpression(@NotNull KtPrefixExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new OperatorExpressionGenerator(this).generatePrefixExpression(expression2);
    }

    @NotNull
    public IrStatement visitPostfixExpression(@NotNull KtPostfixExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new OperatorExpressionGenerator(this).generatePostfixExpression(expression2);
    }

    @NotNull
    public IrStatement visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new OperatorExpressionGenerator(this).generateCastExpression(expression2);
    }

    @NotNull
    public IrStatement visitIsExpression(@NotNull KtIsExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new OperatorExpressionGenerator(this).generateInstanceOfExpression(expression2);
    }

    @NotNull
    public IrStatement visitIfExpression(@NotNull KtIfExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new BranchingExpressionGenerator(this).generateIfExpression(expression2);
    }

    @NotNull
    public IrStatement visitWhenExpression(@NotNull KtWhenExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new BranchingExpressionGenerator(this).generateWhenExpression(expression2);
    }

    @NotNull
    public IrStatement visitWhileExpression(@NotNull KtWhileExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new LoopExpressionGenerator(this).generateWhileLoop(expression2);
    }

    @NotNull
    public IrStatement visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new LoopExpressionGenerator(this).generateDoWhileLoop(expression2);
    }

    @NotNull
    public IrStatement visitForExpression(@NotNull KtForExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new LoopExpressionGenerator(this).generateForLoop(expression2);
    }

    @NotNull
    public IrStatement visitBreakExpression(@NotNull KtBreakExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new LoopExpressionGenerator(this).generateBreak(expression2);
    }

    @NotNull
    public IrStatement visitContinueExpression(@NotNull KtContinueExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new LoopExpressionGenerator(this).generateContinue(expression2);
    }

    @NotNull
    public IrStatement visitTryExpression(@NotNull KtTryExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new TryCatchExpressionGenerator(this).generateTryCatch(expression2);
    }

    @NotNull
    public IrStatement visitLambdaExpression(@NotNull KtLambdaExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new LocalFunctionGenerator(this).generateLambda(expression2);
    }

    @NotNull
    public IrStatement visitNamedFunction(@NotNull KtNamedFunction function2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return new LocalFunctionGenerator(this).generateFunction(function2);
    }

    @NotNull
    public IrStatement visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new LocalClassGenerator(this).generateObjectLiteral(expression2);
    }

    @NotNull
    public IrStatement visitClassOrObject(@NotNull KtClassOrObject classOrObject, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        return new LocalClassGenerator(this).generateLocalClass(classOrObject);
    }

    @NotNull
    public IrStatement visitTypeAlias(@NotNull KtTypeAlias typeAlias, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        return new IrBlockImpl(PsiUtilsKt.getStartOffsetSkippingComments(typeAlias), PsiUtilsKt.getEndOffset(typeAlias), this.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
    }

    @NotNull
    public IrStatement visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new ReflectionReferencesGenerator(this).generateClassLiteral(expression2);
    }

    @NotNull
    public IrStatement visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return new ReflectionReferencesGenerator(this).generateCallableReference(expression2);
    }
}

