/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.setup.module;

import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class NativeLibraryCollector {
    NativeLibraryCollector() {
    }

    @NotNull
    List<NativeLibrary> collectNativeLibraries(@NotNull VirtualFile folder) {
        final HashMap librariesByName = new HashMap();
        ArrayListMultimap sharedObjectFilesByLibraryName = ArrayListMultimap.create();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)folder, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0], (ListMultimap)sharedObjectFilesByLibraryName){
            final /* synthetic */ ListMultimap val$sharedObjectFilesByLibraryName;
            {
                this.val$sharedObjectFilesByLibraryName = listMultimap;
                super(x0);
            }

            public boolean visitFile(@NotNull VirtualFile file) {
                if (!file.isDirectory() && "so".equals(file.getExtension())) {
                    String fileName = file.getName();
                    NativeLibrary library = librariesByName.computeIfAbsent(fileName, NativeLibrary::new);
                    this.val$sharedObjectFilesByLibraryName.put((Object)library.name, (Object)file);
                    return false;
                }
                return true;
            }
        });
        ArrayList<NativeLibrary> libraries = new ArrayList<NativeLibrary>(librariesByName.values());
        if (libraries.size() > 1) {
            libraries.sort(Comparator.comparing(library -> library.name));
        }
        for (NativeLibrary library2 : libraries) {
            List files = sharedObjectFilesByLibraryName.get((Object)library2.name);
            if (files.isEmpty()) continue;
            library2.addSharedObjectFiles((Collection)files);
        }
        return libraries;
    }
}

