/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.junit.AbstractTestClassConfigurationProducer;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.testframework.AbstractPatternBasedConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.run.JvmMppUtilsKt;
import org.jetbrains.kotlin.idea.run.KotlinJUnitRunConfigurationProducerKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0014J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinJUnitRunConfigurationProducer;", "Lcom/intellij/execution/actions/RunConfigurationProducer;", "Lcom/intellij/execution/junit/JUnitConfiguration;", "()V", "createDelegatingContextWithLightElement", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "fromContext", "lightElement", "Lcom/intellij/psi/PsiMember;", "isAvailableInMpp", "", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "isConfigurationFromContext", "configuration", "onFirstRun", "", "performRunnable", "Ljava/lang/Runnable;", "settingsMatchTemplate", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "shouldReplace", "self", "other", "Companion", "kotlin.jvm"})
public final class KotlinJUnitRunConfigurationProducer
extends RunConfigurationProducer<JUnitConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other.isProducedBy(JUnitConfigurationProducer.class) || other.isProducedBy(AbstractPatternBasedConfigurationProducer.class);
    }

    private final boolean isAvailableInMpp(ConfigurationContext context) {
        Module module = context.getModule();
        return module == null || !MultiplatformUtilKt.isNewMPPModule((Module)module) || !JvmMppUtilsKt.forceGradleRunnerInMPP();
    }

    public boolean isConfigurationFromContext(@NotNull JUnitConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        if (!this.isAvailableInMpp(context)) {
            return false;
        }
        Location location = context.getLocation();
        if (location == null || (location = location.getPsiElement()) == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"context.location?.psiElement ?: return false");
        Location leaf = location;
        PsiMethod method = Companion.getTestMethod((PsiElement)leaf);
        PsiClass testClass = Companion.getTestClass((PsiElement)leaf);
        TestObject testObject = configuration.getTestObject();
        if (!testObject.isConfiguredByElement(configuration, testClass, method, null, null)) {
            return false;
        }
        return this.settingsMatchTemplate(configuration, context);
    }

    private final boolean settingsMatchTemplate(JUnitConfiguration configuration, ConfigurationContext context) {
        String vmParameters;
        RunConfiguration predefinedConfiguration = context.getOriginalConfiguration((ConfigurationType)JUnitConfigurationType.getInstance());
        RunConfiguration runConfiguration = predefinedConfiguration;
        if (!(runConfiguration instanceof CommonJavaRunConfigurationParameters)) {
            runConfiguration = null;
        }
        CommonJavaRunConfigurationParameters commonJavaRunConfigurationParameters = (CommonJavaRunConfigurationParameters)runConfiguration;
        String string = vmParameters = commonJavaRunConfigurationParameters != null ? commonJavaRunConfigurationParameters.getVMParameters() : null;
        if (vmParameters != null && Intrinsics.areEqual((Object)configuration.getVMParameters(), (Object)vmParameters) ^ true) {
            return false;
        }
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.project");
        RunManager runManager = RunManager.Companion.getInstance(project);
        ConfigurationFactory configurationFactory = this.getConfigurationFactory();
        Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"configurationFactory");
        RunnerAndConfigurationSettings template = runManager.getConfigurationTemplate(configurationFactory);
        RunConfiguration runConfiguration2 = template.getConfiguration();
        if (runConfiguration2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.execution.configurations.ModuleBasedConfiguration<*, *>");
        }
        RunConfigurationModule runConfigurationModule = ((ModuleBasedConfiguration)runConfiguration2).getConfigurationModule();
        Intrinsics.checkNotNullExpressionValue((Object)runConfigurationModule, (String)"(template.configuration \u2026, *>).configurationModule");
        Module predefinedModule = runConfigurationModule.getModule();
        JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)configuration.getConfigurationModule();
        Intrinsics.checkNotNullExpressionValue((Object)javaRunConfigurationModule, (String)"configuration.configurationModule");
        Module configurationModule = javaRunConfigurationModule.getModule();
        Location location = context.getLocation();
        return Intrinsics.areEqual((Object)configurationModule, location != null && (location = location.getModule()) != null ? JvmMppUtilsKt.asJvmModule((Module)location) : null) || Intrinsics.areEqual((Object)configurationModule, (Object)predefinedModule);
    }

    protected boolean setupConfigurationFromContext(@NotNull JUnitConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        DumbService dumbService = DumbService.getInstance((Project)context.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(context.project)");
        if (dumbService.isDumb()) {
            return false;
        }
        if (!this.isAvailableInMpp(context)) {
            return false;
        }
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"context.location ?: return false");
        Location location2 = location;
        PsiElement psiElement = location2.getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"location.psiElement");
        PsiElement leaf = psiElement;
        Module module = context.getModule();
        if (module == null || (module = JvmMppUtilsKt.asJvmModule(module)) == null) {
            return false;
        }
        Module module2 = module;
        if (!ProjectRootsUtil.isInProjectOrLibSource$default((PsiElement)leaf, (boolean)false, (int)2, null)) {
            return false;
        }
        if (!(leaf.getContainingFile() instanceof KtFile)) {
            return false;
        }
        PsiMethod method = Companion.getTestMethod(leaf);
        if (method != null) {
            configuration.beMethodConfiguration(KotlinJUnitRunConfigurationProducerKt.access$toLocation(method));
            JavaRunConfigurationExtensionManager.Companion.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location2);
            configuration.setModule(module2);
            return true;
        }
        PsiClass testClass = Companion.getTestClass(leaf);
        if (testClass != null) {
            configuration.beClassConfiguration(testClass);
            JavaRunConfigurationExtensionManager.Companion.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location2);
            configuration.setModule(module2);
            return true;
        }
        return false;
    }

    public void onFirstRun(@NotNull ConfigurationFromContext fromContext, @NotNull ConfigurationContext context, @NotNull Runnable performRunnable) {
        PsiMember psiMember;
        Intrinsics.checkNotNullParameter((Object)fromContext, (String)"fromContext");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)performRunnable, (String)"performRunnable");
        PsiElement psiElement = fromContext.getSourceElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"fromContext.sourceElement");
        PsiElement leaf = psiElement;
        PsiMethod psiMethod = Companion.getTestMethod(leaf);
        if (!(psiMethod instanceof PsiMember)) {
            psiMethod = null;
        }
        if ((psiMember = (PsiMember)psiMethod) == null) {
            psiMember = (PsiMember)Companion.getTestClass(leaf);
        }
        if (psiMember == null) {
            super.onFirstRun(fromContext, context, performRunnable);
            return;
        }
        PsiMember sourceElement = psiMember;
        ConfigurationFromContext contextWithLightElement = this.createDelegatingContextWithLightElement(fromContext, sourceElement);
        new AbstractTestClassConfigurationProducer((ConfigurationType)JUnitConfigurationType.getInstance()){}.onFirstRun(contextWithLightElement, context, performRunnable);
    }

    private final ConfigurationFromContext createDelegatingContextWithLightElement(ConfigurationFromContext fromContext, PsiMember lightElement) {
        return new ConfigurationFromContext(fromContext, lightElement){
            final /* synthetic */ ConfigurationFromContext $fromContext;
            final /* synthetic */ PsiMember $lightElement;

            @NotNull
            public RunnerAndConfigurationSettings getConfigurationSettings() {
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.$fromContext.getConfigurationSettings();
                Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"fromContext.configurationSettings");
                return runnerAndConfigurationSettings;
            }

            public void setConfigurationSettings(@NotNull RunnerAndConfigurationSettings configurationSettings) {
                Intrinsics.checkNotNullParameter((Object)configurationSettings, (String)"configurationSettings");
                this.$fromContext.setConfigurationSettings(configurationSettings);
            }

            @NotNull
            public PsiMember getSourceElement() {
                return this.$lightElement;
            }
            {
                this.$fromContext = $captured_local_variable$0;
                this.$lightElement = $captured_local_variable$1;
            }
        };
    }

    public KotlinJUnitRunConfigurationProducer() {
        super((ConfigurationType)JUnitConfigurationType.getInstance());
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0017\u0010\u0007\u001a\t\u0018\u00010\b\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u000f*\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinJUnitRunConfigurationProducer$Companion;", "", "()V", "getTestClass", "Lcom/intellij/psi/PsiClass;", "leaf", "Lcom/intellij/psi/PsiElement;", "getTestClassInFile", "Lorg/jetbrains/kotlin/psi/KtClass;", "Lkotlin/internal/NoInfer;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getTestMethod", "Lcom/intellij/psi/PsiMethod;", "isJUnitTestClass", "", "kotlin.jvm"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final PsiClass getTestClass(@NotNull PsiElement leaf) {
            void $this$getParentOfType$iv;
            Intrinsics.checkNotNullParameter((Object)leaf, (String)"leaf");
            PsiFile psiFile2 = leaf.getContainingFile();
            if (!(psiFile2 instanceof KtFile)) {
                psiFile2 = null;
            }
            KtFile ktFile = (KtFile)psiFile2;
            if (ktFile == null) {
                return null;
            }
            KtFile containingFile = ktFile;
            PsiElement psiElement = leaf;
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtClass.class, (boolean)strict$iv);
            if (!this.isJUnitTestClass(ktClass)) {
                ktClass = this.getTestClassInFile(containingFile);
            }
            KtClass ktClass2 = ktClass;
            return (PsiClass)(ktClass2 != null ? LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass2)) : null);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final PsiMethod getTestMethod(@NotNull PsiElement leaf) {
            void $this$getParentOfType$iv;
            Intrinsics.checkNotNullParameter((Object)leaf, (String)"leaf");
            PsiElement psiElement = leaf;
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtNamedFunction.class, (boolean)strict$iv);
            if (ktNamedFunction == null) {
                return null;
            }
            KtNamedFunction function = ktNamedFunction;
            KtTypeParameterListOwner owner = (KtTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)function), (Class[])new Class[]{KtFunction.class, KtClass.class});
            if (owner instanceof KtClass) {
                PsiMethod psiMethod;
                block6: {
                    KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)owner));
                    if (ktLightClass == null) {
                        return null;
                    }
                    KtLightClass delegate = ktLightClass;
                    PsiMethod[] psiMethodArray = delegate.getMethods();
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"delegate.methods");
                    PsiMethod[] $this$firstOrNull$iv = psiMethodArray;
                    boolean $i$f$firstOrNull = false;
                    PsiMethod[] psiMethodArray2 = $this$firstOrNull$iv;
                    int n = psiMethodArray2.length;
                    for (int i = 0; i < n; ++i) {
                        PsiMethod element$iv;
                        PsiMethod it = element$iv = psiMethodArray2[i];
                        boolean bl = false;
                        PsiMethod psiMethod2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)psiMethod2, (String)"it");
                        if (!Intrinsics.areEqual((Object)psiMethod2.getNavigationElement(), (Object)function)) continue;
                        psiMethod = element$iv;
                        break block6;
                    }
                    psiMethod = null;
                }
                if (psiMethod == null) {
                    return null;
                }
                PsiMethod method = psiMethod;
                if (JUnitUtil.isTestMethod((Location)KotlinJUnitRunConfigurationProducerKt.access$toLocation(method), (boolean)false)) {
                    return method;
                }
            }
            return null;
        }

        private final boolean isJUnitTestClass(KtClass $this$isJUnitTestClass) {
            boolean bl;
            KtClass ktClass = $this$isJUnitTestClass;
            if (ktClass != null && (ktClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass))) != null) {
                KtClass ktClass2 = ktClass;
                boolean bl2 = false;
                boolean bl3 = false;
                KtClass it = ktClass2;
                boolean bl4 = false;
                bl = JUnitUtil.isTestClass((PsiClass)((PsiClass)it), (boolean)false, (boolean)true);
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final KtClass getTestClassInFile(KtFile ktFile) {
            Object v0;
            block3: {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = ktFile.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof KtClass)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    KtClass it = (KtClass)element$iv;
                    boolean bl = false;
                    if (!Companion.isJUnitTestClass(it)) continue;
                    if (found$iv) {
                        v0 = null;
                        break block3;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            return v0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

