/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.CommonBundle;
import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.facet.impl.ui.libraries.LibraryOptionsPanel;
import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.RadioButtonEnumModel;
import java.awt.LayoutManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.formatter.KotlinPredefinedCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.idea.formatter.ProjectCodeStyleImporter;
import org.jetbrains.kotlin.idea.framework.CustomLibraryDescriptorWithDeferredConfig;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdDescription;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeLibraryDescription;
import org.jetbrains.kotlin.idea.framework.KotlinSdkType;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;

public class KotlinModuleSettingStep
extends ModuleWizardStep {
    private static final Logger LOG = Logger.getInstance(KotlinModuleSettingStep.class);
    private final TargetPlatform targetPlatform;
    @Nullable
    private final ModuleWizardStep myJavaStep;
    private final CustomLibraryDescription customLibraryDescription;
    private final LibrariesContainer librariesContainer;
    private boolean isNewProject;
    private LibraryOptionsPanel libraryOptionsPanel;
    private JPanel panel;
    private LibraryCompositionSettings libraryCompositionSettings;
    private final String basePath;

    public KotlinModuleSettingStep(TargetPlatform targetPlatform, ModuleBuilder moduleBuilder, @NotNull SettingsStep settingsStep, @Nullable WizardContext wizardContext) {
        if (settingsStep == null) {
            KotlinModuleSettingStep.$$$reportNull$$$0(0);
        }
        boolean bl = this.isNewProject = wizardContext != null && wizardContext.isCreatingNewProject();
        if (!JvmPlatformKt.isJvm((TargetPlatform)targetPlatform)) {
            KotlinSdkType.Companion.setUpIfNeeded();
        }
        this.targetPlatform = targetPlatform;
        this.myJavaStep = JavaModuleType.getModuleType().modifyProjectTypeStep(settingsStep, moduleBuilder);
        this.basePath = moduleBuilder.getContentEntryPath();
        this.librariesContainer = LibrariesContainerFactory.createContainer((Project)settingsStep.getContext().getProject());
        this.customLibraryDescription = this.getCustomLibraryDescription(settingsStep.getContext().getProject());
        moduleBuilder.addModuleConfigurationUpdater(this.createModuleConfigurationUpdater());
        settingsStep.addSettingsComponent(this.getComponent());
    }

    protected ModuleBuilder.ModuleConfigurationUpdater createModuleConfigurationUpdater() {
        return new ModuleBuilder.ModuleConfigurationUpdater(){

            public void update(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
                if (module == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (rootModel == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (KotlinModuleSettingStep.this.libraryCompositionSettings != null) {
                    KotlinModuleSettingStep.this.libraryCompositionSettings.addLibraries(rootModel, new ArrayList(), KotlinModuleSettingStep.this.librariesContainer);
                    if (KotlinModuleSettingStep.this.customLibraryDescription instanceof CustomLibraryDescriptorWithDeferredConfig) {
                        ((CustomLibraryDescriptorWithDeferredConfig)KotlinModuleSettingStep.this.customLibraryDescription).finishLibConfiguration(module, rootModel, KotlinModuleSettingStep.this.isNewProject);
                    }
                }
                if (KotlinModuleSettingStep.this.isNewProject) {
                    ProjectCodeStyleImporter.INSTANCE.apply(module.getProject(), (KotlinPredefinedCodeStyle)KotlinStyleGuideCodeStyle.Companion.getINSTANCE());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rootModel";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/idea/framework/KotlinModuleSettingStep$1";
                objectArray[2] = "update";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void disposeUIResources() {
        if (this.libraryOptionsPanel != null) {
            Disposer.dispose((Disposable)this.libraryOptionsPanel);
        }
    }

    public JComponent getComponent() {
        if (this.panel == null) {
            this.panel = new JPanel((LayoutManager)new VerticalLayout(0));
            this.panel.setBorder(IdeBorderFactory.createTitledBorder((String)this.getLibraryLabelText()));
            this.panel.add(this.getLibraryPanel().getMainPanel());
        }
        return this.panel;
    }

    @NotNull
    protected String getLibraryLabelText() {
        if (JvmPlatformKt.isJvm((TargetPlatform)this.targetPlatform)) {
            String string = KotlinJvmBundle.message("library.label.jvm", new Object[0]);
            if (string == null) {
                KotlinModuleSettingStep.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (JsPlatformKt.isJs((TargetPlatform)this.targetPlatform)) {
            String string = KotlinJvmBundle.message("library.label.javascript", new Object[0]);
            if (string == null) {
                KotlinModuleSettingStep.$$$reportNull$$$0(2);
            }
            return string;
        }
        throw new IllegalStateException("Only JS and JVM target are supported");
    }

    @NotNull
    protected CustomLibraryDescription getCustomLibraryDescription(@Nullable Project project) {
        if (JvmPlatformKt.isJvm((TargetPlatform)this.targetPlatform)) {
            return new JavaRuntimeLibraryDescription(project);
        }
        if (JsPlatformKt.isJs((TargetPlatform)this.targetPlatform)) {
            return new JSLibraryStdDescription(project);
        }
        throw new IllegalStateException("Only JS and JVM target are supported");
    }

    public void updateDataModel() {
        this.libraryCompositionSettings = this.getLibraryPanel().apply();
        if (this.myJavaStep != null) {
            this.myJavaStep.updateDataModel();
        }
    }

    public boolean validate() throws ConfigurationException {
        if (!super.validate() || this.myJavaStep != null && !this.myJavaStep.validate()) {
            return false;
        }
        Boolean selected = this.isLibrarySelected();
        return selected == null || selected != false || Messages.showDialog((String)KotlinJvmBundle.message("library.no.kotlin.library.question", new Object[0]), (String)KotlinJvmBundle.message("library.no.kotlin.library.title", new Object[0]), (String[])new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()}, (int)1, (Icon)Messages.getWarningIcon()) == 0;
    }

    protected LibraryOptionsPanel getLibraryPanel() {
        if (this.libraryOptionsPanel == null) {
            String baseDirPath = this.basePath != null ? FileUtil.toSystemIndependentName((String)this.basePath) : "";
            this.libraryOptionsPanel = new LibraryOptionsPanel(this.customLibraryDescription, baseDirPath, FrameworkLibraryVersionFilter.ALL, this.librariesContainer, false);
        }
        return this.libraryOptionsPanel;
    }

    private Boolean isLibrarySelected() {
        try {
            LibraryOptionsPanel panel = this.getLibraryPanel();
            Class<LibraryOptionsPanel> panelClass = LibraryOptionsPanel.class;
            Field modelField = (Field)ArraysKt.singleOrNull((Object[])panelClass.getDeclaredFields(), (Function1)new Function1<Field, Boolean>(){

                public Boolean invoke(Field field) {
                    return RadioButtonEnumModel.class.isAssignableFrom(field.getType());
                }
            });
            if (modelField == null) {
                LOG.error("There must be exactly one field of type RadioButtonEnumModel: " + Arrays.toString(panelClass.getDeclaredFields()));
                return false;
            }
            modelField.setAccessible(true);
            RadioButtonEnumModel enumModel = (RadioButtonEnumModel)modelField.get(panel);
            int ordinal = enumModel.getSelected().ordinal();
            if (ordinal == 0) {
                Field libComboboxField = (Field)ArraysKt.singleOrNull((Object[])panelClass.getDeclaredFields(), (Function1)new Function1<Field, Boolean>(){

                    public Boolean invoke(Field field) {
                        return JComboBox.class.isAssignableFrom(field.getType());
                    }
                });
                if (libComboboxField == null) {
                    LOG.error("There must be exactly one field of type JComboBox: " + Arrays.toString(panelClass.getDeclaredFields()));
                    return false;
                }
                libComboboxField.setAccessible(true);
                JComboBox combobox = (JComboBox)libComboboxField.get(panel);
                return combobox.getSelectedItem() != null;
            }
            return ordinal != 2;
        }
        catch (Exception e) {
            LOG.warn("Error in reflection", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/framework/KotlinModuleSettingStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/framework/KotlinModuleSettingStep";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryLabelText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

