/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.SideModel;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.SideBorder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class SidePanel<T>
extends JPanel
implements SideModel.Listener<T> {
    private static final String SPLITTER = "SPLITTER";
    private static final String EMPTY = "EMPTY";
    private final Side mySide;
    private final JPanel myCards;
    private final CardLayout myLayout;
    private final JPanel myEmpty;
    private final Splitter mySplitter;

    SidePanel(@NotNull Side side, @NotNull SideModel<T> model2) {
        super(new BorderLayout());
        this.mySide = side;
        this.mySplitter = new MySplitter();
        this.myEmpty = new JPanel();
        this.myLayout = new JBCardLayout();
        this.myCards = new JPanel(this.myLayout);
        this.setBorder((Border)new SideBorder(JBColor.border(), side.isLeft() ? 4 : 1));
        this.add((Component)this.myCards, "Center");
        model2.addListener(this);
    }

    @Override
    public void modelChanged(@NotNull SideModel<T> model2, @NotNull SideModel.EventType unused) {
        this.myCards.removeAll();
        this.myCards.add((Component)this.mySplitter, SPLITTER);
        this.myCards.add((Component)this.myEmpty, EMPTY);
        this.addVisibleTools(model2.getVisibleTools(this.mySide));
        this.addHiddenTools(model2.getHiddenTools(this.mySide));
        this.revalidate();
        this.repaint();
    }

    private void addVisibleTools(@NotNull List<AttachedToolWindow> tools) {
        this.mySplitter.setFirstComponent(null);
        this.mySplitter.setSecondComponent(null);
        this.setVisible(!tools.isEmpty());
        this.mySplitter.setEnabled(false);
        if (tools.isEmpty()) {
            this.myLayout.show(this.myCards, EMPTY);
        } else if (tools.size() == 1) {
            AttachedToolWindow tool = tools.get(0);
            this.myCards.add((Component)tool.getComponent(), tool.getToolName());
            this.myLayout.show(this.myCards, tool.getToolName());
        } else {
            AttachedToolWindow tool1 = tools.get(0);
            AttachedToolWindow tool2 = tools.get(1);
            tool1.getComponent().setVisible(true);
            tool2.getComponent().setVisible(true);
            this.mySplitter.setFirstComponent(tool1.getComponent());
            this.mySplitter.setSecondComponent(tool2.getComponent());
            this.mySplitter.setEnabled(true);
            this.myLayout.show(this.myCards, SPLITTER);
        }
    }

    private void addHiddenTools(@NotNull List<AttachedToolWindow> tools) {
        tools.forEach(tool -> this.myCards.add((Component)tool.getComponent(), tool.getToolName()));
    }

    private static class MySplitter
    extends Splitter {
        private MySplitter() {
            super(true);
            this.setDividerWidth(9);
        }

        protected Divider createDivider() {
            Splitter.DividerImpl divider = new Splitter.DividerImpl((Splitter)this);
            divider.setBorder(IdeBorderFactory.createBorder((int)10));
            return divider;
        }
    }
}

