/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RangedSeries<E> {
    @NotNull
    protected final Range myRange;
    @NotNull
    protected DataSeries<E> mySeries;
    @NotNull
    protected final Range myIntersectRange;
    @NotNull
    private Range myLastQueriedRange = new Range();
    @NotNull
    private List<SeriesData<E>> myLastQueriedSeries = Collections.emptyList();

    public RangedSeries(@NotNull Range viewRange, @NotNull DataSeries<E> series, @NotNull Range dataRange) {
        this.myRange = viewRange;
        this.mySeries = series;
        this.myIntersectRange = dataRange;
    }

    public RangedSeries(@NotNull Range defaultRange, @NotNull DataSeries<E> series) {
        this(defaultRange, series, new Range(-1.7976931348623157E308, Double.MAX_VALUE));
    }

    @NotNull
    public List<SeriesData<E>> getSeries() {
        Range queryRange = this.myRange.getIntersection(this.myIntersectRange);
        if (queryRange.getMax() == 9.223372036854776E18 || queryRange.getMax() == Double.MAX_VALUE) {
            return this.getSeriesForRange(queryRange);
        }
        if (this.myLastQueriedRange.isSameAs(queryRange)) {
            return this.myLastQueriedSeries;
        }
        this.myLastQueriedSeries = this.getSeriesForRange(queryRange);
        this.myLastQueriedRange = queryRange;
        return this.myLastQueriedSeries;
    }

    @NotNull
    public List<SeriesData<E>> getSeriesForRange(Range range) {
        return this.mySeries.getDataForRange(range);
    }

    public Range getIntersection() {
        return this.myRange.getIntersection(this.myIntersectRange);
    }

    @NotNull
    public Range getXRange() {
        return this.myRange;
    }
}

