/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.chart.linechart.LineConfig;
import java.awt.Color;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegendConfig {
    @NotNull
    private final Color mColor;
    @NotNull
    private final IconType mIconType;
    @Nullable
    private final Function<String, Icon> mIconGetter;

    public LegendConfig(@NotNull IconType iconType, @NotNull Color color) {
        this(iconType, color, null);
    }

    public LegendConfig(Function<String, Icon> iconGetter, @NotNull Color color) {
        this(IconType.CUSTOM, color, iconGetter);
    }

    public LegendConfig(@NotNull LineConfig config) {
        this(config.getLegendIconType(), config.getColor());
    }

    private LegendConfig(@NotNull IconType iconType, @NotNull Color color, @Nullable Function<String, Icon> iconGetter) {
        this.mColor = color;
        this.mIconGetter = iconGetter;
        this.mIconType = iconType;
    }

    @NotNull
    public Color getColor() {
        return this.mColor;
    }

    @NotNull
    public IconType getIconType() {
        return this.mIconType;
    }

    @Nullable
    public Function<String, Icon> getIconGetter() {
        return this.mIconGetter;
    }

    public static enum IconType {
        NONE,
        LINE,
        DASHED_LINE,
        BOX,
        CUSTOM;

    }
}

