/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.util;

import com.intellij.util.ImageLoader;
import com.intellij.util.SVGLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import org.intellij.images.util.ImageInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageInfoReader {
    private static final byte[] APPLE_PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 4, 67, 103, 66, 73};

    @Nullable
    public static Info getInfo(byte @NotNull [] data) {
        Info info = ImageInfoReader.getSvgInfo(data);
        if (info != null) {
            return info;
        }
        return ImageInfoReader.read(new ByteArrayInputStream(data));
    }

    @Nullable
    private static Info getSvgInfo(byte @NotNull [] data) {
        for (int i = 0; i < Math.min(data.length, 100); ++i) {
            Info info;
            byte b = data[i];
            if (b == 60 && (info = ImageInfoReader.getSvgSize(data)) != null) {
                return info;
            }
            if (!Character.isWhitespace(b)) break;
        }
        return null;
    }

    private static Info getSvgSize(byte[] data) {
        try {
            ImageLoader.Dimension2DDouble size = SVGLoader.getDocumentSize(null, (InputStream)new ByteArrayInputStream(data), (double)1.0);
            return new Info((int)Math.round(size.getWidth()), (int)Math.round(size.getHeight()), 32, true);
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Info read(@NotNull Object input) {
        ImageIO.setUseCache(false);
        try (ImageInputStream iis = ImageIO.createImageInputStream(input);){
            if (ImageInfoReader.isAppleOptimizedPNG(iis)) {
                Info info = null;
                return info;
            }
            Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
            ImageReader reader = it.hasNext() ? it.next() : null;
            if (reader == null) return null;
            reader.setInput(iis, true);
            int w = reader.getWidth(0);
            int h = reader.getHeight(0);
            Iterator<ImageTypeSpecifier> it2 = reader.getImageTypes(0);
            int bpp = it2 != null && it2.hasNext() ? it2.next().getColorModel().getPixelSize() : -1;
            Info info = new Info(w, h, bpp, false);
            return info;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static boolean isAppleOptimizedPNG(@NotNull ImageInputStream iis) throws IOException {
        try {
            byte[] signature = new byte[APPLE_PNG_SIGNATURE.length];
            if (iis.read(signature) != APPLE_PNG_SIGNATURE.length) {
                boolean bl = false;
                return bl;
            }
            boolean bl = Arrays.equals(signature, APPLE_PNG_SIGNATURE);
            return bl;
        }
        finally {
            iis.seek(0L);
        }
    }

    public static class Info
    extends ImageInfo {
        private final boolean myIsSvg;

        public Info(int width, int height, int bpp, boolean isSvg) {
            super(width, height, bpp);
            this.myIsSvg = isSvg;
        }

        public boolean isSvg() {
            return this.myIsSvg;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Info info = (Info)o;
            return this.myIsSvg == info.myIsSvg;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myIsSvg);
        }
    }
}

