/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actionSystem.ThumbnailViewActionUtil;
import org.jetbrains.annotations.NotNull;

public final class ToggleTagsPanelAction
extends ToggleAction {
    public static final String TAGS_PANEL_VISIBLE = "tags.panel.visible";
    public static final String TAGS_PANEL_PROPORTION = "tags.panel.proportion";

    public boolean isSelected(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        return project != null && PropertiesComponent.getInstance((Project)project).getBoolean(TAGS_PANEL_VISIBLE, false);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        PropertiesComponent.getInstance((Project)e.getProject()).setValue(TAGS_PANEL_VISIBLE, state);
        ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
        assert (view != null);
        view.refresh();
    }

    public void update(@NotNull AnActionEvent e) {
        ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
        e.getPresentation().setEnabledAndVisible(view != null);
        e.getPresentation().setText(this.isSelected(e) ? IdeBundle.message((String)"action.text.hide.tags.panel", (Object[])new Object[0]) : IdeBundle.message((String)"action.text.show.tags.panel", (Object[])new Object[0]));
        super.update(e);
    }
}

