/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Alarm;
import org.intellij.images.editor.impl.ImageEditorImpl;
import org.intellij.images.editor.impl.ImageFileEditorImpl;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.vfs.IfsUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class ImageFileEditorProvider
implements FileEditorProvider,
DumbAware {
    @NonNls
    private static final String EDITOR_TYPE_ID = "images";

    ImageFileEditorProvider() {
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        return ImageFileTypeManager.getInstance().isImage(file);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, final @NotNull VirtualFile file) {
        final ImageFileEditorImpl viewer = new ImageFileEditorImpl(project, file);
        if (IfsUtil.isSVG(file)) {
            final TextEditor editor = (TextEditor)TextEditorProvider.getInstance().createEditor(project, file);
            editor.getEditor().getDocument().addDocumentListener(new DocumentListener(){
                final Alarm myAlarm;
                {
                    this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)editor);
                }

                public void documentChanged(@NotNull DocumentEvent event) {
                    this.myAlarm.cancelAllRequests();
                    this.myAlarm.addRequest(() -> ((ImageEditorImpl)viewer.getImageEditor()).setValue((VirtualFile)new LightVirtualFile("preview.svg", file.getFileType(), (CharSequence)event.getDocument().getText())), 500);
                }
            }, (Disposable)editor);
            return new TextEditorWithPreview(editor, (FileEditor)viewer, "SvgEditor");
        }
        return viewer;
    }

    @NotNull
    public String getEditorTypeId() {
        return EDITOR_TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

