/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.notNullVerification;

import com.intellij.compiler.instrumentation.FailSafeClassReader;
import com.intellij.compiler.instrumentation.FailSafeMethodVisitor;
import com.intellij.compiler.notNullVerification.AuxiliaryMethodGenerator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.TypeReference;

public class NotNullVerifyingInstrumenter
extends ClassVisitor
implements Opcodes {
    private static final String IAE_CLASS_NAME = "java/lang/IllegalArgumentException";
    private static final String ISE_CLASS_NAME = "java/lang/IllegalStateException";
    private static final String ANNOTATION_DEFAULT_METHOD = "value";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final MethodData myMethodData;
    private boolean myIsModification = false;
    private RuntimeException myPostponedError;
    private final AuxiliaryMethodGenerator myAuxGenerator;

    private NotNullVerifyingInstrumenter(ClassVisitor classVisitor, ClassReader reader, String[] notNullAnnotations) {
        super(524288, classVisitor);
        HashSet<String> annoSet = new HashSet<String>();
        for (String annotation : notNullAnnotations) {
            annoSet.add('L' + annotation.replace('.', '/') + ';');
        }
        this.myMethodData = NotNullVerifyingInstrumenter.collectMethodData(reader, annoSet);
        this.myAuxGenerator = new AuxiliaryMethodGenerator(reader);
    }

    @Deprecated
    public static boolean processClassFile(FailSafeClassReader reader, ClassVisitor writer, String[] notNullAnnotations) {
        return NotNullVerifyingInstrumenter.processClassFile((ClassReader)reader, writer, notNullAnnotations);
    }

    public static boolean processClassFile(ClassReader reader, ClassVisitor writer, String[] notNullAnnotations) {
        NotNullVerifyingInstrumenter instrumenter = new NotNullVerifyingInstrumenter(writer, reader, notNullAnnotations);
        reader.accept((ClassVisitor)instrumenter, 0);
        return instrumenter.myIsModification;
    }

    private static MethodData collectMethodData(ClassReader reader, final Set<String> notNullAnnotations) {
        final MethodData result = new MethodData();
        reader.accept(new ClassVisitor(524288){
            private boolean myEnum;
            private boolean myInner;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                result.myClassName = name;
                this.myEnum = (access & 0x4000) != 0;
            }

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
                super.visitInnerClass(name, outerName, innerName, access);
                if (result.myClassName.equals(name)) {
                    this.myInner = (access & 8) == 0;
                }
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                final Type[] args = Type.getArgumentTypes((String)desc);
                final boolean methodCanHaveNullability = NotNullVerifyingInstrumenter.isReferenceType(Type.getReturnType((String)desc));
                final LinkedHashMap<Integer, Integer> paramSlots = new LinkedHashMap<Integer, Integer>();
                int slotIndex = NotNullVerifyingInstrumenter.isStatic(access) ? 0 : 1;
                for (int paramIndex = 0; paramIndex < args.length; ++paramIndex) {
                    Type arg = args[paramIndex];
                    paramSlots.put(slotIndex, paramIndex);
                    slotIndex += arg.getSize();
                }
                final MethodInfo methodInfo = new MethodInfo();
                boolean bl = methodInfo.isStable = (access & 0x1A) != 0;
                methodInfo.paramAnnotationOffset = !"<init>".equals(name) ? 0 : (this.myEnum ? 2 : (this.myInner ? 1 : 0));
                result.myMethodInfos.put(MethodData.key(name, desc), methodInfo);
                return new MethodVisitor(this.api){
                    private int myParamAnnotationOffset;
                    {
                        super(x0);
                        this.myParamAnnotationOffset = methodInfo.paramAnnotationOffset;
                    }

                    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
                        if (this.myParamAnnotationOffset != 0 && parameterCount == args.length) {
                            this.myParamAnnotationOffset = 0;
                        }
                        super.visitAnnotableParameterCount(parameterCount, visible);
                    }

                    public AnnotationVisitor visitParameterAnnotation(int parameter, String anno, boolean visible) {
                        AnnotationVisitor base = super.visitParameterAnnotation(parameter, anno, visible);
                        return this.checkParameterNullability(parameter + this.myParamAnnotationOffset, anno, base, false);
                    }

                    public AnnotationVisitor visitAnnotation(String anno, boolean isRuntime) {
                        AnnotationVisitor base = super.visitAnnotation(anno, isRuntime);
                        if (methodCanHaveNullability && notNullAnnotations.contains(anno)) {
                            return this.collectNotNullArgs(base, methodInfo.nullability.withNotNull(anno, NotNullVerifyingInstrumenter.ISE_CLASS_NAME));
                        }
                        return base;
                    }

                    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String anno, boolean visible) {
                        AnnotationVisitor base = super.visitTypeAnnotation(typeRef, typePath, anno, visible);
                        if (typePath != null) {
                            return base;
                        }
                        TypeReference ref = new TypeReference(typeRef);
                        if (methodCanHaveNullability && ref.getSort() == 20) {
                            if (notNullAnnotations.contains(anno)) {
                                return this.collectNotNullArgs(base, methodInfo.nullability.withNotNull(anno, NotNullVerifyingInstrumenter.ISE_CLASS_NAME));
                            }
                            if (this.seemsNullable(anno)) {
                                methodInfo.nullability.hasTypeUseNullable = true;
                            }
                        } else if (ref.getSort() == 22) {
                            return this.checkParameterNullability(ref.getFormalParameterIndex() + methodInfo.paramAnnotationOffset, anno, base, true);
                        }
                        return base;
                    }

                    private boolean seemsNullable(String anno) {
                        String shortName = NotNullVerifyingInstrumenter.getAnnoShortName(anno);
                        return shortName.contains("Nullable") || shortName.equals("CheckForNull");
                    }

                    private AnnotationVisitor collectNotNullArgs(AnnotationVisitor base, final NotNullState state) {
                        return new AnnotationVisitor(524288, base){

                            public void visit(String methodName, Object o) {
                                if (NotNullVerifyingInstrumenter.ANNOTATION_DEFAULT_METHOD.equals(methodName) && !((String)o).isEmpty()) {
                                    state.message = (String)o;
                                } else if ("exception".equals(methodName) && o instanceof Type && !((Type)o).getClassName().equals(Exception.class.getName())) {
                                    state.exceptionType = ((Type)o).getInternalName();
                                }
                                super.visit(methodName, o);
                            }
                        };
                    }

                    private AnnotationVisitor checkParameterNullability(int parameter, String anno, AnnotationVisitor av, boolean typeUse) {
                        if (parameter >= 0 && parameter < args.length && NotNullVerifyingInstrumenter.isReferenceType(args[parameter])) {
                            if (notNullAnnotations.contains(anno)) {
                                return this.collectNotNullArgs(av, methodInfo.obtainParameterNullability(parameter).withNotNull(anno, NotNullVerifyingInstrumenter.IAE_CLASS_NAME));
                            }
                            if (typeUse && this.seemsNullable(anno)) {
                                methodInfo.obtainParameterNullability((int)parameter).hasTypeUseNullable = true;
                            }
                        }
                        return av;
                    }

                    public void visitLocalVariable(String name2, String desc, String signature, Label start, Label end, int slotIndex) {
                        Integer paramIndex = (Integer)paramSlots.get(slotIndex);
                        if (paramIndex != null) {
                            methodInfo.paramNames.put(paramIndex, name2);
                        }
                    }
                };
            }
        }, 4);
        return result;
    }

    private static String getAnnoShortName(String anno) {
        String fullName = anno.substring(1, anno.length() - 1);
        return fullName.substring(fullName.lastIndexOf(47) + 1);
    }

    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        final MethodInfo info = (MethodInfo)this.myMethodData.myMethodInfos.get(MethodData.key(name, desc));
        if ((access & 0x40) != 0 || info == null) {
            return new FailSafeMethodVisitor(524288, super.visitMethod(access, name, desc, signature, exceptions));
        }
        final boolean isStatic = NotNullVerifyingInstrumenter.isStatic(access);
        final Type[] args = Type.getArgumentTypes((String)desc);
        final NotNullInstructionTracker instrTracker = new NotNullInstructionTracker(this.cv.visitMethod(access, name, desc, signature, exceptions));
        return new FailSafeMethodVisitor(524288, instrTracker){
            private Label myStartGeneratedCodeLabel;

            public void visitCode() {
                Iterator<NotNullState> iterator = info.paramNullability.values().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().isNotNull()) continue;
                    iterator.remove();
                }
                if (info.paramNullability.size() > 0) {
                    this.myStartGeneratedCodeLabel = new Label();
                    this.mv.visitLabel(this.myStartGeneratedCodeLabel);
                }
                for (Map.Entry<Integer, NotNullState> entry : info.paramNullability.entrySet()) {
                    String[] stringArray;
                    Integer param = entry.getKey();
                    int var = isStatic ? 0 : 1;
                    for (int i = 0; i < param; ++i) {
                        var += args[i].getSize();
                    }
                    this.mv.visitVarInsn(25, var);
                    Label end = new Label();
                    this.mv.visitJumpInsn(199, end);
                    NotNullState state = entry.getValue();
                    String paramName = NotNullVerifyingInstrumenter.this.myMethodData.lookupParamName(name, desc, param);
                    String descrPattern = state.getNullParamMessage(paramName);
                    if (state.message != null) {
                        stringArray = EMPTY_STRING_ARRAY;
                    } else {
                        String[] stringArray2 = new String[3];
                        stringArray2[0] = paramName != null ? paramName : String.valueOf(param - info.paramAnnotationOffset);
                        stringArray2[1] = NotNullVerifyingInstrumenter.this.myMethodData.myClassName;
                        stringArray = stringArray2;
                        stringArray2[2] = name;
                    }
                    String[] args2 = stringArray;
                    this.reportError(state.exceptionType, end, descrPattern, args2);
                }
            }

            public void visitLocalVariable(String name2, String desc2, String signature, Label start, Label end, int index) {
                boolean isParameterOrThisRef = isStatic ? index < args.length : index <= args.length;
                Label label = isParameterOrThisRef && this.myStartGeneratedCodeLabel != null ? this.myStartGeneratedCodeLabel : start;
                this.mv.visitLocalVariable(name2, desc2, signature, label, end, index);
            }

            public void visitInsn(int opcode) {
                if (opcode == 176 && instrTracker.canBeNull() && info.nullability.isNotNull()) {
                    String[] stringArray;
                    this.mv.visitInsn(89);
                    Label skipLabel = new Label();
                    this.mv.visitJumpInsn(199, skipLabel);
                    String descrPattern = info.nullability.getNullResultMessage();
                    if (info.nullability.message != null) {
                        stringArray = EMPTY_STRING_ARRAY;
                    } else {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = NotNullVerifyingInstrumenter.this.myMethodData.myClassName;
                        stringArray = stringArray2;
                        stringArray2[1] = name;
                    }
                    String[] args2 = stringArray;
                    this.reportError(info.nullability.exceptionType, skipLabel, descrPattern, args2);
                }
                this.mv.visitInsn(opcode);
            }

            private void reportError(String exceptionClass, Label end, String descrPattern, String[] args2) {
                NotNullVerifyingInstrumenter.this.myAuxGenerator.reportError(this.mv, NotNullVerifyingInstrumenter.this.myMethodData.myClassName, exceptionClass, descrPattern, args2);
                this.mv.visitLabel(end);
                NotNullVerifyingInstrumenter.this.myIsModification = true;
                NotNullVerifyingInstrumenter.this.processPostponedErrors();
            }

            public void visitMaxs(int maxStack, int maxLocals) {
                try {
                    super.visitMaxs(maxStack, maxLocals);
                }
                catch (Throwable e) {
                    NotNullVerifyingInstrumenter.this.registerError(name, "visitMaxs", e);
                }
            }
        };
    }

    public void visitEnd() {
        this.myAuxGenerator.generateReportingMethod(this.cv);
        super.visitEnd();
    }

    private static boolean isStatic(int access) {
        return (access & 8) != 0;
    }

    private static boolean isReferenceType(Type type) {
        return type.getSort() == 10 || type.getSort() == 9;
    }

    private void registerError(String methodName, String operationName, Throwable t) {
        if (this.myPostponedError == null) {
            Throwable cause = t.getCause();
            if (cause != null) {
                t = cause;
            }
            String message = t.getMessage();
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            StringBuilder text = new StringBuilder();
            text.append("Operation '").append(operationName).append("' failed for ").append(this.myMethodData.myClassName).append(".").append(methodName).append("(): ");
            if (message != null) {
                text.append(message);
            }
            text.append('\n').append(writer.getBuffer());
            this.myPostponedError = new RuntimeException(text.toString(), cause);
        }
        if (this.myIsModification) {
            this.processPostponedErrors();
        }
    }

    private void processPostponedErrors() {
        RuntimeException error = this.myPostponedError;
        if (error != null) {
            throw error;
        }
    }

    private final class NotNullInstructionTracker
    extends MethodVisitor {
        private boolean myCanBeNull;

        NotNullInstructionTracker(MethodVisitor delegate) {
            super(524288, delegate);
            this.myCanBeNull = true;
        }

        public boolean canBeNull() {
            return this.myCanBeNull;
        }

        public void visitIntInsn(int opcode, int operand) {
            this.myCanBeNull = this.nextCanBeNullValue(opcode);
            super.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            this.myCanBeNull = this.nextCanBeNullValue(opcode);
            super.visitVarInsn(opcode, var);
        }

        public void visitTypeInsn(int opcode, String type) {
            this.myCanBeNull = this.nextCanBeNullValue(opcode);
            super.visitTypeInsn(opcode, type);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            this.myCanBeNull = this.nextCanBeNullValue(opcode);
            super.visitFieldInsn(opcode, owner, name, descriptor);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            this.myCanBeNull = this.nextCanBeNullValue(opcode, owner, name, descriptor);
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            this.myCanBeNull = this.nextCanBeNullValue(186);
            super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
        }

        public void visitJumpInsn(int opcode, Label label) {
            this.myCanBeNull = this.nextCanBeNullValue(opcode);
            super.visitJumpInsn(opcode, label);
        }

        public void visitLdcInsn(Object value) {
            this.myCanBeNull = this.nextCanBeNullValue(18);
            super.visitLdcInsn(value);
        }

        public void visitIincInsn(int var, int increment) {
            this.myCanBeNull = this.nextCanBeNullValue(132);
            super.visitIincInsn(var, increment);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            this.myCanBeNull = this.nextCanBeNullValue(170);
            super.visitTableSwitchInsn(min, max, dflt, labels);
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.myCanBeNull = this.nextCanBeNullValue(171);
            super.visitLookupSwitchInsn(dflt, keys, labels);
        }

        public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
            this.myCanBeNull = this.nextCanBeNullValue(197);
            super.visitMultiANewArrayInsn(descriptor, numDimensions);
        }

        public void visitInsn(int opcode) {
            this.myCanBeNull = this.nextCanBeNullValue(opcode);
            super.visitInsn(opcode);
        }

        private boolean nextCanBeNullValue(int nextMethodCallOpcode, String owner, String name, String descriptor) {
            if (nextMethodCallOpcode == 183 && ("<init>".equals(name) || NotNullVerifyingInstrumenter.this.myMethodData.isAlwaysNotNull(owner, name, descriptor))) {
                return false;
            }
            return nextMethodCallOpcode != 184 && nextMethodCallOpcode != 182 || !NotNullVerifyingInstrumenter.this.myMethodData.isAlwaysNotNull(owner, name, descriptor);
        }

        private boolean nextCanBeNullValue(int nextOpcode) {
            if (nextOpcode == 18 || nextOpcode == 187 || nextOpcode == 189 || nextOpcode == 188 || nextOpcode == 197) {
                return false;
            }
            if (nextOpcode == 89 || nextOpcode == 90 || nextOpcode == 91 || nextOpcode == 92 || nextOpcode == 93 || nextOpcode == 94 || nextOpcode == 168 || nextOpcode == 167 || nextOpcode == 0 || nextOpcode == 169 || nextOpcode == 192) {
                return this.myCanBeNull;
            }
            return true;
        }
    }

    private static class NotNullState {
        String message;
        String exceptionType;
        String notNullAnno;
        boolean hasTypeUseNullable;

        private NotNullState() {
        }

        NotNullState withNotNull(String notNullAnno, String exceptionType) {
            this.notNullAnno = notNullAnno;
            this.exceptionType = exceptionType;
            return this;
        }

        boolean isNotNull() {
            return this.notNullAnno != null && !this.hasTypeUseNullable;
        }

        String getNullParamMessage(String paramName) {
            if (this.message != null) {
                return this.message;
            }
            String shortName = NotNullVerifyingInstrumenter.getAnnoShortName(this.notNullAnno);
            if (paramName != null) {
                return "Argument for @" + shortName + " parameter '%s' of %s.%s must not be null";
            }
            return "Argument %s for @" + shortName + " parameter of %s.%s must not be null";
        }

        String getNullResultMessage() {
            if (this.message != null) {
                return this.message;
            }
            String shortName = NotNullVerifyingInstrumenter.getAnnoShortName(this.notNullAnno);
            return "@" + shortName + " method %s.%s must not return null";
        }
    }

    private static final class MethodData {
        private String myClassName;
        private final Map<String, MethodInfo> myMethodInfos = new HashMap<String, MethodInfo>();

        private MethodData() {
        }

        static String key(String methodName, String desc) {
            return methodName + desc;
        }

        String lookupParamName(String methodName, String desc, Integer num) {
            MethodInfo info = this.myMethodInfos.get(MethodData.key(methodName, desc));
            Map<Integer, String> names = info == null ? null : info.paramNames;
            return names != null ? names.get(num) : null;
        }

        boolean isAlwaysNotNull(String className, String methodName, String desc) {
            if (this.myClassName.equals(className)) {
                MethodInfo info = this.myMethodInfos.get(MethodData.key(methodName, desc));
                return info != null && info.isStable && info.nullability.isNotNull();
            }
            return false;
        }
    }

    private static class MethodInfo {
        final NotNullState nullability = new NotNullState();
        final Map<Integer, String> paramNames = new HashMap<Integer, String>();
        final Map<Integer, NotNullState> paramNullability = new LinkedHashMap<Integer, NotNullState>();
        boolean isStable;
        int paramAnnotationOffset;

        private MethodInfo() {
        }

        NotNullState obtainParameterNullability(int index) {
            NotNullState state = this.paramNullability.get(index);
            if (state == null) {
                state = new NotNullState();
                this.paramNullability.put(index, state);
            }
            return state;
        }
    }
}

