/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DebuggableRunConfiguration
extends RunConfiguration {
    @NotNull
    default public InetSocketAddress computeDebugAddress(RunProfileState state) throws ExecutionException {
        try {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), NetUtils.findAvailableSocketPort());
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot find available port", (Throwable)e);
        }
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress var1, @NotNull XDebugSession var2, @Nullable ExecutionResult var3, @NotNull ExecutionEnvironment var4) throws ExecutionException;

    default public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        return true;
    }
}

