/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

public abstract class BreakpointTarget {
    public abstract <R> R accept(Visitor<R> var1);

    public abstract String toString();

    public static final class ScriptName
    extends BreakpointTarget {
        @NotNull
        private final String name;
        @Nullable
        private final Script script;

        public ScriptName(@NotNull String name) {
            this.name = name;
            this.script = null;
        }

        public ScriptName(@NotNull Script script) {
            this.script = script;
            this.name = script.getUrl().toDecodedForm();
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public Script getScript() {
            return this.script;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public <R> R accept(@NotNull Visitor<R> visitor) {
            return visitor.visitScriptName(this.name, this.script);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.name.equals(((ScriptName)o).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static final class ScriptId
    extends BreakpointTarget {
        public final Script script;

        public ScriptId(@NotNull Script script) {
            this.script = script;
        }

        @Override
        public <R> R accept(Visitor<R> visitor) {
            return visitor.visitScript(this.script);
        }

        @Override
        public String toString() {
            return this.script.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.script.equals(((ScriptId)o).script);
        }

        public int hashCode() {
            return this.script.hashCode();
        }
    }

    public static interface Visitor<R> {
        public R visitScriptName(String var1, @Nullable Script var2);

        public R visitScript(Script var1);

        public R visitUnknown(BreakpointTarget var1);
    }
}

