/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.intention;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.RegExpHighlighter;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.RegExpMatch;
import org.intellij.lang.regexp.RegExpMatchResult;
import org.intellij.lang.regexp.RegExpMatcherProvider;
import org.intellij.lang.regexp.RegExpModifierProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class CheckRegExpForm {
    private static final Logger LOG = Logger.getInstance(CheckRegExpForm.class);
    public static final Key<Boolean> CHECK_REG_EXP_EDITOR = Key.create((String)"CHECK_REG_EXP_EDITOR");
    private static final Key<List<RegExpMatch>> LAST_MATCHES = Key.create((String)"REG_EXP_LAST_MATCHES");
    private static final String LAST_EDITED_REGEXP = "last.edited.regexp";
    private final EditorTextField mySampleText;
    private final JPanel myRootPanel;
    private final JBLabel myRegExpIcon = new JBLabel();
    private final JBLabel mySampleIcon = new JBLabel();
    private final SmartList<RangeHighlighter> highlighters = new SmartList();

    public CheckRegExpForm(final @NotNull PsiFile regexpFile) {
        final Project project = regexpFile.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(regexpFile);
        Language language = regexpFile.getLanguage();
        Object fileType = language instanceof RegExpLanguage ? RegExpLanguage.INSTANCE.getAssociatedFileType() : new RegExpFileType(language);
        final EditorTextField myRegExp = new EditorTextField(document, project, (FileType)fileType, false, false){

            @Override
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.putUserData(CHECK_REG_EXP_EDITOR, Boolean.TRUE);
                editor.putUserData(IncrementalFindAction.SEARCH_DISABLED, Boolean.TRUE);
                editor.setEmbeddedIntoDialogWrapper(true);
                return editor;
            }

            @Override
            protected void updateBorder(@NotNull EditorEx editor) {
                this.setupBorder(editor);
            }
        };
        CheckRegExpForm.setupIcon(myRegExp, (JComponent)this.myRegExpIcon);
        String sampleText = PropertiesComponent.getInstance((Project)project).getValue(LAST_EDITED_REGEXP, "Sample Text");
        this.mySampleText = new EditorTextField(sampleText, project, (FileType)PlainTextFileType.INSTANCE){

            @Override
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.putUserData(IncrementalFindAction.SEARCH_DISABLED, Boolean.TRUE);
                editor.setEmbeddedIntoDialogWrapper(true);
                return editor;
            }

            @Override
            protected void updateBorder(@NotNull EditorEx editor) {
                this.setupBorder(editor);
            }
        };
        CheckRegExpForm.setupIcon(this.mySampleText, (JComponent)this.mySampleIcon);
        this.mySampleText.setOneLineMode(false);
        int preferredWidth = Math.max(JBUIScale.scale((int)250), myRegExp.getPreferredSize().width);
        myRegExp.setPreferredWidth(preferredWidth);
        this.mySampleText.setPreferredWidth(preferredWidth);
        this.myRootPanel = new JPanel(new GridBagLayout()){
            Disposable disposable;
            Alarm updater;

            @Override
            public void addNotify() {
                super.addNotify();
                this.disposable = Disposer.newDisposable();
                IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)CheckRegExpForm.this.mySampleText), true);
                this.registerFocusShortcut((JComponent)((Object)myRegExp), "shift TAB", CheckRegExpForm.this.mySampleText);
                this.registerFocusShortcut((JComponent)((Object)myRegExp), "TAB", CheckRegExpForm.this.mySampleText);
                this.registerFocusShortcut((JComponent)((Object)CheckRegExpForm.this.mySampleText), "shift TAB", myRegExp);
                this.registerFocusShortcut((JComponent)((Object)CheckRegExpForm.this.mySampleText), "TAB", myRegExp);
                this.updater = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.disposable);
                DocumentListener documentListener = new DocumentListener(){

                    public void documentChanged(@NotNull DocumentEvent e) {
                        this.update();
                    }
                };
                myRegExp.addDocumentListener(documentListener);
                CheckRegExpForm.this.mySampleText.addDocumentListener(documentListener);
                this.update();
                CheckRegExpForm.this.mySampleText.selectAll();
            }

            private void registerFocusShortcut(JComponent source, String shortcut, final EditorTextField target2) {
                AnAction action2 = new AnAction(){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        IdeFocusManager.findInstance().requestFocus((Component)target2.getFocusTarget(), true);
                    }
                };
                action2.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{shortcut}), source);
            }

            private void update() {
                this.updater.cancelAllRequests();
                if (!this.updater.isDisposed()) {
                    this.updater.addRequest(() -> {
                        RegExpMatchResult result2 = CheckRegExpForm.isMatchingText(regexpFile, myRegExp.getText(), CheckRegExpForm.this.mySampleText.getText());
                        ApplicationManager.getApplication().invokeLater(() -> CheckRegExpForm.this.reportResult(result2, regexpFile), ModalityState.any(), __ -> this.updater.isDisposed());
                    }, 0);
                }
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                Disposer.dispose((Disposable)this.disposable);
                PropertiesComponent.getInstance((Project)project).setValue(CheckRegExpForm.LAST_EDITED_REGEXP, CheckRegExpForm.this.mySampleText.getText());
            }
        };
        this.myRootPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = JBUI.insets((int)2, (int)5);
        c.gridx = 0;
        c.gridy = 0;
        this.myRootPanel.add((Component)CheckRegExpForm.createLabel(RegExpBundle.message("label.regexp", new Object[0]), (JComponent)((Object)myRegExp)), c);
        c.gridx = 1;
        this.myRootPanel.add((Component)((Object)myRegExp), c);
        c.gridx = 0;
        ++c.gridy;
        this.myRootPanel.add((Component)CheckRegExpForm.createLabel(RegExpBundle.message("label.sample", new Object[0]), (JComponent)((Object)this.mySampleText)), c);
        c.gridx = 1;
        this.myRootPanel.add((Component)((Object)this.mySampleText), c);
    }

    private static JLabel createLabel(@NotNull @NlsContexts.Label String labelText, @NotNull JComponent component2) {
        JLabel label2 = new JLabel(UIUtil.removeMnemonic((String)labelText));
        int index = UIUtil.getDisplayMnemonicIndex((String)labelText);
        if (index != -1) {
            label2.setDisplayedMnemonic(labelText.charAt(index + 1));
            label2.setDisplayedMnemonicIndex(index);
        }
        label2.setLabelFor(component2);
        return label2;
    }

    private static void setupIcon(@NotNull EditorTextField field, @NotNull JComponent icon2) {
        field.addSettingsProvider(editor -> {
            icon2.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
            JScrollPane scrollPane = editor.getScrollPane();
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setVerticalScrollBarPolicy(22);
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            verticalScrollBar.setBackground(editor.getBackgroundColor());
            verticalScrollBar.add("JB_SCROLL_BAR_LEADING_COMPONENT", icon2);
            verticalScrollBar.setOpaque(true);
        });
    }

    void reportResult(RegExpMatchResult result2, @NotNull PsiFile regexpFile) {
        switch (result2) {
            case NO_MATCH: {
                CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, AllIcons.General.BalloonError, RegExpBundle.message("tooltip.no.match", new Object[0]));
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, null, null);
                break;
            }
            case MATCHES: {
                CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, AllIcons.General.InspectionsOK, RegExpBundle.message("tooltip.matches", new Object[0]));
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, null, null);
                break;
            }
            case FOUND: {
                List<RegExpMatch> matches2 = CheckRegExpForm.getMatches(regexpFile);
                Editor editor = this.mySampleText.getEditor();
                if (editor != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        HighlightManager highlightManager = HighlightManager.getInstance((Project)regexpFile.getProject());
                        for (RangeHighlighter highlighter : this.highlighters) {
                            highlightManager.removeSegmentHighlighter(editor, highlighter);
                        }
                        for (RegExpMatch match : matches2) {
                            int start2 = match.start(0);
                            int end = match.end(0);
                            highlightManager.addRangeHighlight(editor, start2, end, RegExpHighlighter.MATCHED_GROUPS, true, this.highlighters);
                        }
                    });
                }
                if (matches2.size() > 1) {
                    CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, AllIcons.General.InspectionsOK, RegExpBundle.message("tooltip.found.multiple", matches2.size()));
                } else {
                    CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, AllIcons.General.InspectionsOK, RegExpBundle.message("tooltip.found", new Object[0]));
                }
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, null, null);
                break;
            }
            case INCOMPLETE: {
                CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, AllIcons.General.BalloonWarning, RegExpBundle.message("tooltip.more.input.expected", new Object[0]));
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, null, null);
                break;
            }
            case BAD_REGEXP: {
                CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, null, null);
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, AllIcons.General.BalloonError, RegExpBundle.message("tooltip.bad.pattern", new Object[0]));
                break;
            }
            case TIMEOUT: {
                CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, null, null);
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, AllIcons.General.BalloonWarning, RegExpBundle.message("tooltip.pattern.is.too.complex", new Object[0]));
            }
        }
    }

    private static void setIconAndTooltip(JBLabel label2, Icon icon2, @NlsContexts.Tooltip String tooltip) {
        label2.setIcon(icon2);
        label2.setToolTipText(tooltip);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.mySampleText;
    }

    @NotNull
    public JPanel getRootPanel() {
        return this.myRootPanel;
    }

    @ApiStatus.Internal
    public static List<RegExpMatch> getMatches(@NotNull PsiFile regexpFile) {
        return (List)regexpFile.getUserData(LAST_MATCHES);
    }

    public static void setMatches(@NotNull PsiFile regexpFile, @NotNull List<RegExpMatch> matches2) {
        regexpFile.putUserData(LAST_MATCHES, matches2);
    }

    public static boolean isMatchingTextTest(@NotNull PsiFile regexpFile, @NotNull String sampleText) {
        return CheckRegExpForm.getMatchResult(regexpFile, sampleText) == RegExpMatchResult.MATCHES;
    }

    public static RegExpMatchResult getMatchResult(@NotNull PsiFile regexpFile, @NotNull String sampleText) {
        return CheckRegExpForm.isMatchingText(regexpFile, regexpFile.getText(), sampleText);
    }

    static RegExpMatchResult isMatchingText(@NotNull PsiFile regexpFile, String regexpText, @NotNull String sampleText) {
        RegExpMatchResult result2;
        Language regexpFileLanguage = regexpFile.getLanguage();
        RegExpMatcherProvider matcherProvider = (RegExpMatcherProvider)RegExpMatcherProvider.EP.forLanguage(regexpFileLanguage);
        if (matcherProvider != null && (result2 = (RegExpMatchResult)((Object)ReadAction.compute(() -> {
            PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)regexpFile);
            if (host != null) {
                return matcherProvider.matches(regexpText, regexpFile, (PsiElement)host, sampleText, 1000L);
            }
            return null;
        }))) != null) {
            return result2;
        }
        Integer patternFlags = (Integer)ReadAction.compute(() -> {
            int flags;
            block1: {
                RegExpModifierProvider provider;
                PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)regexpFile);
                flags = 0;
                if (host == null) break block1;
                Iterator iterator2 = RegExpModifierProvider.EP.allForLanguage(host.getLanguage()).iterator();
                while (iterator2.hasNext() && (flags = (provider = (RegExpModifierProvider)iterator2.next()).getFlags((PsiElement)host, regexpFile)) <= 0) {
                }
            }
            return flags;
        });
        try {
            Matcher matcher = Pattern.compile(regexpText, patternFlags).matcher(StringUtil.newBombedCharSequence((CharSequence)sampleText, (long)1000L));
            if (matcher.matches()) {
                return RegExpMatchResult.MATCHES;
            }
            if (matcher.hitEnd()) {
                return RegExpMatchResult.INCOMPLETE;
            }
            if (matcher.find()) {
                SmartList matches2 = new SmartList();
                do {
                    RegExpMatch match = new RegExpMatch();
                    int count = matcher.groupCount();
                    for (int i2 = 0; i2 <= count; ++i2) {
                        match.add(matcher.start(i2), matcher.end(i2));
                    }
                    matches2.add((Object)match);
                } while (matcher.find());
                CheckRegExpForm.setMatches(regexpFile, (List<RegExpMatch>)matches2);
                return RegExpMatchResult.FOUND;
            }
            return RegExpMatchResult.NO_MATCH;
        }
        catch (ProcessCanceledException ignore) {
            return RegExpMatchResult.TIMEOUT;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return RegExpMatchResult.BAD_REGEXP;
        }
    }
}

