/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XDebuggerInlayUtil;
import com.intellij.xdebugger.impl.evaluate.quick.XValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.XStackFrameNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.awt.Component;
import java.awt.Point;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XVariablesViewBase
extends XDebugView {
    private final XDebuggerTreePanel myTreePanel;
    private MySelectionListener mySelectionListener;
    private Object myFrameEqualityObject;
    private XDebuggerTreeRestorer myTreeRestorer;
    private final Map<Object, XDebuggerTreeState> myTreeStates = new FixedHashMap(Registry.get((String)"debugger.tree.states.depth").asInteger());

    protected XVariablesViewBase(@NotNull Project project, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XValueMarkers<?, ?> markers) {
        this.myTreePanel = new XDebuggerTreePanel(project, editorsProvider, this, null, this instanceof XWatchesView ? "XDebugger.Watches.Tree.Popup" : "XDebugger.Variables.Tree.Popup", markers);
        this.getTree().getEmptyText().setText(XDebuggerBundle.message((String)"debugger.variables.not.available", (Object[])new Object[0]));
        DnDManager.getInstance().registerSource((DnDSource)this.myTreePanel, (JComponent)((Object)this.getTree()));
    }

    public JComponent getDefaultFocusedComponent() {
        return this.myTreePanel.getTree();
    }

    protected void buildTreeAndRestoreState(@NotNull XStackFrame stackFrame) {
        XDebuggerTreeState state;
        XSourcePosition position = stackFrame.getSourcePosition();
        XDebuggerTree tree = this.getTree();
        tree.setSourcePosition(position);
        this.createNewRootNode(stackFrame);
        XVariablesView.InlineVariablesInfo.set(XVariablesViewBase.getSession((Component)((Object)tree)), new XVariablesView.InlineVariablesInfo());
        XVariablesViewBase.clearInlays(tree);
        Object newEqualityObject = stackFrame.getEqualityObject();
        if (newEqualityObject != null && (state = this.myTreeStates.get(newEqualityObject)) != null) {
            this.disposeTreeRestorer();
            this.myTreeRestorer = state.restoreState(tree);
        }
        if (position != null && Registry.is((String)"debugger.valueTooltipAutoShowOnSelection")) {
            this.registerInlineEvaluator(stackFrame, position, tree.getProject());
        }
    }

    protected static void clearInlays(XDebuggerTree tree) {
        if (Registry.is((String)"debugger.show.values.inplace")) {
            XDebuggerInlayUtil.clearInlays(tree.getProject());
        }
    }

    protected final XValueContainerNode createNewRootNode(@Nullable XStackFrame stackFrame) {
        this.saveCurrentTreeState();
        XValueContainerNode node = this.doCreateNewRootNode(stackFrame);
        this.getTree().setRoot(node, false);
        this.myFrameEqualityObject = stackFrame != null ? stackFrame.getEqualityObject() : null;
        return node;
    }

    protected XValueContainerNode doCreateNewRootNode(@Nullable XStackFrame stackFrame) {
        XValueContainerNode root = stackFrame == null ? new XValueContainerNode<XValueContainer>(this.getTree(), null, false, new XValueContainer(){}){} : new XStackFrameNode(this.getTree(), stackFrame);
        return root;
    }

    private void registerInlineEvaluator(XStackFrame stackFrame, XSourcePosition position, Project project) {
        VirtualFile file2 = position.getFile();
        FileEditor fileEditor = FileEditorManagerEx.getInstanceEx(project).getSelectedEditor(file2);
        if (fileEditor instanceof PsiAwareTextEditorImpl) {
            Editor editor = ((PsiAwareTextEditorImpl)fileEditor).getEditor();
            this.removeSelectionListener();
            this.mySelectionListener = new MySelectionListener(editor, stackFrame, project, this.myTreePanel);
            editor.getSelectionModel().addSelectionListener((SelectionListener)this.mySelectionListener);
        }
    }

    private void saveCurrentTreeState() {
        this.removeSelectionListener();
        if (this.myFrameEqualityObject != null && (this.myTreeRestorer == null || this.myTreeRestorer.isFinished())) {
            this.myTreeStates.put(this.myFrameEqualityObject, XDebuggerTreeState.saveState(this.getTree()));
        }
        this.disposeTreeRestorer();
    }

    private void removeSelectionListener() {
        if (this.mySelectionListener != null) {
            this.mySelectionListener.remove();
            this.mySelectionListener = null;
        }
    }

    @Override
    protected void clear() {
        this.removeSelectionListener();
    }

    private void disposeTreeRestorer() {
        if (this.myTreeRestorer != null) {
            this.myTreeRestorer.dispose();
            this.myTreeRestorer = null;
        }
    }

    @NotNull
    public final XDebuggerTree getTree() {
        return this.myTreePanel.getTree();
    }

    public JComponent getPanel() {
        return this.myTreePanel.getMainPanel();
    }

    public void dispose() {
        this.disposeTreeRestorer();
        this.removeSelectionListener();
        DnDManager.getInstance().unregisterSource((DnDSource)this.myTreePanel, (JComponent)((Object)this.getTree()));
    }

    private static class MySelectionListener
    implements SelectionListener {
        private static final Collection<String> SIDE_EFFECT_PRODUCERS = Arrays.asList("exec(", "++", "--", "=");
        private static final Set<String> IGNORED_TEXTS = new HashSet<String>(Arrays.asList("", ";", "()"));
        private static final Alarm ALARM = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        private static final int EVALUATION_DELAY_MILLIS = 100;
        private final Editor myEditor;
        private final XStackFrame myStackFrame;
        private final Project myProject;
        private final XDebuggerTreePanel myTreePanel;

        MySelectionListener(Editor editor, XStackFrame stackFrame, Project project, XDebuggerTreePanel panel2) {
            this.myEditor = editor;
            this.myStackFrame = stackFrame;
            this.myProject = project;
            this.myTreePanel = panel2;
        }

        public void remove() {
            this.myEditor.getSelectionModel().removeSelectionListener((SelectionListener)this);
        }

        public void selectionChanged(@NotNull SelectionEvent e) {
            if (!Registry.is((String)"debugger.valueTooltipAutoShowOnSelection") || this.myEditor.getCaretModel().getCaretCount() > 1 || e.getNewRanges().length != 1 || Objects.equals(e.getNewRange(), e.getOldRange())) {
                return;
            }
            String text = this.myEditor.getDocument().getText(e.getNewRange()).trim();
            if (!IGNORED_TEXTS.contains(text)) {
                if (SIDE_EFFECT_PRODUCERS.stream().noneMatch(text::contains)) {
                    XDebugSession session2 = XDebugView.getSession((Component)((Object)this.myTreePanel.getTree()));
                    if (session2 == null) {
                        return;
                    }
                    XDebuggerEvaluator evaluator = this.myStackFrame.getEvaluator();
                    if (evaluator == null) {
                        return;
                    }
                    TextRange range2 = e.getNewRange();
                    ExpressionInfo info = new ExpressionInfo(range2);
                    int offset = range2.getStartOffset();
                    LogicalPosition pos = this.myEditor.offsetToLogicalPosition(offset);
                    Point point = this.myEditor.logicalPositionToXY(pos);
                    this.showTooltip(point, info, evaluator, session2);
                }
            }
        }

        private void showTooltip(@NotNull Point point, @NotNull ExpressionInfo info, @NotNull XDebuggerEvaluator evaluator, @NotNull XDebugSession session2) {
            ALARM.cancelAllRequests();
            ALARM.addRequest(() -> {
                if (DocumentUtil.isValidOffset(info.getTextRange().getEndOffset(), this.myEditor.getDocument())) {
                    new XValueHint(this.myProject, this.myEditor, point, ValueHintType.MOUSE_OVER_HINT, info, evaluator, session2, true).invokeHint();
                }
            }, 100);
        }
    }
}

